/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "jg_jnu.h"
#include "gtk_java.h"
#include <libebook/e-book.h>
#include <bonobo/bonobo-main.h>
#include "org_gnu_libebook_EBookView.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EBookView
 * Method:    e_book_view_start
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EBookView_e_1book_1view_1start
(JNIEnv *env, jclass cls, jobject obj)
{
    EBookView *e_book_view_g = (EBookView*)getPointerFromHandle(env, obj);
    e_book_view_start(e_book_view_g);
	bonobo_main();
}


/*
 * Class:     org_gnu_libebook_EBookView
 * Method:    e_book_view_stop
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EBookView_e_1book_1view_1stop
(JNIEnv *env, jclass cls, jobject obj)
{
    EBookView *e_book_view_g = (EBookView*)getPointerFromHandle(env, obj);
    e_book_view_stop(e_book_view_g);
    bonobo_main_quit();
}


/*
 * Class:     org_gnu_libebook_EBookView
 * Method:    e_book_view_get_contacts_from_glist
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libebook_EBookView_e_1book_1view_1get_1contacts_1from_1glist
(JNIEnv *env, jclass cls, jobject obj) {
    GList *contacts = (GList*)getPointerFromHandle(env, obj);
    return getGObjectHandlesFromGListAndRef(env, contacts);
}


#ifdef __cplusplus
}

#endif
