/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "gtk_java.h"
#include <libebook/e-contact.h>
#include "org_gnu_libebook_EContact.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContact_e_1contact_1new
(JNIEnv *env, jclass cls)
{
    return getGObjectHandle(env, (GObject *)e_contact_new());
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_new_from_vcard
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContact_e_1contact_1new_1from_1vcard
(JNIEnv *env, jclass cls, jstring vcard)
{
    char* vcard_g = (char*)(*env)->GetStringUTFChars(env, vcard, 0);
    EContact *econtact = e_contact_new_from_vcard(vcard_g);
    (*env)->ReleaseStringUTFChars(env, vcard, vcard_g);
    return getGObjectHandle(env, (GObject *)econtact);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_duplicate
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContact_e_1contact_1duplicate
(JNIEnv *env, jclass cls, jobject obj)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    return getGObjectHandle(env, (GObject *)e_contact_duplicate(contact));
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_to_vcard_string
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EContact_e_1contact_1to_1vcard_1string
(JNIEnv *env, jclass cls, jobject obj)
{
    EVCard *contact = (EVCard*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_vcard_to_string(contact, EVC_FORMAT_VCARD_30));
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_get_string
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EContact_e_1contact_1get_1string
(JNIEnv *env, jclass cls, jobject obj, jint field_id)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    char const *field_data = e_contact_get_const(contact, (int)field_id);

    return (*env)->NewStringUTF(env, field_data);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_set_string
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContact_e_1contact_1set_1string
(JNIEnv *env, jclass cls, jobject obj, jint field_id, jstring value)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    e_contact_set(contact, (int)field_id, value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_get_address
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContact_e_1contact_1get_1address
(JNIEnv *env, jclass cls, jobject obj, jint field_id)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    return getStructHandle(env, e_contact_get(contact, (int)field_id), NULL, (JGFreeFunc)e_contact_address_free);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_set_address
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContact_e_1contact_1set_1address
(JNIEnv *env, jclass cls, jobject obj, jint field_id, jobject value)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    e_contact_set(contact, (int)field_id, getPointerFromHandle(env, value));
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_get_photo
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContact_e_1contact_1get_1photo
(JNIEnv *env, jclass cls, jobject obj, jint field_id)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    EContactPhoto *photo = e_contact_get(contact, (int)field_id);
    return getStructHandle(env, photo, NULL, (JGFreeFunc)e_contact_photo_free);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_set_photo
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContact_e_1contact_1set_1photo
(JNIEnv *env, jclass cls, jobject obj, jint field_id, jobject value)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    EContactPhoto *contact_photo = (EContactPhoto*)getPointerFromHandle(env, value);
    e_contact_set(contact, (int)field_id, contact_photo);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_get_date
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContact_e_1contact_1get_1date
(JNIEnv *env, jclass cls, jobject obj, jint field_id)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    EContactDate *date = e_contact_get(contact, (int)field_id);
    return getStructHandle(env, date, NULL, (JGFreeFunc)e_contact_date_free);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_set_date
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContact_e_1contact_1set_1date
(JNIEnv *env, jclass cls, jobject obj, jint field_id, jobject value)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    EContactDate *contact_date = (EContactDate*)getPointerFromHandle(env, value);
    e_contact_set(contact, (int)field_id, contact_date);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_get_name
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContact_e_1contact_1get_1name
(JNIEnv *env, jclass cls, jobject obj, jint field_id)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    EContactName *name = e_contact_get(contact, (int)field_id);
    return getStructHandle(env, name, NULL, (JGFreeFunc)e_contact_name_free);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_set_name
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContact_e_1contact_1set_1name
(JNIEnv *env, jclass cls, jobject obj, jint field_id, jobject value)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, value);
    e_contact_set(contact, (int)field_id, contact_name);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_get_boolean
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libebook_EContact_e_1contact_1get_1boolean
(JNIEnv *env, jclass cls, jobject obj, jint field_id)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    return e_contact_get(contact, (int)field_id);
}

/*
 * Class:     org_gnu_libebook_EContact
 * Method:    e_contact_set_boolean
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContact_e_1contact_1set_1boolean
(JNIEnv *env, jclass cls, jobject obj, jint field_id, jboolean value)
{
    EContact *contact = (EContact*)getPointerFromHandle(env, obj);
    e_contact_set(contact, (int)field_id, value);
}


#ifdef __cplusplus
}

#endif
