/* iagno.c generated by valac 0.27.1.12-a3c8, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_THEMES_DIALOG (themes_dialog_get_type ())
#define THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES_DIALOG, ThemesDialog))
#define THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES_DIALOG, ThemesDialogClass))
#define IS_THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES_DIALOG))
#define IS_THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES_DIALOG))
#define THEMES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES_DIALOG, ThemesDialogClass))

typedef struct _ThemesDialog ThemesDialog;
typedef struct _ThemesDialogClass ThemesDialogClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define IAGNO_TYPE_SOUND (iagno_sound_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _IagnoPrivate {
	GSettings* settings;
	gboolean is_tiled;
	gboolean is_maximized;
	gint window_width;
	gint window_height;
	GtkWindow* window;
	GtkHeaderBar* headerbar;
	GameView* view;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	GtkStack* main_stack;
	ThemesDialog* themes_dialog;
	GtkButton* back_button;
	GtkButton* undo_button;
	GSimpleAction* back_action;
	ComputerPlayer* computer;
	Player player_one;
	Game* game;
};

typedef enum  {
	IAGNO_SOUND_FLIP,
	IAGNO_SOUND_GAMEOVER
} IagnoSound;

struct _Block3Data {
	int _ref_count_;
	Iagno* self;
	GtkBox* level_box;
	GtkBox* color_box;
};


static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gboolean iagno_alternative_start;
static gboolean iagno_alternative_start = FALSE;
static gint iagno_computer_level;
static gint iagno_computer_level = 0;
static gint iagno_size;
static gint iagno_size = 8;
static gboolean iagno_begin_with_new_game_screen;
static gboolean iagno_begin_with_new_game_screen = FALSE;
static gchar* iagno_color;
static gchar* iagno_color = NULL;
static gboolean* iagno_sound;
static gboolean* iagno_sound = NULL;
static gboolean* iagno_two_players;
static gboolean* iagno_two_players = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType themes_dialog_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static GType iagno_sound_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define IAGNO_QUICK_MOVE_DELAY 0.4
#define IAGNO_MODERATE_MOVE_DELAY 1.0
#define IAGNO_SLOW_MOVE_DELAY 2.0
static void iagno_new_game_cb (Iagno* self);
static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_start_game_cb (Iagno* self);
static void _iagno_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_undo_move_cb (Iagno* self);
static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_back_cb (Iagno* self);
static void _iagno_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_theme_cb (Iagno* self);
static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint iagno_main (gchar** args, int args_length1);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static void iagno_real_startup (GApplication* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda8_ (Block3Data* _data3_);
static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda9_ (Block3Data* _data3_);
static void ___lambda9__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void iagno_size_allocate_cb (Iagno* self, GtkAllocation* allocation);
static void _iagno_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event);
static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
static void iagno_show_new_game_screen (Iagno* self);
static void iagno_start_game (Iagno* self);
static void iagno_real_activate (GApplication* base);
static void iagno_real_shutdown (GApplication* base);
ThemesDialog* themes_dialog_new (GSettings* settings, GameView* view);
ThemesDialog* themes_dialog_construct (GType object_type, GSettings* settings, GameView* view);
static void iagno_show_game_board (Iagno* self);
Player game_get_current_color (Game* self);
gboolean game_get_is_complete (Game* self);
void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_);
static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound);
void computer_player_cancel_move (ComputerPlayer* self);
Game* game_new (gboolean alternative_start, gint tmp_size);
Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size);
static void iagno_turn_ended_cb (Iagno* self);
static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self);
void game_view_set_game (GameView* self, Game* value);
ComputerPlayer* computer_player_new (Game* game, gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level);
static void iagno_update_ui (Iagno* self);
gint game_get_number_of_moves (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_get_current_player_can_move (Game* self);
static void iagno_play_sound (Iagno* self, IagnoSound sound);
void game_view_update_scoreboard (GameView* self);
static void iagno_prepare_move (Iagno* self);
static void iagno_pass (Iagno* self);
void game_pass (Game* self);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry IAGNO_option_entries[11] = {{"alternative-start", (gchar) 0, 0, G_OPTION_ARG_NONE, &iagno_alternative_start, "Start with an alternative position", NULL}, {"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, "Reduce delay before AI moves", NULL}, {"first", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play first", NULL}, {"level", 'l', 0, G_OPTION_ARG_INT, &iagno_computer_level, "Set the level of the computer's AI", "LEVEL"}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"second", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play second", NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &iagno_size, "Size of the board (debug only)", "SIZE"}, {"two-players", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Two-players mode", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry IAGNO_app_actions[8] = {{"new-game", _iagno_new_game_cb_gsimple_action_activate_callback}, {"start-game", _iagno_start_game_cb_gsimple_action_activate_callback}, {"undo-move", _iagno_undo_move_cb_gsimple_action_activate_callback}, {"back", _iagno_back_cb_gsimple_action_activate_callback}, {"theme", _iagno_theme_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static GType iagno_sound_get_type (void) {
	static volatile gsize iagno_sound_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_sound_type_id__volatile)) {
		static const GEnumValue values[] = {{IAGNO_SOUND_FLIP, "IAGNO_SOUND_FLIP", "flip"}, {IAGNO_SOUND_GAMEOVER, "IAGNO_SOUND_GAMEOVER", "gameover"}, {0, NULL, NULL}};
		GType iagno_sound_type_id;
		iagno_sound_type_id = g_enum_register_static ("IagnoSound", values);
		g_once_init_leave (&iagno_sound_type_id__volatile, iagno_sound_type_id);
	}
	return iagno_sound_type_id__volatile;
}


static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_new_game_cb ((Iagno*) self);
#line 275 "iagno.c"
}


static void _iagno_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_start_game_cb ((Iagno*) self);
#line 282 "iagno.c"
}


static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_undo_move_cb ((Iagno*) self);
#line 289 "iagno.c"
}


static void _iagno_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_back_cb ((Iagno*) self);
#line 296 "iagno.c"
}


static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_theme_cb ((Iagno*) self);
#line 303 "iagno.c"
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_help_cb ((Iagno*) self);
#line 310 "iagno.c"
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_about_cb ((Iagno*) self);
#line 317 "iagno.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_application_quit ((GApplication*) self);
#line 324 "iagno.c"
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Iagno* _tmp1_ = NULL;
	Iagno* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	setlocale (LC_ALL, "");
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	textdomain (GETTEXT_PACKAGE);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = _ ("Iagno");
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_set_application_name (_tmp0_);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_set_default_icon_name ("iagno");
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = iagno_new ();
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = args;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3__length1 = args_length1;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp2_);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	result = _tmp5_;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 369 "iagno.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return iagno_main (argv, argc);
#line 379 "iagno.c"
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self;
#line 391 "iagno.c"
}


Iagno* iagno_new (void) {
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return iagno_construct (TYPE_IAGNO);
#line 398 "iagno.c"
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	dup = g_new0 (gboolean, 1);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return dup;
#line 410 "iagno.c"
}


static gpointer __bool_dup0 (gpointer self) {
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self ? _bool_dup (self) : NULL;
#line 417 "iagno.c"
}


static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Iagno * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp3_ = 0;
	GVariantDict* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GVariantDict* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	GVariantDict* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = options;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 445 "iagno.c"
		FILE* _tmp2_ = NULL;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = stderr;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "iagno", VERSION);
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		result = EXIT_SUCCESS;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return result;
#line 455 "iagno.c"
	}
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = iagno_size;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp3_ < 4) {
#line 461 "iagno.c"
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = stderr;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _ ("Size must be at least 4.");
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp4_, "%s\n", _tmp5_);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		result = EXIT_FAILURE;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return result;
#line 474 "iagno.c"
	}
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = options;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = g_variant_dict_contains (_tmp6_, "unmute");
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp7_) {
#line 482 "iagno.c"
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_ = NULL;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = TRUE;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = __bool_dup0 (&_tmp8_);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_sound);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_sound = _tmp9_;
#line 493 "iagno.c"
	}
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp10_ = options;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = g_variant_dict_contains (_tmp10_, "mute");
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp11_) {
#line 501 "iagno.c"
		gboolean _tmp12_ = FALSE;
		gboolean* _tmp13_ = NULL;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = FALSE;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = __bool_dup0 (&_tmp12_);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_sound);
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_sound = _tmp13_;
#line 512 "iagno.c"
	}
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = iagno_computer_level;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp15_ < 0) {
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = TRUE;
#line 520 "iagno.c"
	} else {
		gint _tmp16_ = 0;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp16_ = iagno_computer_level;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = _tmp16_ > 3;
#line 527 "iagno.c"
	}
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp14_) {
#line 531 "iagno.c"
		FILE* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp17_ = stderr;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged.");
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp17_, "%s\n", _tmp18_);
#line 540 "iagno.c"
	}
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = options;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp20_ = g_variant_dict_contains (_tmp19_, "two-players");
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp20_) {
#line 548 "iagno.c"
		gboolean _tmp21_ = FALSE;
		gboolean* _tmp22_ = NULL;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = TRUE;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp22_ = __bool_dup0 (&_tmp21_);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_two_players);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_two_players = _tmp22_;
#line 559 "iagno.c"
	} else {
		GVariantDict* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp23_ = options;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp24_ = g_variant_dict_contains (_tmp23_, "first");
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp24_) {
#line 569 "iagno.c"
			gchar* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gboolean* _tmp27_ = NULL;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp25_ = g_strdup ("dark");
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (iagno_color);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_color = _tmp25_;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp26_ = FALSE;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp27_ = __bool_dup0 (&_tmp26_);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (iagno_two_players);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_two_players = _tmp27_;
#line 587 "iagno.c"
		} else {
			GVariantDict* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp28_ = options;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp29_ = g_variant_dict_contains (_tmp28_, "second");
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			if (_tmp29_) {
#line 597 "iagno.c"
				gchar* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				gboolean* _tmp32_ = NULL;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp30_ = g_strdup ("light");
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_g_free0 (iagno_color);
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				iagno_color = _tmp30_;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp31_ = FALSE;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp32_ = __bool_dup0 (&_tmp31_);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_g_free0 (iagno_two_players);
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				iagno_two_players = _tmp32_;
#line 615 "iagno.c"
			} else {
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				iagno_begin_with_new_game_screen = TRUE;
#line 619 "iagno.c"
			}
		}
	}
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	result = -1;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 627 "iagno.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return _data3_;
#line 636 "iagno.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 645 "iagno.c"
		Iagno* self;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self = _data3_->self;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (_data3_->color_box);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (_data3_->level_box);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_slice_free (Block3Data, _data3_);
#line 657 "iagno.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self ? g_object_ref (self) : NULL;
#line 665 "iagno.c"
}


static void __lambda8_ (Block3Data* _data3_) {
	Iagno* self;
	GtkBox* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = _data3_->self;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = _data3_->level_box;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = g_settings_get_int (_tmp1_, "num-players");
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_ == 1);
#line 684 "iagno.c"
}


static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	__lambda8_ (self);
#line 691 "iagno.c"
}


static void __lambda9_ (Block3Data* _data3_) {
	Iagno* self;
	GtkBox* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = _data3_->self;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = _data3_->color_box;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = g_settings_get_int (_tmp1_, "num-players");
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_ == 1);
#line 710 "iagno.c"
}


static void ___lambda9__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	__lambda9_ (self);
#line 717 "iagno.c"
}


static void _iagno_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_size_allocate_cb ((Iagno*) self, allocation);
#line 724 "iagno.c"
}


static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = iagno_window_state_event_cb ((Iagno*) self, event);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 733 "iagno.c"
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_player_move_cb ((Iagno*) self, x, y);
#line 740 "iagno.c"
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	Block3Data* _data3_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_ = NULL;
	GtkCssProvider* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GtkCssProvider* _tmp3_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	gboolean* _tmp6_ = NULL;
	gboolean* _tmp9_ = NULL;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp22_ = FALSE;
	gint _tmp23_ = 0;
	gchar* _tmp29_ = NULL;
	gchar** _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gchar* _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gchar** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	GSettings* _tmp35_ = NULL;
	GAction* _tmp36_ = NULL;
	GAction* _tmp37_ = NULL;
	GSettings* _tmp38_ = NULL;
	GAction* _tmp39_ = NULL;
	GAction* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	GAction* _tmp42_ = NULL;
	GAction* _tmp43_ = NULL;
	GSettings* _tmp44_ = NULL;
	GAction* _tmp45_ = NULL;
	GAction* _tmp46_ = NULL;
	GtkBuilder* _tmp47_ = NULL;
	GObject* _tmp48_ = NULL;
	GtkBox* _tmp49_ = NULL;
	GSettings* _tmp50_ = NULL;
	GtkBox* _tmp51_ = NULL;
	GSettings* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkBox* _tmp56_ = NULL;
	GSettings* _tmp57_ = NULL;
	GtkBox* _tmp58_ = NULL;
	GSettings* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	GtkBuilder* _tmp61_ = NULL;
	GObject* _tmp62_ = NULL;
	GtkWindow* _tmp63_ = NULL;
	GtkWindow* _tmp64_ = NULL;
	GtkWindow* _tmp65_ = NULL;
	GtkWindow* _tmp66_ = NULL;
	GSettings* _tmp67_ = NULL;
	gint _tmp68_ = 0;
	GSettings* _tmp69_ = NULL;
	gint _tmp70_ = 0;
	GSettings* _tmp71_ = NULL;
	gboolean _tmp72_ = FALSE;
	GtkWindow* _tmp74_ = NULL;
	GSettings* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GSettings* _tmp77_ = NULL;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	gboolean* _tmp80_ = NULL;
	GSettings* _tmp81_ = NULL;
	GameView* _tmp82_ = NULL;
	GameView* _tmp83_ = NULL;
	GtkBuilder* _tmp84_ = NULL;
	GObject* _tmp85_ = NULL;
	GameView* _tmp86_ = NULL;
	GameView* _tmp87_ = NULL;
	GSettings* _tmp88_ = NULL;
	gchar* _tmp89_ = NULL;
	gchar* _tmp90_ = NULL;
	GameView* _tmp91_ = NULL;
	GameView* _tmp92_ = NULL;
	GtkBox* game_box = NULL;
	GtkBuilder* _tmp93_ = NULL;
	GObject* _tmp94_ = NULL;
	GtkBox* _tmp95_ = NULL;
	GtkBox* _tmp96_ = NULL;
	GameView* _tmp97_ = NULL;
	GtkBuilder* _tmp98_ = NULL;
	GObject* _tmp99_ = NULL;
	GtkHeaderBar* _tmp100_ = NULL;
	GtkBuilder* _tmp101_ = NULL;
	GObject* _tmp102_ = NULL;
	GtkLabel* _tmp103_ = NULL;
	GtkBuilder* _tmp104_ = NULL;
	GObject* _tmp105_ = NULL;
	GtkLabel* _tmp106_ = NULL;
	GtkBuilder* _tmp107_ = NULL;
	GObject* _tmp108_ = NULL;
	GtkStack* _tmp109_ = NULL;
	GtkBuilder* _tmp110_ = NULL;
	GObject* _tmp111_ = NULL;
	GtkButton* _tmp112_ = NULL;
	GtkBuilder* _tmp113_ = NULL;
	GObject* _tmp114_ = NULL;
	GtkButton* _tmp115_ = NULL;
	GAction* _tmp116_ = NULL;
	GSimpleAction* _tmp117_ = NULL;
	gboolean _tmp118_ = FALSE;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->_ref_count_ = 1;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->self = g_object_ref (self);
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = gtk_css_provider_new ();
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	css_provider = _tmp0_;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = css_provider;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_css_provider_load_from_resource (_tmp1_, "/org/gnome/iagno/ui/iagno.css");
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = gdk_screen_get_default ();
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = css_provider;
#line 163 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = gtk_builder_new_from_resource ("/org/gnome/iagno/ui/iagno.ui");
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	builder = _tmp4_;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = g_settings_new ("org.gnome.iagno");
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->settings = _tmp5_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = iagno_sound;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp6_ != NULL) {
#line 890 "iagno.c"
		GSettings* _tmp7_ = NULL;
		gboolean* _tmp8_ = NULL;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->settings;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = iagno_sound;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_boolean (_tmp7_, "sound", *_tmp8_);
#line 899 "iagno.c"
	}
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp9_ = iagno_two_players;
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp9_ != NULL) {
#line 905 "iagno.c"
		gint _tmp10_ = 0;
		gboolean* _tmp11_ = NULL;
		GSettings* _tmp12_ = NULL;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = iagno_two_players;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (*_tmp11_) {
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp10_ = 2;
#line 915 "iagno.c"
		} else {
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp10_ = 1;
#line 919 "iagno.c"
		}
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->settings;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_int (_tmp12_, "num-players", _tmp10_);
#line 925 "iagno.c"
	} else {
		GSettings* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		gboolean* _tmp16_ = NULL;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = self->priv->settings;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = g_settings_get_int (_tmp13_, "num-players");
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = _tmp14_ == 2;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp16_ = __bool_dup0 (&_tmp15_);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_two_players);
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_two_players = _tmp16_;
#line 943 "iagno.c"
	}
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = iagno_color;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp17_ != NULL) {
#line 949 "iagno.c"
		GSettings* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = self->priv->settings;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp19_ = iagno_color;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_string (_tmp18_, "color", _tmp19_);
#line 958 "iagno.c"
	} else {
		GSettings* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp20_ = self->priv->settings;
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = g_settings_get_string (_tmp20_, "color");
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_color);
#line 181 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_color = _tmp21_;
#line 970 "iagno.c"
	}
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp23_ = iagno_computer_level;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp23_ > 0) {
#line 976 "iagno.c"
		gint _tmp24_ = 0;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp24_ = iagno_computer_level;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp22_ = _tmp24_ <= 3;
#line 982 "iagno.c"
	} else {
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp22_ = FALSE;
#line 986 "iagno.c"
	}
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp22_) {
#line 990 "iagno.c"
		GSettings* _tmp25_ = NULL;
		gint _tmp26_ = 0;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp25_ = self->priv->settings;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp26_ = iagno_computer_level;
#line 184 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_int (_tmp25_, "computer-level", _tmp26_);
#line 999 "iagno.c"
	} else {
		GSettings* _tmp27_ = NULL;
		gint _tmp28_ = 0;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp27_ = self->priv->settings;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp28_ = g_settings_get_int (_tmp27_, "computer-level");
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_computer_level = _tmp28_;
#line 1009 "iagno.c"
	}
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp29_ = g_strdup ("<Primary>n");
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp30_ = g_new0 (gchar*, 1 + 1);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp30_[0] = _tmp29_;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp31_ = _tmp30_;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp31__length1 = 1;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp31_);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp32_ = g_strdup ("<Primary>z");
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp33_ = g_new0 (gchar*, 1 + 1);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp33_[0] = _tmp32_;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp34_ = _tmp33_;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp34__length1 = 1;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo-move", _tmp34_);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp35_ = self->priv->settings;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp36_ = g_settings_create_action (_tmp35_, "sound");
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp37_ = _tmp36_;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp37_);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp37_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp38_ = self->priv->settings;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp39_ = g_settings_create_action (_tmp38_, "color");
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp40_ = _tmp39_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp40_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp40_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp41_ = self->priv->settings;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp42_ = g_settings_create_action (_tmp41_, "num-players");
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp43_ = _tmp42_;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp43_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp43_);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp44_ = self->priv->settings;
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp45_ = g_settings_create_action (_tmp44_, "computer-level");
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp46_ = _tmp45_;
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp46_);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp46_);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp47_ = builder;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp48_ = gtk_builder_get_object (_tmp47_, "difficulty-box");
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, gtk_box_get_type ()) ? ((GtkBox*) _tmp48_) : NULL);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->level_box = _tmp49_;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp50_ = self->priv->settings;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp50_, "changed::num-players", (GCallback) ___lambda8__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp51_ = _data3_->level_box;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp52_ = self->priv->settings;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp53_ = g_settings_get_int (_tmp52_, "num-players");
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp51_, _tmp53_ == 1);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp54_ = builder;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp55_ = gtk_builder_get_object (_tmp54_, "color-box");
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, gtk_box_get_type ()) ? ((GtkBox*) _tmp55_) : NULL);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->color_box = _tmp56_;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp57_ = self->priv->settings;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp57_, "changed::num-players", (GCallback) ___lambda9__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp58_ = _data3_->color_box;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp59_ = self->priv->settings;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp60_ = g_settings_get_int (_tmp59_, "num-players");
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp58_, _tmp60_ == 1);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp61_ = builder;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp62_ = gtk_builder_get_object (_tmp61_, "window");
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp63_ = _g_object_ref0 ((GtkWindow*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp62_) : NULL));
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->window = _tmp63_;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp64_ = self->priv->window;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp64_, "size-allocate", (GCallback) _iagno_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp65_ = self->priv->window;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp65_, "window-state-event", (GCallback) _iagno_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp66_ = self->priv->window;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp67_ = self->priv->settings;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp68_ = g_settings_get_int (_tmp67_, "window-width");
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp69_ = self->priv->settings;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp70_ = g_settings_get_int (_tmp69_, "window-height");
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_set_default_size (_tmp66_, _tmp68_, _tmp70_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp71_ = self->priv->settings;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp72_ = g_settings_get_boolean (_tmp71_, "window-is-maximized");
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp72_) {
#line 1157 "iagno.c"
		GtkWindow* _tmp73_ = NULL;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp73_ = self->priv->window;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_window_maximize (_tmp73_);
#line 1163 "iagno.c"
	}
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp74_ = self->priv->window;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_add_window ((GtkApplication*) self, _tmp74_);
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_sync ();
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp75_ = self->priv->settings;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp76_ = iagno_color;
#line 224 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_string (_tmp75_, "color", _tmp76_);
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp77_ = self->priv->settings;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp78_ = iagno_computer_level;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_int (_tmp77_, "computer-level", _tmp78_);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp80_ = iagno_two_players;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (*_tmp80_) {
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp79_ = 2;
#line 1189 "iagno.c"
	} else {
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp79_ = 1;
#line 1193 "iagno.c"
	}
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp81_ = self->priv->settings;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_int (_tmp81_, "num-players", _tmp79_);
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp82_ = game_view_new ();
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp82_);
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->view = _tmp82_;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp83_ = self->priv->view;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp84_ = builder;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp85_ = gtk_builder_get_object (_tmp84_, "scoreboard");
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_scoreboard (_tmp83_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, gtk_drawing_area_get_type ()) ? ((GtkDrawingArea*) _tmp85_) : NULL);
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp86_ = self->priv->view;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp86_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp87_ = self->priv->view;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp88_ = self->priv->settings;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp89_ = g_settings_get_string (_tmp88_, "theme");
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp90_ = _tmp89_;
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_theme (_tmp87_, _tmp90_);
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp90_);
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp91_ = self->priv->view;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp91_, GTK_ALIGN_FILL);
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp92_ = self->priv->view;
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp92_);
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp93_ = builder;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp94_ = gtk_builder_get_object (_tmp93_, "game-box");
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp94_, gtk_box_get_type ()) ? ((GtkBox*) _tmp94_) : NULL);
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_box = _tmp95_;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp96_ = game_box;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp97_ = self->priv->view;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_box_pack_start (_tmp96_, (GtkWidget*) _tmp97_, TRUE, TRUE, (guint) 0);
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp98_ = builder;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp99_ = gtk_builder_get_object (_tmp98_, "headerbar");
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp100_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp99_) : NULL);
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->headerbar = _tmp100_;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp101_ = builder;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp102_ = gtk_builder_get_object (_tmp101_, "light-score-label");
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp103_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp102_) : NULL);
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->light_score_label = _tmp103_;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp104_ = builder;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp105_ = gtk_builder_get_object (_tmp104_, "dark-score-label");
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp106_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp105_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp105_) : NULL);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->dark_score_label = _tmp106_;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp107_ = builder;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp108_ = gtk_builder_get_object (_tmp107_, "main_stack");
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, gtk_stack_get_type ()) ? ((GtkStack*) _tmp108_) : NULL);
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->main_stack = _tmp109_;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp110_ = builder;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp111_ = gtk_builder_get_object (_tmp110_, "back_button");
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp112_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp111_, gtk_button_get_type ()) ? ((GtkButton*) _tmp111_) : NULL);
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->back_button);
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->back_button = _tmp112_;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp113_ = builder;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp114_ = gtk_builder_get_object (_tmp113_, "undo_button");
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp115_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp114_, gtk_button_get_type ()) ? ((GtkButton*) _tmp114_) : NULL);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->undo_button);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->undo_button = _tmp115_;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp116_ = g_action_map_lookup_action ((GActionMap*) self, "back");
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp117_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, g_simple_action_get_type (), GSimpleAction));
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->back_action);
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->back_action = _tmp117_;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp118_ = iagno_begin_with_new_game_screen;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp118_) {
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_show_new_game_screen (self);
#line 1327 "iagno.c"
	} else {
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_start_game (self);
#line 1331 "iagno.c"
	}
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (game_box);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (builder);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (css_provider);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	block3_data_unref (_data3_);
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_ = NULL;
#line 1343 "iagno.c"
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GtkWindow* _tmp0_ = NULL;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_present (_tmp0_);
#line 1356 "iagno.c"
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->window_width;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->settings;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = self->priv->window_height;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = self->priv->settings;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->is_maximized;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
#line 1390 "iagno.c"
}


static void iagno_size_allocate_cb (Iagno* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (allocation != NULL);
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->is_maximized;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = TRUE;
#line 1411 "iagno.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->is_tiled;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = _tmp2_;
#line 1418 "iagno.c"
	}
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 279 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 1424 "iagno.c"
	}
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = *allocation;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_.width;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->window_width = _tmp4_;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = *allocation;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = _tmp5_.height;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->window_height = _tmp6_;
#line 1438 "iagno.c"
}


static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = event;
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1458 "iagno.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = event;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1467 "iagno.c"
	}
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = event;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1475 "iagno.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = event;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1484 "iagno.c"
	}
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	result = FALSE;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 1490 "iagno.c"
}


static void iagno_theme_cb (Iagno* self) {
	ThemesDialog* _tmp0_ = NULL;
	ThemesDialog* _tmp6_ = NULL;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->themes_dialog;
#line 301 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1503 "iagno.c"
		GSettings* _tmp1_ = NULL;
		GameView* _tmp2_ = NULL;
		ThemesDialog* _tmp3_ = NULL;
		ThemesDialog* _tmp4_ = NULL;
		GtkWindow* _tmp5_ = NULL;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->settings;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->view;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = themes_dialog_new (_tmp1_, _tmp2_);
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_object_ref_sink (_tmp3_);
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->themes_dialog);
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->themes_dialog = _tmp3_;
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = self->priv->themes_dialog;
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = self->priv->window;
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp4_, _tmp5_);
#line 1527 "iagno.c"
	}
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = self->priv->themes_dialog;
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_present ((GtkWindow*) _tmp6_);
#line 1533 "iagno.c"
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
#line 309 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 1541 "iagno.c"
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = self->priv->window;
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1556 "iagno.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		e = _inner_error_;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = e;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->message;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_warning ("iagno.vala:317: Failed to show help: %s", _tmp4_);
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 1578 "iagno.c"
	}
	__finally5:
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 1589 "iagno.c"
	}
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = g_strdup ("Ian Peters");
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_strdup ("Robert Ancell");
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = g_new0 (gchar*, 3 + 1);
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[0] = _tmp0_;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[1] = _tmp1_;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[2] = NULL;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors = _tmp2_;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors_length1 = 3;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_authors_size_ = authors_length1;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = g_strdup ("Tiffany Antopolski");
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_[0] = _tmp3_;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_[1] = NULL;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters = _tmp4_;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters_length1 = 2;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_documenters_size_ = documenters_length1;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->window;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = _ ("Iagno");
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = _ ("A disk flipping game derived from Reversi");
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp8_ = _ ("translator-credits");
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_show_about_dialog (_tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" "Copyright © 2013–2015 Michael Catanzaro\n" "Copyright © 2014–2015 Arnaud Bonatti", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp7_, "authors", authors, "documenters", documenters, "translator-credits", _tmp8_, "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1658 "iagno.c"
}


static void iagno_start_game_cb (Iagno* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
#line 348 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->main_stack;
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->back_button;
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_start_game (self);
#line 1677 "iagno.c"
}


static void iagno_back_cb (Iagno* self) {
	GtkStack* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Game* _tmp4_ = NULL;
	Player _tmp5_ = 0;
	Player _tmp6_ = 0;
	Player _tmp7_ = 0;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->main_stack;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
#line 358 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_show_game_board (self);
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->back_action;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = self->priv->game;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = game_get_current_color (_tmp4_);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = _tmp5_;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = self->priv->player_one;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp6_ != _tmp7_) {
#line 1712 "iagno.c"
		ComputerPlayer* _tmp8_ = NULL;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = self->priv->computer;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = _tmp8_ != NULL;
#line 1718 "iagno.c"
	} else {
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = FALSE;
#line 1722 "iagno.c"
	}
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp3_) {
#line 1726 "iagno.c"
		Game* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = self->priv->game;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = game_get_is_complete (_tmp9_);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = _tmp10_;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = !_tmp11_;
#line 1738 "iagno.c"
	} else {
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = FALSE;
#line 1742 "iagno.c"
	}
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_) {
#line 1746 "iagno.c"
		ComputerPlayer* _tmp12_ = NULL;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->computer;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_move_async (_tmp12_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
#line 1752 "iagno.c"
	} else {
		Game* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = self->priv->game;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = game_get_is_complete (_tmp13_);
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = _tmp14_;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp15_) {
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_game_complete (self, FALSE);
#line 1767 "iagno.c"
		}
	}
}


static void iagno_show_game_board (Iagno* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->main_stack;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->back_button;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->undo_button;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
#line 1791 "iagno.c"
}


static void iagno_show_new_game_screen (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1805 "iagno.c"
		ComputerPlayer* _tmp1_ = NULL;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->computer;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp1_);
#line 1811 "iagno.c"
	}
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->main_stack;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_stack_set_visible_child_name (_tmp2_, "start-box");
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = self->priv->undo_button;
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
#line 1821 "iagno.c"
}


static void iagno_new_game_cb (Iagno* self) {
	GtkStack* _tmp0_ = NULL;
	GtkHeaderBar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->main_stack;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_show_new_game_screen (self);
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->headerbar;
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_header_bar_set_subtitle (_tmp1_, NULL);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->back_button;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = self->priv->back_action;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 1850 "iagno.c"
}


static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self) {
#line 403 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_turn_ended_cb ((Iagno*) self);
#line 1857 "iagno.c"
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	ComputerPlayer* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	GameView* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	Player _tmp19_ = 0;
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1882 "iagno.c"
		Game* _tmp1_ = NULL;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1888 "iagno.c"
	}
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->computer;
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_ != NULL) {
#line 1894 "iagno.c"
		ComputerPlayer* _tmp3_ = NULL;
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->computer;
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp3_);
#line 1900 "iagno.c"
	}
#line 400 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_show_game_board (self);
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = iagno_alternative_start;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = iagno_size;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = game_new (_tmp4_, _tmp5_);
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->game = _tmp6_;
#line 403 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = self->priv->game;
#line 403 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp7_, "turn-ended", (GCallback) _iagno_turn_ended_cb_game_turn_ended, self, 0);
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp8_ = self->priv->view;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp9_ = self->priv->game;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_game (_tmp8_, _tmp9_);
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp10_ = self->priv->settings;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "num-players");
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp11_ == 2) {
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->computer = NULL;
#line 1934 "iagno.c"
	} else {
		Game* _tmp12_ = NULL;
		GSettings* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		ComputerPlayer* _tmp15_ = NULL;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->game;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = self->priv->settings;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = g_settings_get_int (_tmp13_, "computer-level");
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = computer_player_new (_tmp12_, _tmp14_);
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->computer = _tmp15_;
#line 1952 "iagno.c"
	}
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = self->priv->settings;
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = g_settings_get_enum (_tmp16_, "color");
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp17_ == 1) {
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->player_one = PLAYER_LIGHT;
#line 1962 "iagno.c"
	} else {
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->player_one = PLAYER_DARK;
#line 1966 "iagno.c"
	}
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = self->priv->player_one;
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp19_ != PLAYER_DARK) {
#line 1974 "iagno.c"
		ComputerPlayer* _tmp20_ = NULL;
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp20_ = self->priv->computer;
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = _tmp20_ != NULL;
#line 1980 "iagno.c"
	} else {
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = FALSE;
#line 1984 "iagno.c"
	}
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp18_) {
#line 1988 "iagno.c"
		ComputerPlayer* _tmp21_ = NULL;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = self->priv->computer;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_move_async (_tmp21_, IAGNO_MODERATE_MOVE_DELAY, NULL, NULL);
#line 1994 "iagno.c"
	}
}


static void iagno_update_ui (Iagno* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GSimpleAction* undo_action = NULL;
	GAction* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Player _tmp4_ = 0;
	GtkLabel* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	Game* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->headerbar;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "undo-move");
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	undo_action = _tmp2_;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = self->priv->player_one;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = TRUE;
#line 2038 "iagno.c"
	} else {
		ComputerPlayer* _tmp5_ = NULL;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = self->priv->computer;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = _tmp5_ == NULL;
#line 2045 "iagno.c"
	}
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp3_) {
#line 2049 "iagno.c"
		GSimpleAction* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = undo_action;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_number_of_moves (_tmp7_);
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp6_, _tmp9_ >= 1);
#line 2064 "iagno.c"
	} else {
		GSimpleAction* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = undo_action;
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = game_get_number_of_moves (_tmp11_);
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp10_, _tmp13_ >= 2);
#line 2080 "iagno.c"
	}
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = self->priv->dark_score_label;
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = _ ("%.2d");
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = self->priv->game;
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = game_get_n_dark_tiles (_tmp16_);
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp18_ = _tmp17_;
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = g_strdup_printf (_tmp15_, _tmp18_);
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp20_ = _tmp19_;
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_label_set_text (_tmp14_, _tmp20_);
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp20_);
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp21_ = self->priv->light_score_label;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp22_ = _ ("%.2d");
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp23_ = self->priv->game;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp24_ = game_get_n_light_tiles (_tmp23_);
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp25_ = _tmp24_;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp26_ = g_strdup_printf (_tmp22_, _tmp25_);
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp27_ = _tmp26_;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_label_set_text (_tmp21_, _tmp27_);
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp27_);
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (undo_action);
#line 2120 "iagno.c"
}


static void iagno_undo_move_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
	GameView* _tmp17_ = NULL;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 2133 "iagno.c"
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_undo (_tmp1_, 1);
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->game;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = game_get_current_player_can_move (_tmp2_);
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (!_tmp4_) {
#line 2150 "iagno.c"
			Game* _tmp5_ = NULL;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp5_ = self->priv->game;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp5_, 1);
#line 2156 "iagno.c"
		}
	} else {
		ComputerPlayer* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		Player _tmp8_ = 0;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp6_);
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_color (_tmp7_);
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = self->priv->player_one;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp9_ != _tmp10_) {
#line 2178 "iagno.c"
			Game* _tmp11_ = NULL;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp11_ = self->priv->game;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp11_, 1);
#line 2184 "iagno.c"
		} else {
			Game* _tmp12_ = NULL;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp12_ = self->priv->game;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp12_, 2);
#line 2191 "iagno.c"
		}
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		while (TRUE) {
#line 2195 "iagno.c"
			Game* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			Game* _tmp16_ = NULL;
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp13_ = self->priv->game;
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp14_ = game_get_current_player_can_move (_tmp13_);
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp15_ = _tmp14_;
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			if (!(!_tmp15_)) {
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				break;
#line 2210 "iagno.c"
			}
#line 457 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp16_ = self->priv->game;
#line 457 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp16_, 2);
#line 2216 "iagno.c"
		}
	}
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 461 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = self->priv->view;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp17_);
#line 2227 "iagno.c"
}


static void iagno_turn_ended_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = game_get_current_player_can_move (_tmp0_);
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 468 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_) {
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_prepare_move (self);
#line 2249 "iagno.c"
	} else {
		Game* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->game;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = game_get_is_complete (_tmp3_);
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp5_) {
#line 471 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_game_complete (self, TRUE);
#line 2264 "iagno.c"
		} else {
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_pass (self);
#line 2268 "iagno.c"
		}
	}
}


static void iagno_prepare_move (Iagno* self) {
	GameView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 479 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 480 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->view;
#line 480 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp0_);
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 2299 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 2305 "iagno.c"
	} else {
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 2309 "iagno.c"
	}
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 2313 "iagno.c"
		gboolean _tmp7_ = FALSE;
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = iagno_fast_mode;
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp7_) {
#line 2319 "iagno.c"
			ComputerPlayer* _tmp8_ = NULL;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = self->priv->computer;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			computer_player_move_async (_tmp8_, IAGNO_QUICK_MOVE_DELAY, NULL, NULL);
#line 2325 "iagno.c"
		} else {
			ComputerPlayer* _tmp9_ = NULL;
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp9_ = self->priv->computer;
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			computer_player_move_async (_tmp9_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
#line 2332 "iagno.c"
		}
	}
}


static void iagno_pass (Iagno* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->view;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp0_);
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_pass (_tmp1_);
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 2364 "iagno.c"
		GtkHeaderBar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = self->priv->headerbar;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = _ ("Light must pass, Dark’s move");
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp5_, _tmp6_);
#line 2373 "iagno.c"
	} else {
		GtkHeaderBar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->headerbar;
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _ ("Dark must pass, Light’s move");
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp7_, _tmp8_);
#line 2383 "iagno.c"
	}
}


static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound) {
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp18_ = FALSE;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = game_get_n_light_tiles (_tmp0_);
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = self->priv->game;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = game_get_n_dark_tiles (_tmp3_);
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_ > _tmp5_) {
#line 2412 "iagno.c"
		GtkHeaderBar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->headerbar;
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = _ ("Light wins!");
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp6_, _tmp7_);
#line 2421 "iagno.c"
	} else {
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = self->priv->game;
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = game_get_n_dark_tiles (_tmp8_);
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_;
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = game_get_n_light_tiles (_tmp11_);
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 522 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp10_ > _tmp13_) {
#line 2443 "iagno.c"
			GtkHeaderBar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp14_ = self->priv->headerbar;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp15_ = _ ("Dark wins!");
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp14_, _tmp15_);
#line 2452 "iagno.c"
		} else {
			GtkHeaderBar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp16_ = self->priv->headerbar;
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp17_ = _ ("The game is draw.");
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp16_, _tmp17_);
#line 2462 "iagno.c"
		}
	}
#line 533 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp18_ = play_gameover_sound;
#line 533 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp18_) {
#line 534 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_play_sound (self, IAGNO_SOUND_GAMEOVER);
#line 2471 "iagno.c"
	}
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	Game* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 537 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 2499 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 2505 "iagno.c"
	} else {
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 2509 "iagno.c"
	}
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = TRUE;
#line 2515 "iagno.c"
	} else {
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_player_can_move (_tmp7_);
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = !_tmp9_;
#line 2528 "iagno.c"
	}
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 2534 "iagno.c"
	}
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp10_ = self->priv->game;
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = x;
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp12_ = y;
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp13_ = game_place_tile (_tmp10_, _tmp11_, _tmp12_, TRUE);
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp13_ == 0) {
#line 2546 "iagno.c"
		GtkHeaderBar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = self->priv->headerbar;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = _ ("You can’t move there!");
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp14_, _tmp15_);
#line 2555 "iagno.c"
	}
}


static void iagno_play_sound (Iagno* self, IagnoSound sound) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* name = NULL;
	IagnoSound _tmp2_ = 0;
	gchar* path = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint r = 0;
	GameView* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 560 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 563 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 2584 "iagno.c"
	}
#line 566 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = sound;
#line 566 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	switch (_tmp2_) {
#line 566 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		case IAGNO_SOUND_FLIP:
#line 2592 "iagno.c"
		{
			GameView* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp3_ = self->priv->view;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp4_ = game_view_get_sound_flip (_tmp3_);
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp5_ = _tmp4_;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp6_ = g_strdup (_tmp5_);
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			name = _tmp6_;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			break;
#line 2612 "iagno.c"
		}
#line 566 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		case IAGNO_SOUND_GAMEOVER:
#line 2616 "iagno.c"
		{
			GameView* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp7_ = self->priv->view;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = game_view_get_sound_gameover (_tmp7_);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp9_ = _tmp8_;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			name = _tmp10_;
#line 573 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			break;
#line 2636 "iagno.c"
		}
		default:
		{
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			return;
#line 2644 "iagno.c"
		}
	}
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = name;
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp12_ = g_build_filename (SOUND_DIRECTORY, _tmp11_, NULL);
#line 577 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	path = _tmp12_;
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp13_ = self->priv->view;
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = name;
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = path;
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = ca_gtk_play_for_widget ((GtkWidget*) _tmp13_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp14_, CA_PROP_MEDIA_FILENAME, _tmp15_, NULL);
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	r = _tmp16_;
#line 581 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = r;
#line 581 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp17_ != 0) {
#line 2667 "iagno.c"
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = name;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp19_ = path;
#line 582 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_warning ("iagno.vala:582: Error playing file: %s\nfilepath should be:%s", _tmp18_, _tmp19_);
#line 2676 "iagno.c"
	}
#line 560 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (path);
#line 560 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (name);
#line 2682 "iagno.c"
}


static void iagno_class_init (IagnoClass * klass) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_parent_class = g_type_class_peek_parent (klass);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->handle_local_options = iagno_real_handle_local_options;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->startup = iagno_real_startup;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->activate = iagno_real_activate;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->shutdown = iagno_real_shutdown;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
#line 2701 "iagno.c"
}


static void iagno_instance_init (Iagno * self) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv = IAGNO_GET_PRIVATE (self);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->computer = NULL;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->game = NULL;
#line 2712 "iagno.c"
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
#line 24 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 46 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 49 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 50 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->themes_dialog);
#line 52 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->back_button);
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->undo_button);
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->back_action);
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->computer);
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
#line 2748 "iagno.c"
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (gtk_application_get_type (), "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



