using GLib;
using GUPnP;

/*
 * TODO: 
 *  * make this example actually work ...
 *  
 *  * call setlocale
 *  * SIGTERM handler?
 */

public class Test.ServerTest : Object {
    Service content_dir;

    public static int main (string[] args) {
        Test.ServerTest test = new ServerTest ();
        return test.run (args);
    }

    private int run (string[] args) {
        Context ctxt;

        try {
            ctxt = new Context (null, null, 0);
        } catch (Error err) {
            critical (err.message);
            return 1;
        }

        print ("Running on port %u\n", ctxt.port);

        /* Create root device. Needs description.xml in working directory */
        RootDevice dev = new RootDevice (ctxt, "description.xml", ".");
        if (dev == null) {
            critical ("Creating root device failed");
            return 1;
        }

        /* Implement Browse action on ContentDirectory if available */
        content_dir =
            (Service) dev.get_service (
                    "urn:schemas-upnp-org:service:ContentDirectory");
        if (content_dir != null) {
            content_dir.action_invoked["Browse"] += on_browse;
            content_dir.notify_failed += on_notify_failed;
            Timeout.add (5000, timeout);
        }

        dev.available = true;

        MainLoop loop = new MainLoop (null, false);
        loop.run();

        return 0;
    }

    private void on_browse (Service service, owned ServiceAction action) {
        print ("Browse action was invoked\n");

        print ("\tLocales: ");
        GLib.List<string> locales = action.get_locales ();
        foreach (string locale in locales)
            print ("%s,", locale);
        print ("\n");

        string filter;
        action.get ("Filter", typeof (string), out filter,
                    null);
        print ("\tFilter: %s\n", filter);

        action.set ("Result", typeof (string), "Hello world",
                    "NumberReturned", typeof (int), 0,
                    "TotalMatches", typeof (int), 0,
                    "UpdateID", typeof (int), 31415927,
                    null);

        action.return ();
    }

    private void on_notify_failed (Service service,
                                   List    callback_url,
                                   Error   reason) {
        print ("NOTIFY failed: %s\n", reason.message);
    }

    private bool timeout () {
        content_dir.notify ("SystemUpdateID",
                            typeof (uint),
                            27182818,
                            null);
        return false;
    }

}
