/* gupnp-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "GUPnP", lower_case_cprefix = "gupnp_")]
namespace GUPnP {
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class Context : GSSDP.Client {
		[CCode (has_construct_function = false)]
		public Context (GLib.MainContext? main_context, string? @interface, uint port) throws GLib.Error;
		public void host_path (string local_path, string server_path);
		public void unhost_path (string server_path);
		public uint port { get; construct; }
		public Soup.Server server { get; }
		public Soup.Session session { get; }
		public uint subscription_timeout { get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class ContextManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public ContextManager (GLib.MainContext? main_context, uint port);
		public void manage_control_point (GUPnP.ControlPoint control_point);
		public void manage_root_device (GUPnP.RootDevice root_device);
		public GUPnP.ContextManager context_manager { construct; }
		[NoAccessorMethod]
		public void* main_context { get; construct; }
		[NoAccessorMethod]
		public uint port { get; construct; }
		public virtual signal void context_available (GUPnP.Context p0);
		public virtual signal void context_unavailable (GUPnP.Context p0);
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class ControlPoint : GSSDP.ResourceBrowser {
		[CCode (has_construct_function = false)]
		public ControlPoint (GUPnP.Context context, string target);
		[CCode (has_construct_function = false)]
		public ControlPoint.full (GUPnP.Context context, GUPnP.ResourceFactory factory, string target);
		public unowned GUPnP.Context get_context ();
		public unowned GLib.List<GUPnP.DeviceProxy> list_device_proxies ();
		public unowned GLib.List<GUPnP.ServiceProxy> list_service_proxies ();
		public GUPnP.ResourceFactory resource_factory { get; construct; }
		public virtual signal void device_proxy_available (GUPnP.DeviceProxy proxy);
		public virtual signal void device_proxy_unavailable (GUPnP.DeviceProxy proxy);
		public virtual signal void service_proxy_available (GUPnP.ServiceProxy proxy);
		public virtual signal void service_proxy_unavailable (GUPnP.ServiceProxy proxy);
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class Device : GUPnP.DeviceInfo {
		[NoAccessorMethod]
		public GUPnP.RootDevice root_device { owned get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class DeviceInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public DeviceInfo ();
		public string get_description_value (string element);
		public virtual GUPnP.DeviceInfo? get_device (string type);
		public unowned string get_device_type ();
		public string get_friendly_name ();
		public string get_icon_url (string requested_mime_type, int requested_depth, int requested_width, int requested_height, bool prefer_bigger, out unowned string mime_type, out int depth, out int width, out int height);
		public string get_manufacturer ();
		public string get_manufacturer_url ();
		public string get_model_description ();
		public string get_model_name ();
		public string get_model_number ();
		public string get_model_url ();
		public string get_presentation_url ();
		public string get_serial_number ();
		public virtual GUPnP.ServiceInfo? get_service (string type);
		public string get_upc ();
		public GLib.List<string> list_device_types ();
		public GLib.List<GUPnP.DeviceInfo> list_devices ();
		public GLib.List<string> list_dlna_capabilities ();
		public GLib.List<string> list_service_types ();
		public GLib.List<GUPnP.ServiceInfo> list_services ();
		public GUPnP.Context context { get; construct; }
		public string device_type { get; construct; }
		public string location { get; construct; }
		public GUPnP.ResourceFactory resource_factory { get; construct; }
		public string udn { get; construct; }
		public Soup.URI url_base { get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class DeviceProxy : GUPnP.DeviceInfo {
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class ResourceFactory : GLib.Object {
		[CCode (has_construct_function = false)]
		public ResourceFactory ();
		public static unowned GUPnP.ResourceFactory get_default ();
		public void register_resource_proxy_type (string upnp_type, GLib.Type type);
		public void register_resource_type (string upnp_type, GLib.Type type);
		public bool unregister_resource_proxy_type (string upnp_type);
		public bool unregister_resource_type (string upnp_type);
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class RootDevice : GUPnP.Device {
		[CCode (has_construct_function = false)]
		public RootDevice (GUPnP.Context context, string description_path, string description_dir);
		[CCode (has_construct_function = false)]
		public RootDevice.full (GUPnP.Context context, GUPnP.ResourceFactory factory, GUPnP.XMLDoc description_doc, string description_path, string description_dir);
		public unowned string get_description_dir ();
		public unowned string get_description_path ();
		public bool available { get; set; }
		public string description_dir { get; construct; }
		public GUPnP.XMLDoc description_doc { construct; }
		public string description_path { get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class Service : GUPnP.ServiceInfo {
		[CCode (has_construct_function = false)]
		public Service ();
		public void freeze_notify ();
		public void notify (...);
		public void notify_value (string variable, GLib.Value value);
		public void thaw_notify ();
		[NoAccessorMethod]
		public GUPnP.RootDevice root_device { owned get; construct; }
		public virtual signal void action_invoked (owned GUPnP.ServiceAction action);
		public virtual signal void notify_failed (GLib.List<Soup.URI> callback_urls, GLib.Error reason);
		public virtual signal void query_variable (string variable, ref GLib.Value value);
	}
	[CCode (ref_function = "", unref_function = "", cheader_filename = "libgupnp/gupnp.h")]
	public class ServiceAction {
		public void @get (...);
		public GLib.List<string> get_locales ();
		public Soup.Message get_message ();
		public unowned string get_name ();
		public void get_value (string argument, ref GLib.Value value);
		public void @return ();
		public void return_error (uint error_code, string? error_description);
		public void @set (...);
		public void set_value (string argument, ref GLib.Value value);
	}
	[Compact]
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class ServiceActionArgInfo {
		public GUPnP.ServiceActionArgDirection direction;
		public weak string name;
		public weak string related_state_variable;
		public bool retval;
	}
	[CCode (ref_function = "gupnp_service_action_info_ref", unref_function = "gupnp_service_action_info_unref", cheader_filename = "libgupnp/gupnp.h")]
	public class ServiceActionInfo {
		public weak GLib.List<GUPnP.ServiceActionArgInfo> arguments;
		public weak string name;
		[CCode (has_construct_function = false)]
		public ServiceActionInfo ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class ServiceInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public ServiceInfo ();
		public string get_control_url ();
		public string get_event_subscription_url ();
		public string get_id ();
		public GUPnP.ServiceIntrospection? get_introspection () throws GLib.Error;
		public void get_introspection_async (GUPnP.ServiceIntrospectionCallback callback);
		public string get_scpd_url ();
		public GUPnP.Context context { get; construct; }
		public string location { get; construct; }
		public string service_type { get; construct; }
		public string udn { get; construct; }
		public Soup.URI url_base { get; construct; }
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class ServiceIntrospection : GLib.Object {
		public unowned GUPnP.ServiceActionInfo get_action (string action_name);
		public unowned GUPnP.ServiceStateVariableInfo get_state_variable (string variable_name);
		public unowned GLib.List<string> list_action_names ();
		public unowned GLib.List<GUPnP.ServiceActionInfo> list_actions ();
		public unowned GLib.List<string> list_state_variable_names ();
		public unowned GLib.List<GUPnP.ServiceStateVariableInfo> list_state_variables ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class ServiceProxy : GUPnP.ServiceInfo {
		[CCode (has_construct_function = false)]
		public ServiceProxy ();
		public bool add_notify (string variable, GLib.Type type, GUPnP.ServiceProxyNotifyCallback callback);
		public unowned GUPnP.ServiceProxyAction begin_action (string action, GUPnP.ServiceProxyActionCallback callback, ...);
		public unowned GUPnP.ServiceProxyAction begin_action_hash (string action, GUPnP.ServiceProxyActionCallback callback, GLib.HashTable hash);
		public void cancel_action (GUPnP.ServiceProxyAction action);
		public bool end_action (GUPnP.ServiceProxyAction action, ...) throws GLib.Error;
		public bool end_action_hash (GUPnP.ServiceProxyAction action, GLib.HashTable hash) throws GLib.Error;
		public bool remove_notify (string variable, GUPnP.ServiceProxyNotifyCallback callback);
		public bool send_action (string action, ...) throws GLib.Error;
		public bool send_action_hash (string action, GLib.HashTable in_hash, ref unowned GLib.HashTable out_hash) throws GLib.Error;
		public bool subscribed { get; set; }
		public virtual signal void subscription_lost (GLib.Error reason);
	}
	[Compact]
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class ServiceProxyAction {
	}
	[CCode (ref_function = "gupnp_service_state_variable_info_ref", unref_function = "gupnp_service_state_variable_info_unref", cheader_filename = "libgupnp/gupnp.h")]
	public class ServiceStateVariableInfo {
		public weak GLib.List<string> allowed_values;
		public GLib.Value default_value;
		public bool is_numeric;
		public GLib.Value maximum;
		public GLib.Value minimum;
		public weak string name;
		public bool send_events;
		public GLib.Value step;
		public GLib.Type type;
		[CCode (has_construct_function = false)]
		public ServiceStateVariableInfo ();
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public class XMLDoc : GLib.Object {
		public weak Xml.Doc doc;
		[CCode (has_construct_function = false)]
		public XMLDoc (Xml.Doc xml_doc);
		[CCode (has_construct_function = false)]
		public XMLDoc.from_path (string path) throws GLib.Error;
	}
	[CCode (type_id = "GUPNP_TYPE_BIN_BASE64", cheader_filename = "libgupnp/gupnp.h")]
	public struct BinBase64 {
	}
	[CCode (type_id = "GUPNP_TYPE_BIN_HEX", cheader_filename = "libgupnp/gupnp.h")]
	public struct BinHex {
	}
	[CCode (type_id = "GUPNP_TYPE_DATE", cheader_filename = "libgupnp/gupnp.h")]
	public struct Date {
	}
	[CCode (type_id = "GUPNP_TYPE_DATE_TIME", cheader_filename = "libgupnp/gupnp.h")]
	public struct DateTime {
	}
	[CCode (type_id = "GUPNP_TYPE_DATE_TIME_TZ", cheader_filename = "libgupnp/gupnp.h")]
	public struct DateTimeTZ {
	}
	[CCode (type_id = "GUPNP_TYPE_TIME", cheader_filename = "libgupnp/gupnp.h")]
	public struct Time {
	}
	[CCode (type_id = "GUPNP_TYPE_TIME_TZ", cheader_filename = "libgupnp/gupnp.h")]
	public struct TimeTZ {
	}
	[CCode (type_id = "GUPNP_TYPE_URI", cheader_filename = "libgupnp/gupnp.h")]
	public struct URI {
	}
	[CCode (type_id = "GUPNP_TYPE_UUID", cheader_filename = "libgupnp/gupnp.h")]
	public struct UUID {
	}
	[CCode (cprefix = "GUPNP_SERVICE_ACTION_ARG_DIRECTION_", has_type_id = "0", cheader_filename = "libgupnp/gupnp.h")]
	public enum ServiceActionArgDirection {
		IN,
		OUT
	}
	[CCode (cprefix = "GUPNP_XML_ERROR_", has_type_id = "0", cheader_filename = "libgupnp/gupnp.h")]
	public enum XMLError {
		PARSE,
		NO_NODE,
		EMPTY_NODE,
		OTHER
	}
	[CCode (cprefix = "GUPNP_CONTROL_ERROR_", cheader_filename = "libgupnp/gupnp.h")]
	public errordomain ControlError {
		INVALID_ACTION,
		INVALID_ARGS,
		OUT_OF_SYNC,
		ACTION_FAILED,
	}
	[CCode (cprefix = "GUPNP_EVENTING_ERROR_", cheader_filename = "libgupnp/gupnp.h")]
	public errordomain EventingError {
		SUBSCRIPTION_FAILED,
		SUBSCRIPTION_LOST,
		NOTIFY_FAILED,
	}
	[CCode (cprefix = "GUPNP_SERVER_ERROR_", cheader_filename = "libgupnp/gupnp.h")]
	public errordomain ServerError {
		INTERNAL_SERVER_ERROR,
		NOT_FOUND,
		NOT_IMPLEMENTED,
		INVALID_RESPONSE,
		INVALID_URL,
		OTHER,
	}
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public delegate void ServiceIntrospectionCallback (GUPnP.ServiceInfo info, GUPnP.ServiceIntrospection introspection, GLib.Error error);
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public delegate void ServiceProxyActionCallback (GUPnP.ServiceProxy proxy, GUPnP.ServiceProxyAction action);
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public delegate void ServiceProxyNotifyCallback (GUPnP.ServiceProxy proxy, string variable, GLib.Value value);
	[CCode (cheader_filename = "libgupnp/gupnp.h")]
	public static GLib.Quark xml_error_quark ();
}
