// This file was generated by gir (https://github.com/gtk-rs/gir @ 60cbef0)
// from gir-files (https://github.com/gtk-rs/gir-files @ 3043b14)
// DO NOT EDIT

extern crate libhandy_sys;
extern crate shell_words;
extern crate tempfile;
use libhandy_sys::*;
use std::env;
use std::error::Error;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["libhandy-1"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Compiler, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Compiler { args })
    }

    pub fn define<'a, V: Into<Option<&'a str>>>(&mut self, var: &str, val: V) {
        let arg = match val.into() {
            None => format!("-D{}", var),
            Some(val) => format!("-D{}={}", var, val),
        };
        self.args.push(arg);
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let mut cmd = Command::new("pkg-config");
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
    /// Number of tests that failed to compile.
    failed_to_compile: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn record_failed_to_compile(&mut self) {
        self.failed += 1;
        self.failed_to_compile += 1;
    }
    fn summary(&self) -> String {
        format!(
            "{} passed; {} failed (compilation errors: {})",
            self.passed, self.failed, self.failed_to_compile
        )
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let tmpdir = Builder::new()
        .prefix("abi")
        .tempdir()
        .expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!(
        "1",
        get_c_value(tmpdir.path(), &cc, "1").expect("C constant"),
        "failed to obtain correct constant value for 1"
    );

    let mut results: Results = Default::default();
    for (i, &(name, rust_value)) in RUST_CONSTANTS.iter().enumerate() {
        match get_c_value(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            }
            Ok(ref c_value) => {
                if rust_value == c_value {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!(
                        "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                        name, rust_value, c_value
                    );
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("constants ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let tmpdir = Builder::new()
        .prefix("abi")
        .tempdir()
        .expect("temporary directory");
    let cc = Compiler::new().expect("configured compiler");

    assert_eq!(
        Layout {
            size: 1,
            alignment: 1
        },
        get_c_layout(tmpdir.path(), &cc, "char").expect("C layout"),
        "failed to obtain correct layout for char type"
    );

    let mut results: Results = Default::default();
    for (i, &(name, rust_layout)) in RUST_LAYOUTS.iter().enumerate() {
        match get_c_layout(tmpdir.path(), &cc, name) {
            Err(e) => {
                results.record_failed_to_compile();
                eprintln!("{}", e);
            }
            Ok(c_layout) => {
                if rust_layout == c_layout {
                    results.record_passed();
                } else {
                    results.record_failed();
                    eprintln!(
                        "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                        name, rust_layout, &c_layout
                    );
                }
            }
        };
        if (i + 1) % 25 == 0 {
            println!("layout    ... {}", results.summary());
        }
    }
    results.expect_total_success();
}

fn get_c_layout(dir: &Path, cc: &Compiler, name: &str) -> Result<Layout, Box<dyn Error>> {
    let exe = dir.join("layout");
    let mut cc = cc.clone();
    cc.define("ABI_TYPE_NAME", name);
    cc.compile(Path::new("tests/layout.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    let stdout = str::from_utf8(&output.stdout)?;
    let mut words = stdout.trim().split_whitespace();
    let size = words.next().unwrap().parse().unwrap();
    let alignment = words.next().unwrap().parse().unwrap();
    Ok(Layout { size, alignment })
}

fn get_c_value(dir: &Path, cc: &Compiler, name: &str) -> Result<String, Box<dyn Error>> {
    let exe = dir.join("constant");
    let mut cc = cc.clone();
    cc.define("ABI_CONSTANT_NAME", name);
    cc.compile(Path::new("tests/constant.c"), &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    let output = str::from_utf8(&output.stdout)?.trim();
    if !output.starts_with("###gir test###") || !output.ends_with("###gir test###") {
        return Err(format!(
            "command {:?} return invalid output, {:?}",
            &abi_cmd, &output
        )
        .into());
    }

    Ok(String::from(&output[14..(output.len() - 14)]))
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "HdyActionRow",
        Layout {
            size: size_of::<HdyActionRow>(),
            alignment: align_of::<HdyActionRow>(),
        },
    ),
    (
        "HdyActionRowClass",
        Layout {
            size: size_of::<HdyActionRowClass>(),
            alignment: align_of::<HdyActionRowClass>(),
        },
    ),
    (
        "HdyApplicationWindow",
        Layout {
            size: size_of::<HdyApplicationWindow>(),
            alignment: align_of::<HdyApplicationWindow>(),
        },
    ),
    (
        "HdyApplicationWindowClass",
        Layout {
            size: size_of::<HdyApplicationWindowClass>(),
            alignment: align_of::<HdyApplicationWindowClass>(),
        },
    ),
    (
        "HdyAvatarClass",
        Layout {
            size: size_of::<HdyAvatarClass>(),
            alignment: align_of::<HdyAvatarClass>(),
        },
    ),
    (
        "HdyCarouselClass",
        Layout {
            size: size_of::<HdyCarouselClass>(),
            alignment: align_of::<HdyCarouselClass>(),
        },
    ),
    (
        "HdyCarouselIndicatorDotsClass",
        Layout {
            size: size_of::<HdyCarouselIndicatorDotsClass>(),
            alignment: align_of::<HdyCarouselIndicatorDotsClass>(),
        },
    ),
    (
        "HdyCarouselIndicatorLinesClass",
        Layout {
            size: size_of::<HdyCarouselIndicatorLinesClass>(),
            alignment: align_of::<HdyCarouselIndicatorLinesClass>(),
        },
    ),
    (
        "HdyCenteringPolicy",
        Layout {
            size: size_of::<HdyCenteringPolicy>(),
            alignment: align_of::<HdyCenteringPolicy>(),
        },
    ),
    (
        "HdyClampClass",
        Layout {
            size: size_of::<HdyClampClass>(),
            alignment: align_of::<HdyClampClass>(),
        },
    ),
    (
        "HdyComboRow",
        Layout {
            size: size_of::<HdyComboRow>(),
            alignment: align_of::<HdyComboRow>(),
        },
    ),
    (
        "HdyComboRowClass",
        Layout {
            size: size_of::<HdyComboRowClass>(),
            alignment: align_of::<HdyComboRowClass>(),
        },
    ),
    (
        "HdyDeck",
        Layout {
            size: size_of::<HdyDeck>(),
            alignment: align_of::<HdyDeck>(),
        },
    ),
    (
        "HdyDeckClass",
        Layout {
            size: size_of::<HdyDeckClass>(),
            alignment: align_of::<HdyDeckClass>(),
        },
    ),
    (
        "HdyDeckTransitionType",
        Layout {
            size: size_of::<HdyDeckTransitionType>(),
            alignment: align_of::<HdyDeckTransitionType>(),
        },
    ),
    (
        "HdyEnumValueObjectClass",
        Layout {
            size: size_of::<HdyEnumValueObjectClass>(),
            alignment: align_of::<HdyEnumValueObjectClass>(),
        },
    ),
    (
        "HdyExpanderRow",
        Layout {
            size: size_of::<HdyExpanderRow>(),
            alignment: align_of::<HdyExpanderRow>(),
        },
    ),
    (
        "HdyExpanderRowClass",
        Layout {
            size: size_of::<HdyExpanderRowClass>(),
            alignment: align_of::<HdyExpanderRowClass>(),
        },
    ),
    (
        "HdyHeaderBar",
        Layout {
            size: size_of::<HdyHeaderBar>(),
            alignment: align_of::<HdyHeaderBar>(),
        },
    ),
    (
        "HdyHeaderBarClass",
        Layout {
            size: size_of::<HdyHeaderBarClass>(),
            alignment: align_of::<HdyHeaderBarClass>(),
        },
    ),
    (
        "HdyHeaderGroupChildClass",
        Layout {
            size: size_of::<HdyHeaderGroupChildClass>(),
            alignment: align_of::<HdyHeaderGroupChildClass>(),
        },
    ),
    (
        "HdyHeaderGroupChildType",
        Layout {
            size: size_of::<HdyHeaderGroupChildType>(),
            alignment: align_of::<HdyHeaderGroupChildType>(),
        },
    ),
    (
        "HdyHeaderGroupClass",
        Layout {
            size: size_of::<HdyHeaderGroupClass>(),
            alignment: align_of::<HdyHeaderGroupClass>(),
        },
    ),
    (
        "HdyKeypad",
        Layout {
            size: size_of::<HdyKeypad>(),
            alignment: align_of::<HdyKeypad>(),
        },
    ),
    (
        "HdyKeypadClass",
        Layout {
            size: size_of::<HdyKeypadClass>(),
            alignment: align_of::<HdyKeypadClass>(),
        },
    ),
    (
        "HdyLeaflet",
        Layout {
            size: size_of::<HdyLeaflet>(),
            alignment: align_of::<HdyLeaflet>(),
        },
    ),
    (
        "HdyLeafletClass",
        Layout {
            size: size_of::<HdyLeafletClass>(),
            alignment: align_of::<HdyLeafletClass>(),
        },
    ),
    (
        "HdyLeafletTransitionType",
        Layout {
            size: size_of::<HdyLeafletTransitionType>(),
            alignment: align_of::<HdyLeafletTransitionType>(),
        },
    ),
    (
        "HdyNavigationDirection",
        Layout {
            size: size_of::<HdyNavigationDirection>(),
            alignment: align_of::<HdyNavigationDirection>(),
        },
    ),
    (
        "HdyPreferencesGroup",
        Layout {
            size: size_of::<HdyPreferencesGroup>(),
            alignment: align_of::<HdyPreferencesGroup>(),
        },
    ),
    (
        "HdyPreferencesGroupClass",
        Layout {
            size: size_of::<HdyPreferencesGroupClass>(),
            alignment: align_of::<HdyPreferencesGroupClass>(),
        },
    ),
    (
        "HdyPreferencesPage",
        Layout {
            size: size_of::<HdyPreferencesPage>(),
            alignment: align_of::<HdyPreferencesPage>(),
        },
    ),
    (
        "HdyPreferencesPageClass",
        Layout {
            size: size_of::<HdyPreferencesPageClass>(),
            alignment: align_of::<HdyPreferencesPageClass>(),
        },
    ),
    (
        "HdyPreferencesRow",
        Layout {
            size: size_of::<HdyPreferencesRow>(),
            alignment: align_of::<HdyPreferencesRow>(),
        },
    ),
    (
        "HdyPreferencesRowClass",
        Layout {
            size: size_of::<HdyPreferencesRowClass>(),
            alignment: align_of::<HdyPreferencesRowClass>(),
        },
    ),
    (
        "HdyPreferencesWindow",
        Layout {
            size: size_of::<HdyPreferencesWindow>(),
            alignment: align_of::<HdyPreferencesWindow>(),
        },
    ),
    (
        "HdyPreferencesWindowClass",
        Layout {
            size: size_of::<HdyPreferencesWindowClass>(),
            alignment: align_of::<HdyPreferencesWindowClass>(),
        },
    ),
    (
        "HdySearchBar",
        Layout {
            size: size_of::<HdySearchBar>(),
            alignment: align_of::<HdySearchBar>(),
        },
    ),
    (
        "HdySearchBarClass",
        Layout {
            size: size_of::<HdySearchBarClass>(),
            alignment: align_of::<HdySearchBarClass>(),
        },
    ),
    (
        "HdySqueezerClass",
        Layout {
            size: size_of::<HdySqueezerClass>(),
            alignment: align_of::<HdySqueezerClass>(),
        },
    ),
    (
        "HdySqueezerTransitionType",
        Layout {
            size: size_of::<HdySqueezerTransitionType>(),
            alignment: align_of::<HdySqueezerTransitionType>(),
        },
    ),
    (
        "HdySwipeGroupClass",
        Layout {
            size: size_of::<HdySwipeGroupClass>(),
            alignment: align_of::<HdySwipeGroupClass>(),
        },
    ),
    (
        "HdySwipeTrackerClass",
        Layout {
            size: size_of::<HdySwipeTrackerClass>(),
            alignment: align_of::<HdySwipeTrackerClass>(),
        },
    ),
    (
        "HdySwipeableInterface",
        Layout {
            size: size_of::<HdySwipeableInterface>(),
            alignment: align_of::<HdySwipeableInterface>(),
        },
    ),
    (
        "HdyTitleBarClass",
        Layout {
            size: size_of::<HdyTitleBarClass>(),
            alignment: align_of::<HdyTitleBarClass>(),
        },
    ),
    (
        "HdyValueObjectClass",
        Layout {
            size: size_of::<HdyValueObjectClass>(),
            alignment: align_of::<HdyValueObjectClass>(),
        },
    ),
    (
        "HdyViewSwitcherBarClass",
        Layout {
            size: size_of::<HdyViewSwitcherBarClass>(),
            alignment: align_of::<HdyViewSwitcherBarClass>(),
        },
    ),
    (
        "HdyViewSwitcherClass",
        Layout {
            size: size_of::<HdyViewSwitcherClass>(),
            alignment: align_of::<HdyViewSwitcherClass>(),
        },
    ),
    (
        "HdyViewSwitcherPolicy",
        Layout {
            size: size_of::<HdyViewSwitcherPolicy>(),
            alignment: align_of::<HdyViewSwitcherPolicy>(),
        },
    ),
    (
        "HdyViewSwitcherTitleClass",
        Layout {
            size: size_of::<HdyViewSwitcherTitleClass>(),
            alignment: align_of::<HdyViewSwitcherTitleClass>(),
        },
    ),
    (
        "HdyWindow",
        Layout {
            size: size_of::<HdyWindow>(),
            alignment: align_of::<HdyWindow>(),
        },
    ),
    (
        "HdyWindowClass",
        Layout {
            size: size_of::<HdyWindowClass>(),
            alignment: align_of::<HdyWindowClass>(),
        },
    ),
    (
        "HdyWindowHandleClass",
        Layout {
            size: size_of::<HdyWindowHandleClass>(),
            alignment: align_of::<HdyWindowHandleClass>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) HDY_CENTERING_POLICY_LOOSE", "0"),
    ("(gint) HDY_CENTERING_POLICY_STRICT", "1"),
    ("(gint) HDY_DECK_TRANSITION_TYPE_OVER", "0"),
    ("(gint) HDY_DECK_TRANSITION_TYPE_SLIDE", "2"),
    ("(gint) HDY_DECK_TRANSITION_TYPE_UNDER", "1"),
    ("(gint) HDY_HEADER_GROUP_CHILD_TYPE_GTK_HEADER_BAR", "1"),
    ("(gint) HDY_HEADER_GROUP_CHILD_TYPE_HEADER_BAR", "0"),
    ("(gint) HDY_HEADER_GROUP_CHILD_TYPE_HEADER_GROUP", "2"),
    ("(gint) HDY_LEAFLET_TRANSITION_TYPE_OVER", "0"),
    ("(gint) HDY_LEAFLET_TRANSITION_TYPE_SLIDE", "2"),
    ("(gint) HDY_LEAFLET_TRANSITION_TYPE_UNDER", "1"),
    ("(gint) HDY_NAVIGATION_DIRECTION_BACK", "0"),
    ("(gint) HDY_NAVIGATION_DIRECTION_FORWARD", "1"),
    ("(gint) HDY_SQUEEZER_TRANSITION_TYPE_CROSSFADE", "1"),
    ("(gint) HDY_SQUEEZER_TRANSITION_TYPE_NONE", "0"),
    ("(gint) HDY_VIEW_SWITCHER_POLICY_AUTO", "0"),
    ("(gint) HDY_VIEW_SWITCHER_POLICY_NARROW", "1"),
    ("(gint) HDY_VIEW_SWITCHER_POLICY_WIDE", "2"),
];
