/* gamepad-mapping-builder.c generated by valac 0.36.6.6-c7bee, the Vala compiler
 * generated from gamepad-mapping-builder.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <linux/input-event-codes.h>
#include <float.h>
#include <math.h>


#define GAMES_TYPE_GAMEPAD_MAPPING_BUILDER (games_gamepad_mapping_builder_get_type ())
#define GAMES_GAMEPAD_MAPPING_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilder))
#define GAMES_GAMEPAD_MAPPING_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilderClass))
#define GAMES_IS_GAMEPAD_MAPPING_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER))
#define GAMES_IS_GAMEPAD_MAPPING_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER))
#define GAMES_GAMEPAD_MAPPING_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilderClass))

typedef struct _GamesGamepadMappingBuilder GamesGamepadMappingBuilder;
typedef struct _GamesGamepadMappingBuilderClass GamesGamepadMappingBuilderClass;
typedef struct _GamesGamepadMappingBuilderPrivate GamesGamepadMappingBuilderPrivate;

#define GAMES_GAMEPAD_MAPPING_BUILDER_TYPE_GAMEPAD_INPUT_MAPPING (games_gamepad_mapping_builder_gamepad_input_mapping_get_type ())
typedef struct _GamesGamepadMappingBuilderGamepadInputMapping GamesGamepadMappingBuilderGamepadInputMapping;

#define GAMES_TYPE_GAMEPAD_DPAD (games_gamepad_dpad_get_type ())

#define GAMES_TYPE_GAMEPAD_INPUT (games_gamepad_input_get_type ())
typedef struct _GamesGamepadInput GamesGamepadInput;
typedef struct _GamesGamepadDPad GamesGamepadDPad;

#define GAMES_GAMEPAD_MAPPING_BUILDER_TYPE_GAMEPAD_INPUT_SOURCE (games_gamepad_mapping_builder_gamepad_input_source_get_type ())
typedef struct _GamesGamepadMappingBuilderGamepadInputSource GamesGamepadMappingBuilderGamepadInputSource;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesGamepadMappingBuilder {
	GObject parent_instance;
	GamesGamepadMappingBuilderPrivate * priv;
};

struct _GamesGamepadMappingBuilderClass {
	GObjectClass parent_class;
};

struct _GamesGamepadMappingBuilderGamepadInputMapping {
	gchar* source_string;
	gchar* destination_string;
};

struct _GamesGamepadInput {
	guint16 type;
	guint16 code;
};

struct _GamesGamepadDPad {
	GamesGamepadInput inputs[4];
	gint32 axis_values[2];
};

struct _GamesGamepadMappingBuilderPrivate {
	GamesGamepadMappingBuilderGamepadInputMapping* mappings;
	gint mappings_length1;
	gint _mappings_size_;
	GamesGamepadDPad* dpads;
	gint dpads_length1;
	gint _dpads_size_;
};

struct _GamesGamepadMappingBuilderGamepadInputSource {
	GamesGamepadInput input;
	gchar* source;
};


static gpointer games_gamepad_mapping_builder_parent_class = NULL;

GType games_gamepad_mapping_builder_get_type (void) G_GNUC_CONST;
static GType games_gamepad_mapping_builder_gamepad_input_mapping_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GamesGamepadMappingBuilderGamepadInputMapping* games_gamepad_mapping_builder_gamepad_input_mapping_dup (const GamesGamepadMappingBuilderGamepadInputMapping* self);
static void games_gamepad_mapping_builder_gamepad_input_mapping_free (GamesGamepadMappingBuilderGamepadInputMapping* self);
static void games_gamepad_mapping_builder_gamepad_input_mapping_copy (const GamesGamepadMappingBuilderGamepadInputMapping* self, GamesGamepadMappingBuilderGamepadInputMapping* dest);
static void games_gamepad_mapping_builder_gamepad_input_mapping_destroy (GamesGamepadMappingBuilderGamepadInputMapping* self);
GType games_gamepad_dpad_get_type (void) G_GNUC_CONST;
GType games_gamepad_input_get_type (void) G_GNUC_CONST;
GamesGamepadInput* games_gamepad_input_dup (const GamesGamepadInput* self);
void games_gamepad_input_free (GamesGamepadInput* self);
GamesGamepadDPad* games_gamepad_dpad_dup (const GamesGamepadDPad* self);
void games_gamepad_dpad_free (GamesGamepadDPad* self);
#define GAMES_GAMEPAD_MAPPING_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilderPrivate))
enum  {
	GAMES_GAMEPAD_MAPPING_BUILDER_0_PROPERTY
};
static void _vala_GamesGamepadMappingBuilderGamepadInputMapping_array_free (GamesGamepadMappingBuilderGamepadInputMapping * array, gint array_length);
static GType games_gamepad_mapping_builder_gamepad_input_source_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GamesGamepadMappingBuilderGamepadInputSource* games_gamepad_mapping_builder_gamepad_input_source_dup (const GamesGamepadMappingBuilderGamepadInputSource* self);
static void games_gamepad_mapping_builder_gamepad_input_source_free (GamesGamepadMappingBuilderGamepadInputSource* self);
static void games_gamepad_mapping_builder_gamepad_input_source_copy (const GamesGamepadMappingBuilderGamepadInputSource* self, GamesGamepadMappingBuilderGamepadInputSource* dest);
static void games_gamepad_mapping_builder_gamepad_input_source_destroy (GamesGamepadMappingBuilderGamepadInputSource* self);
gchar* games_gamepad_mapping_builder_build_sdl_string (GamesGamepadMappingBuilder* self);
gboolean games_gamepad_mapping_builder_set_button_mapping (GamesGamepadMappingBuilder* self, guint8 hardware_index, GamesGamepadInput* source);
static gboolean games_gamepad_mapping_builder_add_destination (GamesGamepadMappingBuilder* self, const gchar* destination_string, GamesGamepadInput* source);
gboolean games_gamepad_mapping_builder_set_axis_mapping (GamesGamepadMappingBuilder* self, guint8 hardware_index, GamesGamepadInput* source);
gboolean games_gamepad_mapping_builder_set_hat_mapping (GamesGamepadMappingBuilder* self, guint8 hardware_index, gint32 value, GamesGamepadInput* source);
static void _vala_array_add8 (GamesGamepadDPad* * array, int* length, int* size, const GamesGamepadDPad* value);
static gboolean games_gamepad_mapping_builder_is_mapping_present (GamesGamepadMappingBuilder* self, const gchar* destination_string);
static gchar* games_gamepad_mapping_builder_get_mapping_source (GamesGamepadMappingBuilder* self, GamesGamepadInput* input);
static void _vala_array_add9 (GamesGamepadMappingBuilderGamepadInputMapping* * array, int* length, int* size, const GamesGamepadMappingBuilderGamepadInputMapping* value);
static gboolean _games_gamepad_input_equal (const GamesGamepadInput * s1, const GamesGamepadInput * s2);
GamesGamepadMappingBuilder* games_gamepad_mapping_builder_new (void);
GamesGamepadMappingBuilder* games_gamepad_mapping_builder_construct (GType object_type);
static GObject * games_gamepad_mapping_builder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void games_gamepad_mapping_builder_finalize (GObject * obj);

static const GamesGamepadMappingBuilderGamepadInputSource GAMES_GAMEPAD_MAPPING_BUILDER_INPUT_SOURCES[21] = {{{EV_ABS, ABS_X}, "leftx"}, {{EV_ABS, ABS_Y}, "lefty"}, {{EV_ABS, ABS_RX}, "rightx"}, {{EV_ABS, ABS_RY}, "righty"}, {{EV_KEY, BTN_A}, "a"}, {{EV_KEY, BTN_B}, "b"}, {{EV_KEY, BTN_DPAD_DOWN}, "dpdown"}, {{EV_KEY, BTN_DPAD_LEFT}, "dpleft"}, {{EV_KEY, BTN_DPAD_RIGHT}, "dpright"}, {{EV_KEY, BTN_DPAD_UP}, "dpup"}, {{EV_KEY, BTN_MODE}, "guide"}, {{EV_KEY, BTN_SELECT}, "back"}, {{EV_KEY, BTN_TL}, "leftshoulder"}, {{EV_KEY, BTN_TR}, "rightshoulder"}, {{EV_KEY, BTN_START}, "start"}, {{EV_KEY, BTN_THUMBL}, "leftstick"}, {{EV_KEY, BTN_THUMBR}, "rightstick"}, {{EV_KEY, BTN_TL2}, "lefttrigger"}, {{EV_KEY, BTN_TR2}, "righttrigger"}, {{EV_KEY, BTN_Y}, "x"}, {{EV_KEY, BTN_X}, "y"}};

static void _vala_GamesGamepadMappingBuilderGamepadInputMapping_array_free (GamesGamepadMappingBuilderGamepadInputMapping * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&array[i]);
		}
	}
	g_free (array);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* games_gamepad_mapping_builder_build_sdl_string (GamesGamepadMappingBuilder* self) {
	gchar* result = NULL;
	gchar* sdl_string = NULL;
	gchar* _tmp0_;
	GamesGamepadMappingBuilderGamepadInputMapping* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("platform:Linux,");
	sdl_string = _tmp0_;
	_tmp1_ = self->priv->mappings;
	_tmp1__length1 = self->priv->mappings_length1;
	{
		GamesGamepadMappingBuilderGamepadInputMapping* mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
		mapping_collection = _tmp1_;
		mapping_collection_length1 = _tmp1__length1;
		for (mapping_it = 0; mapping_it < _tmp1__length1; mapping_it = mapping_it + 1) {
			GamesGamepadMappingBuilderGamepadInputMapping _tmp2_ = {0};
			GamesGamepadMappingBuilderGamepadInputMapping mapping = {0};
			games_gamepad_mapping_builder_gamepad_input_mapping_copy (&mapping_collection[mapping_it], &_tmp2_);
			mapping = _tmp2_;
			{
				const gchar* _tmp3_;
				GamesGamepadMappingBuilderGamepadInputMapping _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				GamesGamepadMappingBuilderGamepadInputMapping _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp3_ = sdl_string;
				_tmp4_ = mapping;
				_tmp5_ = _tmp4_.source_string;
				_tmp6_ = string_to_string (_tmp5_);
				_tmp7_ = mapping;
				_tmp8_ = _tmp7_.destination_string;
				_tmp9_ = string_to_string (_tmp8_);
				_tmp10_ = g_strconcat (_tmp6_, ":", _tmp9_, ",", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp3_, _tmp11_, NULL);
				_g_free0 (sdl_string);
				sdl_string = _tmp12_;
				_g_free0 (_tmp11_);
				games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&mapping);
			}
		}
	}
	result = sdl_string;
	return result;
}


gboolean games_gamepad_mapping_builder_set_button_mapping (GamesGamepadMappingBuilder* self, guint8 hardware_index, GamesGamepadInput* source) {
	gboolean result = FALSE;
	guint8 _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GamesGamepadInput _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = hardware_index;
	_tmp1_ = g_strdup_printf ("%hhu", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("b", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = *source;
	_tmp6_ = games_gamepad_mapping_builder_add_destination (self, _tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp7_;
	return result;
}


gboolean games_gamepad_mapping_builder_set_axis_mapping (GamesGamepadMappingBuilder* self, guint8 hardware_index, GamesGamepadInput* source) {
	gboolean result = FALSE;
	guint8 _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GamesGamepadInput _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = hardware_index;
	_tmp1_ = g_strdup_printf ("%hhu", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("a", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = *source;
	_tmp6_ = games_gamepad_mapping_builder_add_destination (self, _tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp7_;
	return result;
}


static void _vala_array_add8 (GamesGamepadDPad* * array, int* length, int* size, const GamesGamepadDPad* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGamepadDPad, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}


gboolean games_gamepad_mapping_builder_set_hat_mapping (GamesGamepadMappingBuilder* self, guint8 hardware_index, gint32 value, GamesGamepadInput* source) {
	gboolean result = FALSE;
	gint dpad_index = 0;
	guint8 _tmp0_;
	gint dpad_axis = 0;
	guint8 _tmp1_;
	GamesGamepadDPad dpad = {0};
	GamesGamepadDPad* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	GamesGamepadDPad _tmp8_;
	gint32 _tmp9_ = 0;
	gint32 _tmp10_;
	gint32 changed_value = 0;
	gint _tmp15_;
	gint32 _tmp16_;
	gint32 _tmp17_;
	gint32 dpad_position = 0;
	gint _tmp18_;
	gdouble dpad_position_2pow = 0.0;
	gdouble _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GamesGamepadInput _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = hardware_index;
	dpad_index = _tmp0_ / 2;
	_tmp1_ = hardware_index;
	dpad_axis = _tmp1_ % 2;
	while (TRUE) {
		GamesGamepadDPad* _tmp2_;
		gint _tmp2__length1;
		guint8 _tmp3_;
		GamesGamepadDPad* _tmp4_;
		gint _tmp4__length1;
		GamesGamepadDPad _tmp5_ = {0};
		_tmp2_ = self->priv->dpads;
		_tmp2__length1 = self->priv->dpads_length1;
		_tmp3_ = hardware_index;
		if (!(_tmp2__length1 <= ((gint) _tmp3_))) {
			break;
		}
		_tmp4_ = self->priv->dpads;
		_tmp4__length1 = self->priv->dpads_length1;
		memset (&_tmp5_, 0, sizeof (GamesGamepadDPad));
		_vala_array_add8 (&self->priv->dpads, &self->priv->dpads_length1, &self->priv->_dpads_size_, &_tmp5_);
	}
	_tmp6_ = self->priv->dpads;
	_tmp6__length1 = self->priv->dpads_length1;
	_tmp7_ = dpad_index;
	_tmp8_ = _tmp6_[_tmp7_];
	dpad = _tmp8_;
	_tmp10_ = value;
	if (_tmp10_ == ((gint32) 0)) {
		GamesGamepadDPad _tmp11_;
		gint _tmp12_;
		gint32 _tmp13_;
		_tmp11_ = dpad;
		_tmp12_ = dpad_axis;
		_tmp13_ = _tmp11_.axis_values[_tmp12_];
		_tmp9_ = _tmp13_;
	} else {
		gint32 _tmp14_;
		_tmp14_ = value;
		_tmp9_ = _tmp14_;
	}
	changed_value = _tmp9_;
	_tmp15_ = dpad_axis;
	_tmp16_ = value;
	dpad.axis_values[_tmp15_] = _tmp16_;
	_tmp17_ = dpad.axis_values[_tmp15_];
	_tmp18_ = dpad_axis;
	dpad_position = ((changed_value + _tmp18_) + 4) % 4;
	_tmp19_ = pow ((gdouble) 2, (gdouble) dpad_position);
	dpad_position_2pow = _tmp19_;
	_tmp20_ = dpad_index;
	_tmp21_ = g_strdup_printf ("%i", _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = double_to_string (dpad_position_2pow);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat ("h", _tmp22_, ".", _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = *source;
	_tmp28_ = games_gamepad_mapping_builder_add_destination (self, _tmp26_, &_tmp27_);
	_tmp29_ = _tmp28_;
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	result = _tmp29_;
	return result;
}


static void _vala_array_add9 (GamesGamepadMappingBuilderGamepadInputMapping* * array, int* length, int* size, const GamesGamepadMappingBuilderGamepadInputMapping* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGamepadMappingBuilderGamepadInputMapping, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gboolean games_gamepad_mapping_builder_add_destination (GamesGamepadMappingBuilder* self, const gchar* destination_string, GamesGamepadInput* source) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gchar* source_string = NULL;
	GamesGamepadInput _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GamesGamepadMappingBuilderGamepadInputMapping mapping = {0};
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GamesGamepadMappingBuilderGamepadInputMapping _tmp9_ = {0};
	GamesGamepadMappingBuilderGamepadInputMapping* _tmp10_;
	gint _tmp10__length1;
	GamesGamepadMappingBuilderGamepadInputMapping _tmp11_;
	GamesGamepadMappingBuilderGamepadInputMapping _tmp12_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (destination_string != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = destination_string;
	_tmp1_ = games_gamepad_mapping_builder_is_mapping_present (self, _tmp0_);
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *source;
	_tmp3_ = games_gamepad_mapping_builder_get_mapping_source (self, &_tmp2_);
	source_string = _tmp3_;
	_tmp4_ = source_string;
	if (_tmp4_ == NULL) {
		g_critical ("gamepad-mapping-builder.vala:86: Invalid input");
		result = FALSE;
		_g_free0 (source_string);
		return result;
	}
	_tmp5_ = source_string;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = destination_string;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_tmp9_.source_string);
	_tmp9_.source_string = _tmp6_;
	_g_free0 (_tmp9_.destination_string);
	_tmp9_.destination_string = _tmp8_;
	mapping = _tmp9_;
	_tmp10_ = self->priv->mappings;
	_tmp10__length1 = self->priv->mappings_length1;
	_tmp11_ = mapping;
	games_gamepad_mapping_builder_gamepad_input_mapping_copy (&_tmp11_, &_tmp12_);
	_vala_array_add9 (&self->priv->mappings, &self->priv->mappings_length1, &self->priv->_mappings_size_, &_tmp12_);
	result = TRUE;
	games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&mapping);
	_g_free0 (source_string);
	return result;
}


static gboolean games_gamepad_mapping_builder_is_mapping_present (GamesGamepadMappingBuilder* self, const gchar* destination_string) {
	gboolean result = FALSE;
	GamesGamepadMappingBuilderGamepadInputMapping* _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (destination_string != NULL, FALSE);
	_tmp0_ = self->priv->mappings;
	_tmp0__length1 = self->priv->mappings_length1;
	{
		GamesGamepadMappingBuilderGamepadInputMapping* mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
		mapping_collection = _tmp0_;
		mapping_collection_length1 = _tmp0__length1;
		for (mapping_it = 0; mapping_it < _tmp0__length1; mapping_it = mapping_it + 1) {
			GamesGamepadMappingBuilderGamepadInputMapping _tmp1_ = {0};
			GamesGamepadMappingBuilderGamepadInputMapping mapping = {0};
			games_gamepad_mapping_builder_gamepad_input_mapping_copy (&mapping_collection[mapping_it], &_tmp1_);
			mapping = _tmp1_;
			{
				const gchar* _tmp2_;
				GamesGamepadMappingBuilderGamepadInputMapping _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = destination_string;
				_tmp3_ = mapping;
				_tmp4_ = _tmp3_.destination_string;
				if (g_strcmp0 (_tmp2_, _tmp4_) == 0) {
					result = TRUE;
					games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&mapping);
					return result;
				}
				games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&mapping);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean _games_gamepad_input_equal (const GamesGamepadInput * s1, const GamesGamepadInput * s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->type != s2->type) {
		return FALSE;
	}
	if (s1->code != s2->code) {
		return FALSE;
	}
	return TRUE;
}


static gchar* games_gamepad_mapping_builder_get_mapping_source (GamesGamepadMappingBuilder* self, GamesGamepadInput* input) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	{
		GamesGamepadMappingBuilderGamepadInputSource* input_source_collection = NULL;
		gint input_source_collection_length1 = 0;
		gint _input_source_collection_size_ = 0;
		gint input_source_it = 0;
		input_source_collection = GAMES_GAMEPAD_MAPPING_BUILDER_INPUT_SOURCES;
		input_source_collection_length1 = G_N_ELEMENTS (GAMES_GAMEPAD_MAPPING_BUILDER_INPUT_SOURCES);
		for (input_source_it = 0; input_source_it < G_N_ELEMENTS (GAMES_GAMEPAD_MAPPING_BUILDER_INPUT_SOURCES); input_source_it = input_source_it + 1) {
			GamesGamepadMappingBuilderGamepadInputSource input_source = {0};
			input_source = input_source_collection[input_source_it];
			{
				GamesGamepadInput _tmp0_;
				GamesGamepadMappingBuilderGamepadInputSource _tmp1_;
				GamesGamepadInput _tmp2_;
				_tmp0_ = *input;
				_tmp1_ = input_source;
				_tmp2_ = _tmp1_.input;
				if (_games_gamepad_input_equal (&_tmp0_, &_tmp2_) == TRUE) {
					GamesGamepadMappingBuilderGamepadInputSource _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp3_ = input_source;
					_tmp4_ = _tmp3_.source;
					_tmp5_ = g_strdup (_tmp4_);
					result = _tmp5_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


GamesGamepadMappingBuilder* games_gamepad_mapping_builder_construct (GType object_type) {
	GamesGamepadMappingBuilder * self = NULL;
	self = (GamesGamepadMappingBuilder*) g_object_new (object_type, NULL);
	return self;
}


GamesGamepadMappingBuilder* games_gamepad_mapping_builder_new (void) {
	return games_gamepad_mapping_builder_construct (GAMES_TYPE_GAMEPAD_MAPPING_BUILDER);
}


static GObject * games_gamepad_mapping_builder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GamesGamepadMappingBuilder * self;
	GamesGamepadMappingBuilderGamepadInputMapping* _tmp0_;
	GamesGamepadDPad* _tmp1_;
	parent_class = G_OBJECT_CLASS (games_gamepad_mapping_builder_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilder);
	_tmp0_ = g_new0 (GamesGamepadMappingBuilderGamepadInputMapping, 0);
	self->priv->mappings = (_vala_GamesGamepadMappingBuilderGamepadInputMapping_array_free (self->priv->mappings, self->priv->mappings_length1), NULL);
	self->priv->mappings = _tmp0_;
	self->priv->mappings_length1 = 0;
	self->priv->_mappings_size_ = self->priv->mappings_length1;
	_tmp1_ = g_new0 (GamesGamepadDPad, 0);
	self->priv->dpads = (g_free (self->priv->dpads), NULL);
	self->priv->dpads = _tmp1_;
	self->priv->dpads_length1 = 0;
	self->priv->_dpads_size_ = self->priv->dpads_length1;
	return obj;
}


static void games_gamepad_mapping_builder_gamepad_input_source_copy (const GamesGamepadMappingBuilderGamepadInputSource* self, GamesGamepadMappingBuilderGamepadInputSource* dest) {
	GamesGamepadInput _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = (*self).input;
	(*dest).input = _tmp0_;
	_tmp1_ = (*self).source;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).source);
	(*dest).source = _tmp2_;
}


static void games_gamepad_mapping_builder_gamepad_input_source_destroy (GamesGamepadMappingBuilderGamepadInputSource* self) {
	_g_free0 ((*self).source);
}


static GamesGamepadMappingBuilderGamepadInputSource* games_gamepad_mapping_builder_gamepad_input_source_dup (const GamesGamepadMappingBuilderGamepadInputSource* self) {
	GamesGamepadMappingBuilderGamepadInputSource* dup;
	dup = g_new0 (GamesGamepadMappingBuilderGamepadInputSource, 1);
	games_gamepad_mapping_builder_gamepad_input_source_copy (self, dup);
	return dup;
}


static void games_gamepad_mapping_builder_gamepad_input_source_free (GamesGamepadMappingBuilderGamepadInputSource* self) {
	games_gamepad_mapping_builder_gamepad_input_source_destroy (self);
	g_free (self);
}


static GType games_gamepad_mapping_builder_gamepad_input_source_get_type (void) {
	static volatile gsize games_gamepad_mapping_builder_gamepad_input_source_type_id__volatile = 0;
	if (g_once_init_enter (&games_gamepad_mapping_builder_gamepad_input_source_type_id__volatile)) {
		GType games_gamepad_mapping_builder_gamepad_input_source_type_id;
		games_gamepad_mapping_builder_gamepad_input_source_type_id = g_boxed_type_register_static ("GamesGamepadMappingBuilderGamepadInputSource", (GBoxedCopyFunc) games_gamepad_mapping_builder_gamepad_input_source_dup, (GBoxedFreeFunc) games_gamepad_mapping_builder_gamepad_input_source_free);
		g_once_init_leave (&games_gamepad_mapping_builder_gamepad_input_source_type_id__volatile, games_gamepad_mapping_builder_gamepad_input_source_type_id);
	}
	return games_gamepad_mapping_builder_gamepad_input_source_type_id__volatile;
}


static void games_gamepad_mapping_builder_gamepad_input_mapping_copy (const GamesGamepadMappingBuilderGamepadInputMapping* self, GamesGamepadMappingBuilderGamepadInputMapping* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).source_string;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).source_string);
	(*dest).source_string = _tmp1_;
	_tmp2_ = (*self).destination_string;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).destination_string);
	(*dest).destination_string = _tmp3_;
}


static void games_gamepad_mapping_builder_gamepad_input_mapping_destroy (GamesGamepadMappingBuilderGamepadInputMapping* self) {
	_g_free0 ((*self).source_string);
	_g_free0 ((*self).destination_string);
}


static GamesGamepadMappingBuilderGamepadInputMapping* games_gamepad_mapping_builder_gamepad_input_mapping_dup (const GamesGamepadMappingBuilderGamepadInputMapping* self) {
	GamesGamepadMappingBuilderGamepadInputMapping* dup;
	dup = g_new0 (GamesGamepadMappingBuilderGamepadInputMapping, 1);
	games_gamepad_mapping_builder_gamepad_input_mapping_copy (self, dup);
	return dup;
}


static void games_gamepad_mapping_builder_gamepad_input_mapping_free (GamesGamepadMappingBuilderGamepadInputMapping* self) {
	games_gamepad_mapping_builder_gamepad_input_mapping_destroy (self);
	g_free (self);
}


static GType games_gamepad_mapping_builder_gamepad_input_mapping_get_type (void) {
	static volatile gsize games_gamepad_mapping_builder_gamepad_input_mapping_type_id__volatile = 0;
	if (g_once_init_enter (&games_gamepad_mapping_builder_gamepad_input_mapping_type_id__volatile)) {
		GType games_gamepad_mapping_builder_gamepad_input_mapping_type_id;
		games_gamepad_mapping_builder_gamepad_input_mapping_type_id = g_boxed_type_register_static ("GamesGamepadMappingBuilderGamepadInputMapping", (GBoxedCopyFunc) games_gamepad_mapping_builder_gamepad_input_mapping_dup, (GBoxedFreeFunc) games_gamepad_mapping_builder_gamepad_input_mapping_free);
		g_once_init_leave (&games_gamepad_mapping_builder_gamepad_input_mapping_type_id__volatile, games_gamepad_mapping_builder_gamepad_input_mapping_type_id);
	}
	return games_gamepad_mapping_builder_gamepad_input_mapping_type_id__volatile;
}


static void games_gamepad_mapping_builder_class_init (GamesGamepadMappingBuilderClass * klass) {
	games_gamepad_mapping_builder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesGamepadMappingBuilderPrivate));
	G_OBJECT_CLASS (klass)->constructor = games_gamepad_mapping_builder_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_gamepad_mapping_builder_finalize;
}


static void games_gamepad_mapping_builder_instance_init (GamesGamepadMappingBuilder * self) {
	self->priv = GAMES_GAMEPAD_MAPPING_BUILDER_GET_PRIVATE (self);
}


static void games_gamepad_mapping_builder_finalize (GObject * obj) {
	GamesGamepadMappingBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilder);
	self->priv->mappings = (_vala_GamesGamepadMappingBuilderGamepadInputMapping_array_free (self->priv->mappings, self->priv->mappings_length1), NULL);
	self->priv->dpads = (g_free (self->priv->dpads), NULL);
	G_OBJECT_CLASS (games_gamepad_mapping_builder_parent_class)->finalize (obj);
}


GType games_gamepad_mapping_builder_get_type (void) {
	static volatile gsize games_gamepad_mapping_builder_type_id__volatile = 0;
	if (g_once_init_enter (&games_gamepad_mapping_builder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesGamepadMappingBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gamepad_mapping_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGamepadMappingBuilder), 0, (GInstanceInitFunc) games_gamepad_mapping_builder_instance_init, NULL };
		GType games_gamepad_mapping_builder_type_id;
		games_gamepad_mapping_builder_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesGamepadMappingBuilder", &g_define_type_info, 0);
		g_once_init_leave (&games_gamepad_mapping_builder_type_id__volatile, games_gamepad_mapping_builder_type_id);
	}
	return games_gamepad_mapping_builder_type_id__volatile;
}



