/* steam-uri-iterator.c generated by valac 0.36.6.6-c7bee, the Vala compiler
 * generated from steam-uri-iterator.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define GAMES_TYPE_STEAM_URI_ITERATOR (games_steam_uri_iterator_get_type ())
#define GAMES_STEAM_URI_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_URI_ITERATOR, GamesSteamUriIterator))
#define GAMES_STEAM_URI_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_URI_ITERATOR, GamesSteamUriIteratorClass))
#define GAMES_IS_STEAM_URI_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_URI_ITERATOR))
#define GAMES_IS_STEAM_URI_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_URI_ITERATOR))
#define GAMES_STEAM_URI_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_URI_ITERATOR, GamesSteamUriIteratorClass))

typedef struct _GamesSteamUriIterator GamesSteamUriIterator;
typedef struct _GamesSteamUriIteratorClass GamesSteamUriIteratorClass;
typedef struct _GamesSteamUriIteratorPrivate GamesSteamUriIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesSteamUriIterator {
	GObject parent_instance;
	GamesSteamUriIteratorPrivate * priv;
};

struct _GamesSteamUriIteratorClass {
	GObjectClass parent_class;
};

struct _GamesSteamUriIteratorPrivate {
	gchar** directories;
	gint directories_length1;
	gint _directories_size_;
	gint directory_index;
	GFileEnumerator* enumerator;
	GamesUri* uri;
};


static gpointer games_steam_uri_iterator_parent_class = NULL;
static GamesUriIteratorIface * games_steam_uri_iterator_games_uri_iterator_parent_iface = NULL;
static GType games_steam_uri_iterator_type_id = 0;

GType games_steam_uri_iterator_get_type (void) G_GNUC_CONST;
#define GAMES_STEAM_URI_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_STEAM_URI_ITERATOR, GamesSteamUriIteratorPrivate))
enum  {
	GAMES_STEAM_URI_ITERATOR_0_PROPERTY
};
GamesSteamUriIterator* games_steam_uri_iterator_new (gchar** directories, int directories_length1);
GamesSteamUriIterator* games_steam_uri_iterator_construct (GType object_type, gchar** directories, int directories_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static GamesUri* games_steam_uri_iterator_real_get (GamesUriIterator* base);
static gboolean games_steam_uri_iterator_real_next (GamesUriIterator* base);
static gboolean games_steam_uri_iterator_try_next_for_directory (GamesSteamUriIterator* self, const gchar* directory);
static gboolean games_steam_uri_iterator_next_for_directory (GamesSteamUriIterator* self, const gchar* directory, GError** error);
static void games_steam_uri_iterator_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


GamesSteamUriIterator* games_steam_uri_iterator_construct (GType object_type, gchar** directories, int directories_length1) {
	GamesSteamUriIterator * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (GamesSteamUriIterator*) g_object_new (object_type, NULL);
	_tmp0_ = directories;
	_tmp0__length1 = directories_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->directories = (_vala_array_free (self->priv->directories, self->priv->directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->directories = _tmp1_;
	self->priv->directories_length1 = _tmp1__length1;
	self->priv->_directories_size_ = self->priv->directories_length1;
	self->priv->directory_index = 0;
	_games_uri_unref0 (self->priv->uri);
	self->priv->uri = NULL;
	_g_object_unref0 (self->priv->enumerator);
	self->priv->enumerator = NULL;
	return self;
}


GamesSteamUriIterator* games_steam_uri_iterator_new (gchar** directories, int directories_length1) {
	return games_steam_uri_iterator_construct (GAMES_TYPE_STEAM_URI_ITERATOR, directories, directories_length1);
}


static gpointer _games_uri_ref0 (gpointer self) {
	return self ? games_uri_ref (self) : NULL;
}


static GamesUri* games_steam_uri_iterator_real_get (GamesUriIterator* base) {
	GamesSteamUriIterator * self;
	GamesUri* result = NULL;
	GamesUri* _tmp0_;
	GamesUri* _tmp1_;
	self = (GamesSteamUriIterator*) base;
	_tmp0_ = self->priv->uri;
	_tmp1_ = _games_uri_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean games_steam_uri_iterator_real_next (GamesUriIterator* base) {
	GamesSteamUriIterator * self;
	gboolean result = FALSE;
	self = (GamesSteamUriIterator*) base;
	while (TRUE) {
		gint _tmp0_;
		gchar** _tmp1_;
		gint _tmp1__length1;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_;
		gint _tmp6_;
		_tmp0_ = self->priv->directory_index;
		_tmp1_ = self->priv->directories;
		_tmp1__length1 = self->priv->directories_length1;
		if (!(_tmp0_ < _tmp1__length1)) {
			break;
		}
		_tmp2_ = self->priv->directories;
		_tmp2__length1 = self->priv->directories_length1;
		_tmp3_ = self->priv->directory_index;
		_tmp4_ = _tmp2_[_tmp3_];
		_tmp5_ = games_steam_uri_iterator_try_next_for_directory (self, _tmp4_);
		if (_tmp5_) {
			result = TRUE;
			return result;
		}
		_tmp6_ = self->priv->directory_index;
		self->priv->directory_index = _tmp6_ + 1;
	}
	result = FALSE;
	return result;
}


static gboolean games_steam_uri_iterator_try_next_for_directory (GamesSteamUriIterator* self, const gchar* directory) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = directory;
		_tmp2_ = games_steam_uri_iterator_next_for_directory (self, _tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("steam-uri-iterator.vala:37: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp5_;
	}
	_games_uri_unref0 (self->priv->uri);
	self->priv->uri = NULL;
	_g_object_unref0 (self->priv->enumerator);
	self->priv->enumerator = NULL;
	result = FALSE;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean games_steam_uri_iterator_next_for_directory (GamesSteamUriIterator* self, const gchar* directory, GError** error) {
	gboolean result = FALSE;
	GFileEnumerator* _tmp0_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp19_;
	gchar* filename = NULL;
	const gchar* _tmp20_;
	GFileInfo* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* file_uri = NULL;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GamesUri* _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = self->priv->enumerator;
	if (_tmp0_ == NULL) {
		GFile* file = NULL;
		const gchar* _tmp1_;
		GFile* _tmp2_;
		GFileEnumerator* _tmp3_ = NULL;
		GFile* _tmp4_;
		GFileEnumerator* _tmp5_;
		GFileEnumerator* _tmp7_;
		_tmp1_ = directory;
		_tmp2_ = g_file_new_for_path (_tmp1_);
		file = _tmp2_;
		_tmp4_ = file;
		_tmp5_ = g_file_enumerate_children (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return _tmp6_;
		}
		_tmp7_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->enumerator);
		self->priv->enumerator = _tmp7_;
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (file);
	}
	info = NULL;
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			GFileInfo* _tmp14_ = NULL;
			GFileEnumerator* _tmp15_;
			GFileInfo* _tmp16_;
			GFileInfo* _tmp18_;
			if (!_tmp8_) {
				gboolean _tmp9_ = FALSE;
				GFileInfo* _tmp10_;
				_tmp10_ = info;
				if (_tmp10_ != NULL) {
					GFileInfo* _tmp11_;
					const gchar* _tmp12_;
					gboolean _tmp13_;
					_tmp11_ = info;
					_tmp12_ = g_file_info_get_name (_tmp11_);
					_tmp13_ = g_str_has_suffix (_tmp12_, ".acf");
					_tmp9_ = !_tmp13_;
				} else {
					_tmp9_ = FALSE;
				}
				if (!_tmp9_) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp15_ = self->priv->enumerator;
			_tmp16_ = g_file_enumerator_next_file (_tmp15_, NULL, &_inner_error_);
			_tmp14_ = _tmp16_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp17_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (info);
				return _tmp17_;
			}
			_tmp18_ = _tmp14_;
			_tmp14_ = NULL;
			_g_object_unref0 (info);
			info = _tmp18_;
			_g_object_unref0 (_tmp14_);
		}
	}
	_tmp19_ = info;
	if (_tmp19_ == NULL) {
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	_tmp20_ = directory;
	_tmp21_ = info;
	_tmp22_ = g_file_info_get_name (_tmp21_);
	_tmp23_ = g_build_filename (_tmp20_, _tmp22_, NULL);
	filename = _tmp23_;
	_tmp24_ = filename;
	_tmp25_ = g_filename_to_uri (_tmp24_, NULL, &_inner_error_);
	file_uri = _tmp25_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp26_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (filename);
		_g_object_unref0 (info);
		return _tmp26_;
	}
	_tmp27_ = file_uri;
	_tmp28_ = string_to_string (_tmp27_);
	_tmp29_ = g_strconcat ("steam+", _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = games_uri_new (_tmp30_);
	_games_uri_unref0 (self->priv->uri);
	self->priv->uri = _tmp31_;
	_g_free0 (_tmp30_);
	result = TRUE;
	_g_free0 (file_uri);
	_g_free0 (filename);
	_g_object_unref0 (info);
	return result;
}


static void games_steam_uri_iterator_class_init (GamesSteamUriIteratorClass * klass) {
	games_steam_uri_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesSteamUriIteratorPrivate));
	G_OBJECT_CLASS (klass)->finalize = games_steam_uri_iterator_finalize;
}


static void games_steam_uri_iterator_games_uri_iterator_interface_init (GamesUriIteratorIface * iface) {
	games_steam_uri_iterator_games_uri_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->get = (GamesUri* (*) (GamesUriIterator *)) games_steam_uri_iterator_real_get;
	iface->next = (gboolean (*) (GamesUriIterator *)) games_steam_uri_iterator_real_next;
}


static void games_steam_uri_iterator_instance_init (GamesSteamUriIterator * self) {
	self->priv = GAMES_STEAM_URI_ITERATOR_GET_PRIVATE (self);
}


static void games_steam_uri_iterator_finalize (GObject * obj) {
	GamesSteamUriIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_STEAM_URI_ITERATOR, GamesSteamUriIterator);
	self->priv->directories = (_vala_array_free (self->priv->directories, self->priv->directories_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->enumerator);
	_games_uri_unref0 (self->priv->uri);
	G_OBJECT_CLASS (games_steam_uri_iterator_parent_class)->finalize (obj);
}


GType games_steam_uri_iterator_get_type (void) {
	return games_steam_uri_iterator_type_id;
}


GType games_steam_uri_iterator_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesSteamUriIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_steam_uri_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSteamUriIterator), 0, (GInstanceInitFunc) games_steam_uri_iterator_instance_init, NULL };
	static const GInterfaceInfo games_uri_iterator_info = { (GInterfaceInitFunc) games_steam_uri_iterator_games_uri_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_steam_uri_iterator_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSteamUriIterator", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_steam_uri_iterator_type_id, GAMES_TYPE_URI_ITERATOR, &games_uri_iterator_info);
	return games_steam_uri_iterator_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



