/* contacts-utils.c generated by valac 0.21.1.32-328f, the Vala compiler
 * generated from contacts-utils.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <folks/folks-telepathy.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks.h>
#include <gee.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_UTILS (contacts_utils_get_type ())
#define CONTACTS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_UTILS, ContactsUtils))
#define CONTACTS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_UTILS, ContactsUtilsClass))
#define CONTACTS_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_UTILS))
#define CONTACTS_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_UTILS))
#define CONTACTS_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_UTILS, ContactsUtilsClass))

typedef struct _ContactsUtils ContactsUtils;
typedef struct _ContactsUtilsClass ContactsUtilsClass;
typedef struct _ContactsUtilsPrivate ContactsUtilsPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block36Data Block36Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _ContactsUtils {
	GObject parent_instance;
	ContactsUtilsPrivate * priv;
};

struct _ContactsUtilsClass {
	GObjectClass parent_class;
};

struct _Block36Data {
	int _ref_count_;
	gulong id;
	GtkWidget* widget;
};


static gpointer contacts_utils_parent_class = NULL;

gboolean contacts_is_set (const gchar* str);
GtkBuilder* contacts_load_ui (const gchar* ui);
GType contacts_utils_get_type (void) G_GNUC_CONST;
enum  {
	CONTACTS_UTILS_DUMMY_PROPERTY
};
void contacts_utils_compose_mail (const gchar* email);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts);
void contacts_utils_start_call_with_account (const gchar* contact_id, TpAccount* account);
gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection);
GtkMenuItem* contacts_utils_add_menu_item (GtkMenu* menu, const gchar* label);
void contacts_utils_grid_insert_row_after (GtkGrid* grid, GtkWidget* widget, gboolean expand_intersecting);
void contacts_utils_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2);
void contacts_utils_cairo_rounded_box (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius);
static gunichar contacts_utils_strip_char (gunichar ch);
gboolean contacts_utils_string_is_empty (const gchar* str);
gchar* contacts_utils_canonicalize_for_search (const gchar* str);
void contacts_utils_grab_widget_later (GtkWidget* widget);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static void __lambda3_ (Block36Data* _data36_);
static void ___lambda3__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
void contacts_utils_grab_entry_focus_no_select (GtkEntry* entry);
static void contacts_utils_spawn_app (GSettings* app_settings, GError** error);
void contacts_utils_show_calendar (GDateTime* day);
gchar** contacts_utils_get_stock_avatars (int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
ContactsUtils* contacts_utils_new (void);
ContactsUtils* contacts_utils_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gboolean contacts_is_set (const gchar* str) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	_tmp1_ = str;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = str;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


GtkBuilder* contacts_load_ui (const gchar* ui) {
	GtkBuilder* result = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ui != NULL, NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	{
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = ui;
		_tmp2_ = g_strconcat ("/org/gnome/contacts/", _tmp1_, NULL, NULL);
		_tmp3_ = _tmp2_;
		gtk_builder_add_from_resource (builder, _tmp3_, &_inner_error_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e->message;
		g_error ("contacts-utils.vala:34: loading ui file: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally24:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = builder;
	return result;
}


void contacts_utils_compose_mail (const gchar* email) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (email != NULL);
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp0_ = email;
		_tmp1_ = g_uri_escape_string (_tmp0_, "@", FALSE);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("mailto:", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		gtk_show_uri (NULL, _tmp4_, (guint32) 0, &_inner_error_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally25:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id) {
	TpfPersona* im_persona = NULL;
	ContactsContact* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	TpfPersona* _tmp3_ = NULL;
	TpAccount* account = NULL;
	FolksPersonaStore* _tmp4_ = NULL;
	FolksPersonaStore* _tmp5_ = NULL;
	TpAccount* _tmp6_ = NULL;
	TpAccount* _tmp7_ = NULL;
	TpAccount* _tmp8_ = NULL;
	GHashTable* request_dict = NULL;
	GHashFunc _tmp9_ = NULL;
	GEqualFunc _tmp10_ = NULL;
	GHashTable* _tmp11_ = NULL;
	GValue* _tmp12_ = NULL;
	GValue* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GValue* _tmp15_ = NULL;
	TpAccountChannelRequest* request = NULL;
	gint64 _tmp16_ = 0LL;
	TpAccountChannelRequest* _tmp17_ = NULL;
	g_return_if_fail (contact != NULL);
	g_return_if_fail (protocol != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = contact;
	_tmp1_ = protocol;
	_tmp2_ = id;
	_tmp3_ = contacts_contact_find_im_persona (_tmp0_, _tmp1_, _tmp2_);
	im_persona = _tmp3_;
	_tmp4_ = folks_persona_get_store ((FolksPersona*) im_persona);
	_tmp5_ = _tmp4_;
	_tmp6_ = tpf_persona_store_get_account (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp5_) : NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	account = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, NULL, __vala_GValue_free0_);
	request_dict = _tmp11_;
	_tmp12_ = g_new0 (GValue, 1);
	g_value_init (_tmp12_, G_TYPE_STRING);
	g_value_set_string (_tmp12_, TP_IFACE_CHANNEL_TYPE_TEXT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_CHANNEL_TYPE, _tmp12_);
	_tmp13_ = g_new0 (GValue, 1);
	g_value_init (_tmp13_, G_TYPE_INT);
	g_value_set_int (_tmp13_, (gint) TP_HANDLE_TYPE_CONTACT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_HANDLE_TYPE, _tmp13_);
	_tmp14_ = id;
	_tmp15_ = g_new0 (GValue, 1);
	g_value_init (_tmp15_, G_TYPE_STRING);
	g_value_set_string (_tmp15_, _tmp14_);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_ID, _tmp15_);
	_tmp16_ = G_MAXINT64;
	_tmp17_ = tp_account_channel_request_new (account, request_dict, _tmp16_);
	request = _tmp17_;
	tp_account_channel_request_ensure_channel_async (request, "org.freedesktop.Telepathy.Client.Empathy.Chat", NULL, NULL, NULL);
	_g_object_unref0 (request);
	_g_hash_table_unref0 (request_dict);
	_g_object_unref0 (account);
	_g_object_unref0 (im_persona);
}


void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts) {
	TpAccount* account = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gpointer* _tmp5_ = NULL;
	TpAccount** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	TpAccount* _tmp7_ = NULL;
	TpAccount* _tmp8_ = NULL;
	TpAccount* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (contact_id != NULL);
	g_return_if_fail (accounts != NULL);
	_tmp0_ = accounts;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = gee_collection_to_array (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp7_ = _tmp6_[0];
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp3_);
	account = _tmp9_;
	_tmp10_ = contact_id;
	contacts_utils_start_call_with_account (_tmp10_, account);
	_g_object_unref0 (account);
}


void contacts_utils_start_call_with_account (const gchar* contact_id, TpAccount* account) {
	GHashTable* request_dict = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GValue* _tmp6_ = NULL;
	GValue* _tmp7_ = NULL;
	TpAccountChannelRequest* request = NULL;
	TpAccount* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	TpAccountChannelRequest* _tmp10_ = NULL;
	g_return_if_fail (contact_id != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, __vala_GValue_free0_);
	request_dict = _tmp2_;
	_tmp3_ = g_new0 (GValue, 1);
	g_value_init (_tmp3_, G_TYPE_STRING);
	g_value_set_string (_tmp3_, TP_IFACE_CHANNEL_TYPE_CALL);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_CHANNEL_TYPE, _tmp3_);
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_INT);
	g_value_set_int (_tmp4_, (gint) TP_HANDLE_TYPE_CONTACT);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_HANDLE_TYPE, _tmp4_);
	_tmp5_ = contact_id;
	_tmp6_ = g_new0 (GValue, 1);
	g_value_init (_tmp6_, G_TYPE_STRING);
	g_value_set_string (_tmp6_, _tmp5_);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TARGET_ID, _tmp6_);
	_tmp7_ = g_new0 (GValue, 1);
	g_value_init (_tmp7_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp7_, TRUE);
	g_hash_table_insert (request_dict, TP_PROP_CHANNEL_TYPE_CALL_INITIAL_AUDIO, _tmp7_);
	_tmp8_ = account;
	_tmp9_ = G_MAXINT64;
	_tmp10_ = tp_account_channel_request_new (_tmp8_, request_dict, _tmp9_);
	request = _tmp10_;
	tp_account_channel_request_ensure_channel_async (request, "org.freedesktop.Telepathy.Client.Empathy.Call", NULL, NULL, NULL);
	_g_object_unref0 (request);
	_g_hash_table_unref0 (request_dict);
}


gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection) {
	gpointer result = NULL;
	GeeIterator* i = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = collection;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	i = _tmp1_;
	_tmp2_ = i;
	_tmp3_ = gee_iterator_next (_tmp2_);
	if (_tmp3_) {
		GeeIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		_tmp4_ = i;
		_tmp5_ = gee_iterator_get (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (i);
		return result;
	}
	result = NULL;
	_g_object_unref0 (i);
	return result;
}


GtkMenuItem* contacts_utils_add_menu_item (GtkMenu* menu, const gchar* label) {
	GtkMenuItem* result = NULL;
	GtkMenuItem* mi = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	GtkMenu* _tmp2_ = NULL;
	g_return_val_if_fail (menu != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = label;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp0_);
	g_object_ref_sink (_tmp1_);
	mi = _tmp1_;
	_tmp2_ = menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp2_, (GtkWidget*) mi);
	gtk_widget_show ((GtkWidget*) mi);
	result = mi;
	return result;
}


void contacts_utils_grid_insert_row_after (GtkGrid* grid, GtkWidget* widget, gboolean expand_intersecting) {
	gint y = 0;
	gint h = 0;
	GtkGrid* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gint start = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkGrid* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	g_return_if_fail (grid != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = grid;
	_tmp1_ = widget;
	gtk_container_child_get ((GtkContainer*) _tmp0_, _tmp1_, "top-attach", &y, "height", &h, NULL);
	_tmp2_ = y;
	_tmp3_ = h;
	start = _tmp2_ + _tmp3_;
	_tmp4_ = grid;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp5_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkGrid* _tmp6_ = NULL;
				GtkWidget* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				_tmp6_ = grid;
				_tmp7_ = child;
				gtk_container_child_get ((GtkContainer*) _tmp6_, _tmp7_, "top-attach", &y, "height", &h, NULL);
				_tmp8_ = y;
				_tmp9_ = start;
				if (_tmp8_ >= _tmp9_) {
					GtkGrid* _tmp10_ = NULL;
					GtkWidget* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					_tmp10_ = grid;
					_tmp11_ = child;
					_tmp12_ = y;
					gtk_container_child_set ((GtkContainer*) _tmp10_, _tmp11_, "top-attach", _tmp12_ + 1, NULL);
				} else {
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gboolean _tmp18_ = FALSE;
					_tmp14_ = y;
					_tmp15_ = h;
					_tmp16_ = start;
					if ((_tmp14_ + _tmp15_) > _tmp16_) {
						gboolean _tmp17_ = FALSE;
						_tmp17_ = expand_intersecting;
						_tmp13_ = _tmp17_;
					} else {
						_tmp13_ = FALSE;
					}
					_tmp18_ = _tmp13_;
					if (_tmp18_) {
						GtkGrid* _tmp19_ = NULL;
						GtkWidget* _tmp20_ = NULL;
						gint _tmp21_ = 0;
						_tmp19_ = grid;
						_tmp20_ = child;
						_tmp21_ = h;
						gtk_container_child_set ((GtkContainer*) _tmp19_, _tmp20_, "height", _tmp21_ + 1, NULL);
					}
				}
			}
		}
		_g_list_free0 (child_collection);
	}
}


void contacts_utils_cairo_ellipsis (cairo_t* cr, gdouble xc, gdouble yc, gdouble xradius, gdouble yradius, gdouble angle1, gdouble angle2) {
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_ = 0.0;
	gboolean _tmp3_ = FALSE;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	cairo_t* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	cairo_t* _tmp14_ = NULL;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	cairo_t* _tmp17_ = NULL;
	g_return_if_fail (cr != NULL);
	_tmp1_ = xradius;
	if (_tmp1_ <= 0.0) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp2_ = 0.0;
		_tmp2_ = yradius;
		_tmp0_ = _tmp2_ <= 0.0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		cairo_t* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		_tmp4_ = cr;
		_tmp5_ = xc;
		_tmp6_ = yc;
		cairo_line_to (_tmp4_, _tmp5_, _tmp6_);
		return;
	}
	_tmp7_ = cr;
	cairo_save (_tmp7_);
	_tmp8_ = cr;
	_tmp9_ = xc;
	_tmp10_ = yc;
	cairo_translate (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = cr;
	_tmp12_ = xradius;
	_tmp13_ = yradius;
	cairo_scale (_tmp11_, _tmp12_, _tmp13_);
	_tmp14_ = cr;
	_tmp15_ = angle1;
	_tmp16_ = angle2;
	cairo_arc (_tmp14_, (gdouble) 0, (gdouble) 0, 1.0, _tmp15_, _tmp16_);
	_tmp17_ = cr;
	cairo_restore (_tmp17_);
}


void contacts_utils_cairo_rounded_box (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius) {
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	cairo_t* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	cairo_t* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	cairo_t* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_new_sub_path (_tmp0_);
	_tmp1_ = cr;
	_tmp2_ = x;
	_tmp3_ = radius;
	_tmp4_ = y;
	_tmp5_ = radius;
	_tmp6_ = radius;
	_tmp7_ = radius;
	contacts_utils_cairo_ellipsis (_tmp1_, (gdouble) (_tmp2_ + _tmp3_), (gdouble) (_tmp4_ + _tmp5_), (gdouble) _tmp6_, (gdouble) _tmp7_, G_PI, (3 * G_PI) / 2);
	_tmp8_ = cr;
	_tmp9_ = x;
	_tmp10_ = width;
	_tmp11_ = radius;
	_tmp12_ = y;
	_tmp13_ = radius;
	_tmp14_ = radius;
	_tmp15_ = radius;
	contacts_utils_cairo_ellipsis (_tmp8_, (gdouble) ((_tmp9_ + _tmp10_) - _tmp11_), (gdouble) (_tmp12_ + _tmp13_), (gdouble) _tmp14_, (gdouble) _tmp15_, (-G_PI) / 2, (gdouble) 0);
	_tmp16_ = cr;
	_tmp17_ = x;
	_tmp18_ = width;
	_tmp19_ = radius;
	_tmp20_ = y;
	_tmp21_ = height;
	_tmp22_ = radius;
	_tmp23_ = radius;
	_tmp24_ = radius;
	contacts_utils_cairo_ellipsis (_tmp16_, (gdouble) ((_tmp17_ + _tmp18_) - _tmp19_), (gdouble) ((_tmp20_ + _tmp21_) - _tmp22_), (gdouble) _tmp23_, (gdouble) _tmp24_, (gdouble) 0, G_PI / 2);
	_tmp25_ = cr;
	_tmp26_ = x;
	_tmp27_ = radius;
	_tmp28_ = y;
	_tmp29_ = height;
	_tmp30_ = radius;
	_tmp31_ = radius;
	_tmp32_ = radius;
	contacts_utils_cairo_ellipsis (_tmp25_, (gdouble) (_tmp26_ + _tmp27_), (gdouble) ((_tmp28_ + _tmp29_) - _tmp30_), (gdouble) _tmp31_, (gdouble) _tmp32_, G_PI / 2, G_PI);
}


static gunichar contacts_utils_strip_char (gunichar ch) {
	gunichar result = 0U;
	gunichar _tmp0_ = 0U;
	GUnicodeType _tmp1_ = 0;
	_tmp0_ = ch;
	_tmp1_ = g_unichar_type (_tmp0_);
	switch (_tmp1_) {
		case G_UNICODE_CONTROL:
		case G_UNICODE_FORMAT:
		case G_UNICODE_UNASSIGNED:
		case G_UNICODE_NON_SPACING_MARK:
		case G_UNICODE_COMBINING_MARK:
		case G_UNICODE_ENCLOSING_MARK:
		{
			result = (gunichar) 0;
			return result;
		}
		default:
		{
			gunichar _tmp2_ = 0U;
			gunichar _tmp3_ = 0U;
			_tmp2_ = ch;
			_tmp3_ = g_unichar_tolower (_tmp2_);
			result = _tmp3_;
			return result;
		}
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gboolean contacts_utils_string_is_empty (const gchar* str) {
	gboolean result = FALSE;
	gunichar c = 0U;
	g_return_val_if_fail (str != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				const gchar* _tmp2_ = NULL;
				gunichar _tmp3_ = 0U;
				gboolean _tmp4_ = FALSE;
				gunichar _tmp5_ = 0U;
				gboolean _tmp6_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
				}
				_tmp0_ = FALSE;
				_tmp2_ = str;
				_tmp4_ = string_get_next_char (_tmp2_, &i, &_tmp3_);
				c = _tmp3_;
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = c;
				_tmp6_ = g_unichar_isspace (_tmp5_);
				if (!_tmp6_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* contacts_utils_canonicalize_for_search (const gchar* str) {
	gchar* result = NULL;
	const gchar* s = NULL;
	gunichar* buf = NULL;
	gunichar* _tmp0_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	GString* res = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_new0 (gunichar, 18);
	buf = _tmp0_;
	buf_length1 = 18;
	_buf_size_ = buf_length1;
	_tmp1_ = g_string_new ("");
	res = _tmp1_;
	{
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = str;
		s = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			const gchar* _tmp7_ = NULL;
			gchar _tmp8_ = '\0';
			gunichar c = 0U;
			const gchar* _tmp9_ = NULL;
			gunichar _tmp10_ = 0U;
			gunichar _tmp11_ = 0U;
			gunichar _tmp12_ = 0U;
			_tmp4_ = _tmp3_;
			if (!_tmp4_) {
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				_tmp5_ = s;
				_tmp6_ = g_utf8_next_char (_tmp5_);
				s = _tmp6_;
			}
			_tmp3_ = FALSE;
			_tmp7_ = s;
			_tmp8_ = string_get (_tmp7_, (glong) 0);
			if (!(((gint) _tmp8_) != 0)) {
				break;
			}
			_tmp9_ = s;
			_tmp10_ = string_get_char (_tmp9_, (glong) 0);
			_tmp11_ = contacts_utils_strip_char (_tmp10_);
			c = _tmp11_;
			_tmp12_ = c;
			if (_tmp12_ != ((gunichar) 0)) {
				gsize size = 0UL;
				gunichar _tmp13_ = 0U;
				gunichar* _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gsize _tmp15_ = 0UL;
				gsize _tmp16_ = 0UL;
				_tmp13_ = c;
				_tmp14_ = buf;
				_tmp14__length1 = buf_length1;
				_tmp15_ = g_unichar_fully_decompose (_tmp13_, FALSE, _tmp14_, _tmp14__length1);
				size = _tmp15_;
				_tmp16_ = size;
				if (_tmp16_ > ((gsize) 0)) {
					GString* _tmp17_ = NULL;
					gunichar* _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gunichar _tmp19_ = 0U;
					_tmp17_ = res;
					_tmp18_ = buf;
					_tmp18__length1 = buf_length1;
					_tmp19_ = _tmp18_[0];
					g_string_append_unichar (_tmp17_, _tmp19_);
				}
			}
		}
	}
	_tmp20_ = res;
	_tmp21_ = _tmp20_->str;
	_tmp22_ = g_strdup (_tmp21_);
	result = _tmp22_;
	_g_string_free0 (res);
	buf = (g_free (buf), NULL);
	return result;
}


static Block36Data* block36_data_ref (Block36Data* _data36_) {
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}


static void block36_data_unref (void * _userdata_) {
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		_g_object_unref0 (_data36_->widget);
		g_slice_free (Block36Data, _data36_);
	}
}


static void __lambda3_ (Block36Data* _data36_) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	_tmp0_ = _data36_->widget;
	gtk_widget_grab_focus (_tmp0_);
	_tmp1_ = _data36_->widget;
	_tmp2_ = _data36_->id;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
}


static void ___lambda3__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	__lambda3_ (self);
}


void contacts_utils_grab_widget_later (GtkWidget* widget) {
	Block36Data* _data36_;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	g_return_if_fail (widget != NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data36_->widget);
	_data36_->widget = _tmp1_;
	_data36_->id = (gulong) 0;
	_tmp2_ = _data36_->widget;
	_tmp3_ = g_signal_connect_data (_tmp2_, "size-allocate", (GCallback) ___lambda3__gtk_widget_size_allocate, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_data36_->id = _tmp3_;
	block36_data_unref (_data36_);
	_data36_ = NULL;
}


void contacts_utils_grab_entry_focus_no_select (GtkEntry* entry) {
	gint start = 0;
	gint end = 0;
	GtkEntry* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GtkEntry* _tmp7_ = NULL;
	GtkEntry* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (entry != NULL);
	_tmp0_ = entry;
	_tmp3_ = gtk_editable_get_selection_bounds ((GtkEditable*) _tmp0_, &_tmp1_, &_tmp2_);
	start = _tmp1_;
	end = _tmp2_;
	if (!_tmp3_) {
		GtkEntry* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp4_ = entry;
		_tmp5_ = gtk_editable_get_position ((GtkEditable*) _tmp4_);
		end = _tmp5_;
		_tmp6_ = end;
		start = _tmp6_;
	}
	_tmp7_ = entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
	_tmp8_ = entry;
	_tmp9_ = start;
	_tmp10_ = end;
	gtk_editable_select_region ((GtkEditable*) _tmp8_, _tmp9_, _tmp10_);
}


static void contacts_utils_spawn_app (GSettings* app_settings, GError** error) {
	gboolean needs_term = FALSE;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* exec = NULL;
	GSettings* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (app_settings != NULL);
	_tmp0_ = app_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "needs-term");
	needs_term = _tmp1_;
	_tmp2_ = app_settings;
	_tmp3_ = g_settings_get_string (_tmp2_, "exec");
	exec = _tmp3_;
	_tmp4_ = needs_term;
	if (_tmp4_) {
		GSettings* terminal_settings = NULL;
		GSettings* _tmp5_ = NULL;
		gchar* term = NULL;
		GSettings* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* arg = NULL;
		GSettings* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar** args = NULL;
		gint args_length1 = 0;
		gint _args_size_ = 0;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		_tmp5_ = g_settings_new ("org.gnome.desktop.default-applications.terminal");
		terminal_settings = _tmp5_;
		_tmp6_ = terminal_settings;
		_tmp7_ = g_settings_get_string (_tmp6_, "exec");
		term = _tmp7_;
		_tmp8_ = terminal_settings;
		_tmp9_ = g_settings_get_string (_tmp8_, "exec-arg");
		arg = _tmp9_;
		_tmp10_ = arg;
		if (g_strcmp0 (_tmp10_, "") != 0) {
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar** _tmp17_ = NULL;
			_tmp11_ = term;
			_tmp12_ = g_strdup (_tmp11_);
			_tmp13_ = arg;
			_tmp14_ = g_strdup (_tmp13_);
			_tmp15_ = exec;
			_tmp16_ = g_strdup (_tmp15_);
			_tmp17_ = g_new0 (gchar*, 4 + 1);
			_tmp17_[0] = _tmp12_;
			_tmp17_[1] = _tmp14_;
			_tmp17_[2] = _tmp16_;
			_tmp17_[3] = NULL;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			args = _tmp17_;
			args_length1 = 4;
			_args_size_ = args_length1;
		} else {
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar** _tmp22_ = NULL;
			_tmp18_ = term;
			_tmp19_ = g_strdup (_tmp18_);
			_tmp20_ = exec;
			_tmp21_ = g_strdup (_tmp20_);
			_tmp22_ = g_new0 (gchar*, 3 + 1);
			_tmp22_[0] = _tmp19_;
			_tmp22_[1] = _tmp21_;
			_tmp22_[2] = NULL;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			args = _tmp22_;
			args_length1 = 3;
			_args_size_ = args_length1;
		}
		_tmp23_ = args;
		_tmp23__length1 = args_length1;
		g_spawn_async (NULL, _tmp23_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (arg);
				_g_free0 (term);
				_g_object_unref0 (terminal_settings);
				_g_free0 (exec);
				return;
			} else {
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (arg);
				_g_free0 (term);
				_g_object_unref0 (terminal_settings);
				_g_free0 (exec);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (arg);
		_g_free0 (term);
		_g_object_unref0 (terminal_settings);
	} else {
		const gchar* _tmp24_ = NULL;
		_tmp24_ = exec;
		g_spawn_command_line_async (_tmp24_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (exec);
				return;
			} else {
				_g_free0 (exec);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_free0 (exec);
}


void contacts_utils_show_calendar (GDateTime* day) {
	GSettings* calendar_settings = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* exec = NULL;
	GSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_settings_new ("org.gnome.desktop.default-applications.office.calendar");
	calendar_settings = _tmp0_;
	_tmp1_ = calendar_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "exec");
	exec = _tmp2_;
	_tmp4_ = exec;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = exec;
		_tmp3_ = g_strcmp0 (_tmp5_, "evolution") == 0;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		gchar** args = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar** _tmp10_ = NULL;
		gint args_length1 = 0;
		gint _args_size_ = 0;
		GDateTime* _tmp11_ = NULL;
		_tmp7_ = g_strdup ("evolution");
		_tmp8_ = g_strdup ("-c");
		_tmp9_ = g_strdup ("calendar");
		_tmp10_ = g_new0 (gchar*, 5 + 1);
		_tmp10_[0] = _tmp7_;
		_tmp10_[1] = _tmp8_;
		_tmp10_[2] = _tmp9_;
		_tmp10_[3] = NULL;
		_tmp10_[4] = NULL;
		args = _tmp10_;
		args_length1 = 5;
		_args_size_ = args_length1;
		_tmp11_ = day;
		if (_tmp11_ != NULL) {
			GDateTime* d = NULL;
			GDateTime* _tmp12_ = NULL;
			GDateTime* _tmp13_ = NULL;
			GDateTime* today = NULL;
			GDateTime* _tmp14_ = NULL;
			gchar** _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			GDateTime* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			GDateTime* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			GDateTime* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			_tmp12_ = day;
			_tmp13_ = g_date_time_to_local (_tmp12_);
			d = _tmp13_;
			_tmp14_ = g_date_time_new_now_local ();
			today = _tmp14_;
			_tmp15_ = args;
			_tmp15__length1 = args_length1;
			_tmp16_ = today;
			_tmp17_ = g_date_time_get_year (_tmp16_);
			_tmp18_ = d;
			_tmp19_ = g_date_time_get_month (_tmp18_);
			_tmp20_ = d;
			_tmp21_ = g_date_time_get_day_of_month (_tmp20_);
			_tmp22_ = g_strdup_printf ("calendar:///?startdate=%.4d%.2d%.2d", _tmp17_, _tmp19_, _tmp21_);
			_g_free0 (_tmp15_[3]);
			_tmp15_[3] = _tmp22_;
			_tmp23_ = _tmp15_[3];
			_g_date_time_unref0 (today);
			_g_date_time_unref0 (d);
		}
		{
			gchar** _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			_tmp24_ = args;
			_tmp24__length1 = args_length1;
			g_spawn_async (NULL, _tmp24_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch26_g_error;
			}
		}
		goto __finally26;
		__catch26_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally26:
		if (_inner_error_ != NULL) {
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exec);
			_g_object_unref0 (calendar_settings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	} else {
		{
			GSettings* _tmp25_ = NULL;
			_tmp25_ = calendar_settings;
			contacts_utils_spawn_app (_tmp25_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch27_g_error;
			}
		}
		goto __finally27;
		__catch27_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally27:
		if (_inner_error_ != NULL) {
			_g_free0 (exec);
			_g_object_unref0 (calendar_settings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (exec);
	_g_object_unref0 (calendar_settings);
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** contacts_utils_get_stock_avatars (int* result_length1) {
	gchar** result = NULL;
	gchar** files = NULL;
	gchar** _tmp0_ = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	gchar** system_data_dirs = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint system_data_dirs_length1 = 0;
	gint _system_data_dirs_size_ = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	files = _tmp0_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup5 (_tmp2_, _vala_array_length (_tmp1_)) : ((gpointer) _tmp2_);
	_tmp3__length1 = _vala_array_length (_tmp1_);
	system_data_dirs = _tmp3_;
	system_data_dirs_length1 = _tmp3__length1;
	_system_data_dirs_size_ = system_data_dirs_length1;
	_tmp4_ = system_data_dirs;
	_tmp4__length1 = system_data_dirs_length1;
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp4_;
		data_dir_collection_length1 = _tmp4__length1;
		for (data_dir_it = 0; data_dir_it < _tmp4__length1; data_dir_it = data_dir_it + 1) {
			gchar* _tmp5_ = NULL;
			gchar* data_dir = NULL;
			_tmp5_ = g_strdup (data_dir_collection[data_dir_it]);
			data_dir = _tmp5_;
			{
				gchar* path = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				GDir* dir = NULL;
				GDir* _tmp11_ = NULL;
				_tmp6_ = data_dir;
				_tmp7_ = g_build_filename (_tmp6_, "pixmaps", "faces", NULL);
				path = _tmp7_;
				dir = NULL;
				{
					GDir* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					GDir* _tmp10_ = NULL;
					_tmp9_ = path;
					_tmp10_ = g_dir_open (_tmp9_, (guint) 0, &_inner_error_);
					_tmp8_ = _tmp10_;
					if (_inner_error_ != NULL) {
						goto __catch28_g_error;
					}
					_g_dir_close0 (dir);
					dir = _tmp8_;
				}
				goto __finally28;
				__catch28_g_error:
				{
					g_clear_error (&_inner_error_);
					_inner_error_ = NULL;
				}
				__finally28:
				if (_inner_error_ != NULL) {
					_g_dir_close0 (dir);
					_g_free0 (path);
					_g_free0 (data_dir);
					system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp11_ = dir;
				if (_tmp11_ != NULL) {
					gchar* face = NULL;
					while (TRUE) {
						GDir* _tmp12_ = NULL;
						const gchar* _tmp13_ = NULL;
						gchar* _tmp14_ = NULL;
						const gchar* _tmp15_ = NULL;
						gchar* filename = NULL;
						const gchar* _tmp16_ = NULL;
						const gchar* _tmp17_ = NULL;
						gchar* _tmp18_ = NULL;
						gchar** _tmp19_ = NULL;
						gint _tmp19__length1 = 0;
						const gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						_tmp12_ = dir;
						_tmp13_ = g_dir_read_name (_tmp12_);
						_tmp14_ = g_strdup (_tmp13_);
						_g_free0 (face);
						face = _tmp14_;
						_tmp15_ = face;
						if (!(_tmp15_ != NULL)) {
							break;
						}
						_tmp16_ = path;
						_tmp17_ = face;
						_tmp18_ = g_build_filename (_tmp16_, _tmp17_, NULL);
						filename = _tmp18_;
						_tmp19_ = files;
						_tmp19__length1 = files_length1;
						_tmp20_ = filename;
						_tmp21_ = g_strdup (_tmp20_);
						_vala_array_add10 (&files, &files_length1, &_files_size_, _tmp21_);
						_g_free0 (filename);
					}
					_g_free0 (face);
				}
				_g_dir_close0 (dir);
				_g_free0 (path);
				_g_free0 (data_dir);
			}
		}
	}
	_tmp22_ = files;
	_tmp22__length1 = files_length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ContactsUtils* contacts_utils_construct (GType object_type) {
	ContactsUtils * self = NULL;
	self = (ContactsUtils*) g_object_new (object_type, NULL);
	return self;
}


ContactsUtils* contacts_utils_new (void) {
	return contacts_utils_construct (CONTACTS_TYPE_UTILS);
}


static void contacts_utils_class_init (ContactsUtilsClass * klass) {
	contacts_utils_parent_class = g_type_class_peek_parent (klass);
}


static void contacts_utils_instance_init (ContactsUtils * self) {
}


GType contacts_utils_get_type (void) {
	static volatile gsize contacts_utils_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsUtils), 0, (GInstanceInitFunc) contacts_utils_instance_init, NULL };
		GType contacts_utils_type_id;
		contacts_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsUtils", &g_define_type_info, 0);
		g_once_init_leave (&contacts_utils_type_id__volatile, contacts_utils_type_id);
	}
	return contacts_utils_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



