/* $Id: guppi-debug.c,v 1.1 2000/01/17 05:44:56 trow Exp $ */

/*
 * guppi-debug.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-debug.h"

void
_guppi_unimplemented_function_dialog(const gchar* function,
				     const gchar* filename,
				     gint line)
{
  gchar* s;

  g_return_if_fail(function != NULL);
  g_return_if_fail(filename != NULL);
  g_return_if_fail(line > 0);

  s = g_strdup_printf("\"%s\" is not implemented yet.\n\nCode needs to be added at %s, line %d.", function, filename, line);

  gtk_widget_show_all(gnome_warning_dialog(s));

  g_free(s);
}


/* $Id: guppi-debug.c,v 1.1 2000/01/17 05:44:56 trow Exp $ */
