/* $Id: transform.c,v 1.1.1.1 1999/12/03 07:02:52 trow Exp $ */

/*
 * transform.c
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "transform.h"

static void
transform_calculate_scaling_factors(Transform* tr)
{
  g_return_if_fail(tr != NULL);

  tr->ppu = (tr->p1 - tr->p0) / (tr->t1 - tr->t0);
  tr->C = tr->p0 - tr->t0 * tr->ppu;
}

Transform*
transform_new(void)
{
  Transform* tr = g_new(Transform,1);
  tr->t0 = 0;
  tr->t1 = 1;
  tr->p0 = 0;
  tr->p1 = 100;
  transform_calculate_scaling_factors(tr);
  return tr;
}

void
transform_set_plot_bounds(Transform* tr, double t0, double t1)
{
  g_return_if_fail(tr != NULL);
  
  tr->t0 = t0;
  tr->t1 = t1;
  transform_calculate_scaling_factors(tr);
}

void
transform_set_pixel_bounds(Transform* tr, gint p0, gint p1)
{
  g_return_if_fail(tr != NULL);
  
  tr->p0 = p0;
  tr->p1 = p1;
  transform_calculate_scaling_factors(tr);
}

gint
transform_plot2pixel(const Transform* tr, double t)
{
  g_return_val_if_fail(tr != NULL, 0);
  return transform_plot2pixel_unsafe(tr, t);
}

double
transform_pixel2plot(const Transform* tr, gint p)
{
  g_return_val_if_fail(tr != NULL, 0);
  return transform_pixel2plot_unsafe(tr, p);
}

double
transform_plot_units_per_pixel(const Transform* tr)
{
  g_return_val_if_fail(tr != NULL, 0);
  return 1/tr->ppu;
}

double
transform_pixels_per_plot_units(const Transform* tr)
{
  g_return_val_if_fail(tr != NULL, 0);
  return tr->ppu;
}


/* $Id: transform.c,v 1.1.1.1 1999/12/03 07:02:52 trow Exp $ */
