/* This is -*- C -*- */
/* $Id: guppi-plot-element.c,v 1.2 2000/01/21 06:15:37 trow Exp $ */

/*
 * guppi-plot-element.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-plot-element.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

enum {
  CHANGED_LABEL,
  SHOW,
  HIDE,
  RAISE_OR_LOWER,
  UPDATE,
  LAST_SIGNAL
};
static guint gpe_signals[LAST_SIGNAL] = { 0 };

static void
guppi_plot_element_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_element_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_element_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_plot_element_finalize(GtkObject* obj)
{
  GuppiPlotElement* gpe = GUPPI_PLOT_ELEMENT(obj);

  if (parent_class->finalize)
    parent_class->finalize(obj);
  
  g_free(gpe->label);
  gpe->label = NULL;
}

static void
guppi_plot_element_class_init(GuppiPlotElementClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  gpe_signals[CHANGED_LABEL] = 
    gtk_signal_new("changed_label",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiPlotElementClass, changed_label),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gpe_signals[SHOW] = 
    gtk_signal_new("show",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiPlotElementClass, show),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gpe_signals[HIDE] = 
    gtk_signal_new("hide",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiPlotElementClass, hide),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gpe_signals[RAISE_OR_LOWER] = 
    gtk_signal_new("raise_or_lower",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiPlotElementClass, raise_or_lower),
		   gtk_marshal_NONE__INT,
		   GTK_TYPE_NONE, 1,
		   GTK_TYPE_INT);

  gpe_signals[UPDATE] = 
    gtk_signal_new("update",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiPlotElementClass, update),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gtk_object_class_add_signals(object_class, gpe_signals, LAST_SIGNAL);

  object_class->get_arg = guppi_plot_element_get_arg;
  object_class->set_arg = guppi_plot_element_set_arg;
  object_class->destroy = guppi_plot_element_destroy;
  object_class->finalize = guppi_plot_element_finalize;

  klass->type_name = NULL;
  klass->make_canvas_item = NULL;
  klass->make_state_widget = NULL;

}

static void
guppi_plot_element_init(GuppiPlotElement* obj)
{
  obj->visible = TRUE;
  obj->label = NULL;
}

GtkType
guppi_plot_element_get_type(void)
{
  static GtkType guppi_plot_element_type = 0;
  if (!guppi_plot_element_type) {
    static const GtkTypeInfo guppi_plot_element_info = {
      "GuppiPlotElement",
      sizeof(GuppiPlotElement),
      sizeof(GuppiPlotElementClass),
      (GtkClassInitFunc)guppi_plot_element_class_init,
      (GtkObjectInitFunc)guppi_plot_element_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_plot_element_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_plot_element_info);
  }
  return guppi_plot_element_type;
}

/*
GtkObject*
guppi_plot_element_new(void)
{
  return GTK_OBJECT(gtk_type_new(guppi_plot_element_get_type()));
}
*/

const gchar*
guppi_plot_element_type_name(GuppiPlotElement* gpe)
{
  const gchar* s;

  g_return_val_if_fail(gpe != NULL, NULL);

  s = GUPPI_PLOT_ELEMENT_CLASS(GTK_OBJECT(gpe)->klass)->type_name;
  return s ? s : _("(unknown type)");
}

const gchar*
guppi_plot_element_label(GuppiPlotElement* gpe)
{
  g_return_val_if_fail(gpe != NULL, NULL);

  return gpe->label ? gpe->label : _("(unnamed)");
}

void
guppi_plot_element_set_label(GuppiPlotElement* gpe, const gchar* label)
{
  g_return_if_fail(gpe != NULL);

  g_free(gpe->label);
  gpe->label = g_strdup(label);
  gtk_signal_emit(GTK_OBJECT(gpe), gpe_signals[CHANGED_LABEL]);
}

GuppiCanvasItem*
guppi_plot_element_make_canvas_item(GuppiPlotElement* gpe,
				    GnomeCanvas* canv,
				    double x1, double y1,
				    double x2, double y2)
{
  GuppiCanvasItem* (*fn)(GuppiPlotElement*, GnomeCanvas*, double, double, double, double);

  g_return_val_if_fail(gpe != NULL, NULL);
  g_return_val_if_fail(canv != NULL, NULL);

  fn = GUPPI_PLOT_ELEMENT_CLASS(GTK_OBJECT(gpe)->klass)->make_canvas_item;
  if (fn == NULL) {
    g_warning("The virtual function make_canvas_item() is not defined for type %s", guppi_plot_element_type_name(gpe));
    return NULL;
  } 

  return fn(gpe, canv, x1, y1, x2, y2);
}

GtkWidget*
guppi_plot_element_make_state_editor(GuppiPlotElement* gpe)
{
  GtkWidget* (*fn)(GuppiPlotElement*);

  g_return_val_if_fail(gpe != NULL, NULL);

  fn = GUPPI_PLOT_ELEMENT_CLASS(GTK_OBJECT(gpe)->klass)->make_state_widget;
  if (fn == NULL) {
    g_warning("The virtual function make_state_editor() is not defined for type %s", guppi_plot_element_type_name(gpe));
    return NULL;
  } 

  return fn(gpe);
}
				     

void
guppi_plot_element_show(GuppiPlotElement* gpe)
{
  if (!gpe->visible) {
    gpe->visible = TRUE;
    gtk_signal_emit(GTK_OBJECT(gpe), gpe_signals[SHOW]);
  }
}

void
guppi_plot_element_hide(GuppiPlotElement* gpe)
{
  if (gpe->visible) {
    gpe->visible = FALSE;
    gtk_signal_emit(GTK_OBJECT(gpe), gpe_signals[HIDE]);
  }
}

void
guppi_plot_element_set_visible(GuppiPlotElement* gpe, gboolean v)
{
  if (v)
    guppi_plot_element_show(gpe);
  else
    guppi_plot_element_hide(gpe);
}

void
guppi_plot_element_reverse_visibility(GuppiPlotElement* gpe)
{
  g_return_if_fail(gpe != NULL);
  guppi_plot_element_set_visible(gpe, !gpe->visible);
}

void
guppi_plot_element_raise(GuppiPlotElement* gpe, gint n)
{
  g_return_if_fail(gpe != NULL);

  if (n != 0)
    gtk_signal_emit(GTK_OBJECT(gpe), gpe_signals[RAISE_OR_LOWER], n);
}

void
guppi_plot_element_raise_to_top(GuppiPlotElement* gpe)
{
  g_return_if_fail(gpe != NULL);

  /* This will, of course, fail when there are more than 10^6 elements
     in a single plot. :-) */
  guppi_plot_element_raise(gpe, 1000000);
}

void
guppi_plot_element_lower(GuppiPlotElement* gpe, gint n)
{
  g_return_if_fail(gpe != NULL);
  if (n != 0)
    guppi_plot_element_raise(gpe, -n);
}

void
guppi_plot_element_lower_to_bottom(GuppiPlotElement* gpe)
{
  g_return_if_fail(gpe != NULL);
  guppi_plot_element_raise(gpe, -1000000);
}

void
guppi_plot_element_request_update(GuppiPlotElement* gpe)
{
  g_return_if_fail(gpe != NULL);
  g_assert_not_reached();
  gtk_signal_emit(GTK_OBJECT(gpe), gpe_signals[UPDATE]);
}
  





/* $Id: guppi-plot-element.c,v 1.2 2000/01/21 06:15:37 trow Exp $ */
