/* This is -*- C -*- */
/* $Id: guppi-item-state.c,v 1.2 2000/01/21 06:26:10 trow Exp $ */

/*
 * guppi-item-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-item-state.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

enum {
  UPDATE,
  LAST_SIGNAL
};

static guint gis_signals[LAST_SIGNAL] = { 0 };

static void
guppi_item_state_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_item_state_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_item_state_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_item_state_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_item_state_class_init(GuppiItemStateClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  object_class->get_arg = guppi_item_state_get_arg;
  object_class->set_arg = guppi_item_state_set_arg;
  object_class->destroy = guppi_item_state_destroy;
  object_class->finalize = guppi_item_state_finalize;

  gis_signals[UPDATE] = 
    gtk_signal_new("update",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiItemStateClass, update),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);

  gtk_object_class_add_signals(object_class, gis_signals, LAST_SIGNAL);
}

static void
guppi_item_state_init(GuppiItemState* obj)
{
  obj->freeze_count = 0;
  obj->pending_update = FALSE;
}

GtkType
guppi_item_state_get_type(void)
{
  static GtkType guppi_item_state_type = 0;
  if (!guppi_item_state_type) {
    static const GtkTypeInfo guppi_item_state_info = {
      "GuppiItemState",
      sizeof(GuppiItemState),
      sizeof(GuppiItemStateClass),
      (GtkClassInitFunc)guppi_item_state_class_init,
      (GtkObjectInitFunc)guppi_item_state_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_item_state_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_item_state_info);
  }
  return guppi_item_state_type;
}

GuppiItemState*
guppi_item_state_new(void)
{
  return GUPPI_ITEM_STATE(gtk_type_new(guppi_item_state_get_type()));
}

void
guppi_item_state_freeze(GuppiItemState* gis)
{
  g_return_if_fail(gis != NULL);
  g_assert(gis->freeze_count >= 0);
  ++gis->freeze_count;
}

void
guppi_item_state_thaw(GuppiItemState* gis)
{
  g_return_if_fail(gis != NULL);
  g_return_if_fail(gis->freeze_count > 0);
  --gis->freeze_count;
  
  if (gis->freeze_count == 0) {

    if (gis->pending_update)
      guppi_item_state_request_update(gis);

    gis->pending_update = FALSE;
  }
}

void
guppi_item_state_request_update(GuppiItemState* gis)
{
  g_return_if_fail(gis != NULL);

  if (gis->freeze_count == 0) {
    gtk_signal_emit(GTK_OBJECT(gis), gis_signals[UPDATE]);
  } else {
    gis->pending_update = TRUE;
  }
}


/* $Id: guppi-item-state.c,v 1.2 2000/01/21 06:26:10 trow Exp $ */
