/* This is -*- C -*- */
/* $Id: guppi-bounder.h,v 1.1.1.1 1999/12/03 07:02:54 trow Exp $ */

/*
 * guppi-bounder.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_BOUNDER_H
#define _INC_GUPPI_BOUNDER_H

#include <config.h>
#include <gnome.h>

typedef struct _GuppiBounder GuppiBounder;
typedef struct _GuppiBounderClass GuppiBounderClass;

struct _GuppiBounder {
  GtkObject parent;

  double t0, t1;
  gboolean clamp;
};

struct _GuppiBounderClass {
  GtkObjectClass parent_class;

  void (*changed)(GuppiBounder*);
};

#define GUPPI_TYPE_BOUNDER (guppi_bounder_get_type())
#define GUPPI_BOUNDER(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_BOUNDER,GuppiBounder))
#define GUPPI_BOUNDER_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_BOUNDER,GuppiBounderClass))
#define GUPPI_IS_BOUNDER(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_BOUNDER))
#define GUPPI_IS_BOUNDER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_BOUNDER))

GtkType guppi_bounder_get_type(void);

GtkObject* guppi_bounder_new(void);

void guppi_bounder_set(GuppiBounder*, double new_t0, double new_t1);
void guppi_bounder_reset(GuppiBounder*);
void guppi_bounder_translate(GuppiBounder*, double delta);
void guppi_bounder_scale(GuppiBounder*, double fixed_point, double scale);
void guppi_bounder_recenter(GuppiBounder*, double new_center);

#endif /* _INC_GUPPI_BOUNDER_H */

/* $Id: guppi-bounder.h,v 1.1.1.1 1999/12/03 07:02:54 trow Exp $ */
