/* This is -*- C -*- */
/* $Id: guppi-bounder.c,v 1.1.1.1 1999/12/03 07:02:54 trow Exp $ */

/*
 * guppi-bounder.c
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-bounder.h"

static GtkObjectClass* parent_class = NULL;

enum {
  CHANGED,
  LAST_SIGNAL
};
static guint bnd_signals[LAST_SIGNAL] = { 0 };

enum {
  ARG_0
};

static void
guppi_bounder_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_bounder_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_bounder_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_bounder_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_bounder_class_init(GuppiBounderClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  bnd_signals[CHANGED] = 
    gtk_signal_new("changed",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiBounderClass, changed),
		   gtk_marshal_NONE__NONE,
		   GTK_TYPE_NONE, 0);
  gtk_object_class_add_signals(object_class, bnd_signals, LAST_SIGNAL);

  object_class->get_arg = guppi_bounder_get_arg;
  object_class->set_arg = guppi_bounder_set_arg;
  object_class->destroy = guppi_bounder_destroy;
  object_class->finalize = guppi_bounder_finalize;

}

static void
guppi_bounder_init(GuppiBounder* obj)
{
  obj->t0 = 0;
  obj->t1 = 1;
  obj->clamp = TRUE;
}

GtkType
guppi_bounder_get_type(void)
{
  static GtkType guppi_bounder_type = 0;
  if (!guppi_bounder_type) {
    static const GtkTypeInfo guppi_bounder_info = {
      "GuppiBounder",
      sizeof(GuppiBounder),
      sizeof(GuppiBounderClass),
      (GtkClassInitFunc)guppi_bounder_class_init,
      (GtkObjectInitFunc)guppi_bounder_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_bounder_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_bounder_info);
  }
  return guppi_bounder_type;
}

/*
  "Sometimes I'll meet a bounder,
   who knew me when I was rounder.
   He'll come right up and say "Boy, have a drink!"
   We'll go down to the pool room,
   get in a game and then soon,
   it's broad daylight and I ain't slept a wink."
*/

GtkObject*
guppi_bounder_new(void)
{
  return GTK_OBJECT(gtk_type_new(guppi_bounder_get_type()));
}

void
guppi_bounder_set(GuppiBounder* bnd, double nt0, double nt1)
{
  g_return_if_fail(bnd != NULL);
  g_return_if_fail(nt0 < nt1);

  if (bnd->clamp) {
    nt0 = CLAMP(nt0,0,1);
    nt1 = CLAMP(nt1,0,1);
  }

  if (nt0 >= nt1) {
    g_warning("ignoring bad bounding: %f %f => %f %f",
	      bnd->t0, bnd->t1, nt0, nt1);
    return;
  }

  if (bnd->t0 != nt0 || bnd->t1 != nt1) {
    bnd->t0 = nt0;
    bnd->t1 = nt1;
    gtk_signal_emit(GTK_OBJECT(bnd), bnd_signals[CHANGED]);
  }
}

void
guppi_bounder_reset(GuppiBounder* bnd)
{
  g_return_if_fail(bnd != NULL);

  bnd->t0 = 0;
  bnd->t1 = 1;
}

void
guppi_bounder_translate(GuppiBounder* bnd, double delta)
{
  g_return_if_fail(bnd != NULL);

  if (bnd->clamp) {

    if (bnd->t1+delta > 1)
      delta = 1 - bnd->t1;

    if (bnd->t0+delta < 0)
      delta = -bnd->t0;
  }
  
  guppi_bounder_set(bnd, bnd->t0 + delta, bnd->t1 + delta);
}

void
guppi_bounder_scale(GuppiBounder* bnd, double fixed, double scale)
{
  g_return_if_fail(bnd != NULL);

  guppi_bounder_set(bnd,
		    fixed + scale*(bnd->t0 - fixed),
		    fixed + scale*(bnd->t1 - fixed));
}

void
guppi_bounder_recenter(GuppiBounder* bnd, double center)
{
  double w;
  g_return_if_fail(bnd != NULL);

  w = (bnd->t1 - bnd->t0) / 2;

  if (bnd->clamp) {
    if (center - w/2 < 0)
      center = w/2;
    else if (center + w/2 > 1)
      center = 1 - w/2;
  }

  guppi_bounder_set(bnd, center - w/2, center + w/2);
}


/* $Id: guppi-bounder.c,v 1.1.1.1 1999/12/03 07:02:54 trow Exp $ */




