/* This is -*- C -*- */
/* $Id: guppi-string-data.h,v 1.3 1999/12/07 17:05:04 trow Exp $ */

/*
 * guppi-string-data.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_STRING_DATA_H
#define _INC_GUPPI_STRING_DATA_H

#include <config.h>
#include <gnome.h>
#include "guppi-data.h"

typedef struct _GuppiStringIndexPair GuppiStringIndexPair;
struct _GuppiStringIndexPair {
  gchar* str;
  dindex_t index;
};

typedef struct _GuppiStringData GuppiStringData;
typedef struct _GuppiStringDataClass GuppiStringDataClass;

struct _GuppiStringData {
  GuppiData base;

  gchar** data;
  gsize size, poolsize;

  GuppiStringIndexPair* sorted_data;

  /* A type we might possibly convert to later... */
  GtkType potential_type;
  gchar* potential_empty_override;
  gchar* potential_invalid_override;
};

struct _GuppiStringDataClass {
  GuppiDataClass parent_class;
};

#define GUPPI_TYPE_STRING_DATA (guppi_string_data_get_type())
#define GUPPI_STRING_DATA(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_STRING_DATA,GuppiStringData))
#define GUPPI_STRING_DATA_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_STRING_DATA,GuppiStringDataClass))
#define GUPPI_IS_STRING_DATA(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_STRING_DATA))
#define GUPPI_IS_STRING_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_STRING_DATA))

GtkType guppi_string_data_get_type(void);

GuppiData* guppi_string_data_new(void);

const gchar* guppi_string_data_get(const GuppiStringData*, dindex_t);

/* The *_nc functions are the "no-copy" versions.  Instead of duplicating
   the string you pass in, they just "take ownership" of the pointer
   that you've passed in. */

void guppi_string_data_set_nc(GuppiStringData*, dindex_t, gchar*);
void guppi_string_data_set(GuppiStringData*, dindex_t, const gchar*);
void guppi_string_data_setn(GuppiStringData*, dindex_t, const gchar*, guint);

void guppi_string_data_add_nc(GuppiStringData*, gchar*);
void guppi_string_data_add(GuppiStringData*, const gchar*);
void guppi_string_data_addn(GuppiStringData*, const gchar*, guint);

void guppi_string_data_insert_nc(GuppiStringData*, dindex_t, gchar*);
void guppi_string_data_insert(GuppiStringData*, dindex_t, const gchar*);
void guppi_string_data_insertn(GuppiStringData*, dindex_t, const gchar*,guint);

void guppi_string_data_delete(GuppiStringData*, dindex_t);

dindex_t guppi_string_data_lookup(const GuppiStringData*, const gchar*);
gboolean guppi_string_data_contains(const GuppiStringData*, const gchar*);

guint guppi_string_data_distinct_values(const GuppiStringData*);
guint guppi_string_data_empty_count(const GuppiStringData*);


#endif /* _INC_GUPPI_STRING_DATA_H */

/* $Id: guppi-string-data.h,v 1.3 1999/12/07 17:05:04 trow Exp $ */
