/* $Id: guppi-scm-string-data.c,v 1.1 2000/01/17 05:44:54 trow Exp $ */

/*
 * guppi-scm-string-data.c
 *
 * Copyright (C) 1999, 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scm-data.h"
#include "guppi-scm-string-data.h"


#define SCM_TO_STRING_DATA(x) (GUPPI_STRING_DATA(SCM_CDR(x)))
#define SCM_STRING_DATA_P(x) \
     (SCM_NIMP(x) && scm_data_p(x) && GUPPI_IS_STRING_DATA(SCM_CDR(x)))

gboolean
scm_string_data_p(SCM x)
{
  return SCM_STRING_DATA_P(x);
}

GuppiStringData*
scm2string_data(SCM x)
{
  return SCM_STRING_DATA_P(x) ? SCM_TO_STRING_DATA(x) : NULL;
}

/*****************************************************************************/

GUPPI_PROC(strd_new, "make-string-data",
	   0,0,0, ())
{
  return data2scm(GUPPI_DATA(guppi_string_data_new()));
}

GUPPI_PROC(strdp, "string-data?",
	   1,0,0, (SCM x))
{
  return gh_bool2scm(SCM_STRING_DATA_P(x));
}

GUPPI_PROC(strd_get, "string-data-get",
	   2,0,0, (SCM ssd, SCM si))
{
  GuppiStringData* sd;
  gint i;

  SCM_ASSERT(SCM_STRING_DATA_P(ssd), ssd, SCM_ARG1, str_strd_get);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_strd_get);

  sd = SCM_TO_STRING_DATA(ssd);
  i = gh_scm2int(si);
  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(sd), i), si,
	     SCM_OUTOFRANGE, str_strd_get);

  return gh_str02scm((gchar*)guppi_string_data_get(sd, i));
}

GUPPI_PROC(strd_set, "string-data-set!",
	   3,0,0, (SCM ssd, SCM si, SCM sx))
{
  GuppiStringData* sd;
  gint i;
  gchar* x;
  gint len;

  SCM_ASSERT(SCM_STRING_DATA_P(ssd), ssd, SCM_ARG1, str_strd_set);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_strd_set);
  SCM_ASSERT(gh_string_p(sx), sx, SCM_ARG3, str_strd_set);

  sd = SCM_TO_STRING_DATA(ssd);
  i = gh_scm2int(si);
  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(sd), i), si,
	     SCM_OUTOFRANGE, str_strd_set);
  x = gh_scm2newstr(sx, &len);
  guppi_string_data_set_nc(sd, i, x);

  return ssd;
}

GUPPI_PROC(strd_add, "string-data-add!",
	   2,0,0, (SCM sd, SCM x))
{
  gint len;

  SCM_ASSERT(SCM_STRING_DATA_P(sd), sd, SCM_ARG1, str_strd_add);
  SCM_ASSERT(gh_string_p(x), x, SCM_ARG2, str_strd_add);

  guppi_string_data_add(SCM_TO_STRING_DATA(sd),
			gh_scm2newstr(x, &len));

  return sd;
}

GUPPI_PROC(strd_ins, "string-data-insert!",
	   3,0,0, (SCM ssd, SCM si, SCM sx))
{
  GuppiStringData* sd;
  gint i;
  gchar* x;
  gint len;

  SCM_ASSERT(SCM_STRING_DATA_P(ssd), ssd, SCM_ARG1, str_strd_ins);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_strd_ins);
  SCM_ASSERT(gh_string_p(sx), sx, SCM_ARG3, str_strd_ins);

  sd = SCM_TO_STRING_DATA(ssd);
  i = gh_scm2int(si);
  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(sd), i), si,
	     SCM_OUTOFRANGE, str_strd_ins);

  x = gh_scm2newstr(sx, &len);
  guppi_string_data_insert_nc(sd, i, x);

  return ssd;
}

GUPPI_PROC(strd_del, "string-data-delete!",
	   2,0,0, (SCM ssd, SCM si))
{
  GuppiStringData* sd;
  gint i;

  SCM_ASSERT(SCM_STRING_DATA_P(ssd), ssd, SCM_ARG1, str_strd_del);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_strd_del);

  sd = SCM_TO_STRING_DATA(ssd);
  i = gh_scm2int(si);
  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(sd), i), si,
	     SCM_OUTOFRANGE, str_strd_del);

  guppi_string_data_delete(sd, i);

  return ssd;
}

GUPPI_PROC(strd_look, "string-data-lookup",
	   2,0,0, (SCM ssd, SCM sx))
{
  GuppiStringData* sd;
  gchar* x;
  gint len;
  dindex_t i;

  SCM_ASSERT(SCM_STRING_DATA_P(ssd), ssd, SCM_ARG1, str_strd_look);
  SCM_ASSERT(gh_string_p(sx), sx, SCM_ARG2, str_strd_look);

  sd = SCM_TO_STRING_DATA(ssd);
  x = gh_scm2newstr(sx, &len);

  i = guppi_string_data_lookup(sd, x);
  if (!guppi_data_in_bounds(GUPPI_DATA(sd), i))
      return SCM_BOOL_F;
  else
    return gh_int2scm(i);
}

/*****************************************************************************/

void
guppi_scm_string_data_init(void)
{
  static gboolean initialized = FALSE;
  g_return_if_fail(!initialized);
  initialized = TRUE;

#include "guppi-scm-string-data.x"
}

/* $Id: guppi-scm-string-data.c,v 1.1 2000/01/17 05:44:54 trow Exp $ */
