/* $Id: guppi-scm-scalar-data.c,v 1.1 2000/01/17 05:44:54 trow Exp $ */

/*
 * guppi-scm-scalar-data.c
 *
 * Copyright (C) 1999, 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scm-data.h"
#include "guppi-scm-scalar-data.h"

#define SCM_TO_SCALAR_DATA(x) (GUPPI_SCALAR_DATA(SCM_CDR(x)))
#define SCM_SCALAR_DATA_P(x) \
     (SCM_NIMP(x) && scm_data_p(x) && GUPPI_IS_SCALAR_DATA(SCM_CDR(x)))

gboolean
scm_scalar_data_p(SCM x)
{
  return SCM_SCALAR_DATA_P(x);
}

GuppiScalarData*
scm2scalar_data(SCM x)
{
  return SCM_SCALAR_DATA_P(x) ? SCM_TO_SCALAR_DATA(x) : NULL;
}

/*****************************************************************************/

GUPPI_PROC(gsd_new, "make-scalar-data",
	   0,0,0, ())
{
  return data2scm(GUPPI_DATA(guppi_scalar_data_new()));
}

GUPPI_PROC(gsdp, "scalar-data?",
	   1,0,0, (SCM x))
{
  return gh_bool2scm(SCM_SCALAR_DATA_P(x));
}

GUPPI_PROC(gsdget, "scalar-data-get",
	   2,0,0, (SCM ssd, SCM si))
{
  GuppiScalarData* sd;
  gint i;

  SCM_ASSERT(SCM_SCALAR_DATA_P(ssd), ssd, SCM_ARG1, str_gsdget);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_gsdget);

  sd = SCM_TO_SCALAR_DATA(ssd);
  i = gh_scm2int(si);
  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(sd), i), si,
	     SCM_OUTOFRANGE, str_gsdget);

  return gh_double2scm(guppi_scalar_data_get(sd, i));
}

GUPPI_PROC(gsdset, "scalar-data-set!",
	   3,0,0, (SCM ssd, SCM si, SCM sx))
{
  GuppiScalarData* sd;
  gint i;
  double x;

  SCM_ASSERT(SCM_SCALAR_DATA_P(ssd), ssd, SCM_ARG1, str_gsdset);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_gsdset);
  SCM_ASSERT(gh_number_p(sx), sx, SCM_ARG3, str_gsdset);

  sd = SCM_TO_SCALAR_DATA(ssd);
  i = gh_scm2int(si);
  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(sd), i), si,
	     SCM_OUTOFRANGE, str_gsdset);

  x = gh_scm2double(sx);
  guppi_scalar_data_set(sd, i, x);

  return ssd;
}

GUPPI_PROC(gsdadd, "scalar-data-add!",
	   2,0,0, (SCM sd, SCM sx))
{

  SCM_ASSERT(SCM_SCALAR_DATA_P(sd), sd, SCM_ARG1, str_gsdadd);
  SCM_ASSERT(gh_number_p(sx), sx, SCM_ARG2, str_gsdadd);

  guppi_scalar_data_add(SCM_TO_SCALAR_DATA(sd),
			gh_scm2double(sx));

  return sd;
}

GUPPI_PROC(gsdins, "scalar-data-insert!",
	   3,0,0, (SCM ssd, SCM si, SCM sx))
{
  GuppiScalarData* sd;
  gint i;
  double x;

  SCM_ASSERT(SCM_SCALAR_DATA_P(ssd), ssd, SCM_ARG1, str_gsdins);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_gsdins);
  SCM_ASSERT(gh_number_p(sx), sx, SCM_ARG3, str_gsdins);

  sd = SCM_TO_SCALAR_DATA(ssd);
  i = gh_scm2int(si);
  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(sd), i), si,
	     SCM_OUTOFRANGE, str_gsdins);

  x = gh_scm2double(sx);
  guppi_scalar_data_insert(sd, i, x);

  return ssd;
}

GUPPI_PROC(gsddel, "scalar-data-delete!",
	   2,0,0, (SCM ssd, SCM si))
{
  GuppiScalarData* sd;
  gint i;

  SCM_ASSERT(SCM_SCALAR_DATA_P(ssd), ssd, SCM_ARG1, str_gsddel);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_gsddel);

  sd = SCM_TO_SCALAR_DATA(ssd);
  i = gh_scm2int(si);
  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(sd), i), si,
	     SCM_OUTOFRANGE, str_gsddel);

  guppi_scalar_data_delete(sd, i);

  return ssd;
}


/*****************************************************************************/

GUPPI_PROC(gsdmin, "scalar-data-min",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_SCALAR_DATA_P(x), x, SCM_ARG1, str_gsdmin);

  return gh_double2scm(guppi_scalar_data_min(SCM_TO_SCALAR_DATA(x)));
}

GUPPI_PROC(gsdmax, "scalar-data-max",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_SCALAR_DATA_P(x), x, SCM_ARG1, str_gsdmax);

  return gh_double2scm(guppi_scalar_data_max(SCM_TO_SCALAR_DATA(x)));
}

GUPPI_PROC(gsdsum, "scalar-data-sum",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_SCALAR_DATA_P(x), x, SCM_ARG1, str_gsdsum);

  return gh_double2scm(guppi_scalar_data_sum(SCM_TO_SCALAR_DATA(x)));
}

GUPPI_PROC(gsdmean, "scalar-data-mean",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_SCALAR_DATA_P(x), x, SCM_ARG1, str_gsdmean);

  return gh_double2scm(guppi_scalar_data_mean(SCM_TO_SCALAR_DATA(x)));
}

GUPPI_PROC(gsdvar, "scalar-data-var",
	   1,0,0, (SCM x))
{
  double r;

  SCM_ASSERT(SCM_SCALAR_DATA_P(x), x, SCM_ARG1, str_gsdvar);

  r = guppi_scalar_data_var(SCM_TO_SCALAR_DATA(x));

  return gh_double2scm(r);
}

GUPPI_PROC(gsdvars, "scalar-data-vars",
	   1,0,0, (SCM x))
{
  double r;

  SCM_ASSERT(SCM_SCALAR_DATA_P(x), x, SCM_ARG1, str_gsdvars);

  r = guppi_scalar_data_vars(SCM_TO_SCALAR_DATA(x));

  return gh_double2scm(r);
}

GUPPI_PROC(gsdsdev, "scalar-data-sdev",
	   1,0,0, (SCM x))
{
  double r;

  SCM_ASSERT(SCM_SCALAR_DATA_P(x), x, SCM_ARG1, str_gsdsdev);

  r = guppi_scalar_data_sdev(SCM_TO_SCALAR_DATA(x));

  return gh_double2scm(r);
}

GUPPI_PROC(gsdsdevs, "scalar-data-sdevs",
	   1,0,0, (SCM x))
{
  double r;

  SCM_ASSERT(SCM_SCALAR_DATA_P(x), x, SCM_ARG1, str_gsdsdevs);

  r = guppi_scalar_data_sdevs(SCM_TO_SCALAR_DATA(x));

  return gh_double2scm(r);
}



/*****************************************************************************/

void
guppi_scm_scalar_data_init(void)
{
  static gboolean initialized = FALSE;
  g_return_if_fail(!initialized);
  initialized = TRUE;

#include "guppi-scm-scalar-data.x"
}


/* $Id: guppi-scm-scalar-data.c,v 1.1 2000/01/17 05:44:54 trow Exp $ */

