/* $Id: guppi-scm-importer.c,v 1.2 2000/01/17 06:51:03 trow Exp $ */

/*
 * guppi-scm-importer.c
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scm-data.h"
#include "guppi-scm-stream.h"
#include "guppi-scm-importer.h"

static long imp_type_tag;

#define SCM_TO_IMPORTER(x) (GUPPI_IMPORTER(SCM_CDR(x)))
#define SCM_IMPORTER_P(x) (SCM_NIMP(x) && SCM_CAR(x) == imp_type_tag)

gboolean
scm_importer_p(SCM x)
{
  return SCM_IMPORTER_P(x);
}

SCM
importer2scm(GuppiImporter* x)
{
  SCM smob;

  SCM_DEFER_INTS;
  SCM_NEWCELL(smob);
  SCM_SETCAR(smob, imp_type_tag);
  SCM_SETCDR(smob, x);
  gtk_object_ref(GTK_OBJECT(x));
  SCM_ALLOW_INTS;

  return smob;
}

GuppiImporter*
scm2importer(SCM x)
{
  return SCM_IMPORTER_P(x) ? SCM_TO_IMPORTER(x) : NULL;
}

/*****************************************************************************/

GUPPI_PROC(impp, "importer?",
	   1,0,0, (SCM x))
{
  return gh_bool2scm(SCM_IMPORTER_P(x));
}

GUPPI_PROC(imp_gs, "importer-stream",
	   1,0,0, (SCM x))
{
  GuppiStream* gs;

  SCM_ASSERT(SCM_IMPORTER_P(x), x, SCM_ARG1, str_imp_gs);
  
  gs = guppi_importer_stream(SCM_TO_IMPORTER(x));
  return gs ? stream2scm(gs) : SCM_BOOL_F;
}

GUPPI_PROC(imp_setgs, "importer-set-stream!",
	   2,0,0, (SCM x, SCM sgs))
{
  GuppiStream* gs;

  SCM_ASSERT(SCM_IMPORTER_P(x), x, SCM_ARG1, str_imp_setgs);
  SCM_ASSERT(scm_stream_p(sgs), sgs, SCM_ARG2, str_imp_gs);
  
  gs = scm2stream(sgs);
  guppi_importer_set_stream(SCM_TO_IMPORTER(x), gs);

  return x;
}

GUPPI_PROC(imp_intuit, "importer-intuit!",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_IMPORTER_P(x), x, SCM_ARG1, str_imp_intuit);

  guppi_importer_intuit(SCM_TO_IMPORTER(x));

  return x;
}

GUPPI_PROC(imp_imp, "importer-import!",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_IMPORTER_P(x), x, SCM_ARG1, str_imp_imp);

  guppi_importer_import(SCM_TO_IMPORTER(x));

  return x;
}

GUPPI_PROC(imp_data, "importer-data",
	   1,0,0, (SCM x))
{
  GuppiData** gv;
  gint i;
  SCM output = SCM_EOL;

  SCM_ASSERT(SCM_IMPORTER_P(x), x, SCM_ARG1, str_imp_data);

  gv = guppi_importer_data(SCM_TO_IMPORTER(x));

  if (gv == NULL)
    return SCM_EOL;

  i=0;
  while (gv[i] != NULL) ++i;
  while (i>0) {
    --i;
    output = gh_cons(data2scm(gv[i]), output);
    gtk_object_unref(GTK_OBJECT(gv[i]));
  }

  g_free(gv);
  
  return output;
}

/*****************************************************************************/

static SCM
mark_data(SCM x)
{
  return SCM_BOOL_F;
}

static scm_sizet
free_data(SCM x)
{
  GuppiImporter* d = SCM_TO_IMPORTER(x);

  SCM_DEFER_INTS;
  gtk_object_unref(GTK_OBJECT(d));
  SCM_ALLOW_INTS;

  return 0;
}

static int
print_data(SCM x, SCM port, scm_print_state* state)
{
  scm_puts("<Importer>", port);

  return 1;
}

/*****************************************************************************/

void
guppi_scm_importer_init(void)
{
  static gboolean initialized = FALSE;
  static struct scm_smobfuns imp_fns = {
    mark_data, free_data, print_data, NULL
  };

  g_return_if_fail(!initialized);
  initialized = TRUE;

  imp_type_tag = scm_newsmob(&imp_fns);

#include "guppi-scm-importer.x"
  
}

/* $Id: guppi-scm-importer.c,v 1.2 2000/01/17 06:51:03 trow Exp $ */
