/* $Id: guppi-scm-boolean-data.c,v 1.1 2000/01/17 05:44:54 trow Exp $ */

/*
 * guppi-scm-boolean-data.c
 *
 * Copyright (C) 1999, 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scm-data.h"
#include "guppi-scm-boolean-data.h"

#define SCM_TO_BOOLEAN_DATA(x) (GUPPI_BOOLEAN_DATA(SCM_CDR(x)))
#define SCM_BOOLEAN_DATA_P(x) \
     (SCM_NIMP(x) && scm_data_p(x) && GUPPI_IS_BOOLEAN_DATA(SCM_CDR(x)))

gboolean
scm_boolean_data_p(SCM x)
{
  return SCM_BOOLEAN_DATA_P(x);
}

GuppiBooleanData*
scm2boolean_data(SCM x)
{
  return SCM_BOOLEAN_DATA_P(x) ? SCM_TO_BOOLEAN_DATA(x) : NULL;
}

/*****************************************************************************/

GUPPI_PROC(bd_new, "make-boolean-data",
	   0,0,0, ())
{
  return data2scm(GUPPI_DATA(guppi_boolean_data_new()));
}

GUPPI_PROC(bd_p, "boolean-data?",
	   1,0,0, (SCM x))
{
  return gh_bool2scm(SCM_BOOLEAN_DATA_P(x));
}

GUPPI_PROC(bd_clr, "boolean-data-clear!",
	   1,0,0, (SCM x))
{
  SCM_ASSERT(SCM_BOOLEAN_DATA_P(x), x, SCM_ARG1, str_bd_clr);

  guppi_boolean_data_clear(SCM_TO_BOOLEAN_DATA(x));

  return x;
}

GUPPI_PROC(bd_get, "boolean-data-get",
	   2,0,0, (SCM sbd, SCM si))
{
  GuppiBooleanData* bd;
  gint i;

  SCM_ASSERT(SCM_BOOLEAN_DATA_P(sbd), sbd, SCM_ARG1, str_bd_get);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_bd_get);

  bd = SCM_TO_BOOLEAN_DATA(sbd);
  i = gh_scm2int(si);

  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(bd), i), si,
	     SCM_OUTOFRANGE, str_bd_get);

  return gh_bool2scm(guppi_boolean_data_get(bd, i));
}

GUPPI_PROC(bd_set, "boolean-data-set!",
	   3,0,0, (SCM sbd, SCM si, SCM stf))
{
  GuppiBooleanData* bd;
  gint i;

  SCM_ASSERT(SCM_BOOLEAN_DATA_P(sbd), sbd, SCM_ARG1, str_bd_set);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_bd_set);
  SCM_ASSERT(gh_boolean_p(stf), stf, SCM_ARG3, str_bd_set);

  bd = SCM_TO_BOOLEAN_DATA(sbd);
  i = gh_scm2int(si);

  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(bd), i), si,
	     SCM_OUTOFRANGE, str_bd_set);

  guppi_boolean_data_set(bd, i, gh_scm2bool(stf));

  return sbd;
}

GUPPI_PROC(bd_add, "boolean-data-add!",
	   2,0,0, (SCM sbd, SCM stf))
{
  SCM_ASSERT(SCM_BOOLEAN_DATA_P(sbd), sbd, SCM_ARG1, str_bd_add);
  SCM_ASSERT(gh_boolean_p(stf), stf, SCM_ARG2, str_bd_add);

  guppi_boolean_data_add(SCM_TO_BOOLEAN_DATA(sbd), gh_scm2bool(stf));

  return sbd;
}

GUPPI_PROC(bd_ins, "boolean-data-insert!",
	   3,0,0, (SCM sbd, SCM si, SCM stf))
{
  GuppiBooleanData* bd;
  gint i;

  SCM_ASSERT(SCM_BOOLEAN_DATA_P(sbd), sbd, SCM_ARG1, str_bd_ins);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_bd_ins);
  SCM_ASSERT(gh_boolean_p(stf), stf, SCM_ARG3, str_bd_ins);

  bd = SCM_TO_BOOLEAN_DATA(sbd);
  i = gh_scm2int(si);

  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(bd), i), si,
	     SCM_OUTOFRANGE, str_bd_ins);

  guppi_boolean_data_insert(bd, i, gh_scm2bool(stf));

  return sbd;
}

GUPPI_PROC(bd_del, "boolean-data-delete!",
	   2,0,0, (SCM sbd, SCM si))
{
  GuppiBooleanData* bd;
  gint i;

  SCM_ASSERT(SCM_BOOLEAN_DATA_P(sbd), sbd, SCM_ARG1, str_bd_del);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_bd_del);

  bd = SCM_TO_BOOLEAN_DATA(sbd);
  i = gh_scm2int(si);

  SCM_ASSERT(guppi_data_in_bounds(GUPPI_DATA(bd), i), si,
	     SCM_OUTOFRANGE, str_bd_del);

  guppi_boolean_data_delete(bd, i);

  return sbd;
}

GUPPI_PROC(bd_1t, "boolean-data-first-true",
	   1,0,0, (SCM sbd))
{
  GuppiBooleanData* bd;
  dindex_t i;

  SCM_ASSERT(SCM_BOOLEAN_DATA_P(sbd), sbd, SCM_ARG1, str_bd_1t);

  bd = SCM_TO_BOOLEAN_DATA(sbd);
  i = guppi_boolean_data_first_true(bd);
  return guppi_data_in_bounds(GUPPI_DATA(bd), i) ? gh_int2scm(i) : SCM_BOOL_F;
}

GUPPI_PROC(bd_nt, "boolean-data-next-true",
	   2,0,0, (SCM sbd, SCM si))
{
  GuppiBooleanData* bd;
  dindex_t i;

  SCM_ASSERT(SCM_BOOLEAN_DATA_P(sbd), sbd, SCM_ARG1, str_bd_nt);
  SCM_ASSERT(gh_exact_p(si), si, SCM_ARG2, str_bd_nt);

  bd = SCM_TO_BOOLEAN_DATA(sbd);
  i = guppi_boolean_data_next_true(bd, gh_scm2int(si));
  return guppi_data_in_bounds(GUPPI_DATA(bd), i) ? gh_int2scm(i) : SCM_BOOL_F;
}

GUPPI_PROC(bd_tcnt, "boolean-data-true-count",
	   1,0,0, (SCM sbd))
{
  GuppiBooleanData* bd;

  SCM_ASSERT(SCM_BOOLEAN_DATA_P(sbd), sbd, SCM_ARG1, str_bd_tcnt);

  bd = SCM_TO_BOOLEAN_DATA(sbd);
  return gh_int2scm(guppi_boolean_data_true_count(bd));
}

/*****************************************************************************/

void
guppi_scm_boolean_data_init(void)
{
  static gboolean initialized = FALSE;
  g_return_if_fail(!initialized);
  initialized = TRUE;

#include "guppi-scm-boolean-data.x"
}



/* $Id: guppi-scm-boolean-data.c,v 1.1 2000/01/17 05:44:54 trow Exp $ */
