/* This is -*- C -*- */
/* $Id: guppi-scalar-data.h,v 1.1.1.1 1999/12/03 07:02:39 trow Exp $ */

/*
 * guppi-scalar-data.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SCALAR_DATA_H
#define _INC_GUPPI_SCALAR_DATA_H

#include <config.h>
#include <gnome.h>
#include "guppi-data.h"
#include "guppi-boolean-data.h"

typedef struct _GuppiScalarData GuppiScalarData;
typedef struct _GuppiScalarDataClass GuppiScalarDataClass;

typedef struct _GuppiScalarIndexPair GuppiScalarIndexPair;
struct _GuppiScalarIndexPair {
  double scalar;
  dindex_t index;
};

struct _GuppiScalarData {
  GuppiData base;

  double* data;
  gsize size, poolsize;

  double min, max, sum;
  
  GuppiScalarIndexPair** sip;
};

struct _GuppiScalarDataClass {
  GuppiDataClass parent_class;
};

#define GUPPI_TYPE_SCALAR_DATA (guppi_scalar_data_get_type())
#define GUPPI_SCALAR_DATA(obj) (GTK_CHECK_CAST((obj), \
                                GUPPI_TYPE_SCALAR_DATA,GuppiScalarData))
#define GUPPI_SCALAR_DATA_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), \
                                 GUPPI_TYPE_SCALAR_DATA, GuppiScalarDataClass))
#define GUPPI_IS_SCALAR_DATA(obj) (GTK_CHECK_TYPE((obj), \
				   GUPPI_TYPE_SCALAR_DATA))
#define GUPPI_IS_SCALAR_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), \
                                          GUPPI_TYPE_SCALAR_DATA))

GtkType guppi_scalar_data_get_type(void);

GuppiData* guppi_scalar_data_new(void);

double guppi_scalar_data_get(const GuppiScalarData*, dindex_t);
void guppi_scalar_data_set(GuppiScalarData*, dindex_t, double);
void guppi_scalar_data_add(GuppiScalarData*, double);
void guppi_scalar_data_add_many(GuppiScalarData*, double*, gsize);
void guppi_scalar_data_insert(GuppiScalarData*, dindex_t,  double);
void guppi_scalar_data_delete(GuppiScalarData*, dindex_t);

const double* guppi_scalar_data_raw_access(const GuppiScalarData*);

double guppi_scalar_data_min(const GuppiScalarData*);
double guppi_scalar_data_max(const GuppiScalarData*);
double guppi_scalar_data_sum(const GuppiScalarData*);
double guppi_scalar_data_mean(const GuppiScalarData*);
double guppi_scalar_data_var(const GuppiScalarData*);
double guppi_scalar_data_vars(const GuppiScalarData*);
double guppi_scalar_data_sdev(const GuppiScalarData*);
double guppi_scalar_data_sdevs(const GuppiScalarData*);

gint guppi_scalar_data_range_query(const GuppiScalarData*,
				   double x0, double x1,
				   GuppiBooleanData*);

#define guppi_scalar_data_get_unsafe(sd, i) \
(((GuppiScalarData*)(sd))->data[(i)-((GuppiScalarData*)(sd))->base.min_index])


#endif /* _INC_GUPPI_SCALAR_DATA_H */

/* $Id: guppi-scalar-data.h,v 1.1.1.1 1999/12/03 07:02:39 trow Exp $ */
