/* This is -*- C -*- */
/* $Id: guppi-importer.c,v 1.4 2000/01/25 15:50:59 trow Exp $ */

/*
 * guppi-importer.c
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-dataset.h"
#include "guppi-importer.h"

static GtkObjectClass* parent_class = NULL;

enum {
  CHANGED,
  LAST_SIGNAL
};
static guint imp_signals[LAST_SIGNAL] = { 0 };

enum {
  ARG_0
};

static void
guppi_importer_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_importer_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_importer_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_importer_finalize(GtkObject* obj)
{
  GuppiImporter* gs = GUPPI_IMPORTER(obj);
  if (gs->stream) {
    gtk_object_unref(GTK_OBJECT(gs->stream));
  }

  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_importer_class_init(GuppiImporterClass* klass)
{
  static GuppiDataset* guppi_importer_default_import_dataset(GuppiImporter*);

  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  imp_signals[CHANGED] =
    gtk_signal_new("changed",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiImporterClass, changed),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 0);

  gtk_object_class_add_signals(object_class, imp_signals, LAST_SIGNAL);

  object_class->get_arg = guppi_importer_get_arg;
  object_class->set_arg = guppi_importer_set_arg;
  object_class->destroy = guppi_importer_destroy;
  object_class->finalize = guppi_importer_finalize;

  klass->changed = NULL;

  klass->import_initialize = NULL;
  klass->line_skip = NULL;
  klass->preprocess_line = NULL;
  klass->process_line = NULL;
  klass->postprocess = NULL;
  klass->import_dataset = guppi_importer_default_import_dataset;
  klass->import_finalize = NULL;

}

static void
guppi_importer_init(GuppiImporter* obj)
{
  obj->stream = NULL;
}

GtkType
guppi_importer_get_type(void)
{
  static GtkType guppi_importer_type = 0;
  if (!guppi_importer_type) {
    static const GtkTypeInfo guppi_importer_info = {
      "GuppiImporter",
      sizeof(GuppiImporter),
      sizeof(GuppiImporterClass),
      (GtkClassInitFunc)guppi_importer_class_init,
      (GtkObjectInitFunc)guppi_importer_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_importer_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_importer_info);
  }
  return guppi_importer_type;
}

GtkObject*
guppi_importer_new(void)
{
  return GTK_OBJECT(gtk_type_new(guppi_importer_get_type()));
}

void
guppi_importer_set_stream(GuppiImporter* gi, GuppiStream* gs)
{
  g_return_if_fail(gi != NULL);
  g_return_if_fail(gs != NULL);

  if (gi->stream)
    gtk_object_unref(GTK_OBJECT(gi->stream));

  gi->stream = gs;
  gtk_object_ref(GTK_OBJECT(gs));
}

GuppiStream*
guppi_importer_stream(GuppiImporter* gi)
{
  g_return_val_if_fail(gi != NULL, NULL);

  return gi->stream;
}

void
guppi_importer_intuit(GuppiImporter* gi)
{
  GuppiImporterClass* klass;
  g_return_if_fail(gi != NULL);
  g_return_if_fail(gi->stream != NULL);

  klass = GUPPI_IMPORTER_CLASS(GTK_OBJECT(gi)->klass);
  g_return_if_fail(klass != NULL);

  if (klass->intuit != NULL)
    (klass->intuit)(gi);
}

void
guppi_importer_import(GuppiImporter* gi)
{
  GuppiImporterClass* klass;
  GuppiDataset* dset;
  GuppiData** data;
  gint i;
  const gchar* line;
  gchar* line2;
  const gchar* used_line;

  g_return_if_fail(gi != NULL);
  g_return_if_fail(gi->stream != NULL);

  klass = GUPPI_IMPORTER_CLASS(GTK_OBJECT(gi)->klass);
  g_return_if_fail(klass != NULL);

  /* We can't do anything without these two functions. */
  g_return_if_fail(klass->process_line != NULL);
  g_return_if_fail(klass->get_data != NULL);

  if (klass->import_initialize)
    (klass->import_initialize)(gi);

  guppi_stream_set_sequential_mode(gi->stream);

  i = 0;
  while ( (line = guppi_stream_get_sanitized_line(gi->stream,i)) ) {

    if (klass->preprocess_line)
      used_line = line2 = (klass->preprocess_line)(gi, line, i+1);
    else {
      used_line = line;
      line2 = NULL;
    }

    if (used_line) {

      if (klass->line_skip == NULL || !(klass->line_skip)(gi, used_line, i+1))
	(klass->process_line)(gi, used_line, i+1);

      if (line2)
	g_free(line2);
    }
    
    ++i;
  }

  data = (klass->get_data)(gi);
  
  /* Build a dataset object and attach it to our generated data */
  if (klass->import_dataset) {
    dset = (klass->import_dataset)(gi);
    if (dset) 
      for(i=0; data[i] != NULL; ++i)
	guppi_data_set_dataset(data[i], dset);
  }
}

GuppiData**
guppi_importer_data(GuppiImporter* gi)
{
  GuppiImporterClass* klass;
  GuppiData** data;

  g_return_val_if_fail(gi != NULL, NULL);

  klass = GUPPI_IMPORTER_CLASS(GTK_OBJECT(gi)->klass);
  g_return_val_if_fail(klass != NULL, NULL);
  g_return_val_if_fail(klass->get_data != NULL, NULL);

  data = (klass->get_data)(gi);

  if (klass->postprocess) 
    data = (klass->postprocess)(gi, data);

  if (klass->import_finalize)
    (klass->import_finalize)(gi);

  return data;
}

static GuppiDataset*
guppi_importer_default_import_dataset(GuppiImporter* gi)
{
  static gint import_count = 1;
  GuppiDataset* dataset;

  gchar buffer[128];
  const gint buffer_len = 128;

  g_return_val_if_fail(gi != NULL, NULL);

  dataset = guppi_dataset_new();
  
  g_snprintf(buffer, buffer_len, _("Import #%d"), import_count);
  ++import_count;
  
  guppi_dataset_set_name(dataset, buffer);
  if (gi->stream) 
    guppi_dataset_set_source(dataset,
			     g_basename(guppi_stream_source(gi->stream)));

  return dataset;
}

/* $Id: guppi-importer.c,v 1.4 2000/01/25 15:50:59 trow Exp $ */
