/* This is -*- C -*- */
/* $Id: guppi-dataset.h,v 1.1.1.1 1999/12/03 07:02:42 trow Exp $ */

/*
 * guppi-dataset.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATASET_H
#define _INC_GUPPI_DATASET_H

#include <config.h>
#include <gnome.h>

typedef struct _GuppiDataset GuppiDataset;
typedef struct _GuppiDatasetClass GuppiDatasetClass;

struct _GuppiDataset {
  GtkObject parent;

  gchar* name;
  gchar* source;
  gchar* reference;
  gchar* contact;
  gchar* URL;
  gchar* notes;
};

struct _GuppiDatasetClass {
  GtkObjectClass parent_class;

  void (*changed)(GuppiDataset*);
};

#define GUPPI_TYPE_DATASET (guppi_dataset_get_type())
#define GUPPI_DATASET(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATASET,GuppiDataset))
#define GUPPI_DATASET_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATASET,GuppiDatasetClass))
#define GUPPI_IS_DATASET(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATASET))
#define GUPPI_IS_DATASET_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATASET))

GtkType guppi_dataset_get_type(void);

GuppiDataset* guppi_dataset_new(void);

const gchar* guppi_dataset_name(const GuppiDataset*);
const gchar* guppi_dataset_source(const GuppiDataset*);
const gchar* guppi_dataset_reference(const GuppiDataset*);
const gchar* guppi_dataset_contact(const GuppiDataset*);
const gchar* guppi_dataset_URL(const GuppiDataset*);
const gchar* guppi_dataset_notes(const GuppiDataset*);

void guppi_dataset_set_name(GuppiDataset*, const gchar*);
void guppi_dataset_set_source(GuppiDataset*, const gchar*);
void guppi_dataset_set_reference(GuppiDataset*, const gchar*);
void guppi_dataset_set_contact(GuppiDataset*, const gchar*);
void guppi_dataset_set_URL(GuppiDataset*, const gchar*);
void guppi_dataset_set_notes(GuppiDataset*, const gchar*);

#endif /* _INC_GUPPI_DATASET_H */

/* $Id: guppi-dataset.h,v 1.1.1.1 1999/12/03 07:02:42 trow Exp $ */
