/* This is -*- C -*- */
/* $Id: guppi-data.h,v 1.2 2000/01/05 02:07:25 trow Exp $ */

/*
 * guppi-data.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATA_H
#define _INC_GUPPI_DATA_H

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include "guppi-dataset.h"

typedef gint dindex_t;

typedef struct _GuppiData GuppiData;
typedef struct _GuppiDataClass GuppiDataClass;

struct _GuppiData {
  GtkObject object;
  
  dindex_t min_index, max_index;
  gchar* label;
  GuppiDataset* dataset;
};

struct _GuppiDataClass {
  GtkObjectClass parent_class;

  const gchar* type_name;

  /* virtual functions */
  gboolean (*validate)(const GuppiData*, const gchar*, gchar*, gsize);
  void (*get)(const GuppiData*, dindex_t i, gchar* sbuf, gsize len);
  void (*set)(GuppiData*, dindex_t i, const gchar* sbuf);
  void (*add)(GuppiData*, const gchar*);
  void (*insert)(GuppiData*, dindex_t i, const gchar*);
  void (*del)(GuppiData*, dindex_t i);
  GuppiData* (*copy)(const GuppiData*);

  /* signal handlers */
  void (*changed_one)(GuppiData*, dindex_t index, gpointer old_value);
  void (*changed_add)(GuppiData*, dindex_t new_index, gpointer new_value);
  void (*changed_many)(GuppiData*);
  void (*changed)(GuppiData*);
  void (*changed_label)(GuppiData*);
  void (*changed_dataset)(GuppiData*);
  void (*changed_dataset_content)(GuppiData*);
};

#define GUPPI_TYPE_DATA (guppi_data_get_type())
#define GUPPI_DATA(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATA,GuppiData))
#define GUPPI_DATA_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), \
                                 GUPPI_TYPE_DATA, GuppiDataClass))
#define GUPPI_IS_DATA(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATA))
#define GUPPI_IS_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), \
                                    GUPPI_TYPE_DATA))

GtkType guppi_data_get_type(void);

/* GuppiData is a "pure virtual type", so we don't define a
   guppi_data_new() function. */

dindex_t guppi_data_min_index(const GuppiData*);
dindex_t guppi_data_max_index(const GuppiData*);
gsize guppi_data_size(const GuppiData*);
gboolean guppi_data_in_bounds(const GuppiData*, dindex_t);
gboolean guppi_data_contains_bounds(const GuppiData*, const GuppiData*);
gboolean guppi_data_equal_bounds(const GuppiData*, const GuppiData*);

void guppi_data_shift_indices(GuppiData*, gint);

const gchar* guppi_data_label(const GuppiData*);
void guppi_data_set_label(GuppiData*, const gchar*);

GuppiDataset* guppi_data_dataset(const GuppiData*);
void guppi_data_set_dataset(GuppiData*, GuppiDataset*);

/* Convenience routine */
const gchar* guppi_data_dataset_name(const GuppiData*);

const gchar* guppi_data_type_name(const GuppiData*);
const gchar* guppi_data_type_name_by_type(GtkType);

gboolean guppi_data_validate(const GuppiData*, const gchar*,
			     gchar* errstring, gsize errstring_len);
gboolean guppi_data_validate_by_type(GtkType, const gchar*,
				     gchar* errstring, gsize errstring_len);

void guppi_data_get(const GuppiData*, dindex_t i,
			  gchar* sbuf, gsize max_sbuf_length);
void guppi_data_set(GuppiData*, dindex_t i, const gchar* sbuf);
void guppi_data_add(GuppiData*, const gchar* sbuf);
void guppi_data_insert(GuppiData*, dindex_t, const gchar*);
void guppi_data_delete(GuppiData*, dindex_t);
GuppiData* guppi_data_copy(const GuppiData*);

void guppi_data_dump(const GuppiData*, FILE*);

double guppi_data_conversion_potential(const GuppiData*, GtkType);
GuppiData* guppi_data_convert(const GuppiData* original,
			      GtkType convert_to,
			      const gchar* replace_invalid);

void guppi_data_touch_one(GuppiData*, dindex_t, gpointer);
void guppi_data_touch_add(GuppiData*, dindex_t, gpointer);
void guppi_data_touch(GuppiData*);

void guppi_data_add_from_stream(GuppiData*, FILE* input_stream);
void guppi_data_add_from_file(GuppiData*, const gchar* filename);



#endif /* _INC_GUPPI_DATA_H */

/* $Id: guppi-data.h,v 1.2 2000/01/05 02:07:25 trow Exp $ */
