/* $Id: guppi-data-init.c,v 1.3 2000/01/19 15:45:09 trow Exp $ */

/*
 * guppi-data-init.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scm-dataset.h"
#include "guppi-scm-data.h"
#include "guppi-scm-scalar-data.h"
#include "guppi-scm-boolean-data.h"
#include "guppi-scm-categorical-data.h"
#include "guppi-scm-string-data.h"
#include "guppi-scm-data-catalog.h"
#include "guppi-scm-importer.h"
#include "guppi-scm-delimited-importer.h"
#include "guppi-data-init.h"

void
guppi_data_init(void)
{
  /* Make sure all of our data types "exist". */
  guppi_data_get_type();
  guppi_scalar_data_get_type();
  guppi_boolean_data_get_type();
  guppi_categorical_data_get_type();
  guppi_string_data_get_type();

  /* Initialize our scheme bindings. */
  guppi_scm_dataset_init();
  guppi_scm_data_init();
  guppi_scm_scalar_data_init();
  guppi_scm_boolean_data_init();
  guppi_scm_categorical_data_init();
  guppi_scm_string_data_init();

  guppi_scm_data_catalog_init();
  guppi_scm_importer_init();
  guppi_scm_delimited_importer_init();
}


/* $Id: guppi-data-init.c,v 1.3 2000/01/19 15:45:09 trow Exp $ */
