/* This is -*- C -*- */
/* $Id: guppi-data-catalog.h,v 1.1.1.1 1999/12/03 07:02:40 trow Exp $ */

/*
 * guppi-data-catalog.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATA_CATALOG_H
#define _INC_GUPPI_DATA_CATALOG_H

#include <config.h>
#include <gnome.h>
#include "guppi-data.h"

typedef struct _GuppiDataCatalog GuppiDataCatalog;
typedef struct _GuppiDataCatalogClass GuppiDataCatalogClass;

struct _GuppiDataCatalog {
  GtkObject parent;

  GList* data;
};

struct _GuppiDataCatalogClass {
  GtkObjectClass parent_class;

  void (*changed)(void);
  void (*added)(GuppiData*);
  void (*removed)(GuppiData*);
  void (*data_changed)(GuppiData*);
};

#define GUPPI_TYPE_DATA_CATALOG (guppi_data_catalog_get_type())
#define GUPPI_DATA_CATALOG(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATA_CATALOG,GuppiDataCatalog))
#define GUPPI_DATA_CATALOG_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATA_CATALOG,GuppiDataCatalogClass))
#define GUPPI_IS_DATA_CATALOG(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATA_CATALOG))
#define GUPPI_IS_DATA_CATALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATA_CATALOG))

GtkType guppi_data_catalog_get_type(void);

GtkObject* guppi_data_catalog_new(void);

GuppiDataCatalog* guppi_data_catalog(void);

void guppi_data_catalog_add(GuppiDataCatalog*, GuppiData*);
void guppi_data_catalog_remove(GuppiDataCatalog*, GuppiData*);

gint guppi_data_catalog_size(const GuppiDataCatalog*);
GuppiData* guppi_data_catalog_get(GuppiDataCatalog*, gint);
GuppiData** guppi_data_catalog_get_all(GuppiDataCatalog*);
GuppiData** guppi_data_catalog_get_by_type(GuppiDataCatalog*, GtkType);


#endif /* _INC_GUPPI_DATA_CATALOG_H */

/* $Id: guppi-data-catalog.h,v 1.1.1.1 1999/12/03 07:02:40 trow Exp $ */
