/* This is -*- C -*- */
/* $Id: guppi-data-catalog-browser.h,v 1.1.1.1 1999/12/03 07:02:42 trow Exp $ */

/*
 * guppi-data-catalog-browser.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATA_CATALOG_BROWSER_H
#define _INC_GUPPI_DATA_CATALOG_BROWSER_H

#include <config.h>
#include <gnome.h>
#include "guppi-data-catalog.h"

typedef struct _GuppiDataCatalogBrowser GuppiDataCatalogBrowser;
typedef struct _GuppiDataCatalogBrowserClass GuppiDataCatalogBrowserClass;

struct _GuppiDataCatalogBrowser {
  GtkCList parent;

  GuppiDataCatalog* catalog;
};

struct _GuppiDataCatalogBrowserClass {
  GtkCListClass parent_class;
};

#define GUPPI_TYPE_DATA_CATALOG_BROWSER (guppi_data_catalog_browser_get_type())
#define GUPPI_DATA_CATALOG_BROWSER(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATA_CATALOG_BROWSER,GuppiDataCatalogBrowser))
#define GUPPI_DATA_CATALOG_BROWSER_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATA_CATALOG_BROWSER,GuppiDataCatalogBrowserClass))
#define GUPPI_IS_DATA_CATALOG_BROWSER(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATA_CATALOG_BROWSER))
#define GUPPI_IS_DATA_CATALOG_BROWSER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATA_CATALOG_BROWSER))

GtkType guppi_data_catalog_browser_get_type(void);

GtkWidget* guppi_data_catalog_browser_new(GuppiDataCatalog*);

GuppiDataCatalog*
guppi_data_catalog_browser_get_catalog(GuppiDataCatalogBrowser*);

GuppiData** guppi_data_catalog_browser_get_selection(GuppiDataCatalogBrowser*);



#endif /* _INC_GUPPI_DATA_CATALOG_BROWSER_H */

/* $Id: guppi-data-catalog-browser.h,v 1.1.1.1 1999/12/03 07:02:42 trow Exp $ */
