#include "SubFormClass.h"
#include <iostream.h>
#include <stdlib.h>

SubFormClass::SubFormClass() : FormApp() {
	fd_SubForm = create_form_SubForm();
	// It is very important here to save the this pointer
	// into the FL_FORM struct because we will need this
	// pointer in the callback the this pointer is saved
	// in the FormSetup method of the base class
	FormSetup();

	// We set some other things in the class
	for(int i=0; i<256 ; i++) {
		x[i] = i/256.0;
		y[i] = 50*x[i]*x[i] - x[i]*4 +3;
	}
	fl_set_xyplot_data(fd_SubForm->plot, x, y, 256, "A function", "x", "y");
}

SubFormClass::~SubFormClass() {
	// hide the form
	fl_hide_form(fd_SubForm->SubForm);
	// Free the form and the memory for the fd_SubForm struct
	fl_free_form(fd_SubForm->SubForm);
	fl_free(fd_SubForm);
}

SubFormClass *
SubFormClass::GetThis(FL_OBJECT *obj) {
	return (SubFormClass*) obj->form->u_vdata;
}

// This is a good strategy for retrieving which object triggered
// a callback. Take a close look at the argument entered in the
// fdesign program
// With this strategy, you can have just one static callback
// and a switch to your methods
void
SubFormClass::_Callback(FL_OBJECT *obj, long button) {
	SubFormClass *me = GetThis(obj);
	switch(button) {
	case Dismiss:
		me->DismissCallback();
		break;
	}
}

void
SubFormClass::DismissCallback() {
	Hide();
}


// This is the overloaded virtual method declared in FormApp
FL_FORM *
SubFormClass::Form() {
	return fd_SubForm->SubForm;
}


// we return FL_IGNORE because we don't want the application
// to quit when this window disappear
int
SubFormClass::AtClose() {
	Hide();
	return FL_IGNORE;
}

