#ifndef _MY_FORM_CLASS_HEADER_
#define _MY_FORM_CLASS_HEADER_

// The base class header
// this base class encapsulate the forms library
#include "FormApp.h"

// The header generated by fdesign
// which contains the FD_MyForm definition
#include "MyForm.h"

#include "SubFormClass.h"

// We inherit from the base class
class MyFormClass : public FormApp {
	FD_MyForm *fd_MyForm;
	SubFormClass subForm;
	int n;
	static MyFormClass *GetThis(FL_OBJECT *);
public:
	// This is the enum for the objects in the
	// form
	enum { ButtonOne, ButtonTwo, ButtonThree, Browser };

	MyFormClass();
	~MyFormClass();

	// These are the static methods that we register in the
	// objects
	static void _MyFormCallback(FL_OBJECT *, long);
	static void _AnyButtonCallback(FL_OBJECT *, long);

	// From the static methods, we can call these regular methods
	void MyFormCallback();
	void Button1Callback();
	void Button2Callback();
	void Button3Callback();
	void BrowserCallback();

	// This method must be overloaded because it was defined
	// pure virtual in the base class
	FL_FORM *Form();
};

#endif // _MY_FORM_CLASS_HEADER_
