#include "MyFormClass.h"
#include <iostream.h>
#include <stdlib.h>

MyFormClass::MyFormClass() : FormApp() {
	fd_MyForm = create_form_MyForm();
	// It is very important here to save the this pointer
	// into the FL_FORM struct because we will need this
	// pointer in the callback the this pointer is saved
	// in the FormSetup method of the base class
	FormSetup();
	n = 0;
}

MyFormClass::~MyFormClass() {
	// hide the form
	fl_hide_form(fd_MyForm->MyForm);
	// Free the form and the memory for the fd_MyForm struct
	fl_free_form(fd_MyForm->MyForm);
	fl_free(fd_MyForm);
}

MyFormClass *
MyFormClass::GetThis(FL_OBJECT *obj) {
	return (MyFormClass*) obj->form->u_vdata; 
}

void
MyFormClass::_MyFormCallback(FL_OBJECT *obj, long arg) {
	cerr << "MyFormClass::_MyFormCallback called\n";
	// getting a "this" pointer
	MyFormClass *me = GetThis(obj); 
	me->MyFormCallback();
}

void MyFormClass::MyFormCallback() {
	cerr << "Member function MyFormCallback\n";
}

// This is a good strategy for retrieving which object triggered
// a callback. Take a close look at the argument entered in the
// fdesign program
// With this strategy, you can have just one static callback
// and a switch to your methods
void
MyFormClass::_AnyButtonCallback(FL_OBJECT *obj, long button) {
	MyFormClass *me = GetThis(obj);
	switch(button) {
	case ButtonOne:
		me->Button1Callback();
		break;
	case ButtonTwo:
		me->Button2Callback();
		break;
	case ButtonThree:
		me->Button3Callback();
		break;
  case Browser:
    me->BrowserCallback();
    break;
	}
}

void
MyFormClass::Button1Callback() {
	cerr << "Member function Button1Callback\n";
	cerr << "Button was pressed " << ++n << " times\n";
}

void
MyFormClass::Button2Callback() {
	cerr << "Button 2 was pressed and button 1 was pressed " << n << " times\n";
	char buf[256];
	sprintf(buf, "Button #1 was pressed %d times", n);
	fl_add_browser_line(fd_MyForm->browser, buf);
}

void
MyFormClass::Button3Callback() {
	subForm.Show("A subwindow\n");
	cerr << "Button 3 was pressed and button 1 was pressed " << n << " times\n";
}


void
MyFormClass::BrowserCallback() {
	cerr << "Browser callback\n";
}


// This is the overloaded virtual method declared in FormApp
FL_FORM *
MyFormClass::Form() {
	return fd_MyForm->MyForm;
}

