#ifndef _FORM_APP_HEADER_
#define _FORM_APP_HEADER_

#include "forms.h"

class FormApp {
	static Display *_display;
	static int _nForms;

	static _AtClose(FL_FORM *ptr, void *);
	static FormApp *GetThis(FL_FORM *);
protected:
	void FormSetup();

public:
	// Static methods
	static int Initialize(int *argc, char **argv, const char *cl=0, FL_CMD_OPT *cmd=0, int i=0);
	static FL_OBJECT *Run();

	// Constructor
	FormApp();

	// Destructor
	virtual ~FormApp();

	// Some access methods
	Display *GetDisplay();

	// virtual methods
	virtual long Show(const char *title);
	virtual void Hide();
	virtual int AtClose();

	// This one is pure virtual and must be overloaded
	virtual FL_FORM *Form()=0; 
};

#endif // _FORM_APP_HEADER_
