#include "FormApp.h"
#include <iostream.h>
#include <stdlib.h>

// Static members initialization
Display *FormApp::_display = 0;
int FormApp::_nForms = 0;

// Initialize the forms library
// returns 0 if successfull 1 otherwise
int
FormApp::Initialize(int *argc, char **argv, const char *cl, FL_CMD_OPT *cmd, int i) {
	if (_display) return 0;
	_display = fl_initialize(argc, argv, cl, cmd, i);
	fl_set_atclose(_AtClose, 0);
	return _display==0;
}

// This method must be called to handle events
FL_OBJECT *
FormApp::Run() {
	return fl_do_forms();
}

FormApp *
FormApp::GetThis(FL_FORM *form) {
	return (FormApp*) form->u_vdata;
}

int
FormApp::_AtClose(FL_FORM *form, void *) {
	// here we call a virtual method on the object
	// This vitual method could trigger some data saving
	// and return FL_IGNORE
	FormApp *me = GetThis(form);;
	return me->AtClose();
}

// Here is the default AtClose function
int
FormApp::AtClose() {
	return FL_OK;
}

FormApp::FormApp() {
	// If we forgot to call 
	// Initialize from the main
	if (!_display) {
		int argc=1;
		char *argv[] = {"Formapp", 0};
		Initialize(&argc, argv);
	}

	_nForms++;

	// if _display is still nil
	if (!_display) {
		// It is going to crash !!!
		cerr << "Can't open display\n";
		exit(0);
	}
}

FormApp::~FormApp() {
	_nForms--;
	if (!_nForms) {
		// The last form was destroyed
		// close the X connection
		fl_finish();
		_display = 0;
	}
}

// Here we define a default virtual Show method, this method
// can be overloaded in a specific implementation of a form
// and call fl_show_form with different args.
long
FormApp::Show(const char *title) {
	return fl_show_form(Form(), FL_PLACE_CENTER,FL_FULLBORDER, title);
}

void
FormApp::Hide() {
	fl_hide_form(Form());
}

// This function MUST be called immediately after
// construction !!!
void
FormApp::FormSetup() {
	Form()->u_vdata = this;
}
