/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XChangeDeviceControl(display, device, control, f)
 *   Display	*display;
 *   XDevice	*device;
 *   int control;
 *   XDeviceControl *f;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangeDeviceControl	1
char    *TestName = "XChangeDeviceControl";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XChangeDeviceControl function
 */
static Display	*display;
static XDevice	*device;
static int control;
static XDeviceControl *f;


static int 	ValueReturn;

extern ExtDeviceInfo Devs;
static XDeviceResolutionControl dctl;
static int tval[255];


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	control = 0;
	f = (XDeviceControl *) &dctl;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int i,j,k,l, count=0, ndevices;
XDeviceResolutionState *state;
XAnyClassPtr any;
XDeviceInfo *list;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangeDeviceControl-1.(B)");
	report_assertion("A valid call to XChangeDeviceControl, specifying the");
	report_assertion("DEVICE_RESOLUTION control, changes the resolutions reported");
	report_assertion("for the device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Do a valid ChangeDeviceControl request, specifying DEVICE_RESOLUTION.");
	report_strategy("Verify that the resolutions are changed.");

	tpstartup();
	setargs();
    if (!Setup_Extension_DeviceInfo(DCtlMask))
	{
	untested("No input device that supports %s.\n", TestName);
	return;
	}
    
    /* Get initial values for resolutions so we can be sure we've
       changed them. */

    device = Devs.DvCtl;
    state = (XDeviceResolutionState *) 
	XGetDeviceControl (display, device, DEVICE_RESOLUTION);
    control = DEVICE_RESOLUTION;
    dctl.length = sizeof(XDeviceResolutionControl);
    dctl.control = DEVICE_RESOLUTION;
    dctl.first_valuator = 0;
    dctl.num_valuators = 0;
    dctl.resolutions = tval;

    list = XListInputDevices(display, &ndevices);
    for (i=0,l=0; i<ndevices; i++,list++)
	{
	if (list->id!=Devs.DvCtl->device_id)
	    continue;
	any = (XAnyClassPtr) (list->inputclassinfo);
	for (j=0; j<list->num_classes; j++)
	    {
	    if (any->class == ValuatorClass)
		{
		XAxisInfoPtr a = ((XValuatorInfo *) any)->axes;
		dctl.num_valuators += ((XValuatorInfo *) any)->num_axes;
		for (k=0;k<((XValuatorInfo *) any)->num_axes; k++,l++,a++)
		    if (k%2)
		        if (*(state->resolutions + l) != a->min_value)
			    tval[l] = a->min_value;
			else if (*(state->resolutions + l) != a->max_value)
			    tval[l] = a->max_value;
			else
			    {
			    report("%s: Can't change resolutions; minval=maxval=resolution: %d %d %d\n",TestName,a->min_value,a->max_value,*(state->resolutions +l));
			    UNTESTED;
			    }
		    else
		        if (*(state->resolutions + l) != a->max_value)
			    tval[l] = a->max_value;
			else if (*(state->resolutions + l) != a->min_value)
			    tval[l] = a->min_value;
			else
			    {
			    report("%s: Can't change resolutions; minval=maxval=resolution\n",TestName);
			    UNTESTED;
			    }
		}
	    any = (XAnyClassPtr) ((char *) any + any->length);
	    }
	}
    startcall(display);
    if (isdeleted())
    	return;
    ValueReturn = XChangeDeviceControl(display, device, control, f);
    endcall(display);
    if (geterr() != Success) {
    	report("Got %s, Expecting Success", errorname(geterr()));
    	FAIL;
    }
    if (geterr() == Success)
	CHECK;
    else
	FAIL;
    
    state = (XDeviceResolutionState *) 
	XGetDeviceControl (display, device, DEVICE_RESOLUTION);
    for(i=0; i<state->num_valuators; i++)
	if (*(state->resolutions + i) == tval[i])
	    {
	    CHECK;
	    count++;
	    }
	else
	    {
	    report("%s: resolution %d was %d expected %d.\n",
		TestName, i, *(state->resolutions+i), tval[i]);
	    FAIL;
	    }

    list = XListInputDevices(display, &ndevices);
    for (i=0,l=0; i<ndevices; i++,list++)
	{
	if (list->id!=Devs.DvCtl->device_id)
	    continue;
	any = (XAnyClassPtr) (list->inputclassinfo);
	for (j=0; j<list->num_classes; j++)
	    {
	    if (any->class == ValuatorClass)
		{
		XAxisInfoPtr a = ((XValuatorInfo *) any)->axes;
		for (k=0; k<((XValuatorInfo *) any)->num_axes; k++,l++,a++)
		    if (a->resolution == tval[l])
			{
			CHECK;
			count++;
			}
		    else
			{
			report("%s: XListInputDevices returned %d, wanted (%d)\n",TestName,a->resolution,tval[l]);
			FAIL;
			}
		}
	    any = (XAnyClassPtr) ((char *) any + any->length);
	    }
	}
	CHECKPASS(count+1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int i,j,k,l, count=0, ndevices;
XDeviceResolutionState *state, *sstate;
XAnyClassPtr any;
XDeviceInfo *list;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangeDeviceControl-2.(B)");
	report_assertion("A successful call to ChangeDeviceControl, specifying the");
	report_assertion("Device_Resolution control, does not affect the resolutions");
	report_assertion("of valuators outside the specified range.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Do a valid ChangeDeviceControl request, specifying DEVICE_RESOLUTION.");
	report_strategy("Specify that only 1 axis should have its resolution changed");
	report_strategy("Verify that the other resolutions are unchanged.");

	tpstartup();
	setargs();
    if (!Setup_Extension_DeviceInfo(DCtlMask))
	{
	untested("No input device that supports %s.\n", TestName);
	return;
	}
    /* Get initial values for resolutions so we can be sure we've
       changed them. */

    device = Devs.DvCtl;
    sstate = (XDeviceResolutionState *) 
	XGetDeviceControl (display, device, DEVICE_RESOLUTION);
    control = DEVICE_RESOLUTION;
    dctl.length = sizeof(XDeviceResolutionControl);
    dctl.control = DEVICE_RESOLUTION;
    dctl.first_valuator = 0;
    dctl.resolutions = tval;

    list = XListInputDevices(display, &ndevices);
    for (i=0,l=0; i<ndevices; i++,list++)
	{
	if (list->id!=Devs.DvCtl->device_id)
	    continue;
	any = (XAnyClassPtr) (list->inputclassinfo);
	for (j=0; j<list->num_classes; j++)
	    {
	    if (any->class == ValuatorClass)
		{
		XAxisInfoPtr a = ((XValuatorInfo *) any)->axes;
		if (((XValuatorInfo *) any)->num_axes <= 1)
		    {
		    report("%s: Unable to test that only 1 axis is changed\n",
			TestName);
		    UNTESTED;
		    }
		dctl.num_valuators = 1;
		tval[0] = a->min_value;
		if (*sstate->resolutions != a->min_value)
		    tval[0] = a->min_value;
		else if (*sstate->resolutions != a->max_value)
		    tval[0] = a->min_value;
		else
		    {
		    report("%s: Unable to test that 1 axis is changed.\n", TestName);
		    UNTESTED;
		    }
		}
	    any = (XAnyClassPtr) ((char *) any + any->length);
	    }
	}
    startcall(display);
    if (isdeleted())
    	return;
    ValueReturn = XChangeDeviceControl(display, device, control, f);
    endcall(display);
    if (geterr() != Success) {
    	report("Got %s, Expecting Success", errorname(geterr()));
    	FAIL;
    }
    if (geterr() == Success)
	CHECK;
    else
	FAIL;
    
    state = (XDeviceResolutionState *) 
	XGetDeviceControl (display, device, DEVICE_RESOLUTION);
    if (*state->resolutions == tval[0])
	{
	CHECK;
	count++;
	}
    else
	{
	report("%s: Axis 0 resolution could not be set.\n",TestName);
	FAIL;
	}
    for(i=1; i<state->num_valuators; i++)
	if (*(state->resolutions + i) == *(sstate->resolutions + i))
	    {
	    CHECK;
	    count++;
	    }
	else
	    {
	    report("%s: axis %d RESOLUTION was incorrectly set.\n",TestName,i);
	    FAIL;
	    }

    list = XListInputDevices(display, &ndevices);
    for (i=0; i<ndevices; i++,list++)
	{
	if (list->id!=Devs.DvCtl->device_id)
	    continue;
	any = (XAnyClassPtr) (list->inputclassinfo);
	for (j=0; j<list->num_classes; j++)
	    {
	    if (any->class == ValuatorClass)
		{
		XAxisInfoPtr a = ((XValuatorInfo *) any)->axes;
		if (a->resolution == tval[0])
			{
			CHECK;
			count++;
			a++;
			}
		    else
			{
			report("%s: XListInputDevices returned %d instead of the value returned by XGetDeviceControl (%d)\n",TestName,a->resolution,*(state->resolutions));
			FAIL;
			}
		for (k=1; k<((XValuatorInfo *) any)->num_axes; k++,a++)
		    if (a->resolution == *(sstate->resolutions+k))
			{
			CHECK;
			count++;
			}
		    else
			{
			report("%s: XListInputDevices returned %d instead of the value set by XChangeDeviceControl (%d)\n",TestName,a->resolution,*(sstate->resolutions+k));
			FAIL;
			}
		break;
		}
	    any = (XAnyClassPtr) ((char *) any + any->length);
	    }
	}
	CHECKPASS(count+1);


	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.29178 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangeDeviceControl-3.(B)");
	report_assertion("A call to ChangeDeviceControl, specifying a device control");
	report_assertion("state that conflicts with one in use by another client for");
	report_assertion("the same device will fail with a status of DeviceBusy.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.29178 */

static void t004(){

int ret, i, j, k, ndevices;
XAnyClassPtr any;
XDeviceInfo *list;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangeDeviceControl-4.(B)");
	report_assertion("A call to XChangeDeviceControl, specifying the");
	report_assertion("DEVICE_RESOLUTION control, and resolutions beyond the");
	report_assertion("minimum and maximum allowed, will result in a BadValue");
	report_assertion("error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Do a valid ChangeDeviceControl request, specifying DEVICE_RESOLUTION,");
	report_strategy("and resolutions beyond the minimum and maximum allowed.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
    if (!Setup_Extension_DeviceInfo(DCtlMask | ValMask))
	{
	untested("No input device that supports %s.\n", TestName);
	return;
	}
    device = Devs.DvCtl;
    control = DEVICE_RESOLUTION;
    dctl.first_valuator = 0;
    dctl.resolutions = tval;

    list = XListInputDevices(display, &ndevices);
    for (i=0; i<ndevices; i++,list++)
	{
	if (list->id!=Devs.DvCtl->device_id)
	    continue;
	any = (XAnyClassPtr) (list->inputclassinfo);
	for (j=0; j<list->num_classes; j++)
	    {
	    if (any->class == ValuatorClass)
		{
		XAxisInfoPtr a = ((XValuatorInfo *) any)->axes;
		dctl.num_valuators = ((XValuatorInfo *) any)->num_axes;
		for (k=0; k<((XValuatorInfo *) any)->num_axes; k++,a++)
		    tval[k] = k % 2 ? a->min_value-1 : a->max_value+1;
		}
	    any = (XAnyClassPtr) ((char *) any + any->length);
	    }
	}
    startcall(display);
    if (isdeleted())
    	return;
    ret = XChangeDeviceControl(display, device, control, f);
    endcall(display);
    if (geterr() != BadValue) {
    	report("Got %s, Expecting BadValue", errorname(geterr()));
    	FAIL;
    }
    if (geterr() == BadValue)
	PASS;
    else
	{
	report("%s: Got %d instead of BadValue\n",TestName,ret);
	FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int ret, i,j,k, ndevices;
XAnyClassPtr any;
XDeviceInfo *list;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangeDeviceControl-5.(B)");
	report_assertion("A call to XChangeDeviceControl, specifying the");
	report_assertion("DEVICE_RESOLUTION control, and a device that does not");
	report_assertion("support having its resolution changed, will result in a");
	report_assertion("BadMatch error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Do a valid ChangeDeviceControl request, specifying DEVICE_RESOLUTION,");
	report_strategy("and a device with valuators that does not support having its resolution");
	report_strategy("changed");

	tpstartup();
	setargs();
    if (!Setup_Extension_DeviceInfo(NDvCtlMask))
	{
	untested("No valuator device that doesn't support %s.\n", TestName);
	return;
	}
    device = Devs.NDvCtl;
    control = DEVICE_RESOLUTION;
    dctl.first_valuator = 0;
    dctl.resolutions = tval;

    list = XListInputDevices(display, &ndevices);
    for (i=0; i<ndevices; i++,list++)
	{
	if (list->id!=device->device_id)
	    continue;
	any = (XAnyClassPtr) (list->inputclassinfo);
	for (j=0; j<list->num_classes; j++)
	    {
	    if (any->class == ValuatorClass)
		{
		XAxisInfoPtr a = ((XValuatorInfo *) any)->axes;
		dctl.num_valuators = ((XValuatorInfo *) any)->num_axes;
		for (k=0; k<((XValuatorInfo *) any)->num_axes; k++,a++)
		    tval[k] = k % 2 ? a->min_value : a->max_value;
		break;
		}
	    any = (XAnyClassPtr) ((char *) any + any->length);
	    }
	}
    startcall(display);
    if (isdeleted())
    	return;
    ret = XChangeDeviceControl(display, device, control, f);
    endcall(display);
    if (geterr() != BadMatch) {
    	report("Got %s, Expecting BadMatch", errorname(geterr()));
    	FAIL;
    }
    if (geterr() == BadMatch)
	PASS;
    else
	{
	report("%s: Got %d instead of BadMatch\n",TestName,ret);
	FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XDevice bogus;
XID baddevice;
int ximajor, first, err, ret, val;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XChangeDeviceControl-6.(B)");
	report_assertion("If an invalid device is specified, a BadDevice error will");
	report_assertion("result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Do a ChangeDeviceControl request, specifying an invalid device.");

	tpstartup();
	setargs();
    if (!XQueryExtension (display, INAME, &ximajor, &first, &err))
	{
	untested("%s: Input extension not supported.\n", TestName);
	return;
	}

    BadDevice (display, baddevice);
    bogus.device_id = 128;
    device = &bogus;
    control = DEVICE_RESOLUTION;
    dctl.length = sizeof(XDeviceResolutionControl);
    dctl.control = DEVICE_RESOLUTION;
    dctl.num_valuators = 1;
    dctl.first_valuator = 0;
    dctl.resolutions = &val;
    tval[0] = tval[1] = 0;
    startcall(display);
    if (isdeleted())
    	return;
    ret = XChangeDeviceControl(display, device, control, f);
    endcall(display);
    if (geterr() != baddevice) {
    	report("Got %s, Expecting baddevice", errorname(geterr()));
    	FAIL;
    }
    XSync(display,0);
    if (geterr() == baddevice)
	PASS;
    else
	FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XChangeDeviceControl-7.(B)");
	report_assertion("If an valid device with an invalid Control is specified, a");
	report_assertion("BadValue error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Do a ChangeDeviceControl, specifying an valid device with an invalid");
	report_strategy("Control.");

	tpstartup();
	setargs();
    if (!Setup_Extension_DeviceInfo(DCtlMask))
	{
	untested("No device that supports %s.\n", TestName);
	return;
	}
    device = Devs.DvCtl;
    control = -1;
    dctl.first_valuator = 0;
    dctl.num_valuators = 1;
    tval[0] = tval[1] = 0;
    startcall(display);
    if (isdeleted())
    	return;
    ret = XChangeDeviceControl(display, device, control, f);
    endcall(display);
    if (geterr() != BadValue) {
    	report("Got %s, Expecting BadValue", errorname(geterr()));
    	FAIL;
    }
    if (geterr() == BadValue)
	PASS;
    else
	FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XChangeDeviceControl-8.(B)");
	report_assertion("If an valid device with an invalid DeviceControl id is");
	report_assertion("specified, a BadMatch error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Do a ChangeDeviceControl, specifying an valid device with an id of 255.");

	tpstartup();
	setargs();
    if (!Setup_Extension_DeviceInfo(NValsMask))
	{
	untested("%s: No device without valuators.\n", TestName);
	return;
	}
    device = Devs.NoValuators;
    control = DEVICE_RESOLUTION;
    dctl.first_valuator = 0;
    dctl.num_valuators = 1;
    tval[0] = tval[1] = 0;
    startcall(display);
    if (isdeleted())
    	return;
    ret = XChangeDeviceControl(display, device, control, f);
    endcall(display);
    if (geterr() != BadMatch) {
    	report("Got %s, Expecting BadMatch", errorname(geterr()));
    	FAIL;
    }
    if (geterr() == BadMatch)
	PASS;
    else
	FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XChangeDeviceControl-9.(B)");
	report_assertion("If XChangeDeviceControl is invoked with the");
	report_assertion("DEVICE_RESOLUTION control, and the expression");
	report_assertion("(first_valuator+ num_valuators) is greater than the number");
	report_assertion("of axes reported by the device, a BadValue error will");
	report_assertion("result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Do a ChangeDeviceControl, specifying a first valuator equal to the ");
	report_strategy("number of valuators on the device, with a non-zero num_valuators");
	report_strategy("parameter");

	tpstartup();
	setargs();
    if (!Setup_Extension_DeviceInfo(DCtlMask))
	{
	untested("No device that supports %s.\n", TestName);
	return;
	}
    device = Devs.DvCtl;
    control = DEVICE_RESOLUTION;
    dctl.length = sizeof(XDeviceResolutionControl);
    dctl.control = DEVICE_RESOLUTION;
    dctl.first_valuator = 255;
    dctl.num_valuators = 2;
    tval[0] = tval[1] = 0;
    dctl.resolutions = tval;
    startcall(display);
    if (isdeleted())
    	return;
    ret = XChangeDeviceControl(display, device, control, f);
    endcall(display);
    if (geterr() != BadValue) {
    	report("Got %s, Expecting BadValue", errorname(geterr()));
    	FAIL;
    }
    if (geterr() == BadValue)
	PASS;
    else
	FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int ret;
Display *client2;
int devicemotionnotify;
XEventClass devicemotionnotifyclass;
Window w;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XChangeDeviceControl-10.(B)");
	report_assertion("If XChangeDeviceControl is invoked with the");
	report_assertion("DEVICE_RESOLUTION control, and the device is already grabbed");
	report_assertion("by another client, a status of AlreadyGrabbed will be");
	report_assertion("returned.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab the target device.");
	report_strategy("Do a ChangeDeviceControl.  Verify that a status of AlreadyGrabbed");
	report_strategy("is returned.");

	tpstartup();
	setargs();
    if (!Setup_Extension_DeviceInfo(DCtlMask))
	{
	untested("No device that supports %s.\n", TestName);
	return;
	}
    device = Devs.DvCtl;
    control = DEVICE_RESOLUTION;
    dctl.first_valuator = 0;
    dctl.num_valuators = 1;
    tval[0] = tval[1] = 0;
    dctl.resolutions = tval;

    if ((client2 = opendisplay()) == 0)
	return;
    w = defwin(client2);

    DeviceMotionNotify(Devs.DvCtl, devicemotionnotify, devicemotionnotifyclass);
    ret = XGrabDevice(client2, Devs.DvCtl, w, False, 1, 
	&devicemotionnotifyclass, GrabModeAsync, GrabModeAsync, CurrentTime);
    XSync(display,0);
    if (ret != Success)
	{
	report("%s: Could not set up initial grab",TestName);
	FAIL;
	}
    else
	CHECK;

    device=Devs.DvCtl;
    startcall(display);
    if (isdeleted())
    	return;
    ret = XChangeDeviceControl(display, device, control, f);
    endcall(display);
    if (geterr() != Success) {
    	report("Got %s, Expecting Success", errorname(geterr()));
    	FAIL;
    }
    XSync(display,0);
    if (ret == AlreadyGrabbed)
	CHECK;
    else
	{
	report("%s: Expected AlreadyGrabbed, got %d", TestName, ret);
	FAIL;
	}
    CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
