.\" Man page for LyX.
.\" Use the following command to view man page:
.\"
.\"  tbl lyx.1 | nroff -man | less
.\"
.TH LYX 1 "Feb 2007" "Version 1.5" "LyX 1.5"
.SH NAME
lyx \- A Document Processor
.\"
.\" setup
.de Cr
.ie n (c)
.el \(co
..
.SH SYNOPSIS
\fBlyx\fR [ \fIcommand\-line switches\fR ] [ \fIname[.lyx] ...\fR ]
.br
.SH DESCRIPTION
\fBLyX\fR is too complex to be described completely in the "man" page
format. If your system is properly configured, you can access the full
documentation within \fBLyX\fR under the Help menu.

\fBLyX\fR is a document preparation system. It excels at letting you
create complex technical and scientific articles with mathematics,
cross\-references, bibliographies, indices, etc. It is very good at
documents of any length in which the usual processing abilities are
required: automatic sectioning and pagination, spellchecking, and so
forth. It can also be used to write a letter to your mom, though
granted, there are probably simpler programs available for that. It is
definitely not the best tool for creating banners, flyers, or
advertisements, though with some effort all these can be done, too.
Some examples of what it is used for: memos, letters, dissertations
and theses, lecture notes, seminar notebooks, conference proceedings,
software documentation, books (on PostgreSQL, remote sensing,
cryptology, fictional novels, poetry, and even a children's book or
two), articles in refereed scientific journals, scripts for plays and
movies, business proposals... you get the idea.

Currently, \fBLyX\fR uses the Qt4 library as a
toolkit. \fBLyX\fR should run everywhere, where this library runs.
This is on all major Unix platforms as well as Windows and Mac OS X
(which actually is a unix platform).
.SH OPTIONS
\fBLyX\fR supports the following command\-line switches.
.TP 6
.BI \-help
summarizes LyX usage
.TP
.BI \-version
provides version information on the build of LyX.
.TP
.BI \-sysdir " directory"
sets system directory. Normally not needed.
.TP
.BI \-userdir " directory"
sets user directory. Needed if you want to use LyX with different lyxrc
settings.
.TP
.BI \-geometry " WxH+X+Y"
set geometry of the main window.
.TP
.BI \-dbg " feature[,feature...]"
where feature is a name or number.
Use "\fBlyx \-dbg\fR" to see the list of available debug features.
.TP
\fB \-x [\-\-execute]\fP \fIcommand
where command is a lyx command.
.TP
\fB \-e [\-\-export]\fP \fIfmt
where fmt is the export format of choice.
.TP
\fB \-i [\-\-import]\fP \fIfmt file.xxx
where fmt is the import format of choice and file.xxx is the file to be imported.

.SH ENVIRONMENT
.TP
.B LYX_DIR_15x
can be used to specify which system directory to use.
.PP
The system directory is determined by searching for the file
"chkconfig.ltx". Directories are searched in this order:
.br
1) \-sysdir command line parameter
.br
2) LYX_DIR_15x environment variable
.br
3) Maybe <path of binary>/TOP_SRCDIR/lib
.br
4) <path of binary>/../share/<name of binary>/
.br
5) hardcoded lyx_dir (usually /usr/local/share/lyx on UNIX)
.TP
.B LYX_USERDIR_15x
can be used to specify which user directory to use.
.PP
The user directory is, in order of precedence:
.br
1) \-userdir command line parameter
.br
2) LYX_USERDIR_15x environment variable
.br
3) $HOME/.<name of binary> if no explicit setting is made

.TP
.B LYX_LOCALEDIR
can be used to tell LyX where to look for the translations of its GUI
strings in other languages.
.SH FILES
.nf
.ta \w'\fILIBDIR\fR/lyxrc.in  'u
~/.lyx/preferences      Personal configuration file
~/.lyx/lyxrc.defaults   Personal autodetected configuration file
\fILIBDIR\fR/lyxrc.dist  System wide configuration file
\fILIBDIR\fR/configure.py  Updates \fBLyX\fR if config has changed
\fILIBDIR\fR/bind/      Keybindings
\fILIBDIR\fR/clipart/   Clipart pictures
\fILIBDIR\fR/doc/       Documentation in \fBLyX\fR format.
\fILIBDIR\fR/examples/  Example documents
\fILIBDIR\fR/images/    Images used as icons or in popups
\fILIBDIR\fR/kbd/       Keyboard mappings
\fILIBDIR\fR/layouts/   Layout descriptions
\fILIBDIR\fR/templates/ Templates for documents
\fILIBDIR\fR/tex/       Extra TeX files
.sp
.fi

.I LIBDIR
is the system directory. This is usually /usr/local/share/lyx on UNIX.
.SH SEE ALSO
tex2lyx(1), latex(1).

Full documentation in either native \fBLyX\fR or postscript format.
.SH BUGS/LIMITATIONS
There are still some bugs in \fBLyX\fR. To report one, read if
possible the Introduction found under the Help menu in LyX. You'll
find detailed info on submitting bug reports there. If you can't do
that, send details to the LyX Developers mailing list
lyx\-devel@lists.lyx.org, or use the LyX bug tracker at
http://bugzilla.lyx.org/. Don't forget to mention which version you
are having problems with!

\fBLaTeX\fR import is still not perfect and may produce buggy *.lyx
files. Consult the \fBtex2lyx\fR documentation.

.SH AUTHORS
LyX is Copyright (C) 1995 by Matthias Ettrich, 1995-2008 LyX Team
