/*

filelist.nsh

Lists of files to include in the installer

*/

!define FILE '${COMMAND} "${DIRECTORY}'

!macro FileListLyXBin COMMAND DIRECTORY

  ${FILE}lyx.exe"
  ${FILE}tex2lyx.exe"

!macroend

!macro FileListLyXLauncher COMMAND DIRECTORY

  ${FILE}LyXLauncher.exe"

!macroend

!macro FileListQtBin COMMAND DIRECTORY

  ${FILE}QtCore4.dll"
  ${FILE}QtGui4.dll"  

!macroend

!macro FileListMSVCBin COMMAND DIRECTORY

  ${FILE}msvcr90.dll"
  ${FILE}msvcp90.dll"
  
!macroend

!macro FileListMSVCManifest COMMAND DIRECTORY

  ${FILE}\Microsoft.VC90.CRT.manifest"
  
!macroend

!macro FileListDll COMMAND DIRECTORY

  ${FILE}iconv.dll"
  ${FILE}intl.dll"
  ${FILE}aspell.dll"
  ${FILE}Aiksaurus.dll"
  ${FILE}zlib1.dll"

!macroend

!macro FileListNetpbmBin COMMAND DIRECTORY

  ${FILE}libnetpbm10.dll"
  ${FILE}pnmcrop.exe"
  
!macroend

!macro FileListDTLBin COMMAND DIRECTORY

  ${FILE}dt2dv.exe"
  ${FILE}dv2dt.exe"
  
!macroend

!macro FileListDvipostBin COMMAND DIRECTORY

  ${FILE}pplatex.exe"
  
!macroend

!macro FileListPDFToolsBin COMMAND DIRECTORY

  ${FILE}pdfopen.exe"
  ${FILE}pdfclose.exe"
  
!macroend

!macro FileListPDFViewBin COMMAND DIRECTORY

  ${FILE}pdfview.exe"

!macroend

!macro FileListFonts COMMAND DIRECTORY

  ${FILE}cmex10.ttf"
  ${FILE}cmmi10.ttf"
  ${FILE}cmr10.ttf"
  ${FILE}cmsy10.ttf"
  ${FILE}eufm10.ttf"
  ${FILE}msam10.ttf"
  ${FILE}msbm10.ttf"
  ${FILE}wasy10.ttf"
  
!macroend

!macro FileListPythonBin COMMAND DIRECTORY

  ${FILE}python.exe"
  ${FILE}python26.dll"
  ${FILE}unicodedata.pyd"

!macroend

!macro FileListPythonLib COMMAND DIRECTORY

  ${FILE}__future__.py"
  ${FILE}_abcoll.py"  
  ${FILE}UserDict.py"
  ${FILE}abc.py"  
  ${FILE}codecs.py"
  ${FILE}compileall.py"  
  ${FILE}copy_reg.py"
  ${FILE}functools.py"  
  ${FILE}fnmatch.py"
  ${FILE}genericpath.py"  
  ${FILE}getopt.py"
  ${FILE}gettext.py"
  ${FILE}glob.py"
  ${FILE}gzip.py"
  ${FILE}linecache.py"
  ${FILE}locale.py"
  ${FILE}ntpath.py"
  ${FILE}os.py"
  ${FILE}optparse.py"
  ${FILE}pipes.py"
  ${FILE}posixpath.py"
  ${FILE}py_compile.py"  
  ${FILE}random.py"
  ${FILE}re.py"
  ${FILE}shutil.py"
  ${FILE}site.py"
  ${FILE}sre.py"
  ${FILE}sre_compile.py"
  ${FILE}sre_constants.py"
  ${FILE}sre_parse.py"
  ${FILE}stat.py"
  ${FILE}string.py"
  ${FILE}struct.py"  
  ${FILE}tempfile.py"
  ${FILE}tempfile.py"
  ${FILE}textwrap.py"
  ${FILE}traceback.py"  
  ${FILE}types.py"
  ${FILE}warnings.py"

!macroend

!macro FileListPythonLibEncodings COMMAND DIRECTORY

  ${FILE}aliases.py"
  ${FILE}ascii.py"
  ${FILE}base64_codec.py"
  ${FILE}big5.py"
  ${FILE}big5hkscs.py"
  ${FILE}bz2_codec.py"
  ${FILE}charmap.py"
  ${FILE}cp037.py"
  ${FILE}cp1006.py"
  ${FILE}cp1026.py"
  ${FILE}cp1140.py"
  ${FILE}cp1250.py"
  ${FILE}cp1251.py"
  ${FILE}cp1252.py"
  ${FILE}cp1253.py"
  ${FILE}cp1254.py"
  ${FILE}cp1255.py"
  ${FILE}cp1256.py"
  ${FILE}cp1257.py"
  ${FILE}cp1258.py"
  ${FILE}cp424.py"
  ${FILE}cp437.py"
  ${FILE}cp500.py"
  ${FILE}cp737.py"
  ${FILE}cp775.py"
  ${FILE}cp850.py"
  ${FILE}cp852.py"
  ${FILE}cp855.py"
  ${FILE}cp856.py"
  ${FILE}cp857.py"
  ${FILE}cp860.py"
  ${FILE}cp861.py"
  ${FILE}cp862.py"
  ${FILE}cp863.py"
  ${FILE}cp864.py"
  ${FILE}cp865.py"
  ${FILE}cp866.py"
  ${FILE}cp869.py"
  ${FILE}cp874.py"
  ${FILE}cp875.py"
  ${FILE}cp932.py"
  ${FILE}cp949.py"
  ${FILE}cp950.py"
  ${FILE}euc_jisx0213.py"
  ${FILE}euc_jis_2004.py"
  ${FILE}euc_jp.py"
  ${FILE}euc_kr.py"
  ${FILE}gb18030.py"
  ${FILE}gb2312.py"
  ${FILE}gbk.py"
  ${FILE}hex_codec.py"
  ${FILE}hp_roman8.py"
  ${FILE}hz.py"
  ${FILE}idna.py"
  ${FILE}iso2022_jp.py"
  ${FILE}iso2022_jp_1.py"
  ${FILE}iso2022_jp_2.py"
  ${FILE}iso2022_jp_2004.py"
  ${FILE}iso2022_jp_3.py"
  ${FILE}iso2022_jp_ext.py"
  ${FILE}iso2022_kr.py"
  ${FILE}iso8859_1.py"
  ${FILE}iso8859_10.py"
  ${FILE}iso8859_11.py"
  ${FILE}iso8859_13.py"
  ${FILE}iso8859_14.py"
  ${FILE}iso8859_15.py"
  ${FILE}iso8859_16.py"
  ${FILE}iso8859_2.py"
  ${FILE}iso8859_3.py"
  ${FILE}iso8859_4.py"
  ${FILE}iso8859_5.py"
  ${FILE}iso8859_6.py"
  ${FILE}iso8859_7.py"
  ${FILE}iso8859_8.py"
  ${FILE}iso8859_9.py"
  ${FILE}johab.py"
  ${FILE}koi8_r.py"
  ${FILE}koi8_u.py"
  ${FILE}latin_1.py"
  ${FILE}mac_arabic.py"
  ${FILE}mac_centeuro.py"
  ${FILE}mac_croatian.py"
  ${FILE}mac_cyrillic.py"
  ${FILE}mac_farsi.py"
  ${FILE}mac_greek.py"
  ${FILE}mac_iceland.py"
  ${FILE}mac_latin2.py"
  ${FILE}mac_roman.py"
  ${FILE}mac_romanian.py"
  ${FILE}mac_turkish.py"
  ${FILE}mbcs.py"
  ${FILE}palmos.py"
  ${FILE}ptcp154.py"
  ${FILE}punycode.py"
  ${FILE}quopri_codec.py"
  ${FILE}raw_unicode_escape.py"
  ${FILE}rot_13.py"
  ${FILE}shift_jis.py"
  ${FILE}shift_jisx0213.py"
  ${FILE}shift_jis_2004.py"
  ${FILE}string_escape.py"
  ${FILE}tis_620.py"
  ${FILE}undefined.py"
  ${FILE}unicode_escape.py"
  ${FILE}unicode_internal.py"
  ${FILE}utf_16.py"
  ${FILE}utf_16_be.py"
  ${FILE}utf_16_le.py"
  ${FILE}utf_7.py"
  ${FILE}utf_8.py"
  ${FILE}utf_8_sig.py"
  ${FILE}uu_codec.py"
  ${FILE}zlib_codec.py"
  ${FILE}__init__.py"
  
!macroend

!macro FileListAiksaurusData COMMAND DIRECTORY

  ${FILE}words.dat"
  ${FILE}meanings.dat"
  
!macroend

!macro FileListNSISPluginsStandard COMMAND DIRECTORY

  ${FILE}System.dll"

!macroend

!macro FileListNSISPlugins COMMAND DIRECTORY

  ${FILE}Console.dll"

!macroend

!macro FileListMetaFile2EPS COMMAND DIRECTORY

  ${FILE}metafile2eps.exe"
  ${FILE}metafile2eps.dat"  

!macroend

!macro FileListImageMagick COMMAND DIRECTORY

  ${FILE}analyze.dll"
  ${FILE}coder.xml"
  ${FILE}colors.xml"
  ${FILE}configure.xml"
  ${FILE}convert.exe"
  ${FILE}CORE_RL_bzlib_.dll"
  ${FILE}CORE_RL_jbig_.dll"
  ${FILE}CORE_RL_jp2_.dll"
  ${FILE}CORE_RL_jpeg_.dll"
  ${FILE}CORE_RL_lcms_.dll"
  ${FILE}CORE_RL_libxml_.dll"
  ${FILE}CORE_RL_Magick++_.dll"
  ${FILE}CORE_RL_magick_.dll"
  ${FILE}CORE_RL_png_.dll"
  ${FILE}CORE_RL_tiff_.dll"
  ${FILE}CORE_RL_ttf_.dll"
  ${FILE}CORE_RL_wand_.dll"
  ${FILE}CORE_RL_xlib_.dll"
  ${FILE}CORE_RL_zlib_.dll"
  ${FILE}delegates.xml"
  ${FILE}english.xml"
  ${FILE}ImageMagick.rdf"
  ${FILE}IM_MOD_RL_art_.dll"
  ${FILE}IM_MOD_RL_avi_.dll"
  ${FILE}IM_MOD_RL_avs_.dll"
  ${FILE}IM_MOD_RL_bmp_.dll"
  ${FILE}IM_MOD_RL_braille_.dll"
  ${FILE}IM_MOD_RL_caption_.dll"
  ${FILE}IM_MOD_RL_cin_.dll"
  ${FILE}IM_MOD_RL_cip_.dll"
  ${FILE}IM_MOD_RL_clipboard_.dll"
  ${FILE}IM_MOD_RL_clip_.dll"
  ${FILE}IM_MOD_RL_cmyk_.dll"
  ${FILE}IM_MOD_RL_cut_.dll"
  ${FILE}IM_MOD_RL_dcm_.dll"
  ${FILE}IM_MOD_RL_dds_.dll"
  ${FILE}IM_MOD_RL_dib_.dll"
  ${FILE}IM_MOD_RL_djvu_.dll"
  ${FILE}IM_MOD_RL_dng_.dll"
  ${FILE}IM_MOD_RL_dot_.dll"
  ${FILE}IM_MOD_RL_dps_.dll"
  ${FILE}IM_MOD_RL_dpx_.dll"
  ${FILE}IM_MOD_RL_emf_.dll"
  ${FILE}IM_MOD_RL_ept_.dll"
  ${FILE}IM_MOD_RL_exr_.dll"
  ${FILE}IM_MOD_RL_fax_.dll"
  ${FILE}IM_MOD_RL_fits_.dll"
  ${FILE}IM_MOD_RL_fpx_.dll"
  ${FILE}IM_MOD_RL_gif_.dll"
  ${FILE}IM_MOD_RL_gradient_.dll"
  ${FILE}IM_MOD_RL_gray_.dll"
  ${FILE}IM_MOD_RL_histogram_.dll"
  ${FILE}IM_MOD_RL_html_.dll"
  ${FILE}IM_MOD_RL_icon_.dll"
  ${FILE}IM_MOD_RL_info_.dll"
  ${FILE}IM_MOD_RL_inline_.dll"
  ${FILE}IM_MOD_RL_ipl_.dll"
  ${FILE}IM_MOD_RL_jbig_.dll"
  ${FILE}IM_MOD_RL_jp2_.dll"
  ${FILE}IM_MOD_RL_jpeg_.dll"
  ${FILE}IM_MOD_RL_label_.dll"
  ${FILE}IM_MOD_RL_magick_.dll"
  ${FILE}IM_MOD_RL_map_.dll"
  ${FILE}IM_MOD_RL_matte_.dll"
  ${FILE}IM_MOD_RL_mat_.dll"
  ${FILE}IM_MOD_RL_meta_.dll"
  ${FILE}IM_MOD_RL_miff_.dll"
  ${FILE}IM_MOD_RL_mono_.dll"
  ${FILE}IM_MOD_RL_mpc_.dll"
  ${FILE}IM_MOD_RL_mpeg_.dll"
  ${FILE}IM_MOD_RL_mpr_.dll"
  ${FILE}IM_MOD_RL_msl_.dll"
  ${FILE}IM_MOD_RL_mtv_.dll"
  ${FILE}IM_MOD_RL_mvg_.dll"
  ${FILE}IM_MOD_RL_null_.dll"
  ${FILE}IM_MOD_RL_otb_.dll"
  ${FILE}IM_MOD_RL_palm_.dll"
  ${FILE}IM_MOD_RL_pattern_.dll"
  ${FILE}IM_MOD_RL_pcd_.dll"
  ${FILE}IM_MOD_RL_pcl_.dll"
  ${FILE}IM_MOD_RL_pcx_.dll"
  ${FILE}IM_MOD_RL_pdb_.dll"
  ${FILE}IM_MOD_RL_pdf_.dll"
  ${FILE}IM_MOD_RL_pict_.dll"
  ${FILE}IM_MOD_RL_pix_.dll"
  ${FILE}IM_MOD_RL_plasma_.dll"
  ${FILE}IM_MOD_RL_png_.dll"
  ${FILE}IM_MOD_RL_pnm_.dll"
  ${FILE}IM_MOD_RL_preview_.dll"
  ${FILE}IM_MOD_RL_ps2_.dll"
  ${FILE}IM_MOD_RL_ps3_.dll"
  ${FILE}IM_MOD_RL_psd_.dll"
  ${FILE}IM_MOD_RL_ps_.dll"
  ${FILE}IM_MOD_RL_pwp_.dll"
  ${FILE}IM_MOD_RL_raw_.dll"
  ${FILE}IM_MOD_RL_rgb_.dll"
  ${FILE}IM_MOD_RL_rla_.dll"
  ${FILE}IM_MOD_RL_rle_.dll"
  ${FILE}IM_MOD_RL_scr_.dll"
  ${FILE}IM_MOD_RL_sct_.dll"
  ${FILE}IM_MOD_RL_sfw_.dll"
  ${FILE}IM_MOD_RL_sgi_.dll"
  ${FILE}IM_MOD_RL_stegano_.dll"
  ${FILE}IM_MOD_RL_sun_.dll"
  ${FILE}IM_MOD_RL_svg_.dll"
  ${FILE}IM_MOD_RL_tga_.dll"
  ${FILE}IM_MOD_RL_thumbnail_.dll"
  ${FILE}IM_MOD_RL_tiff_.dll"
  ${FILE}IM_MOD_RL_tile_.dll"
  ${FILE}IM_MOD_RL_tim_.dll"
  ${FILE}IM_MOD_RL_ttf_.dll"
  ${FILE}IM_MOD_RL_txt_.dll"
  ${FILE}IM_MOD_RL_uil_.dll"
  ${FILE}IM_MOD_RL_url_.dll"
  ${FILE}IM_MOD_RL_uyvy_.dll"
  ${FILE}IM_MOD_RL_vicar_.dll"
  ${FILE}IM_MOD_RL_vid_.dll"
  ${FILE}IM_MOD_RL_viff_.dll"
  ${FILE}IM_MOD_RL_wbmp_.dll"
  ${FILE}IM_MOD_RL_wmf_.dll"
  ${FILE}IM_MOD_RL_wpg_.dll"
  ${FILE}IM_MOD_RL_xbm_.dll"
  ${FILE}IM_MOD_RL_xcf_.dll"
  ${FILE}IM_MOD_RL_xc_.dll"
  ${FILE}IM_MOD_RL_xpm_.dll"
  ${FILE}IM_MOD_RL_xps_.dll"
  ${FILE}IM_MOD_RL_xtrn_.dll"
  ${FILE}IM_MOD_RL_xwd_.dll"
  ${FILE}IM_MOD_RL_x_.dll"
  ${FILE}IM_MOD_RL_ycbcr_.dll"
  ${FILE}IM_MOD_RL_yuv_.dll"
  ${FILE}locale.xml"
  ${FILE}log.xml"
  ${FILE}magic.xml"
  ${FILE}sRGB.icm"
  ${FILE}thresholds.xml"
  ${FILE}type-ghostscript.xml"
  ${FILE}type.xml"
  ${FILE}X11.dll"
  ${FILE}Xext.dll"

!macroend

!macro FileListGhostscriptBin COMMAND DIRECTORY

  ${FILE}gswin32.exe"
  ${FILE}gswin32c.exe"
  ${FILE}gsdll32.dll"

!macroend

!macro FileListGhostscriptLib COMMAND DIRECTORY

  ${FILE}acctest.ps"
  ${FILE}addxchar.ps"
  ${FILE}afmdiff.awk"
  ${FILE}align.ps"
  ${FILE}bdftops"
  ${FILE}bdftops.bat"
  ${FILE}bdftops.cmd"
  ${FILE}bdftops.ps"
  ${FILE}bj8.rpd"
  ${FILE}bj8gc12f.upp"
  ${FILE}bj8hg12f.upp"
  ${FILE}bj8oh06n.upp"
  ${FILE}bj8pa06n.upp"
  ${FILE}bj8pp12f.upp"
  ${FILE}bj8ts06n.upp"
  ${FILE}bjc610a0.upp"
  ${FILE}bjc610a1.upp"
  ${FILE}bjc610a2.upp"
  ${FILE}bjc610a3.upp"
  ${FILE}bjc610a4.upp"
  ${FILE}bjc610a5.upp"
  ${FILE}bjc610a6.upp"
  ${FILE}bjc610a7.upp"
  ${FILE}bjc610a8.upp"
  ${FILE}bjc610b1.upp"
  ${FILE}bjc610b2.upp"
  ${FILE}bjc610b3.upp"
  ${FILE}bjc610b4.upp"
  ${FILE}bjc610b6.upp"
  ${FILE}bjc610b7.upp"
  ${FILE}bjc610b8.upp"
  ${FILE}caption.ps"
  ${FILE}cbjc600.ppd"
  ${FILE}cbjc800.ppd"
  ${FILE}cdj550.upp"
  ${FILE}cdj690.upp"
  ${FILE}cdj690ec.upp"
  ${FILE}cid2code.ps"
  ${FILE}cidfmap"
  ${FILE}decrypt.ps"
  ${FILE}dnj750c.upp"
  ${FILE}dnj750m.upp"
  ${FILE}docie.ps"
  ${FILE}dumphint"
  ${FILE}dumphint.bat"
  ${FILE}dumphint.ps"
  ${FILE}dvipdf"
  ${FILE}EndOfTask.ps"
  ${FILE}eps2eps"
  ${FILE}eps2eps.bat"
  ${FILE}eps2eps.cmd"
  ${FILE}FAPIcidfmap"
  ${FILE}FAPIconfig"
  ${FILE}FAPIconfig-FCO"
  ${FILE}FAPIfontmap"
  ${FILE}FCOfontmap-PCLPS2"
  ${FILE}FCOfontmap-PCLPS3"
  ${FILE}FCOfontmap-PS3"
  ${FILE}fixmswrd.pl"
  ${FILE}font2c"
  ${FILE}font2c.bat"
  ${FILE}font2c.cmd"
  ${FILE}font2c.ps"
  ${FILE}font2pcl.ps"
  ${FILE}Fontmap"
  ${FILE}Fontmap.ATB"
  ${FILE}Fontmap.ATM"
  ${FILE}Fontmap.GS"
  ${FILE}Fontmap.OS2"
  ${FILE}Fontmap.OSF"
  ${FILE}Fontmap.SGI"
  ${FILE}Fontmap.Sol"
  ${FILE}Fontmap.Ult"
  ${FILE}Fontmap.VMS"
  ${FILE}ghostpdf.inf"
  ${FILE}ghostpdf.ppd"
  ${FILE}gsbj"
  ${FILE}gsbj.bat"
  ${FILE}gsdj"
  ${FILE}gsdj.bat"
  ${FILE}gsdj500"
  ${FILE}gsdj500.bat"
  ${FILE}gslj"
  ${FILE}gslj.bat"
  ${FILE}gslp"
  ${FILE}gslp.bat"
  ${FILE}gslp.ps"
  ${FILE}gsnd"
  ${FILE}gsnd.bat"
  ${FILE}gsndt.bat"
  ${FILE}gsnup.ps"
  ${FILE}gssetgs.bat"
  ${FILE}gst.bat"
  ${FILE}gstt.bat"
  ${FILE}gs_agl.ps"
  ${FILE}gs_btokn.ps"
  ${FILE}gs_ccfnt.ps"
  ${FILE}gs_cet.ps"
  ${FILE}gs_ce_e.ps"
  ${FILE}gs_cff.ps"
  ${FILE}gs_cidcm.ps"
  ${FILE}gs_ciddc.ps"
  ${FILE}gs_cidfm.ps"
  ${FILE}gs_cidfn.ps"
  ${FILE}gs_cidtt.ps"
  ${FILE}gs_ciecs2.ps"
  ${FILE}gs_ciecs3.ps"
  ${FILE}gs_cmap.ps"
  ${FILE}gs_cmdl.ps"
  ${FILE}gs_cspace.ps"
  ${FILE}gs_css_e.ps"
  ${FILE}gs_dbt_e.ps"
  ${FILE}gs_devcs.ps"
  ${FILE}gs_devn.ps"
  ${FILE}gs_devpxl.ps"
  ${FILE}gs_diskf.ps"
  ${FILE}gs_diskn.ps"
  ${FILE}gs_dpnxt.ps"
  ${FILE}gs_dps.ps"
  ${FILE}gs_dps1.ps"
  ${FILE}gs_dps2.ps"
  ${FILE}gs_dscp.ps"
  ${FILE}gs_epsf.ps"
  ${FILE}gs_fapi.ps"
  ${FILE}gs_fform.ps"
  ${FILE}gs_fntem.ps"
  ${FILE}gs_fonts.ps"
  ${FILE}gs_frsd.ps"
  ${FILE}gs_icc.ps"
  ${FILE}gs_il1_e.ps"
  ${FILE}gs_il2_e.ps"
  ${FILE}gs_img.ps"
  ${FILE}gs_indxd.ps"
  ${FILE}gs_init.ps"
  ${FILE}gs_kanji.ps"
  ${FILE}gs_ksb_e.ps"
  ${FILE}gs_l.xbm"
  ${FILE}gs_l.xpm"
  ${FILE}gs_l2img.ps"
  ${FILE}gs_lev2.ps"
  ${FILE}gs_lgo_e.ps"
  ${FILE}gs_lgx_e.ps"
  ${FILE}gs_ll3.ps"
  ${FILE}gs_l_m.xbm"
  ${FILE}gs_m.xbm"
  ${FILE}gs_m.xpm"
  ${FILE}gs_mex_e.ps"
  ${FILE}gs_mgl_e.ps"
  ${FILE}gs_mro_e.ps"
  ${FILE}gs_m_m.xbm"
  ${FILE}gs_patrn.ps"
  ${FILE}gs_pdfwr.ps"
  ${FILE}gs_pdf_e.ps"
  ${FILE}gs_pfile.ps"
  ${FILE}gs_rdlin.ps"
  ${FILE}gs_res.ps"
  ${FILE}gs_resmp.ps"
  ${FILE}gs_resst.ps"
  ${FILE}gs_s.xbm"
  ${FILE}gs_s.xpm"
  ${FILE}gs_sepr.ps"
  ${FILE}gs_setpd.ps"
  ${FILE}gs_statd.ps"
  ${FILE}gs_std_e.ps"
  ${FILE}gs_sym_e.ps"
  ${FILE}gs_s_m.xbm"
  ${FILE}gs_t.xbm"
  ${FILE}gs_t.xpm"
  ${FILE}gs_trap.ps"
  ${FILE}gs_ttf.ps"
  ${FILE}gs_typ32.ps"
  ${FILE}gs_typ42.ps"
  ${FILE}gs_type1.ps"
  ${FILE}gs_t_m.xbm"
  ${FILE}gs_wan_e.ps"
  ${FILE}gs_wl1_e.ps"
  ${FILE}gs_wl2_e.ps"
  ${FILE}gs_wl5_e.ps"
  ${FILE}ht_ccsto.ps"
  ${FILE}image-qa.ps"
  ${FILE}impath.ps"
  ${FILE}Info-macos.plist"
  ${FILE}jispaper.ps"
  ${FILE}jobseparator.ps"
  ${FILE}landscap.ps"
  ${FILE}level1.ps"
  ${FILE}lines.ps"
  ${FILE}lp386.bat"
  ${FILE}lp386r2.bat"
  ${FILE}lpgs.bat"
  ${FILE}lpr2.bat"
  ${FILE}lprsetup.sh"
  ${FILE}markhint.ps"
  ${FILE}markpath.ps"
  ${FILE}mkcidfm.ps"
  ${FILE}necp2x.upp"
  ${FILE}necp2x6.upp"
  ${FILE}opdfread.ps"
  ${FILE}packfile.ps"
  ${FILE}pcharstr.ps"
  ${FILE}pdf2dsc"
  ${FILE}pdf2dsc.bat"
  ${FILE}pdf2dsc.ps"
  ${FILE}pdf2ps"
  ${FILE}pdf2ps.bat"
  ${FILE}pdf2ps.cmd"
  ${FILE}PDFA_def.ps"
  ${FILE}pdfopt"
  ${FILE}pdfopt.bat"
  ${FILE}pdfopt.ps"
  ${FILE}pdfwrite.ps"
  ${FILE}PDFX_def.ps"
  ${FILE}pdf_base.ps"
  ${FILE}pdf_cslayer.ps"
  ${FILE}pdf_draw.ps"
  ${FILE}pdf_font.ps"
  ${FILE}pdf_main.ps"
  ${FILE}pdf_ops.ps"
  ${FILE}pdf_rbld.ps"
  ${FILE}pdf_sec.ps"
  ${FILE}pf2afm"
  ${FILE}pf2afm.bat"
  ${FILE}pf2afm.cmd"
  ${FILE}pf2afm.ps"
  ${FILE}pfbtopfa"
  ${FILE}pfbtopfa.bat"
  ${FILE}pfbtopfa.ps"
  ${FILE}pftogsf.bat"
  ${FILE}ppath.ps"
  ${FILE}pphs"
  ${FILE}pphs.ps"
  ${FILE}prfont.ps"
  ${FILE}printafm"
  ${FILE}printafm.ps"
  ${FILE}ps2ai.ps"
  ${FILE}ps2ascii"
  ${FILE}ps2ascii.bat"
  ${FILE}ps2ascii.cmd"
  ${FILE}ps2ascii.ps"
  ${FILE}ps2epsi"
  ${FILE}ps2epsi.bat"
  ${FILE}ps2epsi.cmd"
  ${FILE}ps2epsi.ps"
  ${FILE}ps2pdf"
  ${FILE}ps2pdf.bat"
  ${FILE}ps2pdf.cmd"
  ${FILE}ps2pdf12"
  ${FILE}ps2pdf12.bat"
  ${FILE}ps2pdf12.cmd"
  ${FILE}ps2pdf13"
  ${FILE}ps2pdf13.bat"
  ${FILE}ps2pdf13.cmd"
  ${FILE}ps2pdf14"
  ${FILE}ps2pdf14.bat"
  ${FILE}ps2pdf14.cmd"
  ${FILE}ps2pdfwr"
  ${FILE}ps2pdfxx.bat"
  ${FILE}ps2ps"
  ${FILE}ps2ps.bat"
  ${FILE}ps2ps.cmd"
  ${FILE}ps2ps2"
  ${FILE}ps2ps2.bat"
  ${FILE}ps2ps2.cmd"
  ${FILE}pv.sh"
  ${FILE}quit.ps"
  ${FILE}ras1.upp"
  ${FILE}ras24.upp"
  ${FILE}ras3.upp"
  ${FILE}ras32.upp"
  ${FILE}ras4.upp"
  ${FILE}ras8m.upp"
  ${FILE}rinkj-2200-setup"
  ${FILE}rollconv.ps"
  ${FILE}showchar.ps"
  ${FILE}showpage.ps"
  ${FILE}st640ih.upp"
  ${FILE}st640ihg.upp"
  ${FILE}st640p.upp"
  ${FILE}st640pg.upp"
  ${FILE}st640pl.upp"
  ${FILE}st640plg.upp"
  ${FILE}stc.upp"
  ${FILE}stc1520h.upp"
  ${FILE}stc2.upp"
  ${FILE}stc200_h.upp"
  ${FILE}stc2s_h.upp"
  ${FILE}stc2_h.upp"
  ${FILE}stc300.upp"
  ${FILE}stc300bl.upp"
  ${FILE}stc300bm.upp"
  ${FILE}stc500p.upp"
  ${FILE}stc500ph.upp"
  ${FILE}stc600ih.upp"
  ${FILE}stc600p.upp"
  ${FILE}stc600pl.upp"
  ${FILE}stc640p.upp"
  ${FILE}stc800ih.upp"
  ${FILE}stc800p.upp"
  ${FILE}stc800pl.upp"
  ${FILE}stcany.upp"
  ${FILE}stcany_h.upp"
  ${FILE}stcinfo.ps"
  ${FILE}stcolor.ps"
  ${FILE}stc_h.upp"
  ${FILE}stc_l.upp"
  ${FILE}stocht.ps"
  ${FILE}traceimg.ps"
  ${FILE}traceop.ps"
  ${FILE}type1enc.ps"
  ${FILE}type1ops.ps"
  ${FILE}uninfo.ps"
  ${FILE}unix-lpr.sh"
  ${FILE}unprot.ps"
  ${FILE}viewcmyk.ps"
  ${FILE}viewgif.ps"
  ${FILE}viewjpeg.ps"
  ${FILE}viewmiff.ps"
  ${FILE}viewpbm.ps"
  ${FILE}viewpcx.ps"
  ${FILE}viewps2a.ps"
  ${FILE}wftopfa"
  ${FILE}wftopfa.ps"
  ${FILE}winmaps.ps"
  ${FILE}wmakebat.bat"
  ${FILE}wrfont.ps"
  ${FILE}xlatmap"
  ${FILE}zeroline.ps"

!macroend

!macro FileListGhostscriptFonts COMMAND DIRECTORY

  ${FILE}a010013l.afm"
  ${FILE}a010013l.pfb"
  ${FILE}a010013l.pfm"
  ${FILE}a010015l.afm"
  ${FILE}a010015l.pfb"
  ${FILE}a010015l.pfm"
  ${FILE}a010033l.afm"
  ${FILE}a010033l.pfb"
  ${FILE}a010033l.pfm"
  ${FILE}a010035l.afm"
  ${FILE}a010035l.pfb"
  ${FILE}a010035l.pfm"
  ${FILE}b018012l.afm"
  ${FILE}b018012l.pfb"
  ${FILE}b018012l.pfm"
  ${FILE}b018015l.afm"
  ${FILE}b018015l.pfb"
  ${FILE}b018015l.pfm"
  ${FILE}b018032l.afm"
  ${FILE}b018032l.pfb"
  ${FILE}b018032l.pfm"
  ${FILE}b018035l.afm"
  ${FILE}b018035l.pfb"
  ${FILE}b018035l.pfm"
  ${FILE}c059013l.afm"
  ${FILE}c059013l.pfb"
  ${FILE}c059016l.afm"
  ${FILE}c059016l.pfb"
  ${FILE}c059033l.afm"
  ${FILE}c059033l.pfb"
  ${FILE}c059036l.afm"
  ${FILE}c059036l.pfb"
  ${FILE}ChangeLog"
  ${FILE}COPYING"
  ${FILE}d050000l.afm"
  ${FILE}d050000l.pfb"
  ${FILE}fonts.dir"
  ${FILE}fonts.scale"
  ${FILE}n019003l.afm"
  ${FILE}n019003l.pfb"
  ${FILE}n019003l.pfm"
  ${FILE}n019004l.afm"
  ${FILE}n019004l.pfb"
  ${FILE}n019004l.pfm"
  ${FILE}n019023l.afm"
  ${FILE}n019023l.pfb"
  ${FILE}n019023l.pfm"
  ${FILE}n019024l.afm"
  ${FILE}n019024l.pfb"
  ${FILE}n019024l.pfm"
  ${FILE}n019043l.afm"
  ${FILE}n019043l.pfb"
  ${FILE}n019044l.afm"
  ${FILE}n019044l.pfb"
  ${FILE}n019063l.afm"
  ${FILE}n019063l.pfb"
  ${FILE}n019064l.afm"
  ${FILE}n019064l.pfb"
  ${FILE}n019064l.pfm"
  ${FILE}n021003l.afm"
  ${FILE}n021003l.pfb"
  ${FILE}n021003l.pfm"
  ${FILE}n021004l.afm"
  ${FILE}n021004l.pfb"
  ${FILE}n021004l.pfm"
  ${FILE}n021023l.afm"
  ${FILE}n021023l.pfb"
  ${FILE}n021023l.pfm"
  ${FILE}n021024l.afm"
  ${FILE}n021024l.pfb"
  ${FILE}n021024l.pfm"
  ${FILE}n022003l.afm"
  ${FILE}n022003l.pfb"
  ${FILE}n022004l.afm"
  ${FILE}n022004l.pfb"
  ${FILE}n022023l.afm"
  ${FILE}n022023l.pfb"
  ${FILE}n022024l.afm"
  ${FILE}n022024l.pfb"
  ${FILE}p052003l.afm"
  ${FILE}p052003l.pfb"
  ${FILE}p052004l.afm"
  ${FILE}p052004l.pfb"
  ${FILE}p052023l.afm"
  ${FILE}p052023l.pfb"
  ${FILE}p052024l.afm"
  ${FILE}p052024l.pfb"
  ${FILE}README"
  ${FILE}README.tweaks"
  ${FILE}s050000l.afm"
  ${FILE}s050000l.pfb"
  ${FILE}TODO"
  ${FILE}uninstal.txt"
  ${FILE}z003034l.afm"
  ${FILE}z003034l.pfb"
  ${FILE}z003034l.pfm"

!macroend

!macro FileListGhostscriptResourceCMap COMMAND DIRECTORY

  ${FILE}78-EUC-H"
  ${FILE}78-EUC-V"
  ${FILE}78-H"
  ${FILE}78-RKSJ-H"
  ${FILE}78-RKSJ-V"
  ${FILE}78-V"
  ${FILE}78ms-RKSJ-H"
  ${FILE}78ms-RKSJ-V"
  ${FILE}83pv-RKSJ-H"
  ${FILE}90ms-RKSJ-H"
  ${FILE}90ms-RKSJ-UCS2"
  ${FILE}90ms-RKSJ-V"
  ${FILE}90msp-RKSJ-H"
  ${FILE}90msp-RKSJ-V"
  ${FILE}90pv-RKSJ-H"
  ${FILE}90pv-RKSJ-UCS2"
  ${FILE}90pv-RKSJ-UCS2C"
  ${FILE}90pv-RKSJ-V"
  ${FILE}Add-H"
  ${FILE}Add-RKSJ-H"
  ${FILE}Add-RKSJ-V"
  ${FILE}Add-V"
  ${FILE}Adobe-CNS1-0"
  ${FILE}Adobe-CNS1-1"
  ${FILE}Adobe-CNS1-2"
  ${FILE}Adobe-CNS1-3"
  ${FILE}Adobe-CNS1-4"
  ${FILE}Adobe-CNS1-5"
  ${FILE}Adobe-CNS1-B5pc"
  ${FILE}Adobe-CNS1-ETenms-B5"
  ${FILE}Adobe-CNS1-H-CID"
  ${FILE}Adobe-CNS1-H-Host"
  ${FILE}Adobe-CNS1-H-Mac"
  ${FILE}Adobe-CNS1-UCS2"
  ${FILE}Adobe-GB1-0"
  ${FILE}Adobe-GB1-1"
  ${FILE}Adobe-GB1-2"
  ${FILE}Adobe-GB1-3"
  ${FILE}Adobe-GB1-4"
  ${FILE}Adobe-GB1-5"
  ${FILE}Adobe-GB1-GBK-EUC"
  ${FILE}Adobe-GB1-GBpc-EUC"
  ${FILE}Adobe-GB1-H-CID"
  ${FILE}Adobe-GB1-H-Host"
  ${FILE}Adobe-GB1-H-Mac"
  ${FILE}Adobe-GB1-UCS2"
  ${FILE}Adobe-Japan1-0"
  ${FILE}Adobe-Japan1-1"
  ${FILE}Adobe-Japan1-2"
  ${FILE}Adobe-Japan1-3"
  ${FILE}Adobe-Japan1-4"
  ${FILE}Adobe-Japan1-5"
  ${FILE}Adobe-Japan1-6"
  ${FILE}Adobe-Japan1-90ms-RKSJ"
  ${FILE}Adobe-Japan1-90pv-RKSJ"
  ${FILE}Adobe-Japan1-H-CID"
  ${FILE}Adobe-Japan1-H-Host"
  ${FILE}Adobe-Japan1-H-Mac"
  ${FILE}Adobe-Japan1-PS-H"
  ${FILE}Adobe-Japan1-PS-V"
  ${FILE}Adobe-Japan1-UCS2"
  ${FILE}Adobe-Japan2-0"
  ${FILE}Adobe-Korea1-0"
  ${FILE}Adobe-Korea1-1"
  ${FILE}Adobe-Korea1-2"
  ${FILE}Adobe-Korea1-H-CID"
  ${FILE}Adobe-Korea1-H-Host"
  ${FILE}Adobe-Korea1-H-Mac"
  ${FILE}Adobe-Korea1-KSCms-UHC"
  ${FILE}Adobe-Korea1-KSCpc-EUC"
  ${FILE}Adobe-Korea1-UCS2"
  ${FILE}B5-H"
  ${FILE}B5-V"
  ${FILE}B5pc-H"
  ${FILE}B5pc-UCS2"
  ${FILE}B5pc-UCS2C"
  ${FILE}B5pc-V"
  ${FILE}CNS-EUC-H"
  ${FILE}CNS-EUC-V"
  ${FILE}CNS01-RKSJ-H"
  ${FILE}CNS02-RKSJ-H"
  ${FILE}CNS03-RKSJ-H"
  ${FILE}CNS04-RKSJ-H"
  ${FILE}CNS05-RKSJ-H"
  ${FILE}CNS06-RKSJ-H"
  ${FILE}CNS07-RKSJ-H"
  ${FILE}CNS1-H"
  ${FILE}CNS1-V"
  ${FILE}CNS15-RKSJ-H"
  ${FILE}CNS2-H"
  ${FILE}CNS2-V"
  ${FILE}ETen-B5-H"
  ${FILE}ETen-B5-UCS2"
  ${FILE}ETen-B5-V"
  ${FILE}ETenms-B5-H"
  ${FILE}ETenms-B5-V"
  ${FILE}ETHK-B5-H"
  ${FILE}ETHK-B5-V"
  ${FILE}EUC-H"
  ${FILE}EUC-V"
  ${FILE}Ext-H"
  ${FILE}Ext-RKSJ-H"
  ${FILE}Ext-RKSJ-V"
  ${FILE}Ext-V"
  ${FILE}GB-EUC-H"
  ${FILE}GB-EUC-V"
  ${FILE}GB-H"
  ${FILE}GB-RKSJ-H"
  ${FILE}GB-V"
  ${FILE}GBK-EUC-H"
  ${FILE}GBK-EUC-UCS2"
  ${FILE}GBK-EUC-V"
  ${FILE}GBK2K-H"
  ${FILE}GBK2K-V"
  ${FILE}GBKp-EUC-H"
  ${FILE}GBKp-EUC-V"
  ${FILE}GBpc-EUC-H"
  ${FILE}GBpc-EUC-UCS2"
  ${FILE}GBpc-EUC-UCS2C"
  ${FILE}GBpc-EUC-V"
  ${FILE}GBT-EUC-H"
  ${FILE}GBT-EUC-V"
  ${FILE}GBT-H"
  ${FILE}GBT-RKSJ-H"
  ${FILE}GBT-V"
  ${FILE}GBTpc-EUC-H"
  ${FILE}GBTpc-EUC-V"
  ${FILE}H"
  ${FILE}Hankaku"
  ${FILE}Hiragana"
  ${FILE}HK-RKSJ-H"
  ${FILE}HKdla-B5-H"
  ${FILE}HKdla-B5-V"
  ${FILE}HKdlb-B5-H"
  ${FILE}HKdlb-B5-V"
  ${FILE}HKgccs-B5-H"
  ${FILE}HKgccs-B5-V"
  ${FILE}HKm314-B5-H"
  ${FILE}HKm314-B5-V"
  ${FILE}HKm471-B5-H"
  ${FILE}HKm471-B5-V"
  ${FILE}HKscs-B5-H"
  ${FILE}HKscs-B5-V"
  ${FILE}Hojo-EUC-H"
  ${FILE}Hojo-EUC-V"
  ${FILE}Hojo-H"
  ${FILE}Hojo-RKSJ-H"
  ${FILE}Hojo-V"
  ${FILE}Identity-H"
  ${FILE}Identity-UTF16-H"
  ${FILE}Identity-UTF16-V"
  ${FILE}Identity-V"
  ${FILE}Katakana"
  ${FILE}KSC-EUC-H"
  ${FILE}KSC-EUC-V"
  ${FILE}KSC-H"
  ${FILE}KSC-Johab-H"
  ${FILE}KSC-Johab-V"
  ${FILE}KSC-RKSJ-H"
  ${FILE}KSC-V"
  ${FILE}KSC2-RKSJ-H"
  ${FILE}KSCms-UHC-H"
  ${FILE}KSCms-UHC-HW-H"
  ${FILE}KSCms-UHC-HW-V"
  ${FILE}KSCms-UHC-UCS2"
  ${FILE}KSCms-UHC-V"
  ${FILE}KSCpc-EUC-H"
  ${FILE}KSCpc-EUC-UCS2"
  ${FILE}KSCpc-EUC-UCS2C"
  ${FILE}KSCpc-EUC-V"
  ${FILE}NWP-H"
  ${FILE}NWP-V"
  ${FILE}RKSJ-H"
  ${FILE}RKSJ-V"
  ${FILE}Roman"
  ${FILE}TCVN-RKSJ-H"
  ${FILE}UCS2-90ms-RKSJ"
  ${FILE}UCS2-90pv-RKSJ"
  ${FILE}UCS2-B5pc"
  ${FILE}UCS2-ETen-B5"
  ${FILE}UCS2-GBK-EUC"
  ${FILE}UCS2-GBpc-EUC"
  ${FILE}UCS2-KSCms-UHC"
  ${FILE}UCS2-KSCpc-EUC"
  ${FILE}UniCNS-UCS2-H"
  ${FILE}UniCNS-UCS2-V"
  ${FILE}UniCNS-UTF16-H"
  ${FILE}UniCNS-UTF16-V"
  ${FILE}UniCNS-UTF32-H"
  ${FILE}UniCNS-UTF32-V"
  ${FILE}UniCNS-UTF8-H"
  ${FILE}UniCNS-UTF8-V"
  ${FILE}UniGB-UCS2-H"
  ${FILE}UniGB-UCS2-V"
  ${FILE}UniGB-UTF16-H"
  ${FILE}UniGB-UTF16-V"
  ${FILE}UniGB-UTF32-H"
  ${FILE}UniGB-UTF32-V"
  ${FILE}UniGB-UTF8-H"
  ${FILE}UniGB-UTF8-V"
  ${FILE}UniHojo-UCS2-H"
  ${FILE}UniHojo-UCS2-V"
  ${FILE}UniHojo-UTF16-H"
  ${FILE}UniHojo-UTF16-V"
  ${FILE}UniHojo-UTF32-H"
  ${FILE}UniHojo-UTF32-V"
  ${FILE}UniHojo-UTF8-H"
  ${FILE}UniHojo-UTF8-V"
  ${FILE}UniJIS-UCS2-H"
  ${FILE}UniJIS-UCS2-HW-H"
  ${FILE}UniJIS-UCS2-HW-V"
  ${FILE}UniJIS-UCS2-V"
  ${FILE}UniJIS-UTF16-H"
  ${FILE}UniJIS-UTF16-V"
  ${FILE}UniJIS-UTF32-H"
  ${FILE}UniJIS-UTF32-V"
  ${FILE}UniJIS-UTF8-H"
  ${FILE}UniJIS-UTF8-V"
  ${FILE}UniJIS2004-UTF16-H"
  ${FILE}UniJIS2004-UTF16-V"
  ${FILE}UniJIS2004-UTF32-H"
  ${FILE}UniJIS2004-UTF32-V"
  ${FILE}UniJIS2004-UTF8-H"
  ${FILE}UniJIS2004-UTF8-V"
  ${FILE}UniJISPro-UCS2-HW-V"
  ${FILE}UniJISPro-UCS2-V"
  ${FILE}UniJISPro-UTF8-V"
  ${FILE}UniJISX0213-UTF32-H"
  ${FILE}UniJISX0213-UTF32-V"
  ${FILE}UniJISX02132004-UTF32-H"
  ${FILE}UniJISX02132004-UTF32-V"
  ${FILE}UniKS-UCS2-H"
  ${FILE}UniKS-UCS2-V"
  ${FILE}UniKS-UTF16-H"
  ${FILE}UniKS-UTF16-V"
  ${FILE}UniKS-UTF32-H"
  ${FILE}UniKS-UTF32-V"
  ${FILE}UniKS-UTF8-H"
  ${FILE}UniKS-UTF8-V"
  ${FILE}V"
  ${FILE}WP-Symbol"

!macroend

!macro FileListGhostscriptResourceColorSpace COMMAND DIRECTORY

  ${FILE}DefaultCMYK"
  ${FILE}DefaultGray"
  ${FILE}DefaultRGB"
  ${FILE}TrivialCMYK"

!macroend

!macro FileListGhostscriptResourceDecoding COMMAND DIRECTORY

  ${FILE}FCO_Dingbats"
  ${FILE}FCO_Symbol"
  ${FILE}FCO_Unicode"
  ${FILE}FCO_Wingdings"
  ${FILE}Latin1"
  ${FILE}StandardEncoding"
  ${FILE}Unicode"

!macroend

!macro FileListGhostscriptResourceEncoding COMMAND DIRECTORY

  ${FILE}Wingdings"

!macroend
