/*****************************************************************************/
/* td_mod_tree_icon.h : Objet Gtk+
 * td_mod_tree_icon.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_TREE_ICON (td_mod_tree_icon_get_type())
#define TD_MOD_TREE_ICON(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_TREE_ICON, TdModTreeIcon))
#define TD_MOD_TREE_ICON_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_TREE_ICON, TdModTreeIconClass))
#define TD_IS_MOD_TREE_ICON(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_TREE_ICON))
#define TD_IS_MOD_TREE_ICON_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_TREE_ICON))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdModTreeIcon TdModTreeIcon;
typedef struct _TdModTreeIconClass TdModTreeIconClass;

struct _TdModTreeIcon
{
  /*< public >*/
  GtkObject object;
  gchar *pixmap1; /*** Image */
  gchar *pixmap2; /*** Masque - Mask */
  gchar *query_visible; /*** Requte de visibilit - Query of visisbility */
};

struct _TdModTreeIconClass
{
  GtkObjectClass parent_class;
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_mod_tree_icon_set_pixmap1 (TdModTreeIcon *mod_tree_icon, gchar *pixmap1);
static void td_mod_tree_icon_set_pixmap2 (TdModTreeIcon *mod_tree_icon, gchar *pixmap2);
static void td_mod_tree_icon_set_query_visible (TdModTreeIcon *mod_tree_icon, gchar *query_visible);
static void td_mod_tree_icon_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_tree_icon_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_tree_icon_init (TdModTreeIcon *mod_tree_icon);
static void td_mod_tree_icon_class_init (TdModTreeIconClass *klass);
GtkType td_mod_tree_icon_get_type (void);
GtkObject *td_mod_tree_icon_new (void);

/*****************************************************************************/
/*** Commande */
/*****************************************************************************/
void td_mod_tree_icon_set (TdModTreeIcon *mod_tree_icon, gchar *value);
