/*****************************************************************************/
/* td_mod_stree.c : Objet Gtk+
 * td_mod_stree.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "gtdk.h"
#include "td_app.h"
#include "td_mod_stree.h"
#include "td_flower.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_NAME_PARENT,
  ARG_ID,
  ARG_ID_PARENT,
};

static void td_mod_stree_set_name (TdModStree *mod_stree, gchar *name)
{
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));
  if (mod_stree->name != name)
    {
      mod_stree->name = name;
      mod_stree->label = gtk_label_new (name);
    }
}

static void td_mod_stree_set_name_parent (TdModStree *mod_stree, gchar *name_parent)
{
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));
  if (mod_stree->name_parent != name_parent)
    mod_stree->name_parent = name_parent;
}

static void td_mod_stree_set_id (TdModStree *mod_stree, int id)
{
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));
  if (mod_stree->id != id)
    mod_stree->id = id;
}

static void td_mod_stree_set_id_parent (TdModStree *mod_stree, int id_parent)
{
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));
  if (mod_stree->id_parent != id_parent)
    mod_stree->id_parent = id_parent;
}

static void td_mod_stree_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModStree *mod_stree;
  mod_stree = TD_MOD_STREE (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_stree_set_name (mod_stree, GTK_VALUE_STRING (*arg));
      break;
    case ARG_NAME_PARENT:
      td_mod_stree_set_name_parent (mod_stree, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ID:
      td_mod_stree_set_id (mod_stree, GTK_VALUE_INT (*arg));
      break;
    case ARG_ID_PARENT:
      td_mod_stree_set_id_parent (mod_stree, GTK_VALUE_INT (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_stree_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModStree *mod_stree;
  mod_stree = TD_MOD_STREE (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod_stree->name;
      break;
    case ARG_NAME_PARENT:
      GTK_VALUE_STRING (*arg) = mod_stree->name_parent;
      break;
    case ARG_ID:
      GTK_VALUE_INT (*arg) = mod_stree->id;
      break;
    case ARG_ID_PARENT:
      GTK_VALUE_INT (*arg) = mod_stree->id_parent;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_stree_init (TdModStree *mod_stree)
{
  mod_stree->name = NULL;
  mod_stree->name_parent = NULL;
  mod_stree->id = -1;
  mod_stree->id_parent = -1;
  mod_stree->label = NULL;

  mod_stree->widget = NULL;
  mod_stree->widget_data = NULL;
  mod_stree->default_menu = NULL;
}

static void td_mod_stree_class_init (TdModStreeClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModStree::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdModStree::name_parent", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME_PARENT);
  gtk_object_add_arg_type ("TdModStree::id", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_ID);
  gtk_object_add_arg_type ("TdModStree::id_parent", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_ID_PARENT);
  object_class->set_arg = td_mod_stree_set_arg;
  object_class->get_arg = td_mod_stree_get_arg;
  klass->set_default_menu = td_mod_stree_set_default_menu;
  klass->create = td_mod_stree_create;
}

GtkType td_mod_stree_get_type (void)
{
  static GtkType mod_stree_type = 0;
  if (!mod_stree_type)
    {
      static const GtkTypeInfo mod_stree_info =
      {
  	"TdModStree", sizeof (TdModStree), sizeof (TdModStreeClass),
  	(GtkClassInitFunc) td_mod_stree_class_init,
	(GtkObjectInitFunc) td_mod_stree_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_stree_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_stree_info);
    }
  return mod_stree_type;
}

/**
 * td_mod_stree_new:
 * 
 * fr: Cr un nouveau arbre
 *
 * en: Creates a new tree
 * 
 * Return value: tree
 **/

GtkObject *td_mod_stree_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_stree_get_type()));
}

/**
 * td_mod_stree_destroy:
 * @mod_stree: tree
 * 
 * fr: Dtruit l'arbre
 *
 * en: Destroys the tree
 **/

void td_mod_stree_destroy (TdModStree *mod_stree)
{
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));
  gtk_object_destroy (GTK_OBJECT (mod_stree));
}

/**
 * td_mod_stree_show:
 * @mod_stree: tree
 * 
 * fr: Affiche l'arbre
 *
 * en: Displays the tree
 **/

void td_mod_stree_show (TdModStree *mod_stree)
{
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));
}

/**
 * td_mod_stree_hide:
 * @mod_stree: tree
 * 
 * fr: Cache l'arbre
 *
 * en: Hides the tree
 **/

void td_mod_stree_hide (TdModStree *mod_stree)
{
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_mod_stree_set_default_menu:
 * @mod_stree: tree
 * @default_menu: menu
 *
 * fr: Affecte le menu  l'arbre
 *
 * en: Allocates the menu to tree
 **/

void td_mod_stree_set_default_menu (TdModStree *mod_stree, GtkWidget *default_menu)
{
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));
  if (mod_stree->default_menu != default_menu)
    mod_stree->default_menu = default_menu;
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_mod_stree_create:
 * @mod_stree: tree
 * @id: component identifier
 * @id_parent: module identifier
 * 
 * fr: Cr l'interface du composant du module
 *
 * en: Creates the interface of component of module
 **/

void td_mod_stree_create (TdModStree *mod_stree, int id, int id_parent)
{
  GtkWidget *vbox;
  GtkWidget *button;
  GtkWidget *scrolledwindow;
  GtkWidget *tree;
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));

  /*** Titre - Title */
  mod_stree->id = id;
  mod_stree->id_parent = id_parent;
  mod_stree->widget = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (mod_stree->widget);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (mod_stree->widget), vbox);
  button = gtk_button_new_with_label (mod_stree->name);
  gtk_widget_show (button);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);

  /*** Arbre - Tree */
  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_start (GTK_BOX (vbox), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  mod_stree->widget_data = gtk_tree_new();
  gtk_widget_show (mod_stree->widget_data);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolledwindow), mod_stree->widget_data);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolledwindow)->child), GTK_SHADOW_NONE);
  gtk_widget_set_usize (mod_stree->widget_data, 0, -2);
  /*** Appels arbre - Calls tree *//*** FIXME: Les appels dfinis par dfaut gnent => +tards - Defaults calls disturb => this night */
  /* gtk_signal_connect (GTK_OBJECT (mod_stree->widget_data), "button_press_event", GTK_SIGNAL_FUNC (td_mod_stree_button_press), mod_stree); */
}

/**
 * td_mod_stree_button_press:
 * @widget: tree widget
 * @event: event button
 * @mod_stree: tree
 * 
 * fr: Evnement 'button_press' de l'arbre
 *
 * en: Event 'button_press' of tree
 **/

void td_mod_stree_button_press (GtkWidget *widget, GdkEventButton *event, TdModStree *mod_stree)
{
  GdkEventButton *bevent;
  bevent = (GdkEventButton*) event;
  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));

  /*** Menu item */
  if (bevent->button == 3)
    if (mod_stree->default_menu)
      gtk_menu_popup (GTK_MENU (TD_MOD_STREE (mod_stree)->default_menu), NULL, NULL, NULL, NULL, bevent->button, bevent->time);

  /*** Menu principal - Main menu */
  if (bevent->button == 2)
    gnome_popup_menu_do_popup (TD_APP (APP)->menu_main, NULL, NULL, bevent, NULL);
}

/*****************************************************************************/
/*** Fichier support - Support file */
/*****************************************************************************/

/**
 * td_mod_stree_item_set_label:
 * @tree_item: node of tree widget
 * @data: text
 * @mod_stree: tree
 * @width: width available
 * 
 * fr: Ecris la donne dans la node
 *
 * en: Writes the data in the node
 **/

void td_mod_stree_item_set_label (GtkWidget *tree_item, gchar *data, TdModStree *mod_stree, int width)
{
  GtkAdjustment* adjustment;
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *label_end;
  gchar *txt_tmp;

  /*** Go ! */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER (tree_item), hbox);
  label = gtk_label_new (data);
  gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 5);
  gtk_widget_set_usize (label, width, -2);

  /*** Etiquette '\n' - Label '\n' */
  label_end = gtk_label_new ("");
  gtk_widget_show (label_end);
  gtk_box_pack_start (GTK_BOX (hbox), label_end, TRUE, TRUE, 0);
}

/**
 * td_mod_stree_load_flower:
 * @mod_stree: tree
 * @flower: flower
 * 
 * fr: Affiche l'arborescence de la fleur dans le composant
 *
 * en: Displays the flower's tree in the component
 **/

void td_mod_stree_load_flower (TdModStree *mod_stree, GtkObject *flower)
{
  GtkWidget *node = NULL;
  GtkWidget *node1 = NULL;
  GtkWidget *node2 = NULL;
  GtkWidget *tree1 = NULL;
  GtkWidget *tree2 = NULL;
  int width;
  int i;
  gboolean node1_continue = FALSE;
  gboolean node2_continue = FALSE;

  g_return_if_fail (mod_stree != NULL);
  g_return_if_fail (TD_IS_MOD_STREE (mod_stree));

  /*** Taille de le fentre pour ajuster les tiquettes - Window size for ajust labels */
  width = gtdk_geometry_get (mod_stree->name_parent, "size x");
  /*** BIDOUILLE: le 32 - the 32 */
  if (width<0)
    width = 600-32-10;
  else
    width = width-32-10;

  /*** Affichage des lignes - Displaying line */
  if (!TD_FLOWER (flower)->petal)
    gtk_tree_set_view_lines (GTK_TREE (mod_stree->widget_data), FALSE);

  /*** Go ! */
  for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
    {
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 0)
	{
	  node = gtk_tree_item_new();
	  gtk_widget_show (node);
	  td_mod_stree_item_set_label (node, g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0), mod_stree, width-(GTK_TREE (mod_stree->widget_data)->indent_value));
	  gtk_tree_append (GTK_TREE (mod_stree->widget_data), node);
	  node1_continue = FALSE;
	  node2_continue = FALSE;
	}
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 1)
	{
	  if (!node1_continue)
	    {
	      tree1 = gtk_tree_new();
	      gtk_widget_show (tree1);
	      gtk_tree_item_set_subtree (GTK_TREE_ITEM (node), tree1);
	    }
	  node1 = gtk_tree_item_new();
	  gtk_widget_show (node1);
	  td_mod_stree_item_set_label (node1, g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0), mod_stree, width-((GTK_TREE (tree1)->indent_value)*2));
	  gtk_tree_append (GTK_TREE (tree1), node1);
	  node1_continue = TRUE;
	  node2_continue = FALSE;
	}
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 2)
	{
	  if (!node2_continue)
	    {
	      tree2 = gtk_tree_new();
	      gtk_widget_show (tree2);
	      gtk_tree_item_set_subtree (GTK_TREE_ITEM (node1), tree2);
	    }
	  node2 = gtk_tree_item_new();
	  gtk_widget_show (node2);
	  td_mod_stree_item_set_label (node2, g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0), mod_stree, width-((GTK_TREE (tree2)->indent_value)*3));
	  gtk_tree_append (GTK_TREE (tree2), node2);
	  node2_continue = TRUE;
	}
    }
}
