/*****************************************************************************/
/* td_mod_menu.c : Objet Gtk+
 * td_mod_menu.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "td_mod_menu.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_LABEL,
  ARG_ICON,
  ARG_TYPE,
  ARG_QUERY_VISIBLE,
  ARG_QUERY_UNSENSITIVE,
};

static void td_mod_menu_set_label (TdModMenu *mod_menu, gchar *label)
{
  g_return_if_fail (mod_menu != NULL);
  g_return_if_fail (TD_IS_MOD_MENU (mod_menu));
  if (mod_menu->label != label)
    mod_menu->label = label;
}

static void td_mod_menu_set_icon (TdModMenu *mod_menu, gchar *icon)
{
  g_return_if_fail (mod_menu != NULL);
  g_return_if_fail (TD_IS_MOD_MENU (mod_menu));
  if (mod_menu->icon != icon)
    mod_menu->icon = icon;
}

static void td_mod_menu_set_type (TdModMenu *mod_menu, gchar *type)
{
  g_return_if_fail (mod_menu != NULL);
  g_return_if_fail (TD_IS_MOD_MENU (mod_menu));
  if (mod_menu->type != type)
    mod_menu->type = type;
}

static void td_mod_menu_set_query_visible (TdModMenu *mod_menu, gchar *query_visible)
{
  g_return_if_fail (mod_menu != NULL);
  g_return_if_fail (TD_IS_MOD_MENU (mod_menu));
  if (mod_menu->query_visible != query_visible)
    mod_menu->query_visible = query_visible;
}

static void td_mod_menu_set_query_unsensitive (TdModMenu *mod_menu, gchar *query_unsensitive)
{
  g_return_if_fail (mod_menu != NULL);
  g_return_if_fail (TD_IS_MOD_MENU (mod_menu));
  if (mod_menu->query_unsensitive != query_unsensitive)
    mod_menu->query_unsensitive = query_unsensitive;
}

static void td_mod_menu_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModMenu *mod_menu;
  mod_menu = TD_MOD_MENU (object);
  switch (arg_id)
    {
    case ARG_LABEL:
      td_mod_menu_set_label (mod_menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ICON:
      td_mod_menu_set_icon (mod_menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TYPE:
      td_mod_menu_set_type (mod_menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_VISIBLE:
      td_mod_menu_set_query_visible (mod_menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_UNSENSITIVE:
      td_mod_menu_set_query_unsensitive (mod_menu, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_menu_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModMenu *mod_menu;
  mod_menu = TD_MOD_MENU (object);
  switch (arg_id)
    {
    case ARG_LABEL:
      GTK_VALUE_STRING (*arg) = mod_menu->label;
      break;
    case ARG_ICON:
      GTK_VALUE_STRING (*arg) = mod_menu->icon;
      break;
    case ARG_TYPE:
      GTK_VALUE_STRING (*arg) = mod_menu->type;
      break;
    case ARG_QUERY_VISIBLE:
      GTK_VALUE_STRING (*arg) = mod_menu->query_visible;
      break;
    case ARG_QUERY_UNSENSITIVE:
      GTK_VALUE_STRING (*arg) = mod_menu->query_unsensitive;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/**** Initialisation */
/*****************************************************************************/
static void td_mod_menu_init (TdModMenu *mod_menu)
{
  mod_menu->label = NULL;
  mod_menu->icon = NULL;
  mod_menu->type = "custom";
  mod_menu->widget = NULL;
  mod_menu->query_visible = NULL;
  mod_menu->query_unsensitive = NULL;
}

static void td_mod_menu_class_init (TdModMenuClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModMenu::label", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LABEL);
  gtk_object_add_arg_type ("TdModMenu::icon", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_ICON);
  gtk_object_add_arg_type ("TdModMenu::type", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TYPE);
  gtk_object_add_arg_type ("TdModMenu::query_visible", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_VISIBLE);
  gtk_object_add_arg_type ("TdModMenu::query_unsensitive", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_UNSENSITIVE);
  object_class->set_arg = td_mod_menu_set_arg;
  object_class->get_arg = td_mod_menu_get_arg;
}

GtkType td_mod_menu_get_type (void)
{
  static GtkType mod_menu_type = 0;
  if (!mod_menu_type)
    {
      static const GtkTypeInfo mod_menu_info =
      {
  	"TdModMenu", sizeof (TdModMenu), sizeof (TdModMenuClass),
  	(GtkClassInitFunc) td_mod_menu_class_init,
	(GtkObjectInitFunc) td_mod_menu_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_menu_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_menu_info);
    }
  return mod_menu_type;
}

/**
 * td_mod_menu_new:
 * 
 * fr: Cr un nouveau menu
 *
 * en: Creates a new menu
 * 
 * Return value: menu
 **/

GtkObject *td_mod_menu_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_menu_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_mod_menu_set_widget:
 * @mod_menu: menu
 * @widget: widget
 *
 * fr: Affecte le widget au menu
 *
 * en: Allocates the widget to menu
 **/

void td_mod_menu_set_widget (TdModMenu *mod_menu, GtkWidget *widget)
{
  g_return_if_fail (mod_menu != NULL);
  g_return_if_fail (TD_IS_MOD_MENU (mod_menu));
  if (mod_menu->widget != widget)
    mod_menu->widget = widget;
}
