/*****************************************************************************/
/* td_mod_etabliste.c : Objet Gtk+
 * td_mod_etabliste.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "database.h"

#include "td_mod.h"
#include "td_mod_etabliste.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_SELECTION_MODE,
  ARG_TABLE_FIELD,
  ARG_QUERY_REFRESH,
  ARG_QUERY_SET,
  ARG_QUERY_UNSET,
  ARG_QUERY_VISIBLE,
  ARG_LIST_QUERY,
  ARG_LIST_TYPE,
};

static void td_mod_etabliste_set_name (TdModEtabliste *mod_etabliste, gchar *name)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->name != name)
    mod_etabliste->name = name;
}

static void td_mod_etabliste_set_selection_mode (TdModEtabliste *mod_etabliste, GtkSelectionMode selection_mode)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->selection_mode != selection_mode)
    mod_etabliste->selection_mode = selection_mode;
}

static void td_mod_etabliste_set_table_field (TdModEtabliste *mod_etabliste, gchar *table_field)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->table_field != table_field)
    mod_etabliste->table_field = table_field;
}

static void td_mod_etabliste_set_query_refresh (TdModEtabliste *mod_etabliste, gchar *query_refresh)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->query_refresh != query_refresh)
    mod_etabliste->query_refresh = query_refresh;
}

static void td_mod_etabliste_set_query_set (TdModEtabliste *mod_etabliste, gchar *query_set)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->query_set != query_set)
    mod_etabliste->query_set = query_set;
}

static void td_mod_etabliste_set_query_unset (TdModEtabliste *mod_etabliste, gchar *query_unset)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->query_unset != query_unset)
    mod_etabliste->query_unset = query_unset;
}

static void td_mod_etabliste_set_query_visible (TdModEtabliste *mod_etabliste, gchar *query_visible)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->query_visible != query_visible)
    mod_etabliste->query_visible = query_visible;
}

static void td_mod_etabliste_set_list_query (TdModEtabliste *mod_etabliste, gchar *list_query)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->list_query != list_query)
    mod_etabliste->list_query = list_query;
}

static void td_mod_etabliste_set_list_type (TdModEtabliste *mod_etabliste, gchar *list_type)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->list_type != list_type)
    mod_etabliste->list_type = list_type;
}

static void td_mod_etabliste_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModEtabliste *mod_etabliste;
  mod_etabliste = TD_MOD_ETABLISTE (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_etabliste_set_name (mod_etabliste, GTK_VALUE_STRING (*arg));
      break;
    case ARG_SELECTION_MODE:
      td_mod_etabliste_set_selection_mode (mod_etabliste, GTK_VALUE_INT (*arg));
      break;
    case ARG_TABLE_FIELD:
      td_mod_etabliste_set_table_field (mod_etabliste, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_REFRESH:
      td_mod_etabliste_set_query_refresh (mod_etabliste, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_SET:
      td_mod_etabliste_set_query_set (mod_etabliste, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_UNSET:
      td_mod_etabliste_set_query_unset (mod_etabliste, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_VISIBLE:
      td_mod_etabliste_set_query_visible (mod_etabliste, GTK_VALUE_STRING (*arg));
      break;
    case ARG_LIST_QUERY:
      td_mod_etabliste_set_list_query (mod_etabliste, GTK_VALUE_STRING (*arg));
      break;
    case ARG_LIST_TYPE:
      td_mod_etabliste_set_list_type (mod_etabliste, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_etabliste_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModEtabliste *mod_etabliste;
  mod_etabliste = TD_MOD_ETABLISTE (object);
  switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod_etabliste->name;
      break;
    case ARG_SELECTION_MODE:
      GTK_VALUE_INT (*arg) = mod_etabliste->selection_mode;
      break;
    case ARG_TABLE_FIELD:
      GTK_VALUE_STRING (*arg) = mod_etabliste->table_field;
      break;
    case ARG_QUERY_REFRESH:
      GTK_VALUE_STRING (*arg) = mod_etabliste->query_refresh;
      break;
    case ARG_QUERY_SET:
      GTK_VALUE_STRING (*arg) = mod_etabliste->query_set;
      break;
    case ARG_QUERY_UNSET:
      GTK_VALUE_STRING (*arg) = mod_etabliste->query_unset;
      break;
    case ARG_QUERY_VISIBLE:
      GTK_VALUE_STRING (*arg) = mod_etabliste->query_visible;
      break;
    case ARG_LIST_QUERY:
      GTK_VALUE_STRING (*arg) = mod_etabliste->list_query;
      break;
    case ARG_LIST_TYPE:
      GTK_VALUE_STRING (*arg) = mod_etabliste->list_type;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_etabliste_init (TdModEtabliste *mod_etabliste)
{
  mod_etabliste->name = NULL;
  mod_etabliste->selection_mode = GTK_SELECTION_SINGLE;
  mod_etabliste->table_field = NULL;
  mod_etabliste->widget = NULL;
  mod_etabliste->widget_parent = NULL;
  mod_etabliste->query_refresh = NULL;
  mod_etabliste->query_set = NULL;
  mod_etabliste->query_unset = NULL;
  mod_etabliste->query_visible = NULL;
  mod_etabliste->list_query = NULL;
  mod_etabliste->list_type = NULL;
  mod_etabliste->dico = NULL;
}

static void td_mod_etabliste_class_init (TdModEtablisteClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModEtabliste::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdModEtabliste::selection_mode", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_SELECTION_MODE);
  gtk_object_add_arg_type ("TdModEtabliste::table_field", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE_FIELD);
  gtk_object_add_arg_type ("TdModEtabliste::query_refresh", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_REFRESH);
  gtk_object_add_arg_type ("TdModEtabliste::query_set", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_SET);
  gtk_object_add_arg_type ("TdModEtabliste::query_unset", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_UNSET);
  gtk_object_add_arg_type ("TdModEtabliste::query_visible", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_VISIBLE);
  gtk_object_add_arg_type ("TdModEtabliste::list_query", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LIST_QUERY);
  gtk_object_add_arg_type ("TdModEtabliste::list_type", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LIST_TYPE);
  object_class->set_arg = td_mod_etabliste_set_arg;
  object_class->get_arg = td_mod_etabliste_get_arg;
  klass->set_widget = td_mod_etabliste_set_widget;
  klass->set_dico = td_mod_etabliste_set_dico;
}

GtkType td_mod_etabliste_get_type (void)
{
  static GtkType mod_etabliste_type = 0;
  if (!mod_etabliste_type)
    {
      static const GtkTypeInfo mod_etabliste_info =
      {
  	"TdModEtabliste", sizeof (TdModEtabliste), sizeof (TdModEtablisteClass),
  	(GtkClassInitFunc) td_mod_etabliste_class_init,
	(GtkObjectInitFunc) td_mod_etabliste_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_etabliste_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_etabliste_info);
    }
  return mod_etabliste_type;
}

/**
 * td_mod_etabliste_new:
 * 
 * fr: Cr un nouveau composant de l'tabli
 *
 * en: Creates a new etabliste component
 * 
 * Return value: etabliste component
 **/

GtkObject *td_mod_etabliste_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_etabliste_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_mod_etabliste_set_widget:
 * @mod_etabliste: etabliste component
 * @widget: widget with data
 * @widget_parent: container of widget
 *
 * fr: Affecte le widget au composant de l'etabliste
 *
 * en: Allocates the widget to etabliste component
 **/

void td_mod_etabliste_set_widget (TdModEtabliste *mod_etabliste, GtkWidget *widget, GtkWidget *widget_parent)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->widget != widget)
    mod_etabliste->widget = widget;
  if (widget_parent)
    {
      if (mod_etabliste->widget_parent != widget_parent)
	mod_etabliste->widget_parent = widget_parent;
    }
  else
    if (mod_etabliste->widget_parent != widget)
      mod_etabliste->widget_parent = widget;
}

/**
 * td_mod_etabliste_set_dico:
 * @mod_etabliste: etabliste component
 * @dico: dictionary
 *
 * fr: Affecte le dictionnaire au composant de l'etabliste
 *
 * en: Allocates the dictionary to etabliste component
 **/

void td_mod_etabliste_set_dico (TdModEtabliste *mod_etabliste, GtkObject *dico)
{
  g_return_if_fail (mod_etabliste != NULL);
  g_return_if_fail (TD_IS_MOD_ETABLISTE (mod_etabliste));
  if (mod_etabliste->dico != dico)
    mod_etabliste->dico = dico;
}
