/*****************************************************************************/
/* td_mod_canvas_symbol.c : Objet Gtk+
 * td_mod_canvas_symbol.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "td_mod_canvas_symbol.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_QUERY_VISIBLE,
};

static void td_mod_canvas_symbol_set_query_visible (TdModCanvasSymbol *mod_canvas_symbol, gchar *query_visible)
{
  g_return_if_fail (mod_canvas_symbol != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS_SYMBOL (mod_canvas_symbol));
  if (mod_canvas_symbol->query_visible != query_visible)
    mod_canvas_symbol->query_visible = query_visible;
}

static void td_mod_canvas_symbol_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModCanvasSymbol *mod_canvas_symbol;
  mod_canvas_symbol = TD_MOD_CANVAS_SYMBOL (object);
  switch (arg_id)
    {
    case ARG_QUERY_VISIBLE:
      td_mod_canvas_symbol_set_query_visible (mod_canvas_symbol, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_canvas_symbol_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModCanvasSymbol *mod_canvas_symbol;
  mod_canvas_symbol = TD_MOD_CANVAS_SYMBOL (object);
  switch (arg_id)
    {
    case ARG_QUERY_VISIBLE:
      GTK_VALUE_STRING (*arg) = mod_canvas_symbol->query_visible;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_canvas_symbol_init (TdModCanvasSymbol *mod_canvas_symbol)
{
  mod_canvas_symbol->query_visible = NULL;
  mod_canvas_symbol->draw = NULL;
}

static void td_mod_canvas_symbol_class_init (TdModCanvasSymbolClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModCanvasSymbol::query_visible", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_VISIBLE);
  object_class->set_arg = td_mod_canvas_symbol_set_arg;
  object_class->get_arg = td_mod_canvas_symbol_get_arg;
  klass->add_draw = td_mod_canvas_symbol_add_draw;
}

GtkType td_mod_canvas_symbol_get_type (void)
{
  static GtkType mod_canvas_symbol_type = 0;
  if (!mod_canvas_symbol_type)
    {
      static const GtkTypeInfo mod_canvas_symbol_info =
      {
  	"TdModCanvasSymbol", sizeof (TdModCanvasSymbol), sizeof (TdModCanvasSymbolClass),
  	(GtkClassInitFunc) td_mod_canvas_symbol_class_init,
	(GtkObjectInitFunc) td_mod_canvas_symbol_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_canvas_symbol_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_canvas_symbol_info);
    }
  return mod_canvas_symbol_type;
}

/**
 * td_mod_canvas_symbol_new:
 * 
 * fr: Cr un nouveau symbole
 *
 * en: Creates a new symbol
 * 
 * Return value: symbol
 **/

GtkObject *td_mod_canvas_symbol_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_canvas_symbol_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_mod_canvas_symbol_add_draw:
 * @mod_canvas_symbol: symbol
 * @draw: drawing primitive
 *
 * fr: Ajoute la primitive graphique au symbole
 *
 * en: Adds the drawing primitive to canvas
 **/

void td_mod_canvas_symbol_add_draw (TdModCanvasSymbol *mod_canvas_symbol, GnomeCanvasItem *draw)
{
  g_return_if_fail (mod_canvas_symbol != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS_SYMBOL (mod_canvas_symbol));
  mod_canvas_symbol->draw = g_list_append (mod_canvas_symbol->draw, draw);
}





