/*****************************************************************************/
/* td_mod_canvas.h : Objet Gtk+
 * td_mod_canvas.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_CANVAS (td_mod_canvas_get_type())
#define TD_MOD_CANVAS(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_CANVAS, TdModCanvas))
#define TD_MOD_CANVAS_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_CANVAS, TdModCanvasClass))
#define TD_IS_MOD_CANVAS(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_CANVAS))
#define TD_IS_MOD_CANVAS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_CANVAS))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdModCanvas TdModCanvas;
typedef struct _TdModCanvasClass TdModCanvasClass;

struct _TdModCanvas
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *name_intl; /*** Nom international - International name */
  int id; /*** Identificateur - Identifier */
  GtkWidget *label; /*** Etiquette - Label */
  gboolean customize; /*** Personnalisable - Customizable */
  gboolean reorderable; /*** Rarrangeable - Reorderable */
  GList *field; /*** Champs - Fields */
  GList *symbol; /*** Symboles - Symbols */
  gchar *symbol_file; /*** Localisation du fichier des symboles - File location of symbols */
  int column_oid; /*** Localisation du champs des idendificateurs - Location of identifiers field */
  gchar *table; /*** Nom de la table - Table name */
  gchar *table_net; /*** Nom de la table du reseau - Network table name */
  gchar *table_tree; /*** Nom de la table de l'arboresence - Tree table name */

  GtkWidget *widget; /*** Widget */
  GtkWidget *widget_data; /*** Widget de donnes - Widget with data */
  GtkWidget *vruler; /*** Rgle verticale - Vertical ruler */
  GtkWidget *hruler; /*** Rgle horizontale - Horizontal ruler */
  GtkWidget *menu_widget; /*** Menu */
  GtkWidget *menu_link_widget; /*** Menu des liens - Links menu */

  GnomeCanvasGroup *selected; /*** Item selectionn - Selected item */
  GList *selected_parent; /*** Items enfant selectionns - Selected child items */
  GList *selected_child; /*** Items enfant selectionns- Selected child items */
  GList *selected_link_parent; /*** Liens entrants selectionns - Selected input links */
  GList *selected_link_child; /*** Liens sortants selectionns - Selected output links */
  GnomeCanvasItem *link; /*** Lien - Link */

  int dragging; /*** Drapeau du tirer - Dragging flag */
  double dragging_x; /*** Coordonne x du tirer - x coordinate of dragging */
  double dragging_y; /*** Coordonne y du tirer - y coordinate of dragging */
  double init_x; /*** Coordonne x initiale du tirer - Initial x coordinate of dragging */
  double init_y; /*** Coordonne y initiale du tirer - Initial y coordinate of dragging */
  GtkObject *panwindow; /*** Fentre pan - Pan window */
  GtkWidget *zoom_label; /*** Etiquette du zoom - Zoom label */
};

struct _TdModCanvasClass
{
  GtkObjectClass parent_class;
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_mod_canvas_set_name (TdModCanvas *mod_canvas, gchar *name);
static void td_mod_canvas_set_name_intl (TdModCanvas *mod_canvas, gchar *name_intl);
static void td_mod_canvas_set_customize (TdModCanvas *mod_canvas, gboolean customize);
static void td_mod_canvas_set_reorderable (TdModCanvas *mod_canvas, gboolean reorderable);
static void td_mod_canvas_set_symbol_file (TdModCanvas *mod_canvas, gchar *symbol_file);
static void td_mod_canvas_set_column_oid (TdModCanvas *mod_canvas, int column_oid);
static void td_mod_canvas_set_table (TdModCanvas *mod_canvas, gchar *table);
static void td_mod_canvas_set_table_net (TdModCanvas *mod_canvas, gchar *table_net);
static void td_mod_canvas_set_table_tree (TdModCanvas *mod_canvas, gchar *table_tree);
static void td_mod_canvas_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_canvas_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_canvas_init (TdModCanvas *mod_canvas);
static void td_mod_canvas_class_init (TdModCanvasClass *klass);
GtkType td_mod_canvas_get_type (void);
GtkObject *td_mod_canvas_new (void);
void td_mod_canvas_destroy (TdModCanvas *mod_canvas);
void td_mod_canvas_show (TdModCanvas *mod_canvas);
void td_mod_canvas_hide (TdModCanvas *mod_canvas);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_mod_canvas_add_symbol (TdModCanvas *mod_canvas, GtkObject *symbol);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/
void td_mod_canvas_create (TdModCanvas *mod_canvas, TdMod *mod);
void td_mod_canvas_button_press (GtkWidget *widget, GdkEventButton *event, TdModCanvas *mod_canvas);
void td_mod_canvas_zoom_changed (GtkAdjustment *adj, TdModCanvas *mod_canvas);
void td_mod_canvas_scrollbar_changed (GtkAdjustment *adj, TdModCanvas *mod_canvas);
void td_mod_canvas_draw_link (GtkObject *mod_canvas, GnomeCanvasItem *link, GnomeCanvasItem *node_parent, GnomeCanvasItem *node);
