/*****************************************************************************/
/* td_mod_canvas.c : Objet Gtk+
 * td_mod_canvas.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <math.h>

#include "commons.h"
#include "gtdk.h"
#include "database.h"
#include "td_app.h"
#include "td_app_palette.h"
#include "td_app_bench.h"
#include "td_mod.h"
#include "td_mod_canvas.h"
#include "td_mod_canvas_symbol.h"
#include "td_db_base.h"
#include "td_db_mod.h"
#include "td_db_datatable.h"
#include "td_db_connect.h"
#include "td_field.h"
#include "td_flower.h"
#include "td_panwindow.h"

/*** FIXME: temps nous gagnerons, par usage abusive du greffon,
 * lments mieux finaliss, alors la lib retrouvera son autorite */

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_NAME_INTL,
  ARG_CUSTOMIZE,
  ARG_REORDERABLE,
  ARG_SYMBOL_FILE,
  ARG_COLUMN_OID,
  ARG_TABLE,
  ARG_TABLE_NET,
  ARG_TABLE_TREE,
};

static void td_mod_canvas_set_name (TdModCanvas *mod_canvas, gchar *name)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (mod_canvas->name != name)
    mod_canvas->name = name;
}

static void td_mod_canvas_set_name_intl (TdModCanvas *mod_canvas, gchar *name_intl)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (mod_canvas->name_intl != name_intl)
    {
      mod_canvas->name_intl = name_intl;
      mod_canvas->label = gtk_label_new (name_intl);
    }
}

static void td_mod_canvas_set_customize (TdModCanvas *mod_canvas, gboolean customize)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (mod_canvas->customize != customize)
    mod_canvas->customize = customize;
}

static void td_mod_canvas_set_reorderable (TdModCanvas *mod_canvas, gboolean reorderable)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (mod_canvas->reorderable != reorderable)
    mod_canvas->reorderable = reorderable;
}

static void td_mod_canvas_set_symbol_file (TdModCanvas *mod_canvas, gchar *symbol_file)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (mod_canvas->symbol_file != symbol_file)
    mod_canvas->symbol_file = symbol_file;
}

static void td_mod_canvas_set_column_oid (TdModCanvas *mod_canvas, int column_oid)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (mod_canvas->column_oid != column_oid)
    mod_canvas->column_oid = column_oid;
}

static void td_mod_canvas_set_table (TdModCanvas *mod_canvas, gchar *table)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (mod_canvas->table != table)
    mod_canvas->table = table;
}

static void td_mod_canvas_set_table_net (TdModCanvas *mod_canvas, gchar *table_net)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (mod_canvas->table_net != table_net)
    mod_canvas->table_net = table_net;
}

static void td_mod_canvas_set_table_tree (TdModCanvas *mod_canvas, gchar *table_tree)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (mod_canvas->table_tree != table_tree)
    mod_canvas->table_tree = table_tree;
}

static void td_mod_canvas_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModCanvas *mod_canvas;
  mod_canvas = TD_MOD_CANVAS (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_canvas_set_name (mod_canvas, GTK_VALUE_STRING (*arg));
      break;
    case ARG_NAME_INTL:
      td_mod_canvas_set_name_intl (mod_canvas, GTK_VALUE_STRING (*arg));
      break;
    case ARG_CUSTOMIZE:
      td_mod_canvas_set_customize (mod_canvas, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_REORDERABLE:
      td_mod_canvas_set_reorderable (mod_canvas, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_SYMBOL_FILE:
      td_mod_canvas_set_symbol_file (mod_canvas, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COLUMN_OID:
      td_mod_canvas_set_column_oid (mod_canvas, GTK_VALUE_INT (*arg));
      break;
    case ARG_TABLE:
      td_mod_canvas_set_table (mod_canvas, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TABLE_NET:
      td_mod_canvas_set_table_net (mod_canvas, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TABLE_TREE:
      td_mod_canvas_set_table_tree (mod_canvas, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_canvas_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModCanvas *mod_canvas;
  mod_canvas = TD_MOD_CANVAS (object);
  switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod_canvas->name;
      break;
    case ARG_NAME_INTL:
      GTK_VALUE_STRING (*arg) = mod_canvas->name_intl;
      break;
    case ARG_CUSTOMIZE:
      GTK_VALUE_BOOL (*arg) = mod_canvas->customize;
      break;
    case ARG_REORDERABLE:
      GTK_VALUE_BOOL (*arg) = mod_canvas->reorderable;
      break;
    case ARG_SYMBOL_FILE:
      GTK_VALUE_STRING (*arg) = mod_canvas->symbol_file;
      break;
    case ARG_COLUMN_OID:
      GTK_VALUE_INT (*arg) = mod_canvas->column_oid;
      break;
    case ARG_TABLE:
      GTK_VALUE_STRING (*arg) = mod_canvas->table;
      break;
    case ARG_TABLE_NET:
      GTK_VALUE_STRING (*arg) = mod_canvas->table_net;
      break;
    case ARG_TABLE_TREE:
      GTK_VALUE_STRING (*arg) = mod_canvas->table_tree;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_canvas_init (TdModCanvas *mod_canvas)
{
  mod_canvas->name = NULL;
  mod_canvas->name_intl = NULL;
  mod_canvas->id = -1;
  mod_canvas->label = NULL;
  mod_canvas->customize = FALSE;
  mod_canvas->reorderable = FALSE;
  mod_canvas->field = NULL;
  mod_canvas->symbol = NULL;
  mod_canvas->symbol_file = NULL;
  mod_canvas->column_oid = 0;
  mod_canvas->table = NULL;
  mod_canvas->table_net = NULL;
  mod_canvas->table_tree = NULL;

  mod_canvas->widget = NULL;
  mod_canvas->widget_data = NULL;
  mod_canvas->vruler = NULL;
  mod_canvas->hruler = NULL;
  mod_canvas->menu_widget = NULL;
  mod_canvas->menu_link_widget = NULL;

  mod_canvas->selected = NULL;
  mod_canvas->selected_parent = NULL;
  mod_canvas->selected_child = NULL;
  mod_canvas->selected_link_parent = NULL;
  mod_canvas->selected_link_child = NULL;
  mod_canvas->link = NULL;

  mod_canvas->dragging = 0;
  mod_canvas->dragging_x = 0;
  mod_canvas->dragging_y = 0;
  mod_canvas->panwindow = NULL;
  mod_canvas->zoom_label = NULL;
}

static void td_mod_canvas_class_init (TdModCanvasClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModCanvas::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdModCanvas::name_intl", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME_INTL);
  gtk_object_add_arg_type ("TdModCanvas::customize", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_CUSTOMIZE);
  gtk_object_add_arg_type ("TdModCanvas::reorderable", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_REORDERABLE);
  gtk_object_add_arg_type ("TdModCanvas::symbol_file", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_SYMBOL_FILE);
  gtk_object_add_arg_type ("TdModCanvas::column_oid", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_COLUMN_OID);
  gtk_object_add_arg_type ("TdModCanvas::table", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE);
  gtk_object_add_arg_type ("TdModCanvas::table_net", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE_NET);
  gtk_object_add_arg_type ("TdModCanvas::table_tree", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE_TREE);
  object_class->set_arg = td_mod_canvas_set_arg;
  object_class->get_arg = td_mod_canvas_get_arg;
}

GtkType td_mod_canvas_get_type (void)
{
  static GtkType mod_canvas_type = 0;
  if (!mod_canvas_type)
    {
      static const GtkTypeInfo mod_canvas_info =
      {
  	"TdModCanvas", sizeof (TdModCanvas), sizeof (TdModCanvasClass),
  	(GtkClassInitFunc) td_mod_canvas_class_init,
	(GtkObjectInitFunc) td_mod_canvas_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_canvas_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_canvas_info);
    }
  return mod_canvas_type;
}

/**
 * td_mod_canvas_new:
 * 
 * fr: Cr un nouveau canevas
 *
 * en: Creates a new canvas
 * 
 * Return value: canvas
 **/

GtkObject *td_mod_canvas_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_canvas_get_type()));
}

/**
 * td_mod_canvas_destroy:
 * @mod_canvas: canvas
 * 
 * fr: Dtruit le canevas
 *
 * en: Destroys the canvas
 **/

void td_mod_canvas_destroy (TdModCanvas *mod_canvas)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  td_panwindow_destroy (TD_PANWINDOW (mod_canvas->panwindow));
  gtk_object_destroy (GTK_OBJECT (mod_canvas));
}

/**
 * td_mod_canvas_show:
 * @mod_canvas: canvas
 * 
 * fr: Affiche le canevas
 *
 * en: Displays the canvas
 **/

void td_mod_canvas_show (TdModCanvas *mod_canvas)
{
  void (*symbol)();
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  if (g_list_length (gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data))->item_list)==0)
    {
      (gpointer*) symbol = td_app_mod_data_symbol (mod_canvas->id, "plugins_refresh", TRUE);
      if (symbol)
	symbol (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), mod_canvas);
    }
}

/**
 * td_mod_canvas_hide:
 * @mod_canvas: canvas
 * 
 * fr: Cache le canevas
 *
 * en: Hides the canvas
 **/

void td_mod_canvas_hide (TdModCanvas *mod_canvas)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  td_panwindow_hide (TD_PANWINDOW (mod_canvas->panwindow));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_mod_canvas_add_symbol:
 * @mod_canvas: canvas
 * @symbol: symbol
 *
 * fr: Ajoute le symbole au cavenas
 *
 * en: Adds the symbol to canvas
 **/

void td_mod_canvas_add_symbol (TdModCanvas *mod_canvas, GtkObject *symbol)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  mod_canvas->symbol = g_list_append (mod_canvas->symbol, symbol);
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_mod_canvas_create:
 * @mod_canvas: component
 * @mod: module
 * 
 * fr: Cr l'interface du composant du module
 *
 * en: Creates the interface of component of module
 **/

void td_mod_canvas_create (TdModCanvas *mod_canvas, TdMod *mod)
{
  void (*symbol)();
  GtkWidget *frame;
  GnomeCanvasGroup *root;
  GtkAdjustment *adj;
  GtkWidget *hbox1;
  GtkWidget *hbox2;
  GtkWidget *vscale;
  GtkWidget *pan_arrow;
  GtkWidget *pan_button;
  GtkWidget *vscrollbar;
  GtkWidget *hscrollbar;
  GtkWidget *menu_arrow;
  GtkWidget *menu_button;
  GList *field2;
  int i;
  gchar *txt_tmp;
  GtkObject *flower;
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));

  /*** Identificateur - Identifier */
  field2 = td_database_field (g_strdup_printf ("SELECT * FROM %s;", mod_canvas->table));
  for (i=0; i<g_list_length (field2); i++)
    if (!strcmp ((gchar*) (g_list_nth_data (field2, i)), "td_id"))
      {
	gtk_object_set (GTK_OBJECT (mod_canvas), "column_oid", i, NULL);
	break;
      }

  /*** Bote - Box */
  mod_canvas->id = mod->id;
  mod_canvas->menu_widget = mod->menu_widget;
  mod_canvas->menu_link_widget = mod->menu_link_widget;
  mod_canvas->widget = gtk_table_new (3, 3, FALSE);
  gtk_widget_show (mod_canvas->widget);
  mod_canvas->widget_data = gnome_canvas_new();

  /*** Zoom */
  adj = GTK_ADJUSTMENT (gtk_adjustment_new (1.00, 0.05, 5.00, 0.05, 0.50, 0.50));
  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_table_attach (GTK_TABLE (mod_canvas->widget), hbox2, 0, 1, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  vscale = gtk_vscale_new (GTK_ADJUSTMENT (adj));
  gtk_scale_set_draw_value (GTK_SCALE (vscale), FALSE);
  gtk_widget_show (vscale);
  gtk_box_pack_start (GTK_BOX (hbox2), vscale, TRUE, TRUE, 0);
  mod_canvas->zoom_label = gtk_label_new ("1.0");
  gtk_widget_show (mod_canvas->zoom_label);
  gtk_table_attach (GTK_TABLE (mod_canvas->widget), mod_canvas->zoom_label, 0, 1, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed", GTK_SIGNAL_FUNC (td_mod_canvas_zoom_changed), mod_canvas);

  /*** Cavenas - Canvas */
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 1);
  gtk_table_attach (GTK_TABLE (mod_canvas->widget), frame, 1, 2, 1, 2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL | GTK_SHRINK), (GtkAttachOptions) (GTK_EXPAND | GTK_FILL | GTK_SHRINK), 0, 0);
  gtk_widget_show (frame);
  gtk_widget_push_visual (gdk_imlib_get_visual());
  gtk_widget_push_colormap (gdk_imlib_get_colormap());
  root = gnome_canvas_root (GNOME_CANVAS (mod_canvas->widget_data));
  gtk_widget_pop_colormap();
  gtk_widget_pop_visual();
  gnome_canvas_set_scroll_region (GNOME_CANVAS (mod_canvas->widget_data), 0, 0, 600, 450);
  gtk_container_add (GTK_CONTAINER (frame), mod_canvas->widget_data);
  gtk_widget_show (mod_canvas->widget_data);
  GTK_WIDGET_SET_FLAGS (mod_canvas->widget_data, GTK_CAN_FOCUS);
  gtk_widget_grab_focus (mod_canvas->widget_data);
  gtk_signal_connect (GTK_OBJECT (mod_canvas->widget_data), "button_press_event", GTK_SIGNAL_FUNC (td_mod_canvas_button_press), mod_canvas);

  /*** Rules - Rgles */
  mod_canvas->vruler = gtk_vruler_new();
  gtk_widget_show (mod_canvas->vruler);
  gtk_box_pack_start (GTK_BOX (hbox2), mod_canvas->vruler, TRUE, TRUE, 0);
  gtk_ruler_set_range (GTK_RULER (mod_canvas->vruler), GTK_ADJUSTMENT (GTK_LAYOUT (mod_canvas->widget_data)->vadjustment)->value, GTK_ADJUSTMENT (GTK_LAYOUT (mod_canvas->widget_data)->vadjustment)->value+GTK_ADJUSTMENT (GTK_LAYOUT (mod_canvas->widget_data)->vadjustment)->page_size, 1, 10);
  mod_canvas->hruler = gtk_hruler_new();
  gtk_widget_show (mod_canvas->hruler);
  gtk_table_attach (GTK_TABLE (mod_canvas->widget), mod_canvas->hruler, 1, 2, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_ruler_set_range (GTK_RULER (mod_canvas->hruler), GTK_ADJUSTMENT (GTK_LAYOUT (mod_canvas->widget_data)->hadjustment)->value, GTK_ADJUSTMENT (GTK_LAYOUT (mod_canvas->widget_data)->hadjustment)->value+GTK_ADJUSTMENT (GTK_LAYOUT (mod_canvas->widget_data)->hadjustment)->page_size, 1, 10);

  /*** Pan */
  vscrollbar = gtk_vscrollbar_new (GTK_LAYOUT (mod_canvas->widget_data)->vadjustment);
  gtk_widget_show (vscrollbar);
  gtk_table_attach (GTK_TABLE (mod_canvas->widget), vscrollbar, 2, 3, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_signal_connect (GTK_OBJECT (GTK_LAYOUT (mod_canvas->widget_data)->vadjustment), "changed", GTK_SIGNAL_FUNC (td_mod_canvas_scrollbar_changed), mod_canvas);
  gtk_signal_connect (GTK_OBJECT (GTK_LAYOUT (mod_canvas->widget_data)->vadjustment), "value_changed", GTK_SIGNAL_FUNC (td_mod_canvas_scrollbar_changed), mod_canvas);
  hscrollbar = gtk_hscrollbar_new (GTK_LAYOUT (mod_canvas->widget_data)->hadjustment);
  gtk_widget_show (hscrollbar);
  gtk_table_attach (GTK_TABLE (mod_canvas->widget), hscrollbar, 1, 2, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
  gtk_signal_connect (GTK_OBJECT (GTK_LAYOUT (mod_canvas->widget_data)->hadjustment), "changed", GTK_SIGNAL_FUNC (td_mod_canvas_scrollbar_changed), mod_canvas);
  gtk_signal_connect (GTK_OBJECT (GTK_LAYOUT (mod_canvas->widget_data)->hadjustment), "value_changed", GTK_SIGNAL_FUNC (td_mod_canvas_scrollbar_changed), mod_canvas);
  pan_button = gtk_button_new();
  gtk_button_set_relief (GTK_BUTTON (pan_button), GTK_RELIEF_NONE);
  gtk_widget_show (pan_button);
  gtk_widget_set_usize (pan_button, 18, 18);
  gtk_table_attach (GTK_TABLE (mod_canvas->widget), pan_button, 2, 3, 2, 3, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  mod_canvas->panwindow = td_panwindow_new();
  td_panwindow_set_canvas (TD_PANWINDOW (mod_canvas->panwindow), mod_canvas->widget_data);
  gtk_signal_connect (GTK_OBJECT (pan_button), "button_press_event", GTK_SIGNAL_FUNC (td_panwindow_create), mod_canvas->panwindow);
  pan_arrow = gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_IN);
  gtk_widget_show (pan_arrow);
  gtk_container_add (GTK_CONTAINER (pan_button), pan_arrow);

  /*** Symbols - Symboles */
  (gpointer*) symbol = td_app_mod_data_symbol (mod_canvas->id, "plugins_symbol_def", TRUE);
  if (symbol)
    symbol (mod_canvas);

  /*** Navigateur - Navigator *//*** FIXME: +tards - this night */
  /*** Bote  outils - Tools box *//*** FIXME: +tards - this night */
}

/**
 * td_mod_canvas_button_press:
 * @widget: canvas widget
 * @event: event button
 * @mod_canvas: component
 * 
 * fr: Evnement 'button_press' du cavenas
 *
 * en: Event 'button_press' of canvas
 **/

void td_mod_canvas_button_press (GtkWidget *widget, GdkEventButton *event, TdModCanvas *mod_canvas)
{
  GnomeCanvasGroup *root;
  GnomeCanvasItem *node;
  GnomeCanvasItem *selected_parent;
  GnomeCanvasItem *selected_child;
  GdkEventButton *bevent;
  int i, j;
  double  x, y;
  gchar *txt_id;
  gchar *txt_id_link;
  gchar *id_item;
  gchar *id_child;
  gchar *id_parent;
  bevent = (GdkEventButton*) event;
  root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data));

  /*** Slection - Selection */
  TD_FLAG_NO_REFRESH_NODE = TRUE;
  gnome_canvas_window_to_world (GNOME_CANVAS (widget), bevent->x, bevent->y, &x, &y);
  node = gnome_canvas_get_item_at (GNOME_CANVAS (widget), x, y);
  TD_MOD_CANVAS (mod_canvas)->init_x = x;
  TD_MOD_CANVAS (mod_canvas)->init_y = y;

  /*** Mise  zro - Raz */
  CURRENT_ROW = NULL;
  CURRENT_ID = 0;
  if (mod_canvas->selected)
    {
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (mod_canvas->selected)->item_list, 0), 
			     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (mod_canvas->selected)->item_list, 1), "fill_color_gdk", &TD_FACE_NODE_TEXT_COLOR[TD_FACE_NORMAL], NULL);
    }
  mod_canvas->selected = NULL;
  if (mod_canvas->selected_parent)
    for (i=0; i<g_list_length (mod_canvas->selected_parent); i++)
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (g_list_nth_data (mod_canvas->selected_parent, i))->item_list, 0),
			     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
  mod_canvas->selected_parent = NULL;
  if (mod_canvas->selected_child)
    for (i=0; i<g_list_length (mod_canvas->selected_child); i++)
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (g_list_nth_data (mod_canvas->selected_child, i))->item_list, 0),
			     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_NORMAL],
			     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_NORMAL], NULL);
  mod_canvas->selected_child = NULL;
  if (mod_canvas->selected_link_parent)
    for (i=0; i<g_list_length (mod_canvas->selected_link_parent); i++)
      gnome_canvas_item_set (g_list_nth_data (mod_canvas->selected_link_parent, i), 
			     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
			     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL], NULL);
  mod_canvas->selected_link_parent = NULL;
  if (mod_canvas->selected_link_child)
    for (i=0; i<g_list_length (mod_canvas->selected_link_child); i++)
      gnome_canvas_item_set (g_list_nth_data (mod_canvas->selected_link_child, i), 
			     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_NORMAL],
			     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_NORMAL],
			     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_NORMAL], NULL);
  mod_canvas->selected_link_child = NULL;

  /*** Rien - Nothing */
  if (!node)
    {

      /*** Editeur des proprits et Menu - Properties editor and Menu */
      td_mod_refresh_bench (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), GTK_OBJECT (mod_canvas));
      td_mod_refresh_etabliste (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), GTK_OBJECT (mod_canvas));
      td_mod_refresh_menu (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), GTK_OBJECT (mod_canvas));
      TD_FLAG_NO_REFRESH_NODE = FALSE;

      /*** Menu item */
      if (bevent->button == 3)
	gtk_menu_popup (GTK_MENU (mod_canvas->menu_widget), NULL, NULL, NULL, NULL, bevent->button, bevent->time);

      /*** Menu principal - Main menu */
      if (bevent->button == 2)
	gnome_popup_menu_do_popup (TD_APP (APP)->menu_main, NULL, NULL, bevent, NULL);
      return;
    }

  /*** Item */
  if (!GNOME_IS_CANVAS_LINE (node))
    {
      CURRENT_ID = atoi (gtk_object_get_user_data (GTK_OBJECT (node->parent)));
      mod_canvas->selected = GNOME_CANVAS_GROUP (node->parent);
      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (mod_canvas->selected)->item_list, 0),
			     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_SELECTED],
			     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_SELECTED],
			     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_SELECTED], NULL);
      gnome_canvas_item_raise_to_top (GNOME_CANVAS_ITEM (mod_canvas->selected));
    }

   /*** Etablis et menu - Benchs and menu */
  if (GNOME_IS_CANVAS_LINE (node))
    {
      td_mod_refresh_bench (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), GTK_OBJECT (mod_canvas));
      td_mod_refresh_etabliste (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), GTK_OBJECT (mod_canvas));
      td_mod_refresh_menu (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), GTK_OBJECT (mod_canvas));
      td_database_set_current (g_strdup_printf ("SELECT * FROM %s WHERE (td_id = %d) AND (td_id_parent = %d);", mod_canvas->table_net, CURRENT_ID, CURRENT_ID_PARENT));
    }
  else
    {
      td_database_set_current (g_strdup_printf ("SELECT * FROM %s WHERE td_id = %d;", mod_canvas->table, CURRENT_ID));
      td_mod_refresh_bench (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), GTK_OBJECT (mod_canvas));
      td_mod_refresh_etabliste (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), GTK_OBJECT (mod_canvas));
      td_mod_refresh_menu (TD_MOD (g_list_nth_data (TD_APP (APP)->mod_data, mod_canvas->id)), GTK_OBJECT (mod_canvas));
    }
  TD_FLAG_NO_REFRESH_NODE = FALSE;


  /*** Liens - Links */
  if (GNOME_IS_CANVAS_LINE (node))
    {
      CURRENT_ID_PARENT = atoi (td_strsplit (gtk_object_get_user_data (GTK_OBJECT (node)), ",", 0));
      CURRENT_ID = atoi (td_strsplit (gtk_object_get_user_data (GTK_OBJECT (node)), ",", 1));
      mod_canvas->selected_link_parent = g_list_append (mod_canvas->selected_link_parent, node);
      gnome_canvas_item_set (node, 
			     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_SELECTED],
			     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_SELECTED],
			     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_SELECTED], NULL);
    }
  else    
    {
      id_parent = g_strdup_printf (",%d", CURRENT_ID);
      id_child = g_strdup_printf ("%d,", CURRENT_ID);
      for (i=0; i<g_list_length (root->item_list); i++)
	{
	  id_item = gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i)));

	  /*** Parents */
	  if ((!id_item) || (!strstr (id_item, ",")))
	    continue;
	  if (strstr (id_item, id_parent))
	    {
	      gnome_canvas_item_set (g_list_nth_data (root->item_list, i),
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_PARENT],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_PARENT],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_PARENT], NULL);
	      mod_canvas->selected_link_parent = g_list_append (mod_canvas->selected_link_parent, GTK_OBJECT (g_list_nth_data (GNOME_CANVAS_GROUP (root)->item_list, i)));
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (gtdk_canvas_link_get_parent (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data), g_list_nth_data (root->item_list, i)))->item_list, 0),
				     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_PARENT],
				     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_PARENT],
				     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_PARENT], NULL);
	      mod_canvas->selected_parent = g_list_append (mod_canvas->selected_parent, GTK_OBJECT (gtdk_canvas_link_get_parent (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data), g_list_nth_data (root->item_list, i))));
	      continue;
	    }

	  /*** Enfant - Childs */
	  if (strstr (id_item, id_child))
	    {
	      gnome_canvas_item_set (g_list_nth_data (root->item_list, i),
				     "fill_color_gdk", &TD_FACE_LINK_LINE_COLOR[TD_FACE_CHILD],
				     "width_units", TD_FACE_LINK_LINE_WIDTH[TD_FACE_CHILD],
				     "line_style", TD_FACE_LINK_LINE_STYLE[TD_FACE_CHILD], NULL);
	      mod_canvas->selected_link_child = g_list_append (mod_canvas->selected_link_child, GTK_OBJECT (g_list_nth_data (GNOME_CANVAS_GROUP (root)->item_list, i)));
	      gnome_canvas_item_set (g_list_nth_data (GNOME_CANVAS_GROUP (gtdk_canvas_link_get_child (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data), g_list_nth_data (root->item_list, i)))->item_list, 0),
				     "fill_color_gdk", &TD_FACE_NODE_FILL_COLOR[TD_FACE_CHILD],
				     "outline_color_gdk", &TD_FACE_NODE_LINE_COLOR[TD_FACE_CHILD],
				     "width_units", TD_FACE_NODE_LINE_WIDTH[TD_FACE_CHILD], NULL);
	      mod_canvas->selected_child = g_list_append (mod_canvas->selected_child, GTK_OBJECT (gtdk_canvas_link_get_child (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data), g_list_nth_data (root->item_list, i))));
	    }
	}
    }

  /*** Menu item */
  if (gtdk_mouse_event (bevent, TD_EVENT_MOUSE_MENU_ITEM))
    {
      if (GNOME_IS_CANVAS_LINE (node))
	{
	  if (mod_canvas->menu_link_widget)
	    gtk_menu_popup (GTK_MENU (mod_canvas->menu_link_widget), NULL, NULL, NULL, NULL, bevent->button, bevent->time);
	}
      else
	gtk_menu_popup (GTK_MENU (mod_canvas->menu_widget), NULL, NULL, NULL, NULL, bevent->button, bevent->time);
    }

  /*** Menu principal - Main menu */
  if (gtdk_mouse_event (bevent, TD_EVENT_MOUSE_MENU_MAIN))
    gnome_popup_menu_do_popup (TD_APP (APP)->menu_main, NULL, NULL, bevent, NULL);
}

/**
 * td_mod_canvas_zoom_changed:
 * @adj: adjustement of zoom of canvas
 * @mod_canvas: component
 * 
 * fr: Evnement 'value_changed' du zoom du canvas
 *
 * en: Event 'value_changed' of zoom of canvas
 **/

void td_mod_canvas_zoom_changed (GtkAdjustment *adj, TdModCanvas *mod_canvas)
{
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  gtk_label_set_text (GTK_LABEL (mod_canvas->zoom_label), g_strdup_printf ("%2.1f", adj->value));
  gnome_canvas_set_pixels_per_unit (GNOME_CANVAS (mod_canvas->widget_data), adj->value);
}

/**
 * td_mod_canvas_scrollbar_changed:
 * @adj: adjustement of scrollbar of canvas
 * @mod_canvas: component
 * 
 * fr: Evnement 'value_changed' d'un des ascenseurs du cavenas
 *
 * en: Event 'value_changed' of scrollbar of canvas
 **/

void td_mod_canvas_scrollbar_changed (GtkAdjustment *adj, TdModCanvas *mod_canvas)
{
  double x, y, width, height;
  GnomeCanvas *canvas = GNOME_CANVAS (mod_canvas->widget_data);
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));
  /*** FIXME: remplacer 600 et 460 par les paramtres : +tards - changing 600 and 460 with parameters : this night */
  x = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->value*(600/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper);
  y = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->value*(460/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper);
  width = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->page_size*(600/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->hadjustment)->upper);
  height = GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->page_size*(460/GTK_ADJUSTMENT (GTK_LAYOUT (canvas)->vadjustment)->upper);
  gtk_ruler_set_range (GTK_RULER (mod_canvas->vruler), y, y+height, y, 10);
  gtk_ruler_set_range (GTK_RULER (mod_canvas->hruler), x, x+width, x, 10);
  td_panwindow_scrollbar_changed (TD_PANWINDOW (mod_canvas->panwindow));
}

/**
 * td_mod_canvas_draw_link:
 * @mod_canvas: component
 * @link: link
 * @node_parent: parent
 * @node: node
 * 
 * fr: Redessine le lien
 *
 * en: Redraws the link
 **/

void td_mod_canvas_draw_link (GtkObject *mod_canvas, GnomeCanvasItem *link, GnomeCanvasItem *node_parent, GnomeCanvasItem *node)
{
  int i;
  gchar *txt_id;
  double x, y, x_parent, y_parent, dx, dy, length;
  double line_x1, line_y1, line_x2, line_y2, line_ratio;
  double node_x1, node_y1, node_x2, node_y2, node_ratio;
  double node_parent_x1, node_parent_y1, node_parent_x2, node_parent_y2, node_parent_ratio;
  double sin_theta, cos_theta;
  GnomeCanvasPoints *points;
  GnomeCanvasItem *node_parent_frame;
  GnomeCanvasItem *node_frame;
  GnomeCanvasGroup *root = gnome_canvas_root (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data));
  g_return_if_fail (mod_canvas != NULL);
  g_return_if_fail (TD_IS_MOD_CANVAS (mod_canvas));

  /*** Nodes */
  if (!node_parent)
    {
      node_parent = gtdk_canvas_link_get_parent (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data), link);
      if ((!node_parent) || (node == node_parent))
	{
	  txt_id = td_strsplit (gtk_object_get_user_data (GTK_OBJECT (link)), ",", 0);
	  for (i=0; i<g_list_length (root->item_list); i++)
	    if ((GNOME_IS_CANVAS_GROUP (g_list_nth_data (root->item_list, i))) && (!strcmp (gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i))), txt_id)))
	      {
		node_parent = g_list_nth_data (root->item_list, i);
		break;
	      }
	}
    }
  if (!node)
    {
      node = gtdk_canvas_link_get_child (GNOME_CANVAS (TD_MOD_CANVAS (mod_canvas)->widget_data), link);
      if ((!node) || (node == node_parent))
	{
	  txt_id = td_strsplit (gtk_object_get_user_data (GTK_OBJECT (link)), ",", 1);
	  for (i=0; i<g_list_length (root->item_list); i++)
	    if ((GNOME_IS_CANVAS_GROUP (g_list_nth_data (root->item_list, i))) && (!strcmp (gtk_object_get_user_data (GTK_OBJECT (g_list_nth_data (root->item_list, i))), txt_id)))
	      {
		node = g_list_nth_data (root->item_list, i);
		break;
	      }
	}
    }

  /*** Lien - Link */
  /* FIXME: a suivre !  : + tards */ 
  node_parent_frame = GNOME_CANVAS_ITEM (g_list_nth_data (GNOME_CANVAS_GROUP (node_parent)->item_list, 0));
  line_x1 = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node_parent), 0);
  line_y1 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node_parent), 0);
  node_parent_x2 = GNOME_CANVAS_RE (node_parent_frame)->x2;
  node_parent_y2 = GNOME_CANVAS_RE (node_parent_frame)->y2;
  node_frame = GNOME_CANVAS_ITEM (g_list_nth_data (GNOME_CANVAS_GROUP (node)->item_list, 0));
  line_x2 = gtdk_canvas_i2w_x (GNOME_CANVAS_ITEM (node), 0);
  line_y2 = gtdk_canvas_i2w_y (GNOME_CANVAS_ITEM (node), 0);
  node_x2 = GNOME_CANVAS_RE (node_frame)->x2;
  node_y2 = GNOME_CANVAS_RE (node_frame)->y2;
  dx = line_x2 - line_x1;
  dy = line_y2 - line_y1;
  length = sqrt (dx * dx + dy * dy);
  if (length <= 0)
    sin_theta = cos_theta = 0.0;
  else 
    {
      cos_theta = dx / length;
      sin_theta = dy / length;
    }
  if (cos_theta >= sqrt (2)/2)
    cos_theta = 1;
  if (cos_theta <= -sqrt (2)/2)
    cos_theta = -1;
  if (sin_theta >= sqrt (2)/2)
    sin_theta = 1;
  if (sin_theta <= -sqrt (2)/2)
    sin_theta = -1;

/*    cos_theta = 0; */
/*    sin_theta = 0; */
  x_parent = line_x1+(node_parent_x2)*cos_theta;
  y_parent = line_y1+(node_parent_y2)*sin_theta;
  x = line_x2-(node_x2*cos_theta);
  y = line_y2-(node_y2*sin_theta);

/*    x = line_x2-((node_x2)+(TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1]))*cos_theta; */
/*    y = line_y2-((node_y2)+(TD_FACE_LINK_ARROW[0]-TD_FACE_LINK_ARROW[1]))*sin_theta; */

  points = gnome_canvas_points_new (2);
  points->coords[0] = x_parent;
  points->coords[1] = y_parent;
  points->coords[2] = x;
  points->coords[3] = y;
  gnome_canvas_item_set (link, "points", points, NULL);
  gnome_canvas_points_free (points);
}
