/*****************************************************************************/
/* td_mod_bench.h : Objet Gtk+
 * td_mod_bench.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_MOD_BENCH (td_mod_bench_get_type())
#define TD_MOD_BENCH(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD_BENCH, TdModBench))
#define TD_MOD_BENCH_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD_BENCH, TdModBenchClass))
#define TD_IS_MOD_BENCH(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD_BENCH))
#define TD_IS_MOD_BENCH_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD_BENCH))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdModBench TdModBench;
typedef struct _TdModBenchClass TdModBenchClass;

struct _TdModBench
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *table_field; /*** Nom du champs - Field name */
  GtkWidget *label; /*** Etiquette - Label */
  GtkWidget *widget; /*** Widget */
  gchar *widget_data1; /*** Donne complmentaire 1 - Complementary data 1 */
  gchar *widget_data2; /*** Donne complmentaire 2 - Complementary data 2 */
  GtkWidget *widget_parent; /*** Container du widget - Container of widget */
  gchar *query_refresh; /*** Requte de rafrachissement - Query of refresh */
  gchar *query_visible; /*** Requte de visibilit - Query of visisbility */
  gchar *query_unsensitive; /*** Requte de sensibilit - Query of sensitivity */

  GtkWidget *list_widget; /*** Widget liste - Widget list */
  gchar *list_query; /*** Requte de liste - Query of list */
  gchar *list_type; /*** Type de liste - Type of list */

  GtkObject *dico; /*** Dictionnaire - Dictionary */
};

struct _TdModBenchClass
{
  GtkObjectClass parent_class;
  void (*set_widget) (TdModBench *mod_bench, GtkWidget *widget, GtkWidget *widget_parent);
  void (*set_dico) (TdModBench *db_mod_bench, GtkObject *dico);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_mod_bench_set_name (TdModBench *mod_bench, gchar *name);
static void td_mod_bench_set_table_field (TdModBench *mod_bench, gchar *table_field);
static void td_mod_bench_set_widget_data1 (TdModBench *mod_bench, gchar *widget_data1);
static void td_mod_bench_set_widget_data2 (TdModBench *mod_bench, gchar *widget_data2);
static void td_mod_bench_set_query_refresh (TdModBench *mod_bench, gchar *query_refresh);
static void td_mod_bench_set_query_visible (TdModBench *mod_bench, gchar *query_visible);
static void td_mod_bench_set_query_unsensitive (TdModBench *mod_bench, gchar *query_unsensitive);
static void td_mod_bench_set_list_query (TdModBench *mod_bench, gchar *list_query);
static void td_mod_bench_set_list_type (TdModBench *mod_bench, gchar *list_type);
static void td_mod_bench_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_bench_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_bench_init (TdModBench *mod_bench);
static void td_mod_bench_class_init (TdModBenchClass *klass);
GtkType td_mod_bench_get_type (void);
GtkObject *td_mod_bench_new (void);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_mod_bench_set_widget (TdModBench *mod_bench, GtkWidget *widget, GtkWidget *widget_parent);
void td_mod_bench_set_widget_list (TdModBench *mod_bench, GtkWidget *list_widget);
void td_mod_bench_set_dico (TdModBench *mod_bench, GtkObject *dico);
