/*****************************************************************************/
/* td_mod_bench.c : Objet Gtk+
 * td_mod_bench.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "database.h"

#include "td_mod.h"
#include "td_mod_bench.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_TYPE,
  ARG_TABLE_FIELD,
  ARG_WIDGET_DATA1,
  ARG_WIDGET_DATA2,
  ARG_QUERY_REFRESH,
  ARG_QUERY_VISIBLE,
  ARG_QUERY_UNSENSITIVE,
  ARG_LIST_QUERY,
  ARG_LIST_TYPE,
};

static void td_mod_bench_set_name (TdModBench *mod_bench, gchar *name)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->name != name)
    mod_bench->name = name;
}

static void td_mod_bench_set_table_field (TdModBench *mod_bench, gchar *table_field)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->table_field != table_field)
    mod_bench->table_field = table_field;
}

static void td_mod_bench_set_widget_data1 (TdModBench *mod_bench, gchar *widget_data1)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->widget_data1 != widget_data1)
    mod_bench->widget_data1 = widget_data1;
}

static void td_mod_bench_set_widget_data2 (TdModBench *mod_bench, gchar *widget_data2)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->widget_data2 != widget_data2)
    mod_bench->widget_data2 = widget_data2;
}

static void td_mod_bench_set_query_refresh (TdModBench *mod_bench, gchar *query_refresh)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->query_refresh != query_refresh)
    mod_bench->query_refresh = query_refresh;
}

static void td_mod_bench_set_query_visible (TdModBench *mod_bench, gchar *query_visible)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->query_visible != query_visible)
    mod_bench->query_visible = query_visible;
}

static void td_mod_bench_set_query_unsensitive (TdModBench *mod_bench, gchar *query_unsensitive)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->query_unsensitive != query_unsensitive)
    mod_bench->query_unsensitive = query_unsensitive;
}

static void td_mod_bench_set_list_query (TdModBench *mod_bench, gchar *list_query)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->list_query != list_query)
    mod_bench->list_query = list_query;
}

static void td_mod_bench_set_list_type (TdModBench *mod_bench, gchar *list_type)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->list_type != list_type)
    mod_bench->list_type = list_type;
}

static void td_mod_bench_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModBench *mod_bench;
  mod_bench = TD_MOD_BENCH (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_bench_set_name (mod_bench, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TABLE_FIELD:
      td_mod_bench_set_table_field (mod_bench, GTK_VALUE_STRING (*arg));
      break;
    case ARG_WIDGET_DATA1:
      td_mod_bench_set_widget_data1 (mod_bench, GTK_VALUE_STRING (*arg));
      break;
    case ARG_WIDGET_DATA2:
      td_mod_bench_set_widget_data2 (mod_bench, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_REFRESH:
      td_mod_bench_set_query_refresh (mod_bench, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_VISIBLE:
      td_mod_bench_set_query_visible (mod_bench, GTK_VALUE_STRING (*arg));
      break;
    case ARG_QUERY_UNSENSITIVE:
      td_mod_bench_set_query_unsensitive (mod_bench, GTK_VALUE_STRING (*arg));
      break;
    case ARG_LIST_QUERY:
      td_mod_bench_set_list_query (mod_bench, GTK_VALUE_STRING (*arg));
      break;
    case ARG_LIST_TYPE:
      td_mod_bench_set_list_type (mod_bench, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_bench_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModBench *mod_bench;
  mod_bench = TD_MOD_BENCH (object);
  switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod_bench->name;
      break;
    case ARG_TABLE_FIELD:
      GTK_VALUE_STRING (*arg) = mod_bench->table_field;
      break;
    case ARG_WIDGET_DATA1:
      GTK_VALUE_STRING (*arg) = mod_bench->widget_data1;
      break;
    case ARG_WIDGET_DATA2:
      GTK_VALUE_STRING (*arg) = mod_bench->widget_data2;
      break;
    case ARG_QUERY_REFRESH:
      GTK_VALUE_STRING (*arg) = mod_bench->query_refresh;
      break;
    case ARG_QUERY_VISIBLE:
      GTK_VALUE_STRING (*arg) = mod_bench->query_visible;
      break;
    case ARG_QUERY_UNSENSITIVE:
      GTK_VALUE_STRING (*arg) = mod_bench->query_unsensitive;
      break;
    case ARG_LIST_QUERY:
      GTK_VALUE_STRING (*arg) = mod_bench->list_query;
      break;
    case ARG_LIST_TYPE:
      GTK_VALUE_STRING (*arg) = mod_bench->list_type;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_bench_init (TdModBench *mod_bench)
{
  mod_bench->name = NULL;
  mod_bench->table_field = NULL;
  mod_bench->label = NULL;
  mod_bench->widget = NULL;
  mod_bench->widget_data1 = NULL;
  mod_bench->widget_data2 = NULL;
  mod_bench->widget_parent = NULL;
  mod_bench->query_refresh = NULL;
  mod_bench->query_visible = NULL;
  mod_bench->query_unsensitive = NULL;
  mod_bench->list_widget = NULL;
  mod_bench->list_query = NULL;
  mod_bench->list_type = NULL;
  mod_bench->dico = NULL;
}

static void td_mod_bench_class_init (TdModBenchClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModBench::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdModBench::table_field", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE_FIELD);
  gtk_object_add_arg_type ("TdModBench::widget_data1", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_WIDGET_DATA1);
  gtk_object_add_arg_type ("TdModBench::widget_data2", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_WIDGET_DATA2);
  gtk_object_add_arg_type ("TdModBench::query_refresh", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_REFRESH);
  gtk_object_add_arg_type ("TdModBench::query_visible", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_VISIBLE);
  gtk_object_add_arg_type ("TdModBench::query_unsensitive", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_QUERY_UNSENSITIVE);
  gtk_object_add_arg_type ("TdModBench::list_query", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LIST_QUERY);
  gtk_object_add_arg_type ("TdModBench::list_type", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LIST_TYPE);
  object_class->set_arg = td_mod_bench_set_arg;
  object_class->get_arg = td_mod_bench_get_arg;
  klass->set_widget = td_mod_bench_set_widget;
  klass->set_dico = td_mod_bench_set_dico;
}

GtkType td_mod_bench_get_type (void)
{
  static GtkType mod_bench_type = 0;
  if (!mod_bench_type)
    {
      static const GtkTypeInfo mod_bench_info =
      {
  	"TdModBench", sizeof (TdModBench), sizeof (TdModBenchClass),
  	(GtkClassInitFunc) td_mod_bench_class_init,
	(GtkObjectInitFunc) td_mod_bench_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_bench_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_bench_info);
    }
  return mod_bench_type;
}

/**
 * td_mod_bench_new:
 * 
 * fr: Cr un nouveau composant de l'tabli
 *
 * en: Creates a new bench component
 * 
 * Return value: bench component
 **/

GtkObject *td_mod_bench_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_bench_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_mod_bench_set_widget:
 * @mod_bench: bench component
 * @widget: widget with data
 * @widget_parent: container of widget
 *
 * fr: Affecte le widget au composant de l'tabli
 *
 * en: Allocates the widget to bench component
 **/

void td_mod_bench_set_widget (TdModBench *mod_bench, GtkWidget *widget, GtkWidget *widget_parent)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->widget != widget)
    mod_bench->widget = widget;
  if (widget_parent)
    {
      if (mod_bench->widget_parent != widget_parent)
	mod_bench->widget_parent = widget_parent;
    }
  else
    if (mod_bench->widget_parent != widget)
      mod_bench->widget_parent = widget;
}

/**
 * td_mod_bench_set_widget_list:
 * @mod_bench: bench component
 * @list_widget: list
 *
 * fr: Affecte la liste au composant de l'tabli
 *
 * en: Allocates the list to bench component
 **/

void td_mod_bench_set_widget_list (TdModBench *mod_bench, GtkWidget *list_widget)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->list_widget != list_widget)
    mod_bench->list_widget = list_widget;
}

/**
 * td_mod_bench_set_dico:
 * @mod_bench: bench component
 * @dico: dictionary
 *
 * fr: Affecte le dictionnaire au composant de l'tabli
 *
 * en: Allocates the dictionary to bench component
 **/

void td_mod_bench_set_dico (TdModBench *mod_bench, GtkObject *dico)
{
  g_return_if_fail (mod_bench != NULL);
  g_return_if_fail (TD_IS_MOD_BENCH (mod_bench));
  if (mod_bench->dico != dico)
    mod_bench->dico = dico;
}
