/*****************************************************************************/
/* td_mod.c : Objet Gtk+
 * td_mod.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <dirent.h>
#include <sys/stat.h>

#include "commons.h"
#include "gtdk.h"
#include "database.h"
#include "td_field.h"
#include "td_about.h"
#include "td_flower.h"
#include "td_dico.h"

#include "td_app.h"
#include "td_app_palette.h"
#include "td_app_bench.h"
#include "td_app_etabliste.h"
#include "td_app_menu.h"

#include "td_mod.h"
#include "td_mod_bench.h"
#include "td_mod_etabliste.h"
#include "td_mod_menu.h"

#include "td_mod_tree.h"
#include "td_mod_canvas.h"
#include "td_mod_gantt.h"
#include "td_mod_box.h"
#include "td_mod_stree.h"

#include "td_db_base.h"
#include "td_db_table.h"
#include "td_db_mod.h"
#include "td_db_mod_table.h"
#include "td_db_connect.h"
#include "td_db_datatable.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_NAME_INTL,
  ARG_GROUP,
  ARG_ID,
  ARG_FIELDS,
  ARG_ICON,
};

static void td_mod_set_name (TdMod *mod, gchar *name)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->name != name)
    mod->name = name;
}

static void td_mod_set_name_intl (TdMod *mod, gchar *name_intl)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->name_intl != name_intl)
    mod->name_intl = name_intl;
}

static void td_mod_set_group (TdMod *mod, gchar *group)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->group != group)
    mod->group = group;
}

static void td_mod_set_id (TdMod *mod, int id)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->id != id)
    mod->id = id;
}

static void td_mod_set_fields (TdMod *mod, gchar *fields)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->fields != fields)
    mod->fields = fields;
}

static void td_mod_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdMod *mod;
  mod = TD_MOD (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_set_name (mod, GTK_VALUE_STRING (*arg));
      break;
    case ARG_NAME_INTL:
      td_mod_set_name_intl (mod, GTK_VALUE_STRING (*arg));
      break;
    case ARG_GROUP:
      td_mod_set_group (mod, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ID:
      td_mod_set_id (mod, GTK_VALUE_INT (*arg));
      break;
    case ARG_FIELDS:
      td_mod_set_fields (mod, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdMod *mod;
  mod = TD_MOD (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod->name;
      break;
    case ARG_NAME_INTL:
      GTK_VALUE_STRING (*arg) = mod->name_intl;
      break;
    case ARG_GROUP:
      GTK_VALUE_STRING (*arg) = mod->group;
      break;
    case ARG_ID:
      GTK_VALUE_INT (*arg) = mod->id;
      break;
    case ARG_FIELDS:
      GTK_VALUE_STRING (*arg) = mod->fields;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_mod_init (TdMod *mod)
{
  mod->name = NULL;
  mod->name_intl = NULL;
  mod->group = NULL;
  mod->id = -1;
  mod->fields = NULL;
  mod->property = NULL;
  mod->modified = FALSE;

  mod->child = NULL;
  mod->table = NULL;
  mod->palette_button = NULL;
  mod->bench = NULL;
  mod->bench_vbox = NULL;
  mod->etabliste = NULL;
  mod->etabliste_vbox = NULL;
  mod->menu = NULL;
  mod->menu_widget = gtk_menu_new();
  mod->menu_link = NULL;
  mod->menu_link_widget = gtk_menu_new();

  mod->window = NULL;
  mod->window_notebook = NULL;
  mod->window_toolbar = NULL;
  mod->window_statusbar = NULL;

  mod->about = NULL;
  mod->presto_browser = NULL;
  mod->custom_browser = NULL;
  mod->custom_notebook = NULL;
  mod->custom_tree = NULL;
  mod->custom_widget = NULL;
}

static void td_mod_class_init (TdModClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdMod::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdMod::name_intl", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME_INTL);
  gtk_object_add_arg_type ("TdMod::group", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_GROUP);
  gtk_object_add_arg_type ("TdMod::id", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_ID);
  gtk_object_add_arg_type ("TdMod::fields", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_FIELDS);
  object_class->set_arg = td_mod_set_arg;
  object_class->get_arg = td_mod_get_arg;
  klass->add_property = td_mod_add_property;
  klass->add_child = td_mod_add_child;
  klass->add_table = td_mod_add_table;
  klass->add_bench = td_mod_add_bench;
  klass->add_etabliste = td_mod_add_etabliste;
  klass->add_menu = td_mod_add_menu;
  klass->add_menu_link = td_mod_add_menu_link;
  klass->set_about = td_mod_set_about;
  klass->add_custom_widget = td_mod_add_custom_widget;
  klass->set_window_toolbar = td_mod_set_window_toolbar;
  klass->set_window_statusbar = td_mod_set_window_statusbar;
}

GtkType td_mod_get_type (void)
{
  static GtkType mod_type = 0;
  if (!mod_type)
    {
      static const GtkTypeInfo mod_info =
      {
  	"TdMod", sizeof (TdMod), sizeof (TdModClass),
  	(GtkClassInitFunc) td_mod_class_init,
	(GtkObjectInitFunc) td_mod_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_info);
    }
  return mod_type;
}

/**
 * td_mod_new:
 * 
 * fr: Cr un nouveau module
 *
 * en: Creates a new module
 * 
 * Return value: module
 **/

GtkObject *td_mod_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_get_type()));
}

/**
 * td_mod_destroy:
 * @mod: module
 * 
 * fr: Dtruit le module
 *
 * en: Destroys the module
 **/

void td_mod_destroy (TdMod *mod)
{
  int i;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));

  /*** Enregistrement configuration - Save configuration */
  gtdk_window_save_conf (mod->name, mod->window, TRUE, FALSE, FALSE);

  /*** Enfants - Childs  */
  for (i=0; i<g_list_length (mod->child); i++)
    {
      if (TD_IS_MOD_TREE (g_list_nth_data (mod->child, i))) /*** mod_tree */
	td_mod_tree_destroy (TD_MOD_TREE (g_list_nth_data (mod->child, i)));
      if (TD_IS_MOD_CANVAS (g_list_nth_data (mod->child, i))) /*** mod_canvas */
	td_mod_canvas_destroy (TD_MOD_CANVAS (g_list_nth_data (mod->child, i)));
      if (TD_IS_MOD_GANTT (g_list_nth_data (mod->child, i))) /*** mod_gantt */
	td_mod_gantt_destroy (TD_MOD_GANTT (g_list_nth_data (mod->child, i)));
      if (TD_IS_MOD_STREE (g_list_nth_data (mod->child, i))) /*** mod_stree */
	td_mod_stree_destroy (TD_MOD_STREE (g_list_nth_data (mod->child, i)));
      if (TD_IS_MOD_BOX (g_list_nth_data (mod->child, i))) /*** mod_box */
	td_mod_box_destroy (TD_MOD_BOX (g_list_nth_data (mod->child, i)));
    }

  /*** Module */
  mod->name = NULL;
  mod->name_intl = NULL;
  mod->group = NULL;
  mod->id = 0;
  mod->fields = NULL;
  g_list_free (mod->property);
  mod->modified = 0;

  g_list_free (mod->child);
  g_list_free (mod->table);
  if (mod->palette_button)
    gtk_widget_destroy (mod->palette_button);
  g_list_free (mod->bench);
  if (mod->bench_vbox)
    gtk_widget_destroy (mod->bench_vbox);
  g_list_free (mod->etabliste);
  if (mod->etabliste_vbox)
    gtk_widget_destroy (mod->etabliste_vbox);
  g_list_free (mod->menu);
  gtk_widget_destroy (mod->menu_widget);
  g_list_free (mod->menu_link);
  gtk_widget_destroy (mod->menu_link_widget);

  gtk_signal_disconnect_by_func (GTK_OBJECT (mod->window_notebook), GTK_SIGNAL_FUNC (td_mod_switch_page), GTK_OBJECT (mod));
  gtk_widget_destroy (mod->window);
  if ((mod->window_toolbar) && (GTK_IS_WIDGET (mod->window_toolbar)))
    gtk_widget_destroy (mod->window_toolbar);
  if (mod->window_statusbar)
    gtk_widget_destroy (mod->window_statusbar);
  /* if (GTK_IS_WIDGET (mod->window_notebook)) */
  /* gtk_widget_destroy (mod->window_notebook); */

  gtk_object_destroy (mod->about);
  if (mod->presto_browser)
    gtk_object_destroy (mod->presto_browser);
  if (mod->custom_browser)
    gtk_object_destroy (mod->custom_browser);
  if (mod->custom_notebook)
    gtk_widget_destroy (mod->custom_notebook);
  if (mod->custom_tree)
    gtk_widget_destroy (mod->custom_tree);
  g_list_free (mod->custom_widget);

  gtk_object_destroy (GTK_OBJECT (mod));
}

/**
 * td_mod_show:
 * @mod: module
 * 
 * fr: Affiche le module
 *
 * en: Displays the module
 **/

void td_mod_show (TdMod *mod)
{
  int i;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));

  /*** Fentre - Window */
  gtk_widget_show (GTK_WIDGET (mod->window));
  gtk_widget_hide_all (GNOME_APP (mod->window)->menubar->parent->parent);

  /*** Enfants - Childs */
  if (mod->id != -1)
    {
      gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_BENCH (TD_APP (APP)->bench)->notebook), mod->id+1);
      gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_ETABLISTE (TD_APP (APP)->etabliste)->notebook), mod->id+1);
      for (i=0; i<g_list_length (mod->child); i++)
	{
	  if (TD_IS_MOD_TREE (g_list_nth_data (mod->child, i))) /* mod_tree */
	    td_mod_tree_show (TD_MOD_TREE (g_list_nth_data (mod->child, i)));
	  if (TD_IS_MOD_CANVAS (g_list_nth_data (mod->child, i))) /* mod_canvas */
	    td_mod_canvas_show (TD_MOD_CANVAS (g_list_nth_data (mod->child, i)));
	  if (TD_IS_MOD_GANTT (g_list_nth_data (mod->child, i))) /* mod_gantt */
	    td_mod_gantt_show (TD_MOD_GANTT (g_list_nth_data (mod->child, i)));
	  if (TD_IS_MOD_STREE (g_list_nth_data (mod->child, i))) /* mod_stree */
	    td_mod_stree_show (TD_MOD_STREE (g_list_nth_data (mod->child, i)));
	  if (TD_IS_MOD_BOX (g_list_nth_data (mod->child, i))) /* mod_box */
	    td_mod_box_show (TD_MOD_BOX (g_list_nth_data (mod->child, i)));
	}
    }
}

/**
 * td_mod_hide:
 * @mod: module
 * 
 * fr: Cache le module
 *
 * en: Hides the module
 **/

void td_mod_hide (TdMod *mod)
{
  int i;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));

  /*** Fentre - Window */
  gtdk_window_save_conf (mod->name, mod->window, TRUE, FALSE, FALSE);
  gtk_widget_hide (GTK_WIDGET (mod->window));
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_BENCH (TD_APP (APP)->bench)->notebook), 0);
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_ETABLISTE (TD_APP (APP)->etabliste)->notebook), 0);

  /*** Enfants - Childs */
  if (mod->id != -1)
    for (i=0; i<g_list_length (mod->child); i++)
      {
	if (TD_IS_MOD_TREE (g_list_nth_data (mod->child, i))) /*** mod_tree */
	  td_mod_tree_hide (TD_MOD_TREE (g_list_nth_data (mod->child, i)));
	if (TD_IS_MOD_CANVAS (g_list_nth_data (mod->child, i))) /*** mod_canvas */
	  td_mod_canvas_hide (TD_MOD_CANVAS (g_list_nth_data (mod->child, i)));
	if (TD_IS_MOD_GANTT (g_list_nth_data (mod->child, i))) /*** mod_gantt */
	  td_mod_gantt_hide (TD_MOD_GANTT (g_list_nth_data (mod->child, i)));
	if (TD_IS_MOD_STREE (g_list_nth_data (mod->child, i))) /*** mod_stree */
	  td_mod_stree_hide (TD_MOD_STREE (g_list_nth_data (mod->child, i)));
	if (TD_IS_MOD_BOX (g_list_nth_data (mod->child, i))) /*** mod_box */
	  td_mod_box_hide (TD_MOD_BOX (g_list_nth_data (mod->child, i)));
      }

  /*** Palette */
  if ((mod->id != -1) && (mod->palette_button) && (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (mod->palette_button))))
    gtk_button_clicked (GTK_BUTTON (mod->palette_button));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_mod_add_property:
 * @mod: module
 * @property: property
 *
 * fr: Ajoute la proprit au module
 *
 * en: Adds the property to module
 **/

void td_mod_add_property (TdMod *mod, GtkObject *property)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  mod->property = g_list_append (mod->property, property);
}

/**
 * td_mod_add_child:
 * @mod: module
 * @child: child
 *
 * fr: Ajoute le sous-module au module
 *
 * en: Adds the sub-module to module
 **/

void td_mod_add_child (TdMod *mod, GtkObject *child)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  mod->child = g_list_append (mod->child, child);
}

/**
 * td_mod_add_table:
 * @mod: module
 * @table: table
 *
 * fr: Ajoute la table au module
 *
 * en: Adds the table to module
 **/

void td_mod_add_table (TdMod *mod, GtkObject *table)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  mod->table = g_list_append (mod->table, table);
}

/**
 * td_mod_add_bench:
 * @mod: module
 * @bench: bench
 *
 * fr: Ajoute un item d'tabli au module
 *
 * en: Adds a bench item to module
 **/

void td_mod_add_bench (TdMod *mod, GtkObject *bench)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (GTK_IS_ENTRY (TD_MOD_BENCH (bench)->widget))
    gtk_signal_connect (GTK_OBJECT (TD_MOD_BENCH (bench)->widget), "changed", GTK_SIGNAL_FUNC (td_mod_action_bench), mod);
  if (GTK_IS_COMBO (TD_MOD_BENCH (bench)->widget))
    gtk_signal_connect (GTK_OBJECT (TD_MOD_BENCH (bench)->widget), "changed", GTK_SIGNAL_FUNC (td_mod_action_bench), mod);
  if (GTK_IS_TOGGLE_BUTTON (TD_MOD_BENCH (bench)->widget))
    gtk_signal_connect (GTK_OBJECT (TD_MOD_BENCH (bench)->widget), "clicked", GTK_SIGNAL_FUNC (td_mod_action_bench), mod);
  if (GTK_IS_SPIN_BUTTON (TD_MOD_BENCH (bench)->widget))
    gtk_signal_connect (GTK_OBJECT (TD_MOD_BENCH (bench)->widget), "changed", GTK_SIGNAL_FUNC (td_mod_action_bench), mod);
  if (TD_MOD_BENCH (bench)->list_query)
    td_mod_bench_set_widget_list (TD_MOD_BENCH (bench), gtk_option_menu_new());
  mod->bench = g_list_append (mod->bench, bench);
}

/**
 * td_mod_add_etabliste:
 * @mod: module
 * @etabliste: etabliste
 *
 * fr: Ajoute une liste d'tabliste au module
 *
 * en: Adds a list of etabliste lists to module
 **/

void td_mod_add_etabliste (TdMod *mod, GtkObject *etabliste)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  mod->etabliste = g_list_append (mod->etabliste, etabliste);
}

/**
 * td_mod_add_menu:
 * @mod: module
 * @menu: menu
 *
 * fr: Ajoute le menu au module
 *
 * en: Adds the menu to module
 **/

void td_mod_add_menu (TdMod *mod, GtkObject *menu)
{
  GtkWidget *widget_item;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  widget_item = gtdk_menu_item_new (TD_MOD_MENU (menu)->label, NULL, TD_MOD_MENU (menu)->icon);
  gtk_signal_connect (GTK_OBJECT (widget_item), "activate", GTK_SIGNAL_FUNC (td_mod_action_menu), mod);
  td_mod_menu_set_widget (TD_MOD_MENU (menu), widget_item);
  gtk_menu_append (GTK_MENU (mod->menu_widget), widget_item);
  mod->menu = g_list_append (mod->menu, menu);
}

/**
 * td_mod_add_menu_link:
 * @mod: module
 * @menu_link: menu of links
 *
 * fr: Ajoute le menu des liens au module
 *
 * en: Adds the menu of links to module
 **/

void td_mod_add_menu_link (TdMod *mod, GtkObject *menu_link)
{
  GtkWidget *widget_item;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  widget_item = gtdk_menu_item_new (TD_MOD_MENU (menu_link)->label, NULL, TD_MOD_MENU (menu_link)->icon);
  gtk_signal_connect (GTK_OBJECT (widget_item), "activate", GTK_SIGNAL_FUNC (td_mod_action_menu_link), mod);
  td_mod_menu_set_widget (TD_MOD_MENU (menu_link), widget_item);
  gtk_menu_append (GTK_MENU (mod->menu_link_widget), widget_item);
  mod->menu_link = g_list_append (mod->menu_link, menu_link);
}

/**
 * td_mod_set_window_toolbar:
 * @mod: module
 * @window_toolbar: toolbar
 *
 * fr: Affecte le barre d'outils au module
 *
 * en: Allocates the toolbar to module
 **/

void td_mod_set_window_toolbar (TdMod *mod, GtkWidget *window_toolbar)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->window_toolbar != window_toolbar)
    mod->window_toolbar = window_toolbar;
}

/**
 * td_mod_set_window_statusbar:
 * @mod: module
 * @window_statusbar: statusbar
 *
 * fr: Affecte le barre de statut au module
 *
 * en: Allocates the statusbar to module
 **/

void td_mod_set_window_statusbar (TdMod *mod, GtkWidget *window_statusbar)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->window_statusbar != window_statusbar)
    mod->window_statusbar = window_statusbar;
}

/**
 * td_mod_set_about:
 * @mod: module
 * @about: description
 *
 * fr: Affecte la description au module
 *
 * en: Allocates the description to module
 **/

void td_mod_set_about (TdMod *mod, GtkObject *about)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (mod->about != about)
    mod->about = about;
}

/**
 * td_mod_add_custom_widget:
 * @mod: module
 * @custom_widget: widget for customize 
 *
 * fr: Ajoute le widget de personnalisation au module
 *
 * en: Adds the widget for customize to module
 **/

void td_mod_add_custom_widget (TdMod *mod, GtkWidget *custom_widget)
{
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  mod->custom_widget = g_list_append (mod->custom_widget, custom_widget);
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_mod_create:
 * @mod: module
 * 
 * fr: Cr l'interface du module
 *
 * en: Creates the interface of module
 **/

void td_mod_create (TdMod *mod)
{
  TdModTree *mod_tree_tmp;
  TdDbMod *db_mod = NULL;
  GtkWidget *dock;
  GtkWidget *table;
  GtkWidget *box_tmp;
  int i, j, k, m, n;
  gboolean bool_tmp;
  GtkObject *config = NULL;
  int column = 0;
  int bench_id = 0;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));

  /*** Fentre - Window */
  mod->window = gnome_app_new (mod->name, NULL);
  mod->modified = TRUE;
  gnome_app_enable_layout_config (GNOME_APP (mod->window), FALSE);
  gtk_window_set_policy (GTK_WINDOW (mod->window), TRUE, TRUE, FALSE);
  if (mod->id < 0)
    gtdk_window_set_title (GTK_WINDOW (mod->window), mod->name_intl, TD_WINDOW_TYPE_TOOL);
  else
    gtdk_window_set_title (GTK_WINDOW (mod->window), mod->name_intl, TD_WINDOW_TYPE_VIEW);
  dock = GNOME_APP (mod->window)->dock;
  gnome_app_create_menus (GNOME_APP (mod->window), TD_APP (APP)->menu_gnomeui);
  gtdk_window_save_defaultconf (mod->name, 600, 400);
  gtdk_window_load_conf (mod->name, mod->window);

  /*** Barres - Bars */
  if (mod->window_toolbar)
    {
      gnome_app_add_toolbar (GNOME_APP (mod->window), GTK_TOOLBAR (mod->window_toolbar), "toolbar", GNOME_DOCK_ITEM_BEH_EXCLUSIVE, GNOME_DOCK_TOP, 1, 0, 0);
      gtk_widget_show (mod->window_toolbar);
    }
  if (mod->window_statusbar)
    {
      gnome_app_set_statusbar (GNOME_APP (mod->window), mod->window_statusbar); 
      gtk_widget_show (mod->window_statusbar); 
    }

  /*** Enfants - Childs */
  mod->window_notebook = gtk_notebook_new();
  gtk_widget_show (mod->window_notebook);
  gnome_app_set_contents (GNOME_APP (mod->window), mod->window_notebook);
  gtk_signal_connect (GTK_OBJECT (mod->window_notebook), "switch_page", GTK_SIGNAL_FUNC (td_mod_switch_page), GTK_OBJECT (mod));
  for (i=0; i<g_list_length (mod->child); i++)
    {

      /* mod_tree */
      if (TD_IS_MOD_TREE (g_list_nth_data (mod->child, i)))
	{
	  td_mod_tree_create (TD_MOD_TREE (g_list_nth_data (mod->child, i)), mod);
	  gtk_container_add (GTK_CONTAINER (mod->window_notebook), TD_MOD_TREE (g_list_nth_data (mod->child, i))->widget);
	  gtk_widget_show (TD_MOD_TREE (g_list_nth_data (mod->child, i))->label);
	  gtk_notebook_set_tab_label (GTK_NOTEBOOK (mod->window_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (mod->window_notebook), i), TD_MOD_TREE (g_list_nth_data (mod->child, i))->label);
	}

      /* mod_canvas */
      if (TD_IS_MOD_CANVAS (g_list_nth_data (mod->child, i)))
	{
	  td_mod_canvas_create (TD_MOD_CANVAS (g_list_nth_data (mod->child, i)), mod);
	  gtk_container_add (GTK_CONTAINER (mod->window_notebook), TD_MOD_CANVAS (g_list_nth_data (mod->child, i))->widget);
	  gtk_widget_show (TD_MOD_CANVAS (g_list_nth_data (mod->child, i))->label);
	  gtk_notebook_set_tab_label (GTK_NOTEBOOK (mod->window_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (mod->window_notebook), i), TD_MOD_CANVAS (g_list_nth_data (mod->child, i))->label);
	}

      /* mod_gantt */
      if (TD_IS_MOD_GANTT (g_list_nth_data (mod->child, i)))
	{
	  td_mod_gantt_create (TD_MOD_GANTT (g_list_nth_data (mod->child, i)), GTK_OBJECT (mod));
	  gtk_container_add (GTK_CONTAINER (mod->window_notebook), TD_MOD_GANTT (g_list_nth_data (mod->child, i))->widget);
	  gtk_widget_show (TD_MOD_GANTT (g_list_nth_data (mod->child, i))->label);
	  gtk_notebook_set_tab_label (GTK_NOTEBOOK (mod->window_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (mod->window_notebook), i), TD_MOD_GANTT (g_list_nth_data (mod->child, i))->label);
	}

      /* mod_box */
      if (TD_IS_MOD_BOX (g_list_nth_data (mod->child, i)))
	{
	  td_mod_box_create (TD_MOD_BOX (g_list_nth_data (mod->child, i)), mod);
	  gtk_container_add (GTK_CONTAINER (mod->window_notebook), TD_MOD_BOX (g_list_nth_data (mod->child, i))->widget);
	  gtk_widget_show (TD_MOD_BOX (g_list_nth_data (mod->child, i))->label);
	  gtk_notebook_set_tab_label (GTK_NOTEBOOK (mod->window_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (mod->window_notebook), i), TD_MOD_BOX (g_list_nth_data (mod->child, i))->label);
	}

      /* mod_stree */
      if (TD_IS_MOD_STREE (g_list_nth_data (mod->child, i)))
	{
	  td_mod_stree_create (TD_MOD_STREE (g_list_nth_data (mod->child, i)), i, mod->id);
	  gtk_container_add (GTK_CONTAINER (mod->window_notebook), TD_MOD_STREE (g_list_nth_data (mod->child, i))->widget);
	  gtk_widget_show (TD_MOD_STREE (g_list_nth_data (mod->child, i))->label);
	  gtk_notebook_set_tab_label (GTK_NOTEBOOK (mod->window_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (mod->window_notebook), i), TD_MOD_STREE (g_list_nth_data (mod->child, i))->label);
	}
    }
  if (!TD_FLAG_DEBUG_MODE)
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK (mod->window_notebook), FALSE);
  gtk_signal_connect_object (GTK_OBJECT (mod->window), "delete_event", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (mod));
  gtk_widget_realize (GTK_WIDGET (mod->window));
  gtk_widget_hide (GTK_WIDGET (mod->window));

  /*** Menu */
  td_app_menu_std_new (mod->menu_widget, GTK_OBJECT (mod));
  td_app_menu_std_new (mod->menu_link_widget, GTK_OBJECT (mod));
}

/**
 * td_mod_switch_page:
 * @notebook: notebook widget
 * @page: page widget
 * @page_num: page number
 * @mod: module
 * 
 * fr: Evnement de changement de page sur l'interface du module
 *
 * en: Event of changing page in the module's interface 
 **/

void td_mod_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, gint page_num, TdMod *mod)
{
  int i, j;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));

  /*** Etablis - Bench */
  for (i=0; i< g_list_length (mod->bench); i++)
    {
      if (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->label)
	gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->label);
      gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget_parent);
      if (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_widget)
	gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget);
    }

  /*** Dselection - Unselection */
  for (i=0; i<g_list_length (mod->child); i++)
    {

      /*** mod_tree */
      if (TD_IS_MOD_TREE (g_list_nth_data (mod->child, i)))
	if (TD_MOD_TREE (g_list_nth_data (mod->child, i))->selected)
	  gtk_ctree_unselect (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (mod->child, i))->widget)->child), TD_MOD_TREE (g_list_nth_data (mod->child, i))->selected);
    }
}

/**
 * td_mod_modified:
 * @mod: module
 * 
 * fr: Marque le module comme modifie
 *
 * en: Mark the module as modified
 **/

void td_mod_modified (TdMod *mod)
{
  gchar *title;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  TD_APP (APP)->modified = TRUE;
  gtdk_window_set_title (GTK_WINDOW (mod->window), mod->name_intl, TD_WINDOW_TYPE_VIEW);
  gtk_entry_set_text (GTK_ENTRY (TD_APP_PALETTE (TD_APP (APP)->palette)->status), " ");
}

/**
 * td_mod_unmodified:
 * @mod: module
 * 
 * fr: Marque le module comme non-modifie
 *
 * en: Mark the module as unmodified
 **/

void td_mod_unmodified (TdMod *mod)
{
  gchar *title;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  TD_APP (APP)->modified = FALSE;
  gtdk_window_set_title (GTK_WINDOW (mod->window), mod->name_intl, TD_WINDOW_TYPE_VIEW);
  gtk_entry_set_text (GTK_ENTRY (TD_APP_PALETTE (TD_APP (APP)->palette)->status), " ");
}

/**
 * td_mod_custom_show:
 * @mod: module
 * 
 * fr: Affiche le dialogue de personnalisation du module
 *
 * en: Displays the customize dialog of module
 **/

void td_mod_custom_show (GtkObject *mod)
{
  void (*symbol)();
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (!TD_MOD (mod)->custom_browser)
    {
      (gpointer*) symbol = td_app_mod_core_symbol (NULL, NULL, "libhelp_customize.so", "plugins_create", TRUE);
      symbol (mod);
    }
  td_mod_show (TD_MOD (TD_MOD (mod)->custom_browser));
}

/**
 * td_mod_presto_show:
 * @mod: module
 * 
 * fr: Affiche le dialogue de documentation du module
 *
 * en: Displays the documentation dialog of module
 **/

void td_mod_presto_show (GtkObject *mod)
{
  void (*symbol)();
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (!TD_MOD (mod)->presto_browser)
    {
      (gpointer*) symbol = td_app_mod_core_symbol (NULL, NULL, "libhelp_doc.so", "plugins_create", TRUE);
      symbol (mod);
    }
  td_mod_show (TD_MOD (TD_MOD (mod)->presto_browser));
}

/*****************************************************************************/
/*** Base de donnes - Database */
/*****************************************************************************/

/**
 * td_mod_refresh_bench:
 * @mod: module
 * @mod_child : component
 * 
 * fr: Rafrachis l'tabli du composant du module
 *
 * en: Refresh the bench of component of module
 **/

void td_mod_refresh_bench (TdMod *mod, GtkObject *mod_child)
{
  int i, j;
  gchar *txt_tmp;
  GList *list_tmp;
  GtkWidget *label_tmp;
  void (*symbol)() = NULL;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_BENCH (TD_APP (APP)->bench)->notebook), mod->id+1);

  /*** Greffon - Plug-in */
  (gpointer*) symbol = td_app_mod_data_symbol (mod->id, "plugins_bench_refresh", TRUE);
  if (symbol)
    symbol (GTK_OBJECT (mod), GTK_OBJECT (mod_child));

  /*** Widget */
  for (i=0; i< g_list_length (mod->bench); i++)
    {

      /*** Visibilit = NULL - Visibility = NULL */
      if (!TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->query_visible)
	{
	  gtk_widget_show (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->label);
	  gtk_widget_show (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget_parent);
	  if (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget)
	    gtk_widget_show (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget);
	  continue;
	}

      /*** Visibilit = (null) - Visibility = (null) */
      if (!strcmp ("(null)", TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->query_visible))
	{
	  gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->label);
	  gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget_parent);
	  if (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget)
	    gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget);
	  continue;
	}

      /*** Visibilit - Visibility */
      txt_tmp = td_database_value (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->query_visible);
      if (!txt_tmp)
	{
	  gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->label);
	  gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget_parent);
	  if (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget)
	    gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget);
	  continue;
	}

      /*** Sensibilit - Sensitivity */
      if (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->query_unsensitive)
	{
	  txt_tmp = td_database_value (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->query_unsensitive);
	  if (txt_tmp)
	    {
	      gtk_widget_set_sensitive (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget_parent, FALSE);
	      if (GTK_IS_TOGGLE_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget))
		if (GTK_TOGGLE_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget)->active)
		  gtk_button_clicked (GTK_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget));
	      if (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget)
		gtk_widget_set_sensitive (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget, FALSE);
	    }
	  else
	    gtk_widget_set_sensitive (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget_parent, TRUE);
	}

      /*** Valeur - Value */
      txt_tmp = td_database_value (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->query_refresh);
      if (!txt_tmp)
	continue;

      /*** Dictionnaire - Dictionary */
      if (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->dico)
	txt_tmp = td_dico_2intl (TD_DICO (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->dico), txt_tmp);

      /*** Widget */
      if (GTK_IS_ENTRY (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget))
	{
	  j = gtk_editable_get_position (GTK_EDITABLE (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget));
	  gtk_entry_set_text (GTK_ENTRY (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget), txt_tmp);
	  gtk_editable_set_position (GTK_EDITABLE (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget), j);
	}
      if (GTK_IS_COMBO (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget))
	{
	  /* j = gtk_editable_get_position (GTK_EDITABLE (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget)); */
	  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget)->entry), txt_tmp);
	  /* gtk_editable_set_position (GTK_EDITABLE (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget), j); */
	}
      if (GTK_IS_SPIN_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget))
	{
	  /* j = gtk_editable_get_position (GTK_EDITABLE (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget)); */
	  gtk_spin_button_set_value (GTK_SPIN_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget), atoi (txt_tmp));
	  /* gtk_editable_set_position (GTK_EDITABLE (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget), j); */
	}
      if (GTK_IS_TOGGLE_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget))
	{
	  label_tmp = GTK_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget)->child;
	  gtk_label_set_text (GTK_LABEL (label_tmp), txt_tmp);
	  if (((GTK_TOGGLE_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget)->active)) && 
	      (!strcmp (txt_tmp, TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget_data1)))
	    gtk_button_clicked (GTK_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget));
	  if (((!GTK_TOGGLE_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget)->active)) && 
	      (strcmp (txt_tmp, TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget_data1)))
	    gtk_button_clicked (GTK_BUTTON (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget));
	}
      gtk_widget_show (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->label);
      gtk_widget_show (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget_parent);

      /*** Liste - List */
      if (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget)
	{
	  if (!strcmp (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_query, "(null)"))
	    {
	      gtdk_option_menu_set_strings (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget, NULL, TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget);
	      gtk_widget_hide (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget);
	      continue;
	    }
	  if ((!strcmp (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_type, "bench list item")) ||
	      (!strcmp (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_type, "bench list static query")))
	    {
	      gtk_widget_show (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget);
	      continue;
	    }
	  if ((!strcmp (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_type, "bench list query")) &&
	      (strcmp (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_query, "(null)")))
	    {
	      list_tmp = td_database_column (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, i))->list_query);
	      gtdk_option_menu_set_strings (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget, list_tmp, TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget);
	      gtk_widget_show (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget);
	      continue;
	    }
	  list_tmp = td_database_column (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_query);
	  gtdk_option_menu_set_strings (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget, list_tmp, TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->widget);
	  gtk_widget_show (TD_MOD_BENCH (g_list_nth_data (mod->bench, i))->list_widget);
	}
    }
}

/**
 * td_mod_refresh_etabliste:
 * @mod: module
 * @mod_child : component
 * 
 * fr: Rafrachis l'tabliste du composant du module
 *
 * en: Refresh the etabliste of component of module
 **/

void td_mod_refresh_etabliste (TdMod *mod, GtkObject *mod_child)
{
  int i, j;
  gchar *txt_tmp;
  GList *data_id;
  GtkObject *datatable;
  GtkWidget *label_tmp;
  GtkCTree *ctree;
  GtkCTreeNode *node;
  void (*symbol)() = NULL;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_APP_ETABLISTE (TD_APP (APP)->etabliste)->notebook), mod->id+1);

  /*** Greffon - Plug-in */
  (gpointer*) symbol = td_app_mod_data_symbol (mod->id, "plugins_etabliste_refresh", TRUE);
  if (symbol)
    symbol (GTK_OBJECT (mod), GTK_OBJECT (mod_child));

  /*** Widget */
  /*** FIXME: pour le momment limitt  la liste, mais arbre et images sont prvues : + tards - at present limited to the list but tree and picture are planned : this night */
  for (i=0; i< g_list_length (mod->etabliste); i++)
    {
      ctree = GTK_CTREE (TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, i))->widget_parent);

      /*** Visibilit - Visibility */
      if (TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, i))->query_visible)
	if ((!strcmp ("(null)", TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, i))->query_visible)) ||
	    (!td_database_value (TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, i))->query_visible)))
	  {
	    gtk_widget_hide (GTK_WIDGET (ctree));
	    continue;
	  }
      gtk_widget_show (GTK_WIDGET (ctree));

      /*** Liste - List */
      if ((!strcmp (TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->list_type, "etabliste list query")) ||
	  (!strcmp (TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->list_type, "etabliste list static query")))
	gtdk_ctree_set_strings (ctree, td_database_select (TD_MOD_ETABLISTE (g_list_nth_data (TD_MOD (mod)->etabliste, i))->list_query), NULL);

      /*** Valeurs - Values */
      gtk_clist_unselect_all (GTK_CLIST (ctree));
      if (!TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, i))->query_refresh)
	continue;
      data_id = td_database_column (TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, i))->query_refresh);
      if (!data_id)
	continue;
      for (i=0; i<g_list_length (data_id); i++)
	{
	  node = gtk_ctree_node_nth (ctree, 0);
	  while (node)
	    {
	      gtk_ctree_node_get_text (ctree, node, 1, &txt_tmp);
	      if (!strcmp ((gchar*) g_list_nth_data (data_id, i), txt_tmp))
		{
		  gtk_ctree_select (ctree, node);
		  break;
		}
	      node = gtdk_ctree_next (node);
	    }
	}
    }
}

/**
 * td_mod_action_bench_real:
 * @data: list
 * 
 * data: 1: widget: widget of the new value 
 *       2: mod: module
 * 
 * fr: Execute une modification gnre par l'tabli du module aprs un dlai d'attente 
 *
 * en: Execute a modification generated by the bench of module after a waiting delay
 * 
 * Return value: FLAG_ENTRY_CHANGED_ID (identifier of bench element)
 **/

int td_mod_action_bench_real (gpointer data)
{
  GtkWidget *widget = g_list_nth_data (data, 0);
  TdMod *mod = g_list_nth_data (data, 1);
  GtkWidget *label_tmp;
  int i;
  gchar *value;
  gchar *txt_tmp = NULL;
  void (*symbol)() = NULL;
  int bench_id;

  /* bench_id */
  for (bench_id = 0; bench_id < g_list_length (mod->bench); bench_id++)
    if (TD_MOD_BENCH (g_list_nth_data (mod->bench, bench_id))->widget == widget)
      break;

  /*** Valeur - Value */
  if (GTK_IS_ENTRY (widget))
    value = gtk_entry_get_text (GTK_ENTRY (widget));
  if (GTK_IS_COMBO (widget))
    value = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (widget)->entry));
  if (GTK_IS_SPIN_BUTTON (widget))
    value = g_strdup_printf ("%d", gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget)));
  if (GTK_IS_TOGGLE_BUTTON (widget))
    {
      label_tmp = GTK_BUTTON (widget)->child;
      if (GTK_TOGGLE_BUTTON (TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, bench_id))->widget)->active)
	gtk_label_set_text (GTK_LABEL (label_tmp), TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, bench_id))->widget_data2);
      else
	gtk_label_set_text (GTK_LABEL (label_tmp), TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, bench_id))->widget_data1);
      gtk_label_get (GTK_LABEL (label_tmp), &value);
    }

  /*** Greffon - Plug-in */
  (gpointer*) symbol = td_app_mod_data_symbol (mod->id, "plugins_bench_action", TRUE);
  if (symbol)
    symbol (GTK_OBJECT (mod), value, TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, bench_id))->table_field, bench_id);
  td_mod_modified (mod);

  /*** Temporisation - Temporization */
  if (FLAG_ENTRY_CHANGED_WIDGET_OLD)
    gtk_timeout_remove (FLAG_ENTRY_CHANGED_ID);
  FLAG_ENTRY_CHANGED_WIDGET_OLD = NULL;
  FLAG_ENTRY_CHANGED_MOD_OLD = NULL;

  /*** Rgles - Rules */
  if (TD_IS_MOD_TREE (g_list_nth_data (mod->child, 0))) 
    txt_tmp = TD_MOD_TREE (g_list_nth_data (mod->child, 0))->table;
  else
    if (TD_IS_MOD_CANVAS (g_list_nth_data (mod->child, 0))) 
      txt_tmp = TD_MOD_CANVAS (g_list_nth_data (mod->child, 0))->table;
    else
      if (TD_IS_MOD_GANTT (g_list_nth_data (mod->child, 0))) 
	txt_tmp = TD_MOD_GANTT (g_list_nth_data (mod->child, 0))->table;
  td_app_action_function (g_strdup_printf ("%s.%s", txt_tmp, TD_MOD_BENCH (g_list_nth_data (TD_MOD (mod)->bench, bench_id))->table_field), GTK_OBJECT (mod));
  return FLAG_ENTRY_CHANGED_ID;
}

/**
 * td_mod_action_bench:
 * @widget: widget of the new value 
 * @mod: module
 * 
 * fr: Execute une modification gnre par l'tabli du module
 *
 * en: Execute a modification generated by the bench of module
 **/

void td_mod_action_bench (GtkWidget *widget, TdMod *mod)
{
  GList *data = NULL;
  GList *data_old = NULL;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  if (TD_FLAG_NO_REFRESH_NODE)
    return;

  /*** Go ! */
  data = g_list_append (data, widget);
  data = g_list_append (data, mod);

  /*** Temporisation obsolte - Obsoleted temporization */
  if (FLAG_ENTRY_CHANGED_WIDGET_OLD)
    if (FLAG_ENTRY_CHANGED_WIDGET_OLD != widget)
      {
	data_old = g_list_append (data_old, FLAG_ENTRY_CHANGED_WIDGET_OLD);
	data_old = g_list_append (data_old, TD_MOD (FLAG_ENTRY_CHANGED_MOD_OLD));
	td_mod_action_bench_real (data_old);
      }

  /*** Widgets avec temporisation - Widgets with temporization */
  if ((GTK_IS_ENTRY (widget)) ||
      (GTK_IS_COMBO (widget)) ||
      (GTK_IS_SPIN_BUTTON (widget)))
    {
      FLAG_ENTRY_CHANGED_WIDGET_OLD = widget;
      FLAG_ENTRY_CHANGED_MOD_OLD = GTK_OBJECT (mod);
      if (FLAG_ENTRY_CHANGED_ID)
	gtk_timeout_remove (FLAG_ENTRY_CHANGED_ID);
      FLAG_ENTRY_CHANGED_ID = gtk_timeout_add (FLAG_ENTRY_CHANGED_TIME, td_mod_action_bench_real, data);
    }

  /*** Widgets sans temporisation - Widgets without temporization */
  if (GTK_IS_TOGGLE_BUTTON (widget))
    td_mod_action_bench_real (data);
}

/**
 * td_mod_action_etabliste_set:
 * @widget: widget of the new value 
 * @row: module
 * @column: column
 * @event: event
 * @mod: module
 * 
 * fr: Execute une mise  un gnre par l'tabliste du module
 *
 * en: Execute a set generated by the etabliste of module
 **/

void td_mod_action_etabliste_set (GtkWidget *widget, gint row, gint column, GdkEvent *event, TdMod *mod)
{
  GtkCTreeNode *selected;
  gchar *item_id;
  gchar *query;
  int etabliste_id;
  void (*symbol)() = NULL;
  if (TD_FLAG_NO_REFRESH_NODE)
    return;

  /* etabliste_id */
  for (etabliste_id = 0; etabliste_id < g_list_length (mod->etabliste); etabliste_id++)
    if (TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, etabliste_id))->widget == widget)
      break;

  /*** Action */
  gtk_ctree_node_get_text (GTK_CTREE (widget), gtk_ctree_node_nth (GTK_CTREE (widget), row), 1, &item_id);
  query = g_strdup_printf ("%s", TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, etabliste_id))->query_set);
  while (strstr (query, "TD_ETABLISTE_ID"))
    query = td_string_replace (query, "TD_ETABLISTE_ID", item_id);
  td_database_command (query);
  td_mod_modified (mod);
}

/**
 * td_mod_action_etabliste_unset:
 * @widget: widget of the new value 
 * @row: module
 * @column: column
 * @event: event
 * @mod: module
 * 
 * fr: Execute une mise  zro gnre par l'tabliste du module
 *
 * en: Execute a unset generated by the etabliste of module
 **/

void td_mod_action_etabliste_unset (GtkWidget *widget, gint row, gint column, GdkEvent *event, TdMod *mod)
{
  GtkCTreeNode *selected;
  gchar *item_id;
  gchar *query;
  int etabliste_id;
  void (*symbol)() = NULL;
  if (TD_FLAG_NO_REFRESH_NODE)
    return;

  /* etabliste_id */
  for (etabliste_id = 0; etabliste_id < g_list_length (mod->etabliste); etabliste_id++)
    if (TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, etabliste_id))->widget == widget)
      break;

  /*** Action */
  gtk_ctree_node_get_text (GTK_CTREE (widget), gtk_ctree_node_nth (GTK_CTREE (widget), row), 1, &item_id);
  query = g_strdup_printf ("%s", TD_MOD_ETABLISTE (g_list_nth_data (mod->etabliste, etabliste_id))->query_unset);
  while (strstr (query, "TD_ETABLISTE_ID"))
    query = td_string_replace (query, "TD_ETABLISTE_ID", item_id);
  td_database_command (query);
  td_mod_modified (mod);
}

/**
 * td_mod_refresh_menu:
 * @mod: module
 * @mod_child : component
 * 
 * fr: Rafrachis le menu du composant du module
 *
 * en: Refresh the menu of component of module
 **/

void td_mod_refresh_menu (TdMod *mod, GtkObject *mod_child)
{
  int i;
  gchar *txt_tmp;
  void (*symbol)() = NULL;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));

  /*** Requte - Query */
  (gpointer*) symbol = td_app_mod_data_symbol (mod->id, "plugins_menu_refresh", TRUE);
  if (symbol)
    symbol (GTK_OBJECT (mod), GTK_OBJECT (mod_child));

  /*** Widget */
  for (i=0; i< g_list_length (mod->menu); i++)
    {

      /*** Visibilit = NULL - Visibility = NULL */
      if (!TD_MOD_MENU (g_list_nth_data (mod->menu, i))->query_visible)
	{
	  gtk_widget_show (TD_MOD_MENU (g_list_nth_data (mod->menu, i))->widget);
	  continue;
	}

      /*** Visibilit = (null) - Visibility = (null) */
      if (!strcmp ("(null)", TD_MOD_MENU (g_list_nth_data (mod->menu, i))->query_visible))
	{
	  gtk_widget_hide (TD_MOD_MENU (g_list_nth_data (mod->menu, i))->widget);
	  continue;
	}

      /*** Visibilit - Visibility */
      txt_tmp = td_database_value (TD_MOD_MENU (g_list_nth_data (mod->menu, i))->query_visible);
      if (!txt_tmp)
	{
	  gtk_widget_hide (TD_MOD_MENU (g_list_nth_data (mod->menu, i))->widget);
	  continue;
	}

      /*** Sensitivit - Sensitivity */
      if (TD_MOD_MENU (g_list_nth_data (mod->menu, i))->query_unsensitive)
	{
	  txt_tmp = td_database_value (TD_MOD_MENU (g_list_nth_data (mod->menu, i))->query_unsensitive);
	  if (txt_tmp)
	    gtk_widget_set_sensitive (TD_MOD_MENU (g_list_nth_data (mod->menu, i))->widget, TRUE);
	  else
	    gtk_widget_set_sensitive (TD_MOD_MENU (g_list_nth_data (mod->menu, i))->widget, FALSE);
	}
      gtk_widget_show (TD_MOD_MENU (g_list_nth_data (mod->menu, i))->widget);
    }
}

/**
 * td_mod_action_menu:
 * @widget: widget 
 * @mod: module
 * 
 * fr: Execute une modification gnre par le menu du module
 *
 * en: Executes a modification generated by the menu of module
 **/

void td_mod_action_menu (GtkWidget *widget, TdMod *mod)
{
  int i;
  void (*symbol)() = NULL;
  int menu_id;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  for (menu_id=0; menu_id< g_list_length (mod->menu); menu_id++)
    if (TD_MOD_MENU (g_list_nth_data (mod->menu, menu_id))->widget == widget)
      break;
  (gpointer*) symbol = td_app_mod_data_symbol (mod->id, "plugins_menu_action", TRUE);
  if (symbol)
    symbol (GTK_OBJECT (mod), menu_id);
  td_mod_modified (mod);
}

/**
 * td_mod_action_menu_link:
 * @widget: widget 
 * @mod: module
 * 
 * fr: Execute une modification gnre par le menu des liens du module
 *
 * en: Executes a modification generated by the links menu of module
 **/

void td_mod_action_menu_link (GtkWidget *widget, TdMod *mod)
{
  int i;
  void (*symbol)() = NULL;
  int menu_id;
  g_return_if_fail (mod != NULL);
  g_return_if_fail (TD_IS_MOD (mod));
  for (menu_id=0; menu_id< g_list_length (mod->menu); menu_id++)
    if (TD_MOD_MENU (g_list_nth_data (mod->menu, menu_id))->widget == widget)
      break;
  (gpointer*) symbol = td_app_mod_data_symbol (mod->id, "plugins_menu_link_action", TRUE);
  if (symbol)
    symbol (GTK_OBJECT (mod), menu_id);
  td_mod_modified (mod);
}

/*****************************************************************************/
/*** Personnalisation et paramtrage - Customizing and parameters */
/*****************************************************************************/

/**
 * td_mod_custom_value:
 * @mod: module
 * @category: option's category
 * @group: option's group
 * @option: option's name
 * 
 * fr: Retourne la valeur de l'option de personnalisation du module
 *
 * en: Return the value of the option of the module's customize
 * 
 * Return value: string
 **/

gchar *td_mod_custom_value (TdMod *mod, gchar *category, gchar *group, gchar *option)
{
  return (td_custom_value (mod->name, category, group, option));
}

/**
 * td_mod_interface_field:
 * @mod: module
 * 
 * fr: Retourne le parametrage de l'interface du module
 *
 * en: Return the interface's parameters of the module
 * 
 * Return value: list
 **/

GList *td_mod_interface_field (TdMod *mod)
{
  if ((mod->id<0) || (!TD_APP (APP)->base))
    return NULL;
  if (!g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, mod->id))
    return NULL;
  return (TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, mod->id))->interface_field);
}

/**
 * td_mod_bench_field:
 * @mod: module
 * 
 * fr: Retourne le parametrage de l'tabli du module
 *
 * en: Return the bench's parameters of the module
 * 
 * Return value: list
 **/

GList *td_mod_bench_field (TdMod *mod)
{
  if ((mod->id<0) || (!TD_APP (APP)->base))
    return NULL;
  if (!g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, mod->id))
    return NULL;
  return (TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, mod->id))->bench_field);
}

/**
 * td_mod_etabliste_field:
 * @mod: module
 * 
 * fr: Retourne le parametrage de l'tabliste du module
 *
 * en: Return the etabliste list's parameters of the module
 * 
 * Return value: list
 **/

GList *td_mod_etabliste_field (TdMod *mod)
{
  if ((mod->id<0) || (!TD_APP (APP)->base))
    return NULL;
  if (!g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, mod->id))
    return NULL;
  return (TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, mod->id))->etabliste_field);
}
