/*****************************************************************************/
/* td_flower.c : Objet Gtk+
 * td_flower.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "td_app.h"
#include "td_flower.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_ROOT,
  ARG_BRANCH,
  ARG_PETAL,
  ARG_FOLIOLE,
  ARG_STOMATE,
  ARG_MODE_LEVEL,
  ARG_MODE_TYPE,
  ARG_MODE_ONE_COLUMN,
};

static void td_flower_set_root (TdFlower *flower, gchar *root)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->root != root)
    flower->root = root;
}

static void td_flower_set_branch (TdFlower *flower, gchar *branch)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->branch != branch)
    flower->branch = branch;
}

static void td_flower_set_petal (TdFlower *flower, gchar *petal)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->petal != petal)
    flower->petal = petal;
}

static void td_flower_set_foliole (TdFlower *flower, gchar *foliole)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->foliole != foliole)
    flower->foliole = foliole;
}

static void td_flower_set_stomate (TdFlower *flower, gchar *stomate)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->stomate != stomate)
    flower->stomate = stomate;
}

static void td_flower_set_mode_level (TdFlower *flower, gboolean mode_level)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->mode_level != mode_level)
    flower->mode_level = mode_level;
}

static void td_flower_set_mode_type (TdFlower *flower, gboolean mode_type)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->mode_type != mode_type)
    flower->mode_type = mode_type;
}

static void td_flower_set_mode_one_column (TdFlower *flower, gboolean mode_one_column)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->mode_one_column != mode_one_column)
    flower->mode_one_column = mode_one_column;
}

static void td_flower_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdFlower *flower;
  flower = TD_FLOWER (object);
  switch (arg_id)
    {
    case ARG_ROOT:
      td_flower_set_root (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_BRANCH:
      td_flower_set_branch (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PETAL:
      td_flower_set_petal (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_FOLIOLE:
      td_flower_set_foliole (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_STOMATE:
      td_flower_set_stomate (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_MODE_LEVEL:
      td_flower_set_mode_level (flower, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_MODE_TYPE:
      td_flower_set_mode_type (flower, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_MODE_ONE_COLUMN:
      td_flower_set_mode_one_column (flower, GTK_VALUE_BOOL (*arg));
      break;
    default:
      break;
    }
}

static void td_flower_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdFlower *flower;
  flower = TD_FLOWER (object);
   switch (arg_id)
    {
    case ARG_ROOT:
      GTK_VALUE_STRING (*arg) = flower->root;
      break;
    case ARG_BRANCH:
      GTK_VALUE_STRING (*arg) = flower->branch;
      break;
    case ARG_PETAL:
      GTK_VALUE_STRING (*arg) = flower->petal;
      break;
    case ARG_FOLIOLE:
      GTK_VALUE_STRING (*arg) = flower->foliole;
      break;
    case ARG_STOMATE:
      GTK_VALUE_STRING (*arg) = flower->stomate;
      break;
    case ARG_MODE_LEVEL:
      GTK_VALUE_BOOL (*arg) = flower->mode_level;
      break;
    case ARG_MODE_TYPE:
      GTK_VALUE_BOOL (*arg) = flower->mode_type;
      break;
    case ARG_MODE_ONE_COLUMN:
      GTK_VALUE_BOOL (*arg) = flower->mode_one_column;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_flower_init (TdFlower *flower)
{
  flower->root = NULL;
  flower->branch = NULL;
  flower->branch_attribut = NULL;
  flower->petal = NULL;
  flower->petal_attribut = NULL;
  flower->foliole = NULL;
  flower->foliole_attribut = NULL;
  flower->stomate = NULL;
  flower->stomate_attribut = NULL;
  flower->items_value = NULL;
  flower->items_level = NULL;
  flower->mode_level = FALSE;
  flower->mode_type = FALSE;
  flower->mode_one_column = FALSE;
}

static void td_flower_class_init (TdFlowerClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdFlower::root", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_ROOT);
  gtk_object_add_arg_type ("TdFlower::branch", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_BRANCH);
  gtk_object_add_arg_type ("TdFlower::petal", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PETAL);
  gtk_object_add_arg_type ("TdFlower::foliole", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_FOLIOLE);
  gtk_object_add_arg_type ("TdFlower::stomate", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_STOMATE);
  gtk_object_add_arg_type ("TdFlower::mode_level", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_MODE_LEVEL);
  gtk_object_add_arg_type ("TdFlower::mode_type", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_MODE_TYPE);
  gtk_object_add_arg_type ("TdFlower::mode_one_column", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_MODE_ONE_COLUMN);
  object_class->set_arg = td_flower_set_arg;
  object_class->get_arg = td_flower_get_arg;
  klass->add_branch_attribut = td_flower_add_branch_attribut;
  klass->add_petal_attribut = td_flower_add_petal_attribut;
  klass->add_foliole_attribut = td_flower_add_foliole_attribut;
  klass->add_stomate_attribut = td_flower_add_stomate_attribut;
}

GtkType td_flower_get_type (void)
{
  static GtkType flower_type = 0;
  if (!flower_type)
    {
      static const GtkTypeInfo flower_info =
      {
  	"TdFlower", sizeof (TdFlower), sizeof (TdFlowerClass),
  	(GtkClassInitFunc) td_flower_class_init,
	(GtkObjectInitFunc) td_flower_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      flower_type = gtk_type_unique (GTK_TYPE_OBJECT, &flower_info);
    }
  return flower_type;
}

/**
 * td_flower_new:
 * 
 * fr: Cr une nouvelle fleur
 *
 * en: Creates a new flower
 * 
 * Return value: flower
 **/

GtkObject *td_flower_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_flower_get_type()));
}

/**
 * td_flower_destroy:
 * @flower: flower
 * 
 * fr: Dtruit la fleur
 *
 * en: Destroys the flower
 **/

void td_flower_destroy (TdFlower *flower)
{
  flower->root = NULL;
  flower->branch = NULL;
  g_list_free (flower->branch_attribut);
  flower->petal = NULL;
  g_list_free (flower->petal_attribut);
  flower->foliole = NULL;
  g_list_free (flower->foliole_attribut);
  flower->stomate = NULL;
  g_list_free (flower->stomate_attribut);
  /* FIXME: utiliser les relatins de la GLib */
  /* for (i=0; i<g_list_length (flower->items_value); i++) */
  /* g_list_free (g_list_nth_data (flower->items_value, i)); */
  g_list_free (flower->items_value);
  g_list_free (flower->items_level);
  flower->mode_level = 0;
  flower->mode_type = 0;
  flower->mode_one_column = 0;
  gtk_object_destroy (GTK_OBJECT (flower));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_flower_add_branch_attribut:
 * @flower: flower
 * @branch_attribut: branch attribut
 *
 * fr: Ajoute l'attribut de branche (niveau 0)  la fleur
 *
 * en: Adds the branch attribut (level 0) to flower
 **/

void td_flower_add_branch_attribut (TdFlower *flower, gchar *branch_attribut)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  flower->branch_attribut = g_list_append (flower->branch_attribut, branch_attribut);
}

/**
 * td_flower_add_petal_attribut:
 * @flower: flower
 * @petal_attribut: petal attribut
 *
 * fr: Ajoute l'attribut de ptale (niveau 1)  la fleur
 *
 * en: Adds the petal attribut (level 1) to flower
 **/

void td_flower_add_petal_attribut (TdFlower *flower, gchar *petal_attribut)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  flower->petal_attribut = g_list_append (flower->petal_attribut, petal_attribut);
}

/**
 * td_flower_add_foliole_attribut:
 * @flower: flower
 * @foliole_attribut: foliole attribut
 *
 * fr: Ajoute l'attribut de foliole (niveau 2)  la fleur
 *
 * en: Adds the foliole attribut (level 2) to flower
 **/

void td_flower_add_foliole_attribut (TdFlower *flower, gchar *foliole_attribut)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  flower->foliole_attribut = g_list_append (flower->foliole_attribut, foliole_attribut);
}

/**
 * td_flower_add_stomate_attribut:
 * @flower: flower
 * @stomate_attribut: stomate attribut
 *
 * fr: Ajoute l'attribut de stomate (niveau 3)  la fleur
 *
 * en: Adds the stomate attribut (level 3) to flower
 **/

void td_flower_add_stomate_attribut (TdFlower *flower, gchar *stomate_attribut)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  flower->stomate_attribut = g_list_append (flower->stomate_attribut, stomate_attribut);
}

/**
 * td_flower_add_item:
 * @flower: flower
 * @item: item
 * @level: item's level
 *
 * fr: Ajoute l'item  la fleur
 *
 * en: Adds the item to flower
 **/

void td_flower_add_item (TdFlower *flower, GList *item, int level)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  flower->items_value = g_list_append (flower->items_value, item);
  flower->items_level = g_list_append (flower->items_level, GINT_TO_POINTER (level));
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_flower_load_file:
 * @flower: flower
 * @file: file
 * 
 * fr: Charge le fichier
 *
 * en: Load the file
 * 
 * Return value: FALSE on error
 **/

gboolean td_flower_load_file (TdFlower *flower, gchar *file)
{
  GList *data = NULL;
  XmlDoc *doc;
  XmlNs *ns;
  XmlNode *cur;
  XmlNode *cur2;
  XmlNode *cur3;
  XmlNode *cur4;
  gchar *txt_tmp = NULL;
  int i, j;

  /*** En-tte - Head */
  doc = xmlParseFile (file);
  if (!doc)
    {
      td_app_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : doc == NULL"), file), TD_MSG_FAILED);
      return FALSE;
    }
  cur = xmlDocGetRootElement (doc);
  if (!cur)
    {
      td_app_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : cur == NULL"), file), TD_MSG_FAILED);
      xmlFreeDoc (doc);
      return FALSE;
    }

  /*** Valeurs - Values */
  cur = cur->xmlChildrenNode;
  while (cur)
    {

      /*** Branche - Branch */
      if (!strcmp (cur->name, flower->branch))
	{
	  if (flower->mode_one_column)
	    {
	      for (j=0; j<g_list_length (flower->branch_attribut); j++)
		if (!j)
		  txt_tmp = g_strdup_printf ("%s", xmlGetProp (cur, g_list_nth_data (flower->branch_attribut, j)));
		else
		  txt_tmp = g_strdup_printf ("%s %s", txt_tmp, xmlGetProp (cur, g_list_nth_data (flower->branch_attribut, j)));
	      data = g_list_append (data, txt_tmp);
	      td_flower_add_item (flower, data, 0);
	      data = NULL;
	    }
	  else
	    {
	      for (j=0; j<g_list_length (flower->branch_attribut); j++)
		data = g_list_append (data, xmlGetProp (cur, g_list_nth_data (flower->branch_attribut, j)));
  	      if (flower->mode_type)
  		data = g_list_append (data, flower->branch);
	      if (flower->mode_level)
		td_flower_add_item (flower, data, atoi (xmlGetProp (cur, "level")));
	      else
		td_flower_add_item (flower, data, 0);
	      data = NULL;
	    }

	  /*** Ptale - Petal */
	  cur2 = cur->xmlChildrenNode;
	  while (cur2)
	    {
	      if (!strcmp (cur2->name, flower->petal))
		{
		  if (flower->mode_one_column)
		    {
		      for (j=0; j<g_list_length (flower->petal_attribut); j++)
			if (!j)
			  txt_tmp = g_strdup_printf ("%s", xmlGetProp (cur2, g_list_nth_data (flower->petal_attribut, j)));
			else
			  txt_tmp = g_strdup_printf ("%s %s", txt_tmp, xmlGetProp (cur2, g_list_nth_data (flower->petal_attribut, j)));
		      data = g_list_append (data, txt_tmp);
		      td_flower_add_item (flower, data, 1);
		      data = NULL;
		    }
		  else
		    {
		      for (j=0; j<g_list_length (flower->petal_attribut); j++)
			data = g_list_append (data, xmlGetProp (cur2, g_list_nth_data (flower->petal_attribut, j)));
  		      if (flower->mode_type)
			data = g_list_append (data, flower->petal);
		      if (flower->mode_level)
			td_flower_add_item (flower, data, atoi (xmlGetProp (cur2, "level")));
		      else
			td_flower_add_item (flower, data, 1);
		      data = NULL;
		    }

		  /*** Foliole */
		  cur3 = cur2->xmlChildrenNode;
		  while (cur3)
		    {
		      if (!strcmp (cur3->name, flower->foliole))
			{
			  if (flower->mode_one_column)
			    {
			      for (j=0; j<g_list_length (flower->foliole_attribut); j++)
				if (!j)
				  txt_tmp = g_strdup_printf ("%s", xmlGetProp (cur3, g_list_nth_data (flower->foliole_attribut, j)));
				else
				  txt_tmp = g_strdup_printf ("%s %s", txt_tmp, xmlGetProp (cur3, g_list_nth_data (flower->foliole_attribut, j)));
			      data = g_list_append (data, txt_tmp);
			      td_flower_add_item (flower, data, 2);
			      data = NULL;
			    }
			  else
			    {
			      for (j=0; j<g_list_length (flower->foliole_attribut); j++)
				data = g_list_append (data, xmlGetProp (cur3, g_list_nth_data (flower->foliole_attribut, j)));
  			      if (flower->mode_type)
  				data = g_list_append (data, flower->foliole);
			      if (flower->mode_level)
				td_flower_add_item (flower, data, atoi (xmlGetProp (cur3, "level")));
			      else
				td_flower_add_item (flower, data, 2);
			      data = NULL;
			    }

			  /*** Stomate */
			  cur4 = cur3->xmlChildrenNode;
			  while (cur4)
			    {
			      if (!strcmp (cur4->name, flower->stomate))
				{
				  if (flower->mode_one_column)
				    {
				      for (j=0; j<g_list_length (flower->stomate_attribut); j++)
					if (!j)
					  txt_tmp = g_strdup_printf ("%s", xmlGetProp (cur4, g_list_nth_data (flower->stomate_attribut, j)));
					else
					  txt_tmp = g_strdup_printf ("%s %s", txt_tmp, xmlGetProp (cur4, g_list_nth_data (flower->stomate_attribut, j)));
				      data = g_list_append (data, txt_tmp);
				      td_flower_add_item (flower, data, 3);
				      data = NULL;
				    }
				  else
				    {
				      for (j=0; j<g_list_length (flower->stomate_attribut); j++)
					data = g_list_append (data, xmlGetProp (cur4, g_list_nth_data (flower->stomate_attribut, j)));
				      if (flower->mode_type)
					data = g_list_append (data, flower->stomate);
				      if (flower->mode_level)
					td_flower_add_item (flower, data, atoi (xmlGetProp (cur4, "level")));
				      else
					td_flower_add_item (flower, data, 3);
				      data = NULL;
				    }
				}
			      cur4 = cur4->next;
			    }
			}
		      cur3 = cur3->next;
		    }
		}
	      cur2 = cur2->next;
	    }
	}
      cur = cur->next;
    }
  xmlFreeDoc (doc);
  return TRUE;
}

/**
 * td_flower_save_file:
 * @flower: flower
 * @file: file
 * 
 * fr: Enregistre le fichier
 *
 * en: Save the file
 * 
 * Return value: FALSE on error
 **/

gboolean td_flower_save_file (TdFlower *flower, gchar *file)
{
  FILE *fp;
  XmlDoc *doc;
  XmlNs *ns;
  XmlNode *tree = NULL;
  XmlNode *item_branch = NULL;
  XmlNode *item_petal = NULL;
  XmlNode *item_foliole = NULL;
  XmlNode *item_stomate;
  gchar *txt_tmp;
  int i, j;
  gchar *comment_category, *comment_group;

  /*** Valeurs - Values */
  doc = xmlNewDoc ("1.0");
  doc->xmlRootNode = xmlNewDocNode (doc, NULL, TD_FLOWER (flower)->root, NULL);
  if (strcmp (td_app_custom_value ("file", "support file", "namespace href"), "none"))
    ns = xmlNewNs (doc->xmlRootNode, td_app_custom_value ("file", "support file", "namespace href"), td_app_custom_value ("file", "support file", "namespace prefix"));
  else
    ns = NULL;
  tree = doc->xmlRootNode;
  comment_category = NULL;
  comment_group = NULL;
  if (flower->foliole)
    {
      if (flower->stomate)
	{
	  comment_category = td_app_custom_value ("file", "support file", "category comment");
	  comment_group = td_app_custom_value ("file", "support file", "group comment");
	}
      else
	comment_category = td_app_custom_value ("file", "support file", "group comment");
    }

  /*** Fleur - Flower */
  for (i=0; i<g_list_length (flower->items_value); i++)
    {

      /*** Branche - Branch */
      if (GPOINTER_TO_INT (g_list_nth_data (flower->items_level, i)) == 0)
	{
	  /* xmlAddChild(tree, xmlNewText("\n")); */
	  if (comment_category)
	    xmlAddChild(tree, xmlNewComment (td_string_replace (comment_category, "$name", flower->branch)));
	  item_branch = xmlNewChild (tree, ns, flower->branch, NULL);
	  for (j=0; j<g_list_length (g_list_nth_data (flower->items_value, i)); j++)
	    xmlSetProp (item_branch, g_list_nth_data (flower->branch_attribut, j), g_list_nth_data (g_list_nth_data (flower->items_value, i), j));
	}

      /*** Ptale - Petale */
      if (GPOINTER_TO_INT (g_list_nth_data (flower->items_level, i)) == 1)
	{
	  /* xmlAddChild(item_branch, xmlNewText("\n")); */
	  if (comment_group)
	    xmlAddChild(item_branch, xmlNewComment (td_string_replace (comment_group, "$name", flower->petal)));
	  item_petal = xmlNewChild (item_branch, ns, flower->petal, NULL);
	  for (j=0; j<g_list_length (g_list_nth_data (flower->items_value, i)); j++)
	    xmlSetProp (item_petal, g_list_nth_data (flower->petal_attribut, j), g_list_nth_data (g_list_nth_data (flower->items_value, i), j));
	}

      /*** Foliole */
      if (GPOINTER_TO_INT (g_list_nth_data (flower->items_level, i)) == 2)
	{
	  item_foliole = xmlNewChild (item_petal, ns, flower->foliole, NULL);
	  for (j=0; j<g_list_length (g_list_nth_data (flower->items_value, i)); j++)
	    xmlSetProp (item_foliole, g_list_nth_data (flower->foliole_attribut, j), g_list_nth_data (g_list_nth_data (flower->items_value, i), j));
	}

      /*** Stomate */
      if (GPOINTER_TO_INT (g_list_nth_data (flower->items_level, i)) == 3)
	{
	  item_stomate = xmlNewChild (item_foliole, ns, flower->stomate, NULL);
	  for (j=0; j<g_list_length (g_list_nth_data (flower->items_value, i)); j++)
	    xmlSetProp (item_stomate, g_list_nth_data (flower->stomate_attribut, j), g_list_nth_data (g_list_nth_data (flower->items_value, i), j));
	}
    }

  /*** Enregistrement - Save */
  fp = fopen (file, "w");
  if (!fp)
    {
      xmlFreeDoc (doc);
      return FALSE;
    }
  fclose (fp);
  /* FIXME: libxml2 : attente d'une version plus mature - libxml2 : wait a more mature version */ 
  /* if (base->encoding) */
  /* { */
  /* if (xmlSaveFileEnc (file, doc, base->encoding)<0) */
  /* { */
  /* td_app_message (NULL, g_strdup_printf (_("Saving geometry '%s'"), file), TD_MSG_FAILED); */
  /* xmlFreeDoc (doc); */
  /* return FALSE; */
  /* } */
  /* } */
  /* else */
  if (xmlSaveFile (file, doc) < 0)
    {
      xmlFreeDoc (doc);
      return FALSE;
    }
  xmlFreeDoc (doc);
  TD_CUSTOM_GEOMETRY_QUEUE = NULL;
  return TRUE;
}
