/*****************************************************************************/
/* td_field.c : Objet Gtk+
 * td_field.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "td_field.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_TABLE_FIELD,
  ARG_COMMENT,
};

static void td_field_set_name (TdField *field, gchar *name)
{
  g_return_if_fail (field != NULL);
  g_return_if_fail (TD_IS_FIELD (field));
  if (field->name != name)
    field->name = name;
}

static void td_field_set_table_field (TdField *field, gchar *table_field)
{
  g_return_if_fail (field != NULL);
  g_return_if_fail (TD_IS_FIELD (field));
  if (field->table_field != table_field)
    field->table_field = table_field;
}

static void td_field_set_comment (TdField *field, gchar *comment)
{
  g_return_if_fail (field != NULL);
  g_return_if_fail (TD_IS_FIELD (field));
  if (field->comment != comment)
    field->comment = comment;
}

static void td_field_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdField *field;
  field = TD_FIELD (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_field_set_name (field, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TABLE_FIELD:
      td_field_set_table_field (field, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COMMENT:
      td_field_set_comment (field, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_field_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdField *field;
  field = TD_FIELD (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = field->name;
      break;
    case ARG_TABLE_FIELD:
      GTK_VALUE_STRING (*arg) = field->table_field;
      break;
    case ARG_COMMENT:
      GTK_VALUE_STRING (*arg) = field->comment;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_field_init (TdField *field)
{
  field->name = NULL;
  field->table_field = NULL;
  field->comment = NULL;
  field->property_name = NULL;
  field->property_value = NULL;
}

static void td_field_class_init (TdFieldClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdField::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdField::table_field", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE_FIELD);
  gtk_object_add_arg_type ("TdField::comment", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COMMENT);
  object_class->set_arg = td_field_set_arg;
  object_class->get_arg = td_field_get_arg;
  klass->add_property = td_field_add_property;
}

GtkType td_field_get_type (void)
{
  static GtkType field_type = 0;
  if (!field_type)
    {
      static const GtkTypeInfo field_info =
      {
  	"TdField", sizeof (TdField), sizeof (TdFieldClass),
  	(GtkClassInitFunc) td_field_class_init,
	(GtkObjectInitFunc) td_field_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      field_type = gtk_type_unique (GTK_TYPE_OBJECT, &field_info);
    }
  return field_type;
}

/**
 * td_field_new:
 * 
 * fr: Cr un nouveau paramtrage de champs
 *
 * en: Creates new field parameters
 * 
 * Return value: field parameters
 **/

GtkObject *td_field_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_field_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_field_add_property:
 * @field: field parameters
 * @property_name: property's name
 * @property_value: property's value
 * 
 * fr: Ajoute la proprit au paramtrage du champs
 *
 * en: Adds the property to field parameters
 **/

void td_field_add_property (TdField *field, gchar *property_name, gchar *property_value)
{
  g_return_if_fail (field != NULL);
  g_return_if_fail (TD_IS_FIELD (field));
  field->property_name = g_list_append (field->property_name, property_name);
  field->property_value = g_list_append (field->property_value, property_value);
}

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

/**
 * td_field_property_value:
 * @field: field parameters
 * @property_name: property name
 * 
 * fr: Retourne la valeur de la proprit du champs
 *
 * en: Returns the value of field property
 * 
 * Return value: string
 **/

gchar *td_field_property_value (TdField *field, gchar *property_name)
{
  int i;
  for (i=0; i<g_list_length (field->property_name); i++)
    if (!strcmp ((gchar*) (g_list_nth_data (field->property_name, i)), property_name))
      return (g_list_nth_data (field->property_value, i));
  return NULL;
}

/**
 * td_field_property_value_list:
 * @field: field parameters
 * @property_name: property name
 * 
 * fr: Retourne la liste des valeurs de la proprit du champs
 *
 * en: Returns the value list of field property
 * 
 * Return value: list
 **/

GList *td_field_property_value_list (TdField *field, gchar *property_name)
{
  int i;
  GList *ret = NULL;
  for (i=0; i<g_list_length (field->property_name); i++)
    if (!strcmp ((gchar*) (g_list_nth_data (field->property_name, i)), property_name))
      ret = g_list_append (ret, g_list_nth_data (field->property_value, i));
  return ret;
}


/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_field_load:
 * @doc: XML document
 * @ns: XML namespace
 * @cur_root: XML node
 * 
 * fr: Retourne le paramtrage du champs de module correspondant  la localisation XML
 *
 * en: Returns the field parameters of module corresponding the XML location
 * 
 * Return value: field parameters
 **/

GtkObject *td_field_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root)
{
  GtkObject *ret;
  XmlNode *cur;

  /*** Champs - Field */
  ret = td_field_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", xmlGetProp (cur_root, "name"), 
		  "table_field", xmlGetProp (cur_root, "table_field"),
		  "comment", xmlGetProp (cur_root, "comment"), NULL);

  /*** Proprits - Properties */
  cur =  td_xml_check_children (cur_root->xmlChildrenNode, "properties");
  if (!cur)
    return (ret);
  while (cur)
    {
      if (!strcmp (cur->name, "property"))
	td_field_add_property (TD_FIELD (ret), xmlGetProp (cur, "name"), xmlGetProp (cur, "value"));
      cur = cur->next;
    }
  return (ret);
}
