/*****************************************************************************/
/* td_db_table.h : Objet Gtk+
 * td_db_table.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <parser.h>
#include <tree.h>
/*  #include <libxml/parser.h> */
/*  #include <libxml/tree.h> */

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/
#define TD_TYPE_DB_TABLE (td_db_table_get_type())
#define TD_DB_TABLE(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_DB_TABLE, TdDbTable))
#define TD_DB_TABLE_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_DB_TABLE, TdDbTableClass))
#define TD_IS_DB_TABLE(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_DB_TABLE))
#define TD_IS_DB_TABLE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_DB_TABLE))

/*****************************************************************************/
/*** Structure */
/*****************************************************************************/
typedef struct _TdDbTable TdDbTable;
typedef struct _TdDbTableClass TdDbTableClass;

struct _TdDbTable
{
  /*< public >*/
  GtkObject object;
  gchar *name; /*** Nom - Name */
  gchar *comment; /*** Commentaire - Comment */
  GList *field; /*** Schma des champs - Fields schema */
  GList *rule; /*** Rgles - Rules */
  GList *function; /*** Fonction - Function */
};

struct _TdDbTableClass
{
  GtkObjectClass parent_class;
  void (*add_field) (TdDbTable *db_table, GtkObject *field);
  void (*add_rule) (TdDbTable *db_table, GtkObject *rule);
  void (*add_function) (TdDbTable *db_table, GtkObject *function);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static void td_db_table_set_name (TdDbTable *db_table, gchar *name);
static void td_db_table_set_comment (TdDbTable *db_table, gchar *comment);
static void td_db_table_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_db_table_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_table_init (TdDbTable *db_table);
static void td_db_table_class_init (TdDbTableClass *klass);
GtkType td_db_table_get_type (void);
GtkObject *td_db_table_new (void);

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/
void td_db_table_add_field (TdDbTable *db_table, GtkObject *field);
void td_db_table_add_rule (TdDbTable *db_table, GtkObject *rule);
void td_db_table_add_function (TdDbTable *db_table, GtkObject *function);

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/
GtkObject *td_db_table_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root);
