/*****************************************************************************/
/* td_db_mod_table.c : Objet Gtk+
 * td_db_mod_table.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "database.h"
#include "td_db_mod_table.h"
#include "td_field.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_TABLE,
};

static void td_db_mod_table_set_name (TdDbModTable *db_mod_table, gchar *name)
{
  g_return_if_fail (db_mod_table != NULL);
  g_return_if_fail (TD_IS_DB_MOD_TABLE (db_mod_table));
  if (db_mod_table->name != name)
    db_mod_table->name = name;
}

static void td_db_mod_table_set_table (TdDbModTable *db_mod_table, gchar *table)
{
  g_return_if_fail (db_mod_table != NULL);
  g_return_if_fail (TD_IS_DB_MOD_TABLE (db_mod_table));
  if (db_mod_table->table != table)
    db_mod_table->table = table;
}

static void td_db_mod_table_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbModTable *db_mod_table;
  db_mod_table = TD_DB_MOD_TABLE (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_mod_table_set_name (db_mod_table, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TABLE:
      td_db_mod_table_set_table (db_mod_table, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_mod_table_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbModTable *db_mod_table;
  db_mod_table = TD_DB_MOD_TABLE (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = db_mod_table->name;
      break;
    case ARG_TABLE:
      GTK_VALUE_STRING (*arg) = db_mod_table->table;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_mod_table_init (TdDbModTable *db_mod_table)
{
  db_mod_table->name = NULL;
  db_mod_table->field = NULL;
  db_mod_table->table = NULL;
  db_mod_table->field = NULL;
}

static void td_db_mod_table_class_init (TdDbModTableClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbModTable::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdDbModTable::table", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE);
  object_class->set_arg = td_db_mod_table_set_arg;
  object_class->get_arg = td_db_mod_table_get_arg;
  klass->add_field = td_db_mod_table_add_field;
}

GtkType td_db_mod_table_get_type (void)
{
  static GtkType db_mod_table_type = 0;
  if (!db_mod_table_type)
    {
      static const GtkTypeInfo db_mod_table_info =
      {
  	"TdDbModTable", sizeof (TdDbModTable), sizeof (TdDbModTableClass),
  	(GtkClassInitFunc) td_db_mod_table_class_init,
	(GtkObjectInitFunc) td_db_mod_table_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_mod_table_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_mod_table_info);
    }
  return db_mod_table_type;
}

/**
 * td_db_mod_table_new:
 * 
 * fr: Cr un nouveau paramtrage de table
 *
 * en: Creates new table parameters
 * 
 * Return value: table parameters
 **/

GtkObject *td_db_mod_table_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_mod_table_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_db_mod_table_add_field:
 * @db_mod_table: menu parameters
 * @field: field parameters
 * 
 * fr: Ajoute le paramtrage du champs au paramtrage de la table
 *
 * en: Adds the field parameters to table parameters
 **/

void td_db_mod_table_add_field (TdDbModTable *db_mod_table, GtkObject *field)
{
  g_return_if_fail (db_mod_table != NULL);
  g_return_if_fail (TD_IS_DB_MOD_TABLE (db_mod_table));
  db_mod_table->field = g_list_append (db_mod_table->field, field);
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_db_mod_table_load:
 * @doc: XML document
 * @ns: XML namespace
 * @cur_root: XML node
 * 
 * fr: Retourne le paramtrage de la table du module correspondant  la localisation XML
 *
 * en: Return the table parameters of module corresponding the XML location
 * 
 * Return value: table parameters
 **/

GtkObject *td_db_mod_table_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root)
{
  XmlNode *cur;
  GtkObject *ret;

  /*** Table */
  ret = td_db_mod_table_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", xmlGetProp (cur_root, "name"), 
		  "table", xmlGetProp (cur_root, "table"), NULL);

  /*** Champs - Fields */
  cur =  td_xml_check_children (cur_root->xmlChildrenNode, "fields");
  if (!cur)
    return (ret);
  while (cur)
    {
      if (!strcmp (cur->name, "field"))
	td_db_mod_table_add_field (TD_DB_MOD_TABLE (ret), td_field_load (doc, ns, cur));
      cur = cur->next;
    }
  return (ret);
}
