/*****************************************************************************/
/* td_db_mod.c : Objet Gtk+
 * td_db_mod.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000-2001 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@toutdoux.org>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"

#include "td_db_mod.h"
#include "td_db_mod_table.h"
#include "td_db_mod_menu.h"
#include "td_field.h"

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_NAME_PARAM,
  ARG_GROUP,
  ARG_COMMENT,
  ARG_ICON,
};

static void td_db_mod_set_name (TdDbMod *db_mod, gchar *name)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  if (db_mod->name != name)
    db_mod->name = name;
}

static void td_db_mod_set_name_param (TdDbMod *db_mod, gchar *name_param)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  if (db_mod->name_param != name_param)
    db_mod->name_param = name_param;
}

static void td_db_mod_set_group (TdDbMod *db_mod, gchar *group)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  if (db_mod->group != group)
    db_mod->group = group;
}

static void td_db_mod_set_comment (TdDbMod *db_mod, gchar *comment)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  if (db_mod->comment != comment)
    db_mod->comment = comment;
}

static void td_db_mod_set_icon (TdDbMod *db_mod, gchar *icon)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  if (db_mod->icon != icon)
    db_mod->icon = icon;
}

static void td_db_mod_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbMod *db_mod;
  db_mod = TD_DB_MOD (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_mod_set_name (db_mod, GTK_VALUE_STRING (*arg));
      break;
    case ARG_NAME_PARAM:
      td_db_mod_set_name_param (db_mod, GTK_VALUE_STRING (*arg));
      break;
    case ARG_GROUP:
      td_db_mod_set_group (db_mod, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COMMENT:
      td_db_mod_set_comment (db_mod, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ICON:
      td_db_mod_set_icon (db_mod, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_mod_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbMod *db_mod;
  db_mod = TD_DB_MOD (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = db_mod->name;
      break;
    case ARG_NAME_PARAM:
      GTK_VALUE_STRING (*arg) = db_mod->name_param;
      break;
    case ARG_GROUP:
      GTK_VALUE_STRING (*arg) = db_mod->group;
      break;
    case ARG_COMMENT:
      GTK_VALUE_STRING (*arg) = db_mod->comment;
      break;
    case ARG_ICON:
      GTK_VALUE_STRING (*arg) = db_mod->icon;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/
static void td_db_mod_init (TdDbMod *db_mod)
{
  db_mod->name = NULL;
  db_mod->name_param = NULL;
  db_mod->group = NULL;
  db_mod->comment = NULL;
  db_mod->icon = NULL;
  db_mod->table = NULL;
  db_mod->interface_field = NULL;
  db_mod->bench_field = NULL;
  db_mod->etabliste_field = NULL;
  db_mod->menu = NULL;
}

static void td_db_mod_class_init (TdDbModClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbMod::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdDbMod::name_param", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME_PARAM);
  gtk_object_add_arg_type ("TdDbMod::group", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_GROUP);
  gtk_object_add_arg_type ("TdDbMod::comment", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COMMENT);
  gtk_object_add_arg_type ("TdDbMod::icon", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_ICON);
  object_class->set_arg = td_db_mod_set_arg;
  object_class->get_arg = td_db_mod_get_arg;
  klass->add_table = td_db_mod_add_table;
  klass->add_interface_field = td_db_mod_add_interface_field;
  klass->add_bench_field = td_db_mod_add_bench_field;
  klass->add_etabliste_field = td_db_mod_add_etabliste_field;
  klass->set_menu = td_db_mod_set_menu;
}

GtkType td_db_mod_get_type (void)
{
  static GtkType db_mod_type = 0;
  if (!db_mod_type)
    {
      static const GtkTypeInfo db_mod_info =
      {
  	"TdDbMod", sizeof (TdDbMod), sizeof (TdDbModClass),
  	(GtkClassInitFunc) td_db_mod_class_init,
	(GtkObjectInitFunc) td_db_mod_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_mod_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_mod_info);
    }
  return db_mod_type;
}

/**
 * td_db_mod_new:
 * 
 * fr: Cr un nouveau paramtrage de module
 *
 * en: Creates new module parameters
 * 
 * Return value: module parameters
 **/

GtkObject *td_db_mod_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_mod_get_type()));
}

/*****************************************************************************/
/*** Affectations - Allocations */
/*****************************************************************************/

/**
 * td_db_mod_add_table:
 * @db_mod: module parameters
 * @table: table parameters
 * 
 * fr: Ajoute le paramtrage de la table au paramtrage du module
 *
 * en: Adds the table parameters to module parameters
 **/

void td_db_mod_add_table (TdDbMod *db_mod, GtkObject *table)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  db_mod->table = g_list_append (db_mod->table, table);
}

/**
 * td_db_mod_add_interface_field:
 * @db_mod: module parameters
 * @interface_field: interface parameters
 * 
 * fr: Ajoute le paramtrage de l'interface au paramtrage du module
 *
 * en: Adds the interface parameters to module parameters
 **/

void td_db_mod_add_interface_field (TdDbMod *db_mod, GtkObject *interface_field)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  db_mod->interface_field = g_list_append (db_mod->interface_field, interface_field);
}

/**
 * td_db_mod_add_bench_field:
 * @db_mod: module parameters
 * @bench_field: bench parameters
 * 
 * fr: Ajoute le paramtrage de l'tabli au paramtrage du module
 *
 * en: Adds the bench parameters to module parameters
 **/

void td_db_mod_add_bench_field (TdDbMod *db_mod, GtkObject *bench_field)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  db_mod->bench_field = g_list_append (db_mod->bench_field, bench_field);
}

/**
 * td_db_mod_add_etabliste_field:
 * @db_mod: module parameters
 * @etabliste_field: etabliste parameters
 * 
 * fr: Ajoute le paramtrage de l'tabliste au paramtrage du module
 *
 * en: Adds the bench of lists parameters to module parameters
 **/

void td_db_mod_add_etabliste_field (TdDbMod *db_mod, GtkObject *etabliste_field)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  db_mod->etabliste_field = g_list_append (db_mod->etabliste_field, etabliste_field);
}

/**
 * td_db_mod_set_menu:
 * @db_mod: module parameters
 * @menu: menu parameters
 * 
 * fr: Ajoute le paramtrage du menu au paramtrage du module
 *
 * en: Adds the menu parameters to module parameters
 **/

void td_db_mod_set_menu (TdDbMod *db_mod, GtkObject *menu)
{
  g_return_if_fail (db_mod != NULL);
  g_return_if_fail (TD_IS_DB_MOD (db_mod));
  if (db_mod->menu != menu)
    db_mod->menu = menu;
}

/*****************************************************************************/
/*** Fichier - File */
/*****************************************************************************/

/**
 * td_db_mod_load:
 * @doc: XML document
 * @ns: XML namespace
 * @cur_root: XML node
 * 
 * fr: Retourne le paramtrage du module correspondant  la localisation XML
 *
 * en: Return the module parameters corresponding the XML location
 * 
 * Return value: module parameters
 **/

GtkObject *td_db_mod_load (XmlDoc *doc, XmlNs *ns, XmlNode *cur_root)
{
  XmlNode *cur;
  GtkObject *ret;

  /*** Module */
  ret = td_db_mod_new();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", xmlGetProp (cur_root, "name"),
		  "name_param", xmlGetProp (cur_root, "name_param"),
		  "group", xmlGetProp (cur_root, "group"),
		  "comment", xmlGetProp (cur_root, "comment"),
		  "icon", xmlGetProp (cur_root, "icon"), NULL);

  /*** Table */
  cur =  td_xml_check_children (cur_root->xmlChildrenNode, "tables");
  if (!cur)
    return (ret);
  while (cur)
    {
      if (!strcmp (cur->name, "table"))
	td_db_mod_add_table (TD_DB_MOD (ret), td_db_mod_table_load (doc, ns, cur));
      cur = cur->next;
    }

  /*** Interface */
  if (!cur_root->xmlChildrenNode->next)
    return (ret);
  cur =  td_xml_check_children (cur_root->xmlChildrenNode->next, "interface");
  while (cur)
    {
      if (!strcmp (cur->name, "field"))
	td_db_mod_add_interface_field (TD_DB_MOD (ret), td_field_load (doc, ns, cur));
      cur = cur->next;
    }

  /*** Etabli - Bench */
  if (!cur_root->xmlChildrenNode->next->next)
    return (ret);
  cur =  td_xml_check_children (cur_root->xmlChildrenNode->next->next, "bench");
  while (cur)
    {
      if (!strcmp (cur->name, "field"))
	td_db_mod_add_bench_field (TD_DB_MOD (ret), td_field_load (doc, ns, cur));
      cur = cur->next;
    }

  /*** Etabliste - Bench of lists */
  if (!cur_root->xmlChildrenNode->next->next->next)
    return (ret);
  cur =  td_xml_check_children (cur_root->xmlChildrenNode->next->next->next, "etabliste");
  while (cur)
    {
      if (!strcmp (cur->name, "field"))
	td_db_mod_add_etabliste_field (TD_DB_MOD (ret), td_field_load (doc, ns, cur));
      cur = cur->next;
    }

  /*** Menu *//* FIXME: +tars */
  /* FIXME: remplacer menu par commandes, non ? */
  /* cur = cur_root->xmlChildrenNode->next->next->next; */
  /* if ((cur) && (!strcmp (cur->name, "menu"))) */
  /* td_db_mod_set_menu (TD_DB_MOD (ret), td_db_mod_menu_load (doc, ns, cur)); */
  return (ret);
}
